<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/3-00-00-overview/">Part Three: Lisp So(u)rcery</a></li>
  <li class="active">Artificial Intelligence</li>
</ol>

## Chapter 3.17

# Artificial Intelligence

> "They kept hooking hardware into him---decision-action boxes to let him boss other computers, bank on bank of additional memories, more banks of associational neural nets, another tubful of twelve-digit random numbers, a greatly augmented temporary memory. Human brain has around ten-to-the-tenth neurons. By third year Mike had better than one and a half times that number of neuristors. And woke up."
> <footer>Robert A. Heinlein, <em>The Moon Is a Harsh Mistress</em></footer>

**Revision Note:** *Trim down intro text to focus on AI techniques in Lisp*.

There is a strong historical association of the LISP-family of programming languages with Artificial Intelligence research; this is mostly accidental, as some notable early Lisp Hackers happened to also be AI researchers, and in particular, John McCarthy---the creator of the original LISP language---also managed to earn himself the title, "the Father of Modern AI".  And of course, we can't forget that the ANSI Committee working on the Common Lisp standard itself was sponsored by DARPA primarily for military-grade artificial intelligence software.

These days, however, there are many good choices for so-called "AI Languages"---and Common Lisp, the general-purpose, high-level, multi-paradigm, programmable programming language is just as strong a choice for AI as for any other problem domain.

It may benefit the reader to know more about the different kinds of AI software that one can write.  Many people still hear the term "AI" and get scared---visions of hostile, AI-driven robots bent on the annihilation of humanity from a variety of Science Fiction stories spring to mind; combined with Elon Musk's recent outburst about AI-researchers "summoning the devil" by creating "soulless" beings.  But AI-research is *nowhere near* the sufficient level of sophistication to allow for *emergent machine intelligence*.  The reality of all AI software-agents written to date is that they are no more than highly complex, underwhelming *impersonations* of intelligent behaviour---and because their behaviour is entirely programmed, the emergence of genuine machine intelligence within them is not even possible.

If you are one of those people that is afraid of the future, where we are either ruled or exterminated by our robot creations, you don't need to be; *the more behaviour you program into an AI agent, the less likely it is to develop sentience*.  In order to create a Strong, or General AI agent that supports the potential for emergent machine intelligence, you would have to recreate the exact conditions in which intelligence emerges naturally---and that is to say, we would not be creating a hostile, demonic, or soulless computational entity; by recreating the exact conditions in which intelligence already emerges naturally, we would simply be creating an artificial *human being*.  But therein also lies the challenge; there is still so much that we do not understand about the human brain, that creating an artificial one is not yet even a feasible undertaking.  And furthermore, there is still the question of just how much instinctual knowledge humans are born with, compared to some other species of animal life; and what instinct actually means, when you consider a computational model of consciousness.

In short, the threat of hostile AI is not worth worrying about; as usual, the only threat is with the people who wield AI techniques for the exploitation of others.

In this chapter, we will review a selection of current models of AI research and development, building on what you already learned in chapters 3.14 on Quantum Computing, and 3.15 on Natural Language Processing in order to create a Learning Agent version of the old Eliza program, that will appear to become smarter the more you use it; and then we'll revisit your game built for Chapter 3.7 and extended in Chapter 3.8, to add more sophisticated NPCs and Enemies that rely on Quantum AI.

## Exercise 3.17.1

**Artificial Intelligence Today**

```lisp

```

## Exercise 3.17.2

**Heuristics**

```lisp

```

## Exercise 3.17.3

**Decisions**

```lisp

```

## Exercise 3.17.4

**Pathfinding**

```lisp

```

## Exercise 3.17.5

**Learning and Neural Networks**

```lisp

```

## Exercise 3.17.6

**The AI Agent's World**

```lisp

```

## Exercise 3.17.7

**Knowledge and Information**

```lisp

```

## Project 3.17.8

**A Learning Eliza**

```lisp

```

## Exercise 3.17.9

**An Intro to Quantum AI**

```lisp

```

## Exercise 3.17.10

**Quantum Learning Algorithms**

```lisp

```

## Exercise 3.17.11

**Quantum Pathfinding**

```lisp

```

## Exercise 3.17.12

**Quantum Optimization and Heuristics**

```lisp

```

## Project 3.17.13

**Upgrading Your Game Engine With Quantum AI**

```lisp

```

## Exercise 3.17.14

**The Turing Test**

```lisp

```

## Project 3.17.15

**A Quantum, Learning Eliza**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/3-16-00-nlp/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/3-18-00-robotics/">Next &raquo;</a><li>
</ul>
