<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/3-00-00-overview/">Part Three: Lisp So(u)rcery</a></li>
  <li class="active">Computational Physics</li>
</ol>

## Chapter 3.14

# Computational Physics

> "Behind every mystery lies another mystery. Infinite recession. But you don't need to know final answers---if there be such---and neither do I."
> <footer>Robert A. Heinlein, <em>Job: A Comedy of Justice</em></footer>

While Computational Science is generally useful for all scientific disciplines, as it allows scientists to refine and improve established theories and models to better match the observed data, computational science is of *fundamental importance* to Physicists, as it allows them to model underlying systems *which cannot yet be observed*; thus, the highly specialized branch of computational science dealing primarily with theoretical physics has its own name, Computational Physics, and is often treated as its own field---though obviously it inherits most of its techniques and tools from its parent.

As a third modality of science, the results of computational simulations of these underlying physical systems can be used in lieu of observation and experiment to aid in the validation of various theories; and naturally, to aid in the modelling of experiments so that the more exotic phenomenon in theoretical physics can be observed, if the theories correctly predict the behaviour and nature of these systems.

While modelling problems in M-Theory, Quantum Field Theory, or other novel approaches at harmonizing General Relativity with Quantum Mechanics are far beyond the scope of this book, it will be interesting to model some of the more approachable problems in physics and astrophysics to create 3D simulations using OpenGL; and write a general physics engine that is lightweight enough to be used anywhere, but accurate enough to simulate all the common physics problems that a student might face in an undergraduate Physics program.

In this chapter, we will revisit the methodology from Chapters 3.12 on Scientific Computing, and 3.7 on 3D Game Development, to progressively build 3D OpenGL simulations of n-body problems, gravitational fields, relativistic systems that warp spacetime, and models of sub-atomic particle physics; and as a final exercise, we will explore Newtonian Mechanics as an emergent system of Quantum Mechanics.

## Exercise 3.14.1

**Common Problems in Computational Physics**

```lisp

```

## Exercise 3.14.2

**The Ising Model**

```lisp

```

## Exercise 3.14.3

**Simulating Physics with OpenGL**

```lisp

```

## Exercise 3.14.4

**An n-body Problem**

```lisp

```

## Exercise 3.14.5

**Gravitational Fields**

```lisp

```

## Exercise 3.14.6

**Relativistic Velocities**

```lisp

```

## Exercise 3.14.7

**Visualizing a Warped Space-Time**

```lisp

```

## Exercise 3.14.8

**Modelling the sub-atomic world**

```lisp

```

## Exercise 3.14.9

**Newtonian Mechanics as Emergent from Quantum Mechanics**

```lisp

```

## Project 3.14.10

**Extending the Computational Science Application for Physics Simulation**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/3-13-00-scientific-computing/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/3-15-00-quantum-computing/">Next &raquo;</a><li>
</ul>
