<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/3-00-00-overview/">Part Three: Lisp So(u)rcery</a></li>
  <li class="active">Audio Generation and Manipulation</li>
</ol>

## Chapter 3.9

# Audio Generation and Manipulation

> "You're not listening."<br>
> "What were you doing talking," she answered reasonably, "when I wasn't listening?"
> <footer>Robert A. Heinlein, <em>Have Space Suit---Will Travel</em></footer>

There is something strangely satisfying about creating music---and it doesn't much matter whether anyone else wants to hear it, because the real point of it is to express yourself, without filters, without judgement, without fear.  Now, there are a lot of ways to make music---you can pick up an instrument, bang your fingers on your desk the the rhythm of your heart, or hum a private tune to yourself; it doesn't much matter, because at the end of the day it's all about how you best express yourself.  Obviously, if you've made it this far in the book, you're now a programmer; so what better way to express yourself than through the language that you have poured your blood, sweat, and tears into learning?

There are a lot of solutions available in the Lisp world for working with audio; you can handle MIDI to control your hardware or software synthesizers, modify WAV files, even live-hack in Common Lisp to create music on the fly with custom instruments and audio samples.  There are no limits---it's just you and your computer, making noise with code; and as it turns out, it is one *powerful* medium.

In this chapter, we will explore the variety of audio generation and manipulation libraries available for Lisp, with a particular emphasis on CL-Collider for algorithmic audio generation and live hacking.  If you have not set up Emacs Live yet, now will be a good time to do so, as it was specifically designed with live hacking in mind.  We will also revisit our 3D platformer game from the previous chapter, to embed a soundtrack and custom sound-effects, all generated with Lisp source code.

## Exercise 3.9.1

**CL-Collider and SuperCollider**

```lisp

```

## Exercise 3.9.2

**Notes and Chords**

```lisp

```

## Exercise 3.9.3

**Instruments**

```lisp

```

## Exercise 3.9.4

**Filters**

```lisp

```

## Exercise 3.9.5

**Controlling MIDI Devices**

```lisp

```

## Exercise 3.9.6

**MIDI Input**

```lisp

```

## Exercise 3.9.7

**Bouncing Audio to Disk**

```lisp

```

## Exercise 3.9.8

**Mixing and Mastering Audio**

```lisp

```

## Exercise 3.9.9

**Live Hacking CL-Collider in Emacs Live**

```lisp

```

## Project 3.9.10

**Extending your 3D Game Engine with programmatic audio**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/3-08-00-gaming/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/3-10-00-data/">Next &raquo;</a><li>
</ul>
