<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/3-00-00-overview/">Part Three: Lisp So(u)rcery</a></li>
  <li class="active">Cross-Platform Desktop Applications</li>
</ol>

## Chapter 3.4

# Cross-Platform Desktop Applications

> "A skillful Artist in shapes and appearances does no more than necessary to create His effect."
> <footer>Robert A. Heinlein, <em>Job: A Comedy of Justice</em></footer>

Assuming your target user-base is not comprised entirely of Lisp Hackers, your users will normally not be interested in receiving a source-code distribution or a command-line utility; they will expect a nice, clean installation package, an attractive and iconographically-appropriate icon, and a graphical user interface that is both familiar and novel.  This means a few different things---first, that your application's UI *looks* like other applications; it *works* like other applications; it fits into the Operating System like all other applications; but it tells its own story to users, like the best applications.  GUI design is not just a matter of calling widgets to simplify a command-line interface with toggle buttons and text areas, after all---you have to consider the User Experience.

Typically, on large commercial software projects, there will be a UX developer either on staff or contract; so you don't have to know the ins-and-outs of UX as a software developer---but it is useful to know the language of UX, and why UX is so important.  Then, you will be able to make the most of the GUI tools available in Common Lisp.

In Common Lisp, there are a lot of choices to provide desktop graphical user interfaces; but GUI applications are still a lot of work, and need to be carefully designed to support cross-platform deployment.  Unfortunately, there is no one-size-fits-all solution to this problem, but there are options which make the task manageable.

For commercial, cross-platform desktop applications, the cleanest, simplest solution is the CAPI library included in all versions of LispWorks.  For 90% of your GUI-application projects, you will need the features and workflow that LispWorks provides; for the rest, an open-source alternative might be preferable, even though they all fall short of the CAPI feature-set.  In order to distribute binaries of your desktop app, you will need the professional version of LispWorks or above for each platform you wish to target---but you can write and test your applications with the free personal edition.

---

Discuss Smoke/QT bindings, LTK, McCLIM, SDL + Dormouse, LispWorks CAPI, etc.

LTK for developing rapid cross-platform guis.

Develop a cross-platform LTK app for OS X, Windows, and Linux, package it for each OS appropriately.

Note: consider a wrapper around Atom-Shell, for writing rapid web technology based cross-platform applications.

---

## Exercise 3.4.1

**QTools and CommonQT**

```lisp

```

## Exercise 3.4.2

**McCLIM**

```lisp

```

## Exercise 3.4.3

**SDL and Dormouse**

```lisp

```

## Exercise 3.4.4

**LTK**

```lisp

```

## Exercise 3.4.5

**LispWorks: CAPI**

```lisp

```

## Exercise 3.4.6

**Atom-Shell: GUI Apps built on Web Technologies**

```lisp

```

## Project 3.4.7

**A Cross-Platform Native GUI App**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/3-03-00-mobile/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/3-05-00-system-utils/">Next &raquo;</a><li>
</ul>
