<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li class="active">Part Three: Lisp So(u)rcery</li>
</ol>

## PART THREE

# Lisp So(u)rcery

> "I would be disappointed if everything I saw turned out to be something Western Electric will build once Bell Labs works the bugs out. There ought to be some magic, somewhere, just for flavor."
> <footer>Robert A. Heinlein, <em>Glory Road</em></footer>

Now that you've gotten a solid grounding in the Common Lisp language and some popular Lisp libraries, it's time to really challenge yourself.  While up to this point, Extra Credit exercises have been mixed in-between fundamental language exercises, this part of the book is all practical exercises.  It will guide you through many of the popular use-cases you will come across as a professional Lisp developer, and by the end of it, you will be able to work some real programming magic.

This part of the book will also be less prescriptive, and leave you to rely on your knowledge and instinct to complete the outlined projects.  I will guide you through system architecture, laying out a project into user stories, and finding relevant libraries which can save you time; but I'm leaving the coding to you.  When you complete each chapter, you can then compare your implementation against my own reference implementation and those of your peers.  But remember, no cheating!  It's important that you finish the project on your own and get it to run with only the information I've given you, before looking for alternate implementations to improve your style or methodology.

### Chapters

1. [Real-World Web Apps](/book/3-01-00-web-apps/)
2. [Typesetting](/book/3-02-00-typesetting/)
3. [Native Mobile Applications](/book/3-03-00-mobile/)
4. [Cross-Platform Desktop Applications](/book/3-04-00-gui/)
5. [Drivers, Daemons, and System-Utilities](/book/3-05-00-system-utils/)
6. [Reverse Engineering](/book/3-06-00-reverse-engineering/)
7. [Graphics Rendering](/book/3-07-00-graphics/)
8. [OpenGL, SDL, and 3D Game Development](/book/3-08-00-gaming/)
9. [Audio Generation and Manipulation](/book/3-09-00-audio/)
10. [Data Aggregation and Analysis](/book/3-10-00-data/)
11. [Cryptography and Security](/book/3-11-00-cryptosec/)
12. [Financial Software and Crypto-Currencies](/book/3-12-00-fintech/)
13. [Scientific Computing](/book/3-13-00-scientific-computing/)
14. [Computational Physics](/book/3-14-00-computational-physics/)
15. [Quantum Computing](/book/3-15-00-quantum-computing/)
16. [Natural Language Processing](/book/3-16-00-nlp/)
17. [Artificial Intelligence](/book/3-17-00-ai/)
18. [Robotics](/book/3-18-00-robotics/)
19. [Space-Tech](/book/3-19-00-space-tech/)
20. [Neuroscience and Thought-Controlled Computing](/book/3-20-00-neurotech/)
21. [A Simple LispOS](/book/3-21-00-lispos/)
22. [Build Your Own Lisp Machine](/book/3-22-00-lisp-machine/)
23. [Government and Military Grade Systems](/book/3-23-00-gov-mil/)

<ul class="pager">
  <li class="previous"><a href="/book/2-21-0-review/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/3-01-00-web-apps/">Next &raquo;</a><li>
</ul>
