<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/2-0-0-overview/">Part Two: The Suffusion of Blue</a></li>
  <li class="active">Detailed Review of Common Lisp</li>
</ol>

## Chapter 2.21

# Detailed Review of Common Lisp

> "The best things in life are beyond money; their price is agony and sweat and devotion... and the price demanded for the most precious of all things in life is life itself---ultimate cost for perfect value."
> <footer>Robert A. Heinlein, <em>Starship Troopers</em></footer>

Brutal though it may have been, you have reached the end of Part Two.  There is just one final challenge before you move on to the industry-themed practical challenges of Part Three---and that's to make your peace with the Common Lisp HyperSpec, and even learn to love it. The HyperSpec is, of course, the de-facto official specification of the Common Lisp language freely available to the public, its text at least partly extracted from the original standards document, ANSI X3.226 (which is now available in a revised version as <a href="http://webstore.ansi.org/RecordDetail.aspx?sku=ANSI%20INCITS%20226-1994%20(R2004)" target="_blank">ANSI INCITS 226-1994 (R2004)</a>). If you'd prefer to use the official ANSI standard as your choice of reference over the HyperSpec, I don't think anyone in the Lisp community would fault you.

Lisp as a language gets a lot of flak from outsiders and newcomers to the language, simply because the HyperSpec looks like it hasn't been updated since 1994.  As it so happens, it was created in 1996, so design-wise it looked old and out of date even then---and the current version is actually much improved over the original release, which had a silver background, and a harsh aqua banner with a slogan reading, "the very definition of class."  But given that the HyperSpec is best viewed within Emacs beside your code in a text-based browser, so you can get right at the documentation text without any interference, it doesn't much matter what the HyperSpec looks like.  What matters is that, aside from the ANSI Standard itself, it is the most complete reference manual to the language available.  And it's free.

What the HyperSpec is not, however, is a tutorial or implementation guide---*this* book, Learn Lisp the Hard Way, has been your tutorial; the last tutorial you need to start your career as a professional Lisp Hacker is how to use the CLHS, and appreciate the magnitude and detail of that document.  So that's what we'll cover here:

* The organization and structure of the CLHS
* Navigating the Chapters, Master Index, and Glossary
* Understanding formal definitions of Common Lisp symbols
* Searching the CLHS on the Web
* Accessing the CLHS with Emacs+SLIME

The final challenge before you move on to Part Three is this:

* Read through all chapters of the CLHS three times, carefully, making notes for yourself as you go
* Study and memorize all symbols in the Common Lisp language, noting their class and type, and other interesting features about them
* Review the formal definitions of all symbols until, from memory, you can write down on paper the semantics of every symbol

Only once you've fully internalized the Common Lisp HyperSpec, can you proudly boast that you're a Lisp Hacker; and then you can move on to Part Three.  Good luck, and see you there!

<ul class="pager">
  <li class="previous"><a href="/book/2-20-0-packaging-libs/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/3-00-00-overview/">Next &raquo;</a><li>
</ul>
