<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/2-0-0-overview/">Part Two: The Suffusion of Blue</a></li>
  <li class="active">Documentation and Inspection</li>
</ol>

## Chapter 2.15

# Documentation and Inspection

> "This non-system holds together by having no togetherness, no uniformity, never seeking perfection, no Utopias---just answers good enough to get by, with lots of looseness and room for many ways and attitudes."
> <footer>Robert A. Heinlein, <em>Glory Road</em></footer>

When exploring a new library, documentation of the source code is invaluable.  In some cases, the ultimate failure or success of a project can rest squarely on how well it has been documented---but lets say you write a library that has no competition, so people use it anyway because it's the only tool available.  How much time and effort can you save answering questions and solving issues, by providing clear and instructive documentation, use-cases, and tutorials up-front?

The same goes for commenting your source-code; sometimes you might think your code is perfectly self-explanatory, but then six-months down the road---or even the next day!---you come back to your code and have no idea what you were thinking when you implemented a critical function to your system.  Imagine how a newcomer to your source code might feel!

Another problem can be the opaqueness of objects. In any serious project, you have all these complex, structured objects running in your program---they could be from any number of libraries, each of which could be using very different conventions.  If only there was some way to see inside these black boxes!

Oh right, this is Lisp.  You can get into the REPL of any running Lisp application and inspect *everything*.

## Exercise 2.15.1

**Documentation and Comments**

```lisp

```

## Exercise 2.15.2

**More Documentation and Comments**

```lisp

```

## Exercise 2.15.3

**Even More Documentation and Comments**

```lisp

```

## Exercise 2.15.4

**DOCUMENTATION**

```lisp

```

## Exercise 2.15.5

**Unreadable Objects**

```lisp

```

## Exercise 2.15.6

**Modifying the Lisp Printer**

```lisp

```

## Exercise 2.15.7

**DESCRIBE**

```lisp

```

## Exercise 2.15.8

**More DESCRIBE**

```lisp

```

## Exercise 2.15.9

**Even More DESCRIBE**

```lisp

```

## Exercise 2.15.10

**INSPECT**

```lisp

```

## Exercise 2.15.11

**More INSPECT**

```lisp

```

## Exercise 2.15.12

**Even More INSPECT**

```lisp

```

## Extra Credit Exercise 2.15.13

**Documentation and Inspection in Emacs+SLIME**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/2-14-0-tree-shaker/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/2-16-0-foreign-libs/">Next &raquo;</a><li>
</ul>
