<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/2-0-0-overview/">Part Two: The Suffusion of Blue</a></li>
  <li class="active">Extra Credit: Write a 2D Game</li>
</ol>

## Chapter 2.12 --- Extra Credit

# Write a 2D Game

> "Going to dance at my wake?"

> "I don't dance," the lawyer answered, "but you tempt me to learn."
> <footer>Robert A. Heinlein, <em>I Will Fear No Evil</em></footer>

Hopefully you've had a lot of fun writing and playing your own Text Adventures and MUD-like online games; but in today's gaming world, you may be hard-pressed to get your friends excited about working at the command line or out of a MUD console to try your new game.  So now it's time to make a paradigm shift and start thinking about graphics and user interfaces.

We already have a game engine to work with, but it needs some major overhaul before we can write our first 2D game.  We also have to determine what we mean by 2D game, since there are so many varieties to choose from---room-based graphical adventures, like the old Sierra classics; side-scrollers, like the old Nintendo games; rogue-likes; the list goes on.  It would be useful if we could abstract all these different styles into our engine, so that we can use it to build all these different styles of 2D games.  Luckily, we're working with Lisp, and that's exactly what it was made for: endless abstraction.

To support our endless whims and fancies, we will be using the `lispbuilder-sdl` library in our extended game engine, one of the better Lisp libraries available for working with graphics, audio, and all things gaming.  We will also be generating our graphics and environments procedurally, so that we can use a minimum of assets and textures from open-source graphic libraries.

## Exercise 2.12.1

**An Intro to LISPBUILDER-SDL**

```lisp

```

## Exercise 2.12.2

**The Display**

```lisp

```

## Exercise 2.12.3

**Display Types**

```lisp

```

## Exercise 2.12.4

**Clearing and Redrawing the Display**

```lisp

```

## Exercise 2.12.5

**Display Buffering and Memory**

```lisp

```

## Exercise 2.12.6

**Audio**

```lisp

```

## Exercise 2.12.7

**More Audio**

```lisp

```

## Exercise 2.12.8

**Even More Audio**

```lisp

```

## Exercise 2.12.9

**Primitives**

```lisp

```

## Exercise 2.12.10

**Graphics and Other Resources**

```lisp

```

## Exercise 2.12.11

**Surfaces**

```lisp

```

## Exercise 2.12.12

**Procedural Content Generation**

```lisp

```

## Exercise 2.12.13

**Game Physics**

```lisp

```

## Exercise 2.12.14

**The Game Loop**

```lisp

```

## Exercise 2.12.15

**Input**

```lisp

```

## Exercise 2.12.16

**More Input**

```lisp

```

## Exercise 2.12.17

**Fonts**

```lisp

```

## Exercise 2.12.18

**More Fonts**

```lisp

```

## Exercise 2.12.19

**The 2D Game Engine**

```lisp

```

## Exercise 2.12.20

**Abstractions of Rooms and Worlds**

```lisp

```

## Exercise 2.12.21

**Tidy Game Scripts**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/2-11-0-conditions/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/2-13-0-compiler/">Next &raquo;</a><li>
</ul>
