<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/2-0-0-overview/">Part Two: The Suffusion of Blue</a></li>
  <li class="active">Conditions and Error Handling</li>
</ol>

## Chapter 2.11

# Conditions and Error Handling

> "The death rate is the same for us as for anybody... one person, one death, sooner or later."
> <footer>Robert A. Heinlein, <em>Tunnel in the Sky</em></footer>

No matter what you do, things will eventually go wrong in any program you write.  You may have overlooked a bug, pass a function an object of the wrong data type, overestimated the ability of your users to follow instructions, incorrectly guaged the needs of your users, or, most commonly, kept working when you're burned-out, and really messed up your code.  It happens to everyone.

Thankfully, Lisp has a very mature and robust system for handling errors gracefully, so that your users can have a seamless experience.

In this chapter, we'll take a tour through all of Lisp's built-in tools for handling, defining, and working with Conditions.

## Exercise 2.11.1

**Errors vs. Conditions**

```lisp

```

## Exercise 2.11.2

**Signaling Conditions**

```lisp

```

## Exercise 2.11.3

**ASSERT**

```lisp

```

## Exercise 2.11.4

**More ASSERT**

```lisp

```

## Exercise 2.11.5

**Handling Conditions**

```lisp

```

## Exercise 2.11.6

**HANDLER-CASE**

```lisp

```

## Exercise 2.11.7

**More HANDLER-CASE**

```lisp

```

## Exercise 2.11.8

**Even More HANDLER-CASE**

```lisp

```

## Exercise 2.11.9

**HANDLER-BIND**

```lisp

```

## Exercise 2.11.10

**More HANDLER-BIND**

```lisp

```

## Exercise 2.11.11

**Even More HANDLER-BIND**

```lisp

```

## Exercise 2.11.12

**Defining Conditions**

```lisp

```

## Exercise 2.11.13

**Defining Conditions, Again**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/2-10-0-improved-text-adventure-engine/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/2-12-0-2d-game/">Next &raquo;</a><li>
</ul>
