<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/2-0-0-overview/">Part Two: The Suffusion of Blue</a></li>
  <li class="active">Extra Credit: Number Theory</li>
</ol>

## Chapter 2.8 --- Extra Credit

# Number Theory

> "Some people insist that 'mediocre' is better than 'best.' They delight in clipping wings because they themselves can't fly. They despise brains because they have none. Pfah!"
> <footer>Robert A. Heinlein, <em>Have Space Suit---Will Travel</em></footer>

Number Theory is a fun, but challenging domain for computer scientists---many aspects of it pose intractable problems for classical computation, forcing us to look to novel technologies for solutions, such as Quantum Computation.  But in the age of concurrency, there are some minor tweaks and adjustments that can be made to the established algorithms, so that while we still cannot efficiently factorize the multiplication of two large primes, we can at least push classical computing to its absolute limit.

Through the excercises in this chapter, we will put together a Number Theory library that can be included in other projects, and contains a number of useful techniques for algorithm design, optimization, unit testing, and further develops on the iterative, incremental development pattern encouraged in Lisp.  We will approach each problem from its theoretical ideal, and then work towards a computational ideal that is as efficient as possible while retaining elegance in expression.

## Exercise 2.8.1

**Prime Numbers, Revisited**

```lisp

```

## Exercise 2.8.2

**Alternate Approaches to Factorization**

```lisp

```

## Exercise 2.8.3

**Factorizing Primes with Look-up Tables**

```lisp

```

## Exercise 2.8.4

**Factorizing Primes with Pollard's Rho Algorithm**

```lisp

```

## Exercise 2.8.5

**Factorizing Primes with Lenstra's Elliptical Curve**

```lisp

```

## Exercise 2.8.6

**Factorizing Primes with the Quadratic Sieve**

```lisp

```

## Exercise 2.8.7

**Factorizing Primes with the General Number Field Sieve**

```lisp

```

## Exercise 2.8.8

**Automatic Factorization Algorithm Selection**

```lisp

```

## Exercise 2.8.9

**Polynomials**

```lisp

```

## Exercise 2.8.10

**More Polynomials**

```lisp

```

## Exercise 2.8.11

**Even More Polynomials**

```lisp

```

## Exercise 2.8.12

**Modular Exponentiation**

```lisp

```

## Exercise 2.8.13

**More Modular Exponentiation**

```lisp

```

## Exercise 2.8.14

**Inverse Modulus**

```lisp

```

## Exercise 2.8.15

**The Jacobi Function**

```lisp

```

## Exercise 2.8.16

**The Euler Totient Function**

```lisp

```

## Exercise 2.8.17

**The Carmichael Functions**

```lisp

```

## Exercise 2.8.18

**More Carmichael Functions**

```lisp

```

## Exercise 2.8.19

**Even More Carmichael Functions**

```lisp

```

## Exercise 2.8.20

**Optimizing for Performance**

```lisp

```

## Exercise 2.8.21

**Optimizing for Memory Use**

```lisp

```

## Exercise 2.8.22

**Putting It All Together**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/2-07-0-logic-and-more-math/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/2-09-0-binary-octets-bits/">Next &raquo;</a><li>
</ul>
