<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/2-0-0-overview/">Part Two: The Suffusion of Blue</a></li>
  <li class="active">Logic and Advanced Math</li>
</ol>

## Chapter 2.7

# Logic and Advanced Math

> "...Mathematics need not have use; it was a game, like chess but more fun."
> <footer>Robert A. Heinlein, <em>Citizen of the Galaxy</em></footer>

**Revision Note:** *Intro text needs complete rewrite*.

We've dabbled in basic math already, and chances are high that in every-day programming, that might be all you ever need.  However, there are many problem domains that require a sophisticated understanding of advanced logic, Lisp's built-in tools for modular arithmetic and trigonometry, and the implementation of functions to support number theory, linear algebra, and calculus; for example, game development, artificial intelligence, computational physics, cryptography, FINTECH, and everything in the Crypto-Currency space.  Even as "just a web developer", on-line security is becoming ever more important as developers are pushed to get the web experience ever closer to the desktop experience---and cryptography plays a central role in that.  As the saying goes, "*the more you know...*"

Of course, by this point you should no longer be afraid of math, since every line of code you write in Lisp, no matter the paradigm, is formally expressed as an S-Expression in the Lambda Calculus.  While what you're doing may not conform to the conception of *pure functional programming*, every expression you write that is evaluated as a proper form returns some result.  At the end of the day, that's all math really is---a set of formally expressed rules that operate on quantitative data.  And *everything* in a computer is quantitative, whether you would normally think of it that way or not.  That Lisp adapts a purely mathematical model underneath in its implementation, and allows qualitative logic to be built on top of a quantifiable system is a feature---and an exciting one.  Lisp demonstrates how all qualitative systems can be reduced to quantitative.  In the age-old debate of philisophy vs. science, the importance of this cannot be understated.  And this should also serve as an explanation as to why Lisp Hackers always say that *programming is math*, while developers from other languages simply fail to see this basic tenet of computer science.

But Math is more important than even that, to all programmers.  Every program that can be written can be abstracted and generalized to a formal mathematical definition, and in so doing, can be simplified and made more elegant.  Consider the problem of 3D Graphics, whether for gaming, simulation, virtual reality, augmented reality, or immersive interfaces.  You can use 3D Graphics applications such as CAD or Blender, or the myriad of robust proprietary alternatives, to visually create your 3D artwork and assets---there's nothing wrong with this, as for artists it is quite intuitive.  However, a mathematician can achieve the same end with pure code.  These 3D assets are all collections of vertices in cartesian space, and they can be generated procedurally just as easily---and sometimes more easily---than they can be created with a 3D graphics application.  It just depends on how well you understand the math behind 3D graphics.

Lisp is particularly good for generating 3D graphics without having to use assets created in a third-party application.  In fact, that was one of the greatest strengths of the fabled Lisp Machines.  In Part Three we will be tackling this problem head-on, to create a complete 3D game without any third-party assets.  Just code.  *This* chapter will provide you with all the math you'll need to achieve that feat---any many, many more.

## Exercise 2.7.1

**Formal Logic**

```lisp

```

## Exercise 2.7.2

**Boolean Logic on Integers**

```lisp

```

## Exercise 2.7.3

**Boolean Logic on Bit-Vectors**

```lisp

```

## Exercise 2.7.4

**Prime Numbers**

```lisp

```

## Exercise 2.7.5

**Prime Factorization**

```lisp

```

## Exercise 2.7.6

**Modular Arithmetic**

```lisp

```

## Exercise 2.7.7

**Imaginary Numbers**

```lisp

```

## Exercise 2.7.8

**Complex Numbers**

```lisp

```

## Exercise 2.7.9

**Trigonometry**

```lisp

```

## Exercise 2.7.10

**More Trigonometry**

```lisp

```

## Exercise 2.7.11

**Geometry**

```lisp

```

## Exercise 2.7.12

**More Geometry**

```lisp

```

## Exercise 2.7.13

**Even More Geometry**

```lisp

```

## Exercise 2.7.14

**The GSLL Library**

```lisp

```

## Exercise 2.7.15

**Linear Algebra with GSLL**

```lisp

```

## Exercise 2.7.16

**More Linear Algebra**

```lisp

```

## Exercise 2.7.17

**Even More Linear Algebra**

```lisp

```

## Exercise 2.7.18

**Calculus with GSLL**

```lisp

```

## Exercise 2.7.19

**More Calculus**

```lisp

```

## Exercise 2.7.20

**Even More Calculus**

```lisp

```

## Exercise 2.7.21

**Further Explorations with GSLL**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/2-06-0-threads-memos-parallel/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/2-08-0-number-theory/">Next &raquo;</a><li>
</ul>
