<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/2-0-0-overview/">Part Two: The Suffusion of Blue</a></li>
  <li class="active">Programming Paradigms</li>
</ol>

## Chapter 2.1

# Programming Paradigms

> "A human being should be able to change a diaper, plan an invasion, butcher a hog, conn a ship, design a building, write a sonnet, balance accounts, build a wall, set a bone, comfort the dying, take orders, give orders, cooperate, act alone, solve equations, analyze a new problem, pitch manure, program a computer, cook a tasty meal, fight efficiently, die gallantly. Specialization is for insects."
> <footer>Robert A. Heinlein, <em>Time Enough for Love</em></footer>

The way that you structure a problem dictates and limits its possible solutions.  Most programming lanugages have a single, or a very small set of built-in approaches to programming---their syntax restricts the lanuage to a single *paradigm*---and as a result, they limit you as a programmer, and artificially stunt your productivity and ingenuity, because they impose a single methodology for approaching all problems.  Human language is much the same in this regard---it is a well-known and established fact in developmental psychology, that the more languages a child learns to speak early on, the broader their thinking ends up becoming.  This is because all languages, human or computer, include certain underlying assumptions about the world that are not directly expressed, but are always there "between the lines" in the untranslatable elements of language.  When you learn to look at the world through different lenses, as the saying goes, you can see it much more clearly.  This also happens to be the scientific perspective.

Lisp is different from other programming lanugages---it is *multi-paradigm* by nature, which means in practice that you are free to approach any given problem by every potential angle; the simplicity of its syntax, the homoiconicity of S-Expressions for representing both code and data also allow for the natural and intuitive representation of all programming paradigms; and in the Lisp REPL, you can try out each potential paradigm side-by-side until you find the right combination of clarity, expressiveness, and simplicity.  As you work more with Lisp and various paradigms through it, you will begin to develop an intuition for problem-solving; then, as you look at a problem and consider its implementation, you will get a feel for "just knowing" which paradigm best suits the job in front of you---just like an artist intuitively knows what colour palette to use as well as which brush.

The ability to switch paradigms in Lisp may strike you, at first, as a source of great confusion.  You might ask yourself, "how am I supposed to look over a piece of code and know what's going on?  What if I mistake one paradigm for another, and mess up a library?"  Obviously, experience will help---the more you work with Lisp and the multi-paradigm approach, the more quickly you will be able to spot the paradigms being used.  But that's not as difficult as it sounds---every paradigm comes with its unique hallmarks, and once you learn them, they're easy to spot.

In Part One, we primarily used the functional programming paradigm for convenience; but as I've said before, Lisp is not a functional language---the functional paradigm is just one of many at your disposal.  In this chapter we will go through exercises that illustrate the use of various paradigms in software design and system architecture, and show how in Lisp you can freely mix-and-match paradigms without confusing either the compiler or another programmer reviewing your code.

This chapter will contain exercises on:

* The Multi-Paradigm Approach
* Imperative vs. Declarative
* Procedural Programming
* Object-Oriented Programming
* Functional Programming
* Alternate Paradigms of Interest

## Exercise 2.1.1

**The Multi-Paradigm Approach**

```lisp

```

## Exercise 2.1.2

**Imperative Programming**

```lisp

```

## Exercise 2.1.3

**Declarative Programming**

```lisp

```

## Exercise 2.1.4

**Procedural Programming**

```lisp

```

## Exercise 2.1.5

**Object-Oriented Programming**

```lisp

```

## Exercise 2.1.6

**Pure Functional Programming**

```lisp

```

## Exercise 2.1.7

**Functional Programming in Practice**

```lisp

```

## Exercise 2.1.8

**Metaprogramming**

```lisp

```

## Exercise 2.1.9

**Combining Paradigms: the wrong way**

```lisp

```

## Exercise 2.1.10

**Combining Paradigms: the right way**

```lisp

```

## Exercise 2.1.11

**The Style Guide, revisited**

```lisp

```

## Exercise 2.1.12

**Alternate Paradigms: Aspect-Oriented**

```lisp

```

## Exercise 2.1.13

**Alternate Paradigms: Agent-Oriented**

```lisp

```

## Exercise 2.1.14

**Alternate Paradigms: Flow-Based Programming**

```lisp

```

## Exercise 2.1.15

**Alternate Paradigms: Functional--Reactive Programming**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/2-0-0-overview/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/2-02-0-regex/">Next &raquo;</a><li>
</ul>
