<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li class="active">Part Two: The Suffusion of Blue</li>
</ol>

## PART TWO

# The Suffusion of Blue

> "The door dilated."
> <footer>Robert A. Heinlein, <em>Beyond This Horizon</em></footer>

It's time to take your Lisp skills up a notch.  Hopefully, you took some time off after Part One as suggested, to let the material sink in deep into your unconscious.  By this point, you may be thinking and dreaming in Lisp---literally.  And when faced with any problem, you may find yourself automatically plotting in your mind how this problem could be represented in S-Expressions.  Ideally, you even may have begun to notice the drastic and startling phenomenon of "Grokking"---each new chapter in Part One adding a new degree of seeming mystic revelation to the already magickal experience that is Lisp.

As Zen Buddhism teaches, however, it is important to not get sucked in to the particular *tokens* of these revelatory experiences---they are, after all, a product of your imagination fuelled by the power and expressiveness of Lisp syntax.  To really harness and master Lisp, however, you need to push past these tokens to the phenomenon known as *the Clear Light* or *the Suffusion of Blue*---it doesn't really have a colour, of course, and it's not really *light* or even true *enlightenment*.  It's just the threshold, as you take your first step on your journey as a Lisp Hacker.  And on this journey, you will learn to see not the black and white extremes encapsulated in the symbol of the Yin-Yang---but every colour in the space between.

But enough with the metaphors for now.  From a practical standpoint, in Part Two you'll be learning all the advanced features of the Common Lisp language---the secrets of multi-paradigm programming; CLOS, the Common Lisp Object System; Regular Expressions and Pattern Matching; Persistent storage and serialization; writing custom types; parellel processing; advanced mathematics and logic; working with binary, assembly language, and the compiler; the foreign-function interface; and a whole lot more.

### Chapters

1. [Programming Paradigms](/book/2-01-0-programming-paradigms/)
2. [Regular Expressions](/book/2-02-0-regex/)
3. [Objects and Control Structures](/book/2-03-0-objects-control/)
4. [Persistence and Databases](/book/2-04-0-data-persistence/)
5. [Extended Types](/book/2-05-0-extended-types/)
6. [Concurrency and Memoization](/book/2-06-0-threads-memos-parallel/)
7. [Logic and Advanced Math](/book/2-07-0-logic-and-more-math/)
8. [Number Theory](/book/2-08-0-number-theory/)
9. [Binary Streams, Octet-Vectors, and Bit-Vectors](/book/2-09-0-binary-octets-bits/)
10. [An Improved Text Adventure Engine](/book/2-10-0-improved-text-adventure-engine/)
11. [Conditions and Error Handling](/book/2-11-0-conditions/)
12. [Write a 2D Game](/book/2-12-0-2d-game/)
13. [The Compiler](/book/2-13-0-compiler/)
14. [Write a Tree-Shaker](/book/2-14-0-tree-shaker/)
15. [Documentation and Inspection](/book/2-15-0-docs-and-inspection/)
16. [Foreign Libraries in Lisp](/book/2-16-0-foreign-libs/)
17. [Debugging and Unit Testing](/book/2-17-0-debugging-testing/)
18. [Write a Foreign Function Interface](/book/2-18-0-ffi/)
19. [Essential Lisp Libraries](/book/2-19-0-essential-libs/)
20. [Packaging Lisp Libraries](/book/2-20-0-packaging-libs/)
21. [Detailed Syntax Review](/book/2-21-0-review/)

<ul class="pager">
  <li class="previous"><a href="/book/1-20-0-review/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/2-01-0-programming-paradigms/">Next &raquo;</a><li>
</ul>
