<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/1-0-0-overview/">Part One: Grokking Lisp</a></li>
  <li class="active">Format Strings</li>
</ol>

## Chapter 1.18

# Format Strings

> "Logic is a feeble reed, friend. 'Logic' proved that airplanes can't fly and that H-bombs won't work and that stones don't fall out of the sky. Logic is a way of saying that anything which didn't happen yesterday won't happen tomorrow."
> <footer>Robert A. Heinlein, <em>Glory Road</em></footer>

You already got a small taste of `format` in Chapter 1.2, but we barely scratched the surface of what it can do.  Like the Loop macro, `format` has many detractors in the Lisp community---but it's one of those tools that is so ridiculously powerful and concise, it's worth getting to know and using, no matter how scary it might look at first.

Almost everything you can do in Common Lisp, you can also do inside a format string.  It gives you so much programmatic control over your application's textual output, that it could rightly be considered its own programming language for manipulating strings---but you get it for free as part of Lisp.  The syntax of format strings is, in-fact, a full Domain-Specific Language.

But don't let that scare you---you already know the basics of writing format strings, and now you know enough about Lisp to make use of format's most powerful features.

This chapter will contain exercises on:

* The FORMAT Function
* Conditionals
* Iteration
* Numbers
* Unprintable Objects
* Etc.

## Exercise 1.18.1

**The FORMAT Function**

## Exercise 1.18.2

**The Stream Parameter**

## Exercise 1.18.3

**Format Strings**

## Exercise 1.18.4

**Format Directives**

## Exercise 1.18.5

**Consuming and Non-Consuming Directives**

## Exercise 1.18.6

**Arguments to Format Strings**

## Exercise 1.18.7

**Numbers**

## Exercise 1.18.8

**Printing**

## Exercise 1.18.9

**Case Conversion**

## Exercise 1.18.10

**Layout**

## Exercise 1.18.11

**Conditionals**

## Exercise 1.18.12

**Iteration**

## Exercise 1.18.13

**Control Flow**

## Exercise 1.18.14

**Pretty-Printing**

## Exercise 1.18.15

**Unprintable Objects**

## Exercise 1.18.16

**Recursive Processing**

## Exercise 1.18.17

**Function Calls**


<ul class="pager">
  <li class="previous"><a href="/book/1-17-0-iterate/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/1-19-0-dsl/">Next &raquo;</a><li>
</ul>
