<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/1-0-0-overview/">Part One: Grokking Lisp</a></li>
  <li class="active">Extra Credit: A Simple Text Adventure</li>
</ol>

## Chapter 1.11 --- Extra Credit

# A Simple Text Adventure

> "Morals&mdash;all correct moral laws&mdash;derive from the instinct to survive. Moral behavior is survival behavior above the individual level."
> <footer>Robert A. Heinlein, <em>Starship Troopers</em></footer>

Now that you're about half-way through Part One, it's time to have a little fun and write a game.  You now know how to write your own functions to extend the Lisp language, write macros that expand into the code you need at compile-time, store your data in variables, prompt your users for input, and do some fun stuff with math and strings---so now it's time to put it all together to write a classic console text-based Adventure game that you can share with your friends, family, and other L(&lambda;)THW students.

A really important aspect of this chapter is to write a game of your very own---but first you need to understand the steps required to write a game of any kind.  As such, you'll have to go through this chapter at least twice---the first time, follow along with me and implement the game exactly as I have, and stick to the five steps of the Hard Way methodology as normal; the second time, replace my game's theme, story, characters, and world with your own, and get creative with the code---experiment, innovate, and don't be afraid to break the program, take this as an opportunity to practice your debugging skills too.

Once you're done working through this chapter for the second time and you get your own unique game to run, and you can play through it from beginning to end, feel free to create a repo or gist and share it in the comments below.  But remember, no cheating!  Make sure you've gone through this chapter at least twice, and successfully played through your own game, before you poke around through other people's code for ideas.

<div class="alert alert-info">
  <strong>Note:</strong>
  <p>This chapter will guide you through writing a straightforward, hard-coded game; in other words, it will have to be recompiled every time you make a change to the source.  This doesn't necessarily represent best practices for game development.  In Parts Two and Three, alternate implementations of game engines will be presented that will load game resources on the fly from your computer's file system, so that you only have to re-compile the game when you change the program logic, and not the game content.
</div>

This chapter will contain exercises on:

* ASCII-art and Text Adventure Aesthetics
* Building your game interface
* Your game's theme, story, and characters
* Your game's world
* Movement through the game world
* Interacting with the game world
* Collecting and using items in the game world
* Non-player Characters
* Quick and Dirty AI enemies
* Packaging and Running your game

## Exercise 1.11.1

**ASCII-Art and ANSI Escape Codes**

```lisp

```

## Exercise 1.11.2

**The Game Interface**

```lisp

```

## Exercise 1.11.3

**Theme, Story, and Characters**

```lisp

```

## Exercise 1.11.4

**The Game World**

```lisp

```

## Exercise 1.11.5

**Movement in the Game World**

```lisp

```

## Exercise 1.11.6

**Interacting with the Game World**

```lisp

```

## Exercise 1.11.7

**Collecting and Using Items in the Game World**

```lisp

```

## Exercise 1.11.8

**Non-Player Characters**

```lisp

```

## Exercise 1.11.9

**Quick and Dirty AI Enemies**

```lisp

```

## Exercise 1.11.10

**Packaging and Running Your Game**

```lisp

```

<ul class="pager">
  <li class="previous"><a href="/book/1-10-0-functions/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/1-12-0-namespaces/">Next &raquo;</a><li>
</ul>
