<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/1-0-0-overview/">Part One: Grokking Lisp</a></li>
  <li><a href="/book/1-02-00-input-output/">Printing, Strings, and Streams</a></li>
  <li class="active">Exercise 11: Printing With <code>princ</code></li>
</ol>

## Exercise 1.2.11

# Printing With <code>princ</code>

When you want to send a string to a stream that's meant for your users and not the Lisp Reader, you'll want to use the `princ` function.  It sets the Lisp Printer parameters `:escape` and `:readably` to `nil`, so that your users can see the string you intended, and not the string you had to type in Lisp to not break anything.

```lisp
(princ "Hello, multiverse!")

(princ "My name is \"Colin\".")
```

<div class="alert alert-success">
    <strong>Tip:</strong>
    <p>As an exception to the usual rule of "Type exactly what I type", you <em>can</em> change my name to yours whenever it comes up in a source-code example.  Just make sure it runs!</p>
</div>

#### What You Should See

```lisp
* (princ "Hello, multiverse!")
Hello, multiverse!
"Hello, multiverse!"
* (princ "My name is \"Colin\".")
My name is "Colin".
"My name is \"Colin\"."
```

Now the difference between the *printed* string and the *return result* for a function should be more clear.  You can see above what setting the Lisp Printer parameters `:escape` and `:readably` to `nil` do: it prints the characters in a string un-escaped, not printing the outer quotation marks---so your users get exactly the string you intended.

The `princ` function, like the other Lisp Printer functions we've covered so far, still returns the original string object after it has been printed to a stream.  This is not the case with `format`, which we'll go over briefly in the next two exercises.

<ul class="pager">
  <li class="previous"><a href="/book/1-02-10-prin1/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/1-02-12-format/">Next &raquo;</a><li>
</ul>
