<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/1-0-0-overview/">Part One: Grokking Lisp</a></li>
  <li><a href="/book/1-02-00-input-output/">Printing, Strings, and Streams</a></li>
  <li class="active">Exercise 10: Printing With <code>prin1</code></li>
</ol>

## Exercise 1.2.10

# Printing With <code>prin1</code>

The `prin1` function is very similar to `print`, except it doesn't output a preceding newline or a trailing space. Its emphasis is on printing readably for the Lisp Reader, *i.e.,* what you print with `prin1` is meant to be read again as source code.  Like `print`, `prin1` sets the Lisp printer paramater `:escape` to `t`, so special characters are printed escaped in strings, the same way you have to type them at the REPL and in your Lisp source files.

```lisp
(prin1 "Although largely uninteresting, this \"string\" has escaped characters in it.")

(prin1 "Remember, since the backslash (\\) is the escape character, it needs to be escaped too.")

(prin1 "\Y\o\u\ \c\a\n\ \a\l\s\o\ \e\s\c\a\p\e\ \e\v\e\r\y\ \c\h\a\r\a\c\t\e\r\ \i\n\ \a\ \s\t\r\i\n\g\.")
```

#### What You Should See

```lisp
* (prin1 "Although largely uninteresting, this \"string\" has escaped characters in it.")
"Although largely uninteresting, this \"string\" has escaped characters in it."
"Although largely uninteresting, this \"string\" has escaped characters in it."
* (prin1 "Remember, since the backslash (\\) is the escape character, it needs to be escaped too.")
"Remember, since the backslash (\\) is the escape character, it needs to be escaped too."
"Remember, since the backslash (\\) is the escape character, it needs to be escaped too."
* (prin1 "\Y\o\u\ \c\a\n\ \a\l\s\o\ \e\s\c\a\p\e\ \e\v\e\r\y\ \c\h\a\r\a\c\t\e\r\ \i\n\ \a\ \s\t\r\i\n\g\.")
"You can also escape every character in a string."
"You can also escape every character in a string."
```

Notice how only the characters that need to be escaped in a string are printed and returned escaped? As far as the Lisp Reader is concerned, a string can contain any character---but since the double-quote character terminates a string, it needs to be escaped if you want it printed, and since the escape character used would normally escape the following character, you also have to escape the backslash to print it.  But that's it.  Every other character supported by your implementation's current encoding can be included in a string.

<ul class="pager">
  <li class="previous"><a href="/book/1-02-09-more-printing/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/1-02-11-princ/">Next &raquo;</a><li>
</ul>
