<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/1-0-0-overview/">Part One: Grokking Lisp</a></li>
  <li class="active">Printing, Strings, and Streams</li>
</ol>

## Chapter 1.2

# Printing, Strings, and Streams

> "There is no such thing as luck; there is only adequate or inadequate preparation to cope with a statistical universe."
> <footer>Robert A. Heinlein, <em>Have Space Suit---Will Travel</em></footer>

Now that you've got an idea of what Lisp is all about and you have your development environment configured to your liking, we can get moving on some real, practical code.

At the end of the day, no matter what the program you're working on does, at some point you will have to give something back to the user.  The more interactive the program, the more data will be going back and forth between the user and your program.  And users love interactivity---they like to know just how long a set of tasks will take, they want to see updates to data in real-time, they want feedback.

Since development in Lisp is so inherently interactive, it makes sense to think about your programs this way too.  So we will be starting our exploration of Common Lisp with the core language features that underlie input and output: printing, strings, and streams.

### Exercises:

* [Strings](/book/1-02-01-strings/)
* [More Strings](/book/1-02-02-more-strings/)
* [Unicode and Strings](/book/1-02-03-unicode/)
* [Characters](/book/1-02-04-chars/)
* [More Characters](/book/1-02-05-more-chars/)
* [Character Codes](/book/1-02-06-char-codes/)
* [Strings from Chars](/book/1-02-07-strings-from-chars/)
* [Printing](/book/1-02-08-printing/)
* [More Printing](/book/1-02-09-more-printing/)
* [Printing With prin1](/book/1-02-10-prin1/)
* [Printing With princ](/book/1-02-11-princ/)
* [A Brief Introduction to Format](/book/1-02-12-format/)
* [A Little Bit More on Format](/book/1-02-13-more-format/)
* [Pathnames](/book/1-02-14-pathnames/)
* [Streams](/book/1-02-15-streams/)
* [File Streams](/book/1-02-16-file-streams/)
* [Binary Streams](/book/1-02-17-binary-streams/)
* [Prompting Users](/book/1-02-18-prompting-users/)
* [Pretty-Printing](/book/1-02-19-pretty-printing/)

<ul class="pager">
  <li class="previous"><a href="/book/1-01-09-emacs-live/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/1-02-01-strings/">Next &raquo;</a><li>
</ul>
