<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/1-0-0-overview/">Part One: Grokking Lisp</a></li>
  <li><a href="/book/1-01-00-lisp-bootcamp/">Common Lisp Bootcamp</a></li>
  <li class="active">The REPL</li>
</ol>

## Exercise 1.1.2

# The REPL

The Lisp REPL---a READ-EVAL-PRINT Loop---is the core of the interactive approach to Lisp development.  You type in an expression, the expression is *read*, *evaluated*, the return result is *printed*, and then it waits for more input.  The REPL is marked by a prompt, like the command line for your operating system, and it is the main interface to your current running Lisp image. Depending on the implementation of Lisp you are using, you may see different prompts.  You can also customize your prompt, but the means of doing so are implementation-dependent.

Typically, imagining that the underscore character below is your blinking cursor, you'll see something to the effect of:

```lisp
CL-USER> _
```

But in SBCL, the default prompt is much less informative:

```lisp
* _
```

For convenience sake, when you should enter a piece of code in the REPL for immediate evaluation, each line of code will be marked by the SBCL prompt character.  When you should enter all the code given in a file, there will be no prompt character preceding each line, and you will be provided with a file name to enter it in.

Remember, you don't type in the prompt character `*` at the REPL; even if your prompt looks different, the `*` *represents* all Common Lisp REPL prompts.  For example, you'll often see code examples like this:

```lisp
* (+ 1 1)

2
* (apply #'+ 1 2 3 4 '(5 6))

21
```

The example above means, you first enter the expression `(+ 1 1)` in the REPL; evaluating it returns the result `2`, exactly what you would expect to get back for 1 + 1.  Then, you get back to the prompt, and can enter the expression, `(apply #'+ 1 2 3 4 '(5 6))`, which returns `21`.  If you're using SBCL from the command-line, this shows a direct transcript of the session---extra line-break between the evaluated expression and return result and all.  If you are using Emacs+SLIME, you won't see that extra line-break.

A lot of Lisp literature and reference works explicitly mark the return value with an ASCII-formatted fat arrow: `=>`.  This can make spotting the return value of a form much easier in examples.  We will adopt this convention herein as well, when it is necessary for visual clarity.  In such a case, the examples above would then look like this:

```lisp
* (+ 1 1)
=> 2
* (apply #'+ 1 2 3 4 '(5 6))
=> 21
```

In most exercises, we will separate the code examples into two copies: first, just the code you are meant to type, and then again with the correct return results for you to compare your work.

<ul class="pager">
  <li class="previous"><a href="/book/1-01-01-syntax-overview/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/1-01-03-expressions/">Next &raquo;</a><li>
</ul>
