<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li><a href="/book/1-0-0-overview/">Part One: Grokking Lisp</a></li>
  <li class="active">Common Lisp Bootcamp</li>
</ol>

## Chapter 1

# Common Lisp Bootcamp

> "I made a very important discovery at Camp Currie.  Happiness consists in getting enough sleep.  Just that, nothing more.  All the wealthy, unhappy people you've ever met take sleeping pills; Mobile Infantrymen don't need them."
> <footer>Robert A. Heinlein, <em>Starship Troopers</em></footer>

It's time to dive head-first into Lisp, no mercy.  You'll need discipline to apply the five steps of learning the hard way, and this is where you'll get a feel for it.  But one thing you need to remember, which many programmers often forget before working themselves to burn-out, the most important thing you need to learn is to get a good night's sleep, every night, on time, so you can wake up fully refreshed to tackle Lisp again the next day.  Make yourself a schedule, a strict one, and follow it like you have a Sergeant throwing you out of your cot every morning, screaming at you all day to push yourself harder.  Eat right, take regular breaks from the computer, work hard, and sleep, and you'll find the learning process far more successful and rewarding.

There is a reason, after all, the military uses this methodology for training---it's an application of the metaphor of alchemy, realized in nuclear physics: given enough heat and pressure, you can in fact turn lead into gold. But now, on to Lisp.  Here is everything you need to know to get hacking in Lisp right this second.

* [Syntax Overview in 5 Minutes](/book/1-01-01-syntax-overview/)
* [The REPL](/book/1-01-02-repl/)
* [Expressions, Parentheses, and Return Values](/book/1-01-03-expressions/)
* [Lists, Cons-Cells, and Memory](/book/1-01-04-lists-cons-cells/)
* [Symbols and Namespaces](/book/1-01-05-symbols/)
* [Prefix Notation](/book/1-01-06-prefix-notation/)
* [Common Lisp Style Guide](/book/1-01-07-style-guide/)
* [Configuring Your Development Environment](/book/1-01-08-configuration/)
* Extra Credit: [Set up and Learn Emacs Live](/book/1-01-09-emacs-live/)

<ul class="pager">
  <li class="previous"><a href="/book/1-0-0-overview/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/1-01-01-syntax-overview/">Next &raquo;</a><li>
</ul>
