<ol class="breadcrumb">
  <li><a href="/">Home</a></li>
  <li><a href="/book/">Book</a></li>
  <li class="active">PART ONE: Grokking Lisp</li>
</ol>

## PART ONE

# Grokking Lisp

> "'Grok' means to understand so thoroughly that the observer becomes a part of the process being observed—to merge, to blend, to intermarry, to lose personal identity in group experience. It means almost everything that we mean by religion, philosophy, and science—and it means as little to us as color means to a blind man."
> <footer>Robert A. Heinlein, <em>Stranger in a Strange Land</em></footer>

Lisp isn't a language you just *learn*.  It changes you, as a programmer and a person.

In Part One, we focus on the core of the Common Lisp language, features that you will use every day, and techniques that will change the way you see programming.

We'll start with a high-level overview of the whole language, working through the details of syntax, semantics, style, and configuration of your development environment.

From there we'll move on to strings, characters, writing, and printing; prompting for user input; lists, trees, and special lists like alists and plists; math, vectors and arrays; lexical scope and variables; and functions.

Then we'll build our first application, a straight-forward text-adventure, using everything you've learned up to that point; extend this knowlege to a simple web application and command-line utilities, explore more advanced features of the language, and writing domain-specific languages for even more control over syntax.

### Chapters

1. [Common Lisp Bootcamp](/book/1-01-00-lisp-bootcamp/)
2. [Printing, Strings and Streams](/book/1-02-00-input-output/)
3. [Getting Input From Users](/book/1-03-0-getting-input-from-users/)
4. [Lists and List-Operations](/book/1-04-0-lists/)
5. [Look-up Lists and Trees](/book/1-05-0-lookups-trees/)
6. [Numbers and Math](/book/1-06-0-math/)
7. [Arrays and Vectors](/book/1-07-0-arrays/)
8. [Variables, Parameters, and Constants](/book/1-08-0-variables/)
9. [Closures](/book/1-09-0-closures/)
10. [Functions and Macros](/book/1-10-0-functions/)
11. [A Simple Text Adventure](/book/1-11-0-text-adventure/)
12. [Namespaces, Symbols, Packages, and Systems](/book/1-12-0-namespaces/)
13. [A Simple Web Application](/book/1-13-0-simple-web-app/)
14. [Conditionals](/book/1-14-0-conditionals/)
15. [Command-Line Utilities](/book/1-15-0-command-line-utility/)
16. [Mapping and Looping](/book/1-16-0-map-loop/)
17. [Revisiting Loops with Iterate](/book/1-17-0-iterate/)
18. [Format Strings](/book/1-18-0-format/)
19. [Domain Specific Languages](/book/1-19-0-dsl/)
20. [Part One in Review](/book/1-20-0-review/)

<ul class="pager">
  <li class="previous"><a href="/book/acknowledgements/">&laquo; Previous</a></li>
  <li><a href="/book/">Table of Contents</a></li>
  <li class="next"><a href="/book/1-01-00-lisp-bootcamp/">Next &raquo;</a><li>
</ul>
