import * as React from 'react';
import PropTypes from 'prop-types';
import Toolbar from '@mui/material/Toolbar';
import Button from '@mui/material/Button';
import Typography from '@mui/material/Typography';
import Link from '@mui/material/Link';
import SearchAppBar from "./SearchBar";
import {ACCESS_TOKEN} from "../../util/constants";
import {useState} from "react";
import {FormControlLabel, Switch} from "@mui/material";
import {styled} from "@mui/material/styles";
import {ENG} from "../../util/constants/language";


const LightMode = styled(Switch)(({theme}) => ({
    width: 62,
    height: 34,
    padding: 7,
    '& .MuiSwitch-switchBase': {
        margin: 1,
        padding: 0,
        transform: 'translateX(6px)',
        '&.Mui-checked': {
            color: '#fff',
            transform: 'translateX(22px)',
            '& .MuiSwitch-thumb:before': {
                backgroundImage: `url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" height="20" width="20" viewBox="0 0 20 20"><path fill="${encodeURIComponent(
                    '#fff',
                )}" d="M4.2 2.5l-.7 1.8-1.8.7 1.8.7.7 1.8.6-1.8L6.7 5l-1.9-.7-.6-1.8zm15 8.3a6.7 6.7 0 11-6.6-6.6 5.8 5.8 0 006.6 6.6z"/></svg>')`,
            },
            '& + .MuiSwitch-track': {
                opacity: 1,
                backgroundColor: theme.palette.mode === 'dark' ? '#8796A5' : '#aab4be',
            },
        },
    },
    '& .MuiSwitch-thumb': {
        backgroundColor: theme.palette.mode === 'dark' ? '#003892' : '#001e3c',
        width: 32,
        height: 32,
        '&:before': {
            text: 'en',
            content: "''",
            position: 'absolute',
            width: '100%',
            height: '100%',
            left: 0,
            top: 0,
            backgroundRepeat: 'no-repeat',
            backgroundPosition: 'center',
            backgroundImage: `url('data:image/svg+xml;utf8,<svg xmlns="http://www.w3.org/2000/svg" height="20" width="20" viewBox="0 0 20 20"><path fill="${encodeURIComponent(
                '#fff',
            )}" d="M9.305 1.667V3.75h1.389V1.667h-1.39zm-4.707 1.95l-.982.982L5.09 6.072l.982-.982-1.473-1.473zm10.802 0L13.927 5.09l.982.982 1.473-1.473-.982-.982zM10 5.139a4.872 4.872 0 00-4.862 4.86A4.872 4.872 0 0010 14.862 4.872 4.872 0 0014.86 10 4.872 4.872 0 0010 5.139zm0 1.389A3.462 3.462 0 0113.471 10a3.462 3.462 0 01-3.473 3.472A3.462 3.462 0 016.527 10 3.462 3.462 0 0110 6.528zM1.665 9.305v1.39h2.083v-1.39H1.666zm14.583 0v1.39h2.084v-1.39h-2.084zM5.09 13.928L3.616 15.4l.982.982 1.473-1.473-.982-.982zm9.82 0l-.982.982 1.473 1.473.982-.982-1.473-1.473zM9.305 16.25v2.083h1.389V16.25h-1.39z"/></svg>')`,
        },
    },
    '& .MuiSwitch-track': {
        opacity: 1,
        backgroundColor: theme.palette.mode === 'dark' ? '#8796A5' : '#aab4be',
        borderRadius: 20 / 2,
    },
}));
const Language = styled(Switch)(({theme}) => ({
    width: 62,
    height: 34,
    padding: 7,
    '& .MuiSwitch-switchBase': {
        margin: 1,
        padding: 0,
        transform: 'translateX(6px)',
        '&.Mui-checked': {
            color: '#fff',
            transform: 'translateX(22px)',
            '& + .MuiSwitch-track': {
                opacity: 1,
                backgroundColor: theme.palette.mode === 'dark' ? '#8796A5' : '#aab4be',
            },
        },
    },
    '& .MuiSwitch-thumb': {
        backgroundColor: theme.palette.mode === 'dark' ? '#003892' : '#001e3c',
        width: 32,
        height: 32,
        '&:before': {
            text: 'en',
            content: "''",
            position: 'absolute',
            width: '100%',
            height: '100%',
            left: 0,
            top: 0,
            backgroundRepeat: 'no-repeat',
            backgroundPosition: 'center',
        },
    },
    '& .MuiSwitch-track': {
        opacity: 1,
        backgroundColor: theme.palette.mode === 'dark' ? '#8796A5' : '#aab4be',
        borderRadius: 20 / 2,
    },
}));

function Header({tags, title,mode, choose_tag, changeLan, user, lan,setMode}) {

    const [auth, setAuth] = useState(!localStorage.getItem(ACCESS_TOKEN))

    function logout() {
        localStorage.removeItem(ACCESS_TOKEN)
        setAuth(true)
    }


    return (
        <div className={mode?'p-4 bg-dark text-white':'p-4 text-dark'}>
            <React.Fragment>
                <Toolbar sx={{borderBottom: 1, borderColor: 'divider'}}>
                    <Typography
                        component="h2"
                        variant="h5"
                        color="inherit"
                        align="left"
                        noWrap
                        sx={{flex: 1}}
                    >
                        {title}
                    </Typography>
                    <LightMode onChange={()=>setMode(p=>!p)} sx={{m: 1}}/>

                    {
                        user.id && <FormControlLabel
                            control={<Language onChange={changeLan} sx={{m: 1}} defaultChecked/>}
                            label={lan}
                        />
                    }


                    <SearchAppBar mode={mode} lan={lan}/>
                    {
                        auth ? (
                            <div>
                                <Button href='/' variant='outlined' className='mx-1' size="small">
                                    Menu
                                </Button>
                                <Button href='/login' variant='outlined' className='mx-1' size="small">
                                    Sign in
                                </Button>
                                <Button href='/register' variant='outlined' className='mx-1' size="small">
                                    Sign up
                                </Button>
                            </div>
                        ) : (
                            <div>
                                <Button href='/dashboard' variant='outlined' className='mx-1' size="small">
                                    {lan === ENG ? 'Dashboard' : 'Панель'}
                                </Button>
                                <Button href='/' variant='outlined' className='mx-1' size="small">
                                    {lan === ENG ? 'Menu' : 'Меню'}
                                </Button>
                                <Button onClick={logout} variant='outlined' color={"error"} className='mx-1'
                                        size="small">
                                    {lan === ENG ? 'Logout' : 'Выйти'}
                                </Button>
                            </div>
                        )
                    }

                </Toolbar>
                <Toolbar
                    component="nav"
                    variant="dense"
                    sx={{justifyContent: 'center', overflowX: 'auto'}}
                >
                    {
                        tags && tags.map(tag => (
                            <Link
                                color="inherit"
                                noWrap
                                className='text-decoration-none'
                                key={tag.id}
                                variant="body2"
                                sx={{p: 1, flexShrink: 0}}
                                onClick={() => choose_tag(tag.id)}
                            >
                                {lan === ENG ? tag.name_eng : tag.name_rus}
                            </Link>
                        ))}
                </Toolbar>
            </React.Fragment>
        </div>
    );
}

Header.propTypes = {
    tags: PropTypes.arrayOf(
        PropTypes.shape({
            id: PropTypes.number.isRequired,
            name: PropTypes.string.isRequired,
        }),
    ).isRequired,
    title: PropTypes.string.isRequired,
};

export default Header;




