# The JavaScript Way

An open source book written by [Baptiste Pesquet](https://www.bpesquet.fr) with the help of [many people](concl02.md). Translated to [French](https://github.com/thejsway/thejsway_fr), [Spanish](https://github.com/thejsway/thejsway_es) and [Indonesian](https://github.com/thejsway/thejsway_id). Published under a [Creative Commons](https://raw.githubusercontent.com/thejsway/thejsway/master/LICENSE) license and free to read online here. All code licensed under an [MIT](https://raw.githubusercontent.com/thejsway/thejsway/master/CODE_LICENSE) license. [Contributions](https://github.com/thejsway/thejsway/blob/master/CONTRIBUTING.md) are most welcome.

This book is also available on [Leanpub](https://leanpub.com/thejsway) (PDF, EPUB), [Amazon](https://www.amazon.com/dp/295644462X) (Kindle, paperback) and [Educative](https://www.educative.io/courses/the-complete-javascript-course-build-a-real-world-app-from-scratch) (interactive course).

[![Book cover](images/title_page_small.png)](https://www.amazon.com/dp/295644462X)

## Overview

This book will be a useful companion for anyone wishing to explore the many facets of JavaScript. Numerous brain cycles were spent to make it:

* **Beginner-friendly yet comprehensive**. From the very basics of programming up to front-end and back-end web development, a lot of topics are covered in a simple and approachable way. No prior knowledge needed!
* **Standards-aligned**. The book is entirely written using the recent **ES2016** syntax, giving you future-proof knowledge. From start to finish, it enforces good programming habits, embraces the ubiquitous JavaScript tools [ESLint](http://eslint.org) and [Prettier](https://prettier.io/).
* **Hands-on**. No real learning happens without practicing! Each chapter is accompanied by a series of exercises to put your newly acquired skills into action. A three-part project will guide you in the creation of a social news web application ([see it in action](https://thejsway-publink.herokuapp.com)).
* **Easy to follow**. Code along directly in your browser or build an efficient JavaScript development environment on your local machine.

## Supporting this work

A lot of time and energy went into this content. If you find it useful and want to support this effort, here's what you can do:

* Buy it under one of the available formats (see above). Any financial contribution would be much appreciated.
* Rate it or leave a review on [Goodreads](https://www.goodreads.com/book/show/35875290-the-javascript-way-a-modern-introduction-to-an-essential-language?from_search=true) or [Amazon](https://www.amazon.com/dp/295644462X).
* Spread the word about it.

Thanks in advance for your support!
