# Contribution guidelines

First off, thank you for considering contributing to this project. Any help would be much appreciated.

## How to contribute

Please feel free to improve the quality of this content by submitting **pull requests**. A merged PR will make you appear in the contributor list. It will, however, be considered a donation of your work to this project. You are still bound by the conditions of the license, meaning that you are not considered an author or owner of the content once it has been merged in.

You may also open **issues** for pointing out mistakes or suggesting ideas.

## Support (or lack thereof)

Please do *not* use issues to ask for help because you're stuck in an exercise or a project. Unfortunately, I don’t have enough free time to answer individual requests, so these issues would be closed immediately.

Instead, start by searching the web and ask your questions on programming forums like [Stack Overflow](https://stackoverflow.com) or [Reddit](https://www.reddit.com/r/learnjavascript/). Knowing how to find answers online is a key skill for a developer!

## Markdown flavor

This book is entirely written in [Markdown](https://www.markdownguide.org/), an easy-to-use text document format.

The online version is powered by [Material for Mkdocs](https://squidfunk.github.io/mkdocs-material/). This documentation system extends Markdown with many [useful additions](https://squidfunk.github.io/mkdocs-material/reference/).

Ebook and paperback versions are generated by the [Leanpub](https://leanpub.com/) engine. A non-public script converts Material Markdown extensions  to the Leanpub-specific syntax.

## Translation guidelines

Not everyone speaks English. You are very welcome to translate this book into your own language. All translations are published under a common [GitHub organization](https://github.com/thejsway). Please note that the original copyright and [license](LICENSE) still apply, so commercial use of any translated material is prohibited.

### Contributing to an existing language

Ask to join a translation team in the organization or create an issue in the translated repository, mentioning @bpesquet in the issue's body. I will add you to the team.

### Starting a new translation

Create an issue in this repository to define your target language, mentioning @bpesquet in the issue's body. I will create the corresponding repo and a new translation team, then add you to it. You might rename the repository and edit its description to your liking, but please keep the original copyright and license.
