# UnlimitedGPT

[![Downloads](https://static.pepy.tech/badge/unlimitedgpt)](https://pepy.tech/project/unlimitedgpt)
[![PyPi](https://img.shields.io/pypi/v/UnlimitedGPT.svg)](https://pypi.python.org/pypi/UnlimitedGPT)
[![License](https://img.shields.io/github/license/Sxvxgee/UnlimitedGPT.svg?color=green)](https://github.com/Sxvxgee/UnlimitedGPT/blob/main/LICENSE)
[![Twitter Follow](https://img.shields.io/twitter/follow/Sxvxgeness.svg?style=social)](https://twitter.com/Sxvxgeness)

UnlimitedGPT is a Python library for using the ChatGPT website as an alternative API to the OpenAI paid API.

UnlimitedGPT makes it easy to send messages and receive responses. UnlimitedGPT can also do a wide range of things such as getting the user data, getting the session data, clearing all conversations, resetting the current conversation, switching themes, switching accounts, and logging out from the session.

![Preview](https://raw.githubusercontent.com/Sxvxgee/UnlimitedGPT/main/docs/assets/preview.png)

## Compatibility
UnlimitedGPT works on Windows, Linux and macOS. It also works on Google Colab and other headless  linux servers. UnlimitedGPT requires Python 3.8 or later.

## Features

-   [x] Cloudflare's anti-bot protection bypass using `undetected_chromedriver`
-   [x] [Headless machines support](#how-do-i-get-it-to-work-on-headless-linux-server)
-   [x] [Google Colab support](#how-do-i-get-it-to-work-on-google-colab)
-   [x] Proxy support (only without basic auth)
-   [x] Automate almost everything in ChatGPT.
-   [x] Supports sending messages and receiving responses, as well as regenerating them.
-   [x] Supports using the **BACKEND API**!
-   [x] Supports imitating human typing, with cusotmized delays.
-   [x] Supports switching between different accounts.
-   [x] Supports switching between different themes.
-   [x] Supports getting the session data, along with the user data.
-   [x] Supports logging out from the session.
-   [x] Supports toggling chat history on/off.

and so much more!

## Documentation
You can find the documentation [here](https://github.com/Sxvxgee/UnlimitedGPT/blob/main/docs/README.md).

## Changelog
You can find the changelog [here](https://github.com/Sxvxgee/UnlimitedGPT/blob/main/CHANGELOG.md).

## Insipration

This project is inspired by

-   [ChatGPT](https://github.com/acheong08/ChatGPT)
-   [chatgpt-api](https://github.com/transitive-bullshit/chatgpt-api)
-   [pyChatGPT](https://github.com/terry3041/pyChatGPT)

## Disclaimer

- This project is not affiliated with OpenAI in any way. Use at your own risk. I am not responsible for any damage caused by this project. Please read the [OpenAI Terms of Service](https://beta.openai.com/terms) before using this project.
- This project is not built from scratch by me, I just modified, improved and fixed the original code of [pyChatGPT](https://github.com/terry3041/pyChatGPT) since I noticed there were already some PRs and they were not responded to by the terry3041. I also added some new features to the package, and will keep on doing so.

## License

This project is licensed under the GPLv3 License - see the [LICENSE](LICENSE) file for details.

## Star History

[![Star History Chart](https://api.star-history.com/svg?repos=theAbdoSabbagh/UnlimitedGPT&type=Date)](https://star-history.com/#Sxvxgee/UnlimitedGPT&Date)
