/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import com.healthmarketscience.jackcess.Database;
import com.healthmarketscience.jackcess.DatabaseBuilder;
import com.healthmarketscience.jackcess.Row;
import com.healthmarketscience.jackcess.Table;
import com.healthmarketscience.jackcess.util.LinkResolver;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileLock;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import net.ucanaccess.converters.LoadJet;
import net.ucanaccess.jdbc.DBReferenceSingleton;
import net.ucanaccess.jdbc.JackcessOpenerInterface;
import net.ucanaccess.jdbc.OnReloadReferenceListener;
import net.ucanaccess.jdbc.Session;
import net.ucanaccess.jdbc.UcanaccessDriver;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.util.Logger;

public class DBReference {
    private static final String CIPHER_SPEC = "AES";
    private static List<OnReloadReferenceListener> onReloadListeners = new ArrayList<OnReloadReferenceListener>();
    private static String version;
    private File dbFile;
    private Database dbIO;
    private FileLock fileLock = null;
    private String id = this.id();
    private boolean inMemory = true;
    private long lastModified;
    private boolean openExclusive = false;
    private MemoryTimer memoryTimer;
    private boolean readOnly;
    private boolean readOnlyFileFormat;
    private boolean showSchema;
    private File tempHsql;
    private File toKeepHsql;
    private boolean immediatelyReleaseResources;
    private boolean encryptHSQLDB;
    private String encryptionKey;
    private String pwd;
    private JackcessOpenerInterface jko;
    private Map<String, String> externalResourcesMapping;
    private boolean firstConnection = true;
    private Database.FileFormat dbFormat;
    private boolean columnOrderDisplay;
    private boolean hsqldbShutdown;
    private File mirrorFolder;
    private Set<File> links = new HashSet<File>();
    private boolean ignoreCase = true;
    private boolean mirrorReadOnly;
    private Integer lobScale;
    private boolean skipIndexes;
    private boolean sysSchema;
    private boolean preventReloading;
    private boolean concatNulls;
    private boolean mirrorRecreated;

    public DBReference(File fl, Database.FileFormat ff, JackcessOpenerInterface _jko, final String _pwd) throws IOException, SQLException {
        this.dbFile = fl;
        this.pwd = _pwd;
        this.jko = _jko;
        this.lastModified = System.currentTimeMillis();
        this.memoryTimer = new MemoryTimer(this);
        Logger.turnOffJackcessLog();
        if (!fl.exists() && ff != null) {
            this.dbIO = DatabaseBuilder.create((Database.FileFormat)ff, (File)fl);
        } else {
            this.dbIO = _jko.open(fl, _pwd);
            try {
                this.readOnlyFileFormat = this.dbIO.getFileFormat().equals((Object)Database.FileFormat.V1997);
                this.dbFormat = this.dbIO.getFileFormat();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.dbIO.setLinkResolver(new LinkResolver(){

                public Database resolveLinkedDatabase(Database linkerDb, String linkeeFileName) throws IOException {
                    if (linkeeFileName == null) {
                        throw new IOException("Cannot resolve db link");
                    }
                    File linkeeFile = new File(linkeeFileName);
                    Map emr = DBReference.this.externalResourcesMapping;
                    if (!linkeeFile.exists() && emr != null && emr.containsKey(linkeeFileName.toLowerCase())) {
                        linkeeFile = new File((String)emr.get(linkeeFileName.toLowerCase()));
                    }
                    if (!linkeeFile.exists()) {
                        Logger.logWarning("External file " + linkeeFile.getAbsolutePath() + " does not exist");
                    } else {
                        DBReference.this.links.add(linkeeFile);
                    }
                    Database ldb = DBReference.this.open(linkeeFile, _pwd);
                    return ldb;
                }
            });
            this.dbIO.setEnforceForeignKeys(Boolean.valueOf(false));
        }
    }

    public Database open(File _dbfl, String _pwd) throws IOException {
        Logger.turnOffJackcessLog();
        Database ret = this.jko.open(_dbfl, _pwd);
        if (this.columnOrderDisplay) {
            ret.setColumnOrder(Table.ColumnOrder.DISPLAY);
        }
        return ret;
    }

    boolean loadedFromKeptMirror(Session session) throws UcanaccessSQLException {
        if (this.toKeepHsql != null && this.toKeepHsql.exists()) {
            if (this.getLastUpdateHSQLDB() >= this.dbFile.lastModified()) {
                return true;
            }
            try {
                this.closeHSQLDB(session, true);
            }
            catch (Exception e) {
                throw new UcanaccessSQLException(e);
            }
            return false;
        }
        return false;
    }

    public static boolean addOnReloadRefListener(OnReloadReferenceListener action) {
        return onReloadListeners.add(action);
    }

    public static String getVersion() {
        return version;
    }

    public static boolean is2xx() {
        return version.startsWith("2.");
    }

    private long filesUpdateTime() {
        long lm = this.dbFile.lastModified();
        for (File fl : this.links) {
            lm = Math.max(lm, fl.lastModified());
        }
        return lm;
    }

    Connection checkLastModified(Connection conn, Session session) throws Exception {
        for (int i = 0; i < Thread.activeCount(); ++i) {
            if (this.lastModified >= this.filesUpdateTime()) {
                return conn;
            }
            Thread.sleep(10L);
        }
        if (this.preventReloading && !this.checkInside()) {
            return conn;
        }
        this.updateLastModified();
        this.closeHSQLDB(session);
        System.gc();
        this.dbIO.flush();
        this.dbIO.close();
        this.dbIO = this.open(this.dbFile, this.pwd);
        this.id = this.id();
        this.firstConnection = true;
        LoadJet lj = new LoadJet(this.getHSQLDBConnection(session), this.dbIO);
        lj.setSkipIndexes(this.skipIndexes);
        lj.setSysSchema(this.sysSchema);
        lj.loadDB();
        return this.getHSQLDBConnection(session);
    }

    private boolean checkInside(Database db) throws IOException {
        Table t = db.getSystemTable("MSysObjects");
        for (Row row : t) {
            Object dobj = row.get((Object)"DateUpdate");
            Object tobj = row.get((Object)"Type");
            if (dobj == null || tobj == null) continue;
            Date dt = (Date)dobj;
            short type = (Short)tobj;
            if (this.lastModified >= dt.getTime() || type != 1 && type != 5 && type != 8) continue;
            return true;
        }
        return false;
    }

    private boolean checkInside() throws IOException {
        boolean reload = this.checkInside(this.dbIO);
        if (reload) {
            return true;
        }
        for (File fl : this.links) {
            Database db = DatabaseBuilder.open((File)fl);
            reload = this.checkInside(db);
            db.close();
            if (!reload) continue;
            return true;
        }
        return false;
    }

    private File[] getHSQLDBFiles() {
        if (this.toKeepHsql == null) {
            return new File[0];
        }
        File folder = this.toKeepHsql.getParentFile();
        String name = this.toKeepHsql.getName();
        return new File[]{new File(folder, name + ".data"), new File(folder, name + ".script"), new File(folder, name + ".properties"), new File(folder, name + ".log"), new File(folder, name + ".lck"), new File(folder, name + ".lobs")};
    }

    private long getLastUpdateHSQLDB() {
        long lu = 0L;
        for (File hsqlF : this.getHSQLDBFiles()) {
            if (!hsqlF.exists() || hsqlF.lastModified() <= lu) continue;
            lu = hsqlF.lastModified();
        }
        if (this.toKeepHsql != null && this.toKeepHsql.exists() && this.toKeepHsql.lastModified() > lu) {
            lu = this.toKeepHsql.lastModified();
        }
        return lu;
    }

    private void closeHSQLDB(Session session) throws Exception {
        this.closeHSQLDB(session, false);
    }

    private void closeHSQLDB(Session session, boolean firstConnectionKeeptMirror) throws Exception {
        this.finalizeHSQLDB(session);
        if (!this.inMemory) {
            if (this.toKeepHsql == null) {
                File folder = this.mirrorFolder == null ? this.dbFile.getParentFile() : this.mirrorFolder;
                File hbase = new File(folder, "Ucanaccess_" + this);
                if (hbase.exists()) {
                    for (File hsqlF : hbase.listFiles()) {
                        hsqlF.delete();
                    }
                }
                hbase.delete();
            } else if (!this.immediatelyReleaseResources || firstConnectionKeeptMirror) {
                this.toKeepHsql.delete();
                this.toKeepHsql.createNewFile();
                for (File hsqlf : this.getHSQLDBFiles()) {
                    if (!hsqlf.exists()) continue;
                    hsqlf.delete();
                }
                this.mirrorRecreated = true;
            }
        }
    }

    public void decrementActiveConnection(Session session) {
        this.memoryTimer.decrementActiveConnection(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeHSQLDB(Session session) throws Exception {
        if (!this.hsqldbShutdown) {
            this.releaseLock();
            Connection conn = null;
            Statement st = null;
            try {
                conn = this.getHSQLDBConnection(session);
                st = conn.createStatement();
                st.execute("SHUTDOWN");
                this.hsqldbShutdown = true;
            }
            catch (Exception exception) {
            }
            finally {
                if (st != null) {
                    st.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
    }

    File getDbFile() {
        return this.dbFile;
    }

    public Database getDbIO() {
        return this.dbIO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setIgnoreCase(Connection conn) throws SQLException {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute("SET DATABASE COLLATION \"SQL_TEXT_UCC\"");
        }
        catch (Exception exception) {
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHSQLDB(Connection conn) throws SQLException {
        Statement st = null;
        try {
            st = conn.createStatement();
            st.execute("SET DATABASE SQL SYNTAX ora TRUE");
            st.execute("SET DATABASE SQL CONCAT NULLS " + this.concatNulls);
            if (this.lobScale == null && this.inMemory) {
                st.execute("SET FILES LOB SCALE 1");
            } else if (this.lobScale != null) {
                st.execute("SET FILES LOB SCALE " + this.lobScale);
            }
        }
        catch (Exception w) {
            w.printStackTrace();
        }
        finally {
            if (st != null) {
                st.close();
            }
        }
    }

    public Connection getHSQLDBConnection(Session session) throws SQLException {
        boolean keptMirror = false;
        if (this.firstConnection && this.toKeepHsql != null && this.toKeepHsql.exists()) {
            keptMirror = true;
        }
        Connection conn = DriverManager.getConnection(this.getHsqlUrl(session), session.getUser() == null ? "Admin" : session.getUser(), session.getPassword());
        if (version == null) {
            version = conn.getMetaData().getDriverVersion();
        }
        if (this.firstConnection) {
            if (this.ignoreCase && (!keptMirror || this.mirrorRecreated)) {
                this.setIgnoreCase(conn);
            }
            if (!this.mirrorReadOnly || !keptMirror || this.mirrorRecreated) {
                this.initHSQLDB(conn);
            }
            this.firstConnection = false;
            this.mirrorRecreated = false;
        }
        this.hsqldbShutdown = false;
        conn.setAutoCommit(false);
        return conn;
    }

    String getId() {
        return this.id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String key(String _pwd) throws SQLException {
        Connection conn = null;
        try {
            if (this.encryptionKey == null) {
                String url = "jdbc:hsqldb:mem:" + this.id + "_tmp";
                conn = DriverManager.getConnection(url);
                Statement stmt = conn.createStatement();
                ResultSet rs = stmt.executeQuery("CALL  CRYPT_KEY('AES', null) ");
                rs.next();
                this.encryptionKey = rs.getString(1);
            }
            String string = this.encryptionKey;
            return string;
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
    }

    private String getHsqlUrl(final Session session) throws SQLException {
        try {
            if (this.openExclusive && this.fileLock == null) {
                this.lockMdbFile();
            }
            String enc = "";
            String log = "";
            if (this.encryptHSQLDB) {
                enc = ";crypt_key=" + this.key(CIPHER_SPEC) + ";crypt_type=aes;crypt_lobs=true";
            }
            if (!this.inMemory && this.toKeepHsql == null) {
                log = ";hsqldb.log_data=FALSE";
            }
            if (!this.inMemory && this.tempHsql == null) {
                if (this.toKeepHsql != null) {
                    if (!this.toKeepHsql.exists()) {
                        this.toKeepHsql.createNewFile();
                    }
                    this.tempHsql = this.toKeepHsql;
                } else {
                    File folder = this.mirrorFolder == null ? this.dbFile.getParentFile() : this.mirrorFolder;
                    File hbase = new File(folder, "Ucanaccess_" + this.toString());
                    hbase.mkdir();
                    this.tempHsql = new File(hbase, this.id);
                    this.tempHsql.createNewFile();
                }
                Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (DBReference.this.toKeepHsql == null) {
                                DBReference.this.closeHSQLDB(session);
                            } else {
                                DBReference.this.finalizeHSQLDB(session);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }));
            }
            String mro = this.mirrorReadOnly ? ";readonly=true" : "";
            return "jdbc:hsqldb:" + (this.inMemory ? "mem:" + this.id : this.tempHsql.getAbsolutePath()) + enc + log + mro;
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public long getInactivityTimeout() {
        return this.memoryTimer.getInactivityTimeout();
    }

    private String id() {
        return UUID.randomUUID() + this.toString();
    }

    public void incrementActiveConnection() {
        this.memoryTimer.incrementActiveConnection();
    }

    public boolean isReadOnly() throws UcanaccessSQLException {
        if (this.readOnly) {
            this.lockMdbFile();
        }
        return this.readOnlyFileFormat || this.readOnly;
    }

    boolean isReadOnlyFileFormat() {
        return this.readOnlyFileFormat;
    }

    boolean isShowSchema() {
        return this.showSchema;
    }

    private File fileLock() {
        File folder = this.dbFile.getParentFile();
        String fileName = this.dbFile.getName();
        int suffixStart = fileName.lastIndexOf(46);
        if (suffixStart < 0) {
            suffixStart = fileName.length();
        }
        String suffix = this.dbFormat != null && (Database.FileFormat.V2016.equals((Object)this.dbFormat) || Database.FileFormat.V2010.equals((Object)this.dbFormat) || Database.FileFormat.V2007.equals((Object)this.dbFormat)) ? ".laccdb" : ".ldb";
        File flLock = new File(folder, fileName.substring(0, suffixStart) + suffix);
        return flLock;
    }

    private void lockMdbFile() throws UcanaccessSQLException {
        try {
            File flLock = this.fileLock();
            flLock.createNewFile();
            RandomAccessFile raf = new RandomAccessFile(flLock, "rw");
            FileLock tryLock = raf.getChannel().tryLock();
            if (tryLock == null) {
                this.readOnly = true;
            } else {
                this.fileLock = tryLock;
                this.readOnly = false;
            }
        }
        catch (IOException e) {
            throw new UcanaccessSQLException(e);
        }
    }

    public void releaseLock() throws IOException {
        if (this.fileLock != null) {
            this.fileLock.release();
        }
    }

    public void reloadDbIO() throws IOException {
        this.dbIO.flush();
        this.dbIO.close();
        for (OnReloadReferenceListener listener : onReloadListeners) {
            listener.onReload();
        }
        this.dbIO = this.open(this.dbFile, this.pwd);
    }

    public void setInactivityTimeout(int inactivityTimeout) {
        this.memoryTimer.setInactivityTimeout(inactivityTimeout);
    }

    public void setInMemory(boolean _inMemory) {
        this.inMemory = _inMemory;
    }

    public void setOpenExclusive(boolean _openExclusive) {
        this.openExclusive = _openExclusive;
    }

    public void setShowSchema(boolean _showSchema) {
        this.showSchema = _showSchema;
    }

    void shutdown(Session _session) throws Exception {
        DBReferenceSingleton.getInstance().remove(this.dbFile.getAbsolutePath());
        if (this.immediatelyReleaseResources) {
            for (OnReloadReferenceListener listener : onReloadListeners) {
                listener.onReload();
            }
        }
        this.memoryTimer.timer.cancel();
        this.dbIO.flush();
        this.dbIO.close();
        this.closeHSQLDB(_session);
    }

    public void updateLastModified() {
        this.lastModified = this.filesUpdateTime();
    }

    public void setImmediatelyReleaseResources(boolean _immediatelyReleaseResources) {
        this.immediatelyReleaseResources = _immediatelyReleaseResources;
    }

    public void setEncryptHSQLDB(boolean _encryptHSQLDB) {
        this.encryptHSQLDB = _encryptHSQLDB;
    }

    public void setExternalResourcesMapping(Map<String, String> _externalResourcesMapping) {
        this.externalResourcesMapping = _externalResourcesMapping;
    }

    public File getToKeepHsql() {
        return this.toKeepHsql;
    }

    public void setToKeepHsql(File _toKeepHsql) {
        this.toKeepHsql = _toKeepHsql;
    }

    public boolean isEncryptHSQLDB() {
        return this.encryptHSQLDB;
    }

    public void setColumnOrderDisplay() {
        this.columnOrderDisplay = true;
        if (this.dbIO != null) {
            this.dbIO.setColumnOrder(Table.ColumnOrder.DISPLAY);
        }
    }

    public boolean isInMemory() {
        return this.inMemory;
    }

    public void setMirrorFolder(File _mirrorFolder) {
        this.mirrorFolder = _mirrorFolder;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean _ignoreCase) {
        this.ignoreCase = _ignoreCase;
    }

    public void setMirrorReadOnly(boolean _mirrorReadOnly) {
        this.mirrorReadOnly = _mirrorReadOnly;
    }

    public void setLobScale(Integer _lobScale) {
        this.lobScale = _lobScale;
    }

    public void setSkipIndexes(boolean _skipIndexes) {
        this.skipIndexes = _skipIndexes;
    }

    public void setSysSchema(boolean _sysSchema) {
        this.sysSchema = _sysSchema;
    }

    public boolean isPreventReloading() {
        return this.preventReloading;
    }

    public void setPreventReloading(boolean _preventReloading) {
        this.preventReloading = _preventReloading;
    }

    public boolean isConcatNulls() {
        return this.concatNulls;
    }

    public void setConcatNulls(boolean _concatNulls) {
        this.concatNulls = _concatNulls;
    }

    protected void finalize() throws Throwable {
        if (this.memoryTimer != null) {
            this.memoryTimer.timer.cancel();
            this.memoryTimer = null;
        }
        super.finalize();
    }

    private static class MemoryTimer {
        private static final long INACTIVITY_TIMEOUT_DEFAULT = 120000L;
        private final DBReference dbReference;
        private final Timer timer;
        private int activeConnection;
        private long inactivityTimeout = 120000L;
        private long lastConnectionTime;

        MemoryTimer(DBReference _dbReference) {
            this.dbReference = _dbReference;
            this.timer = new Timer(this.getClass().getSimpleName() + '-' + _dbReference.getDbFile().getName(), true);
        }

        private synchronized void decrementActiveConnection(final Session _session) {
            --this.activeConnection;
            if (this.dbReference.immediatelyReleaseResources && this.activeConnection == 0) {
                try {
                    this.dbReference.shutdown(_session);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            if (this.dbReference.inMemory && this.inactivityTimeout > 0L && this.activeConnection == 0) {
                TimerTask task = new TimerTask(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Class<UcanaccessDriver> clazz = UcanaccessDriver.class;
                        synchronized (UcanaccessDriver.class) {
                            if (System.currentTimeMillis() - MemoryTimer.this.getLastConnectionTime() >= MemoryTimer.this.inactivityTimeout && MemoryTimer.this.getActiveConnection() == 0) {
                                try {
                                    MemoryTimer.this.dbReference.shutdown(_session);
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                System.gc();
                            }
                            // ** MonitorExit[var1_1] (shouldn't be in output)
                            return;
                        }
                    }
                };
                this.timer.schedule(task, this.inactivityTimeout);
            }
        }

        private synchronized int getActiveConnection() {
            return this.activeConnection;
        }

        private long getInactivityTimeout() {
            return this.inactivityTimeout;
        }

        private synchronized long getLastConnectionTime() {
            return this.lastConnectionTime;
        }

        private synchronized void incrementActiveConnection() {
            ++this.activeConnection;
            if (this.dbReference.inMemory && this.inactivityTimeout > 0L) {
                this.lastConnectionTime = System.currentTimeMillis();
            }
        }

        private void setInactivityTimeout(int _inactivityTimeout) {
            this.inactivityTimeout = _inactivityTimeout;
        }
    }
}

