/*
 * Decompiled with CFR 0.152.
 */
package net.ucanaccess.jdbc;

import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import net.ucanaccess.commands.DDLCommandEnlist;
import net.ucanaccess.converters.Metadata;
import net.ucanaccess.converters.SQLConverter;
import net.ucanaccess.jdbc.Execute;
import net.ucanaccess.jdbc.FeatureNotSupportedException;
import net.ucanaccess.jdbc.UcanaccessConnection;
import net.ucanaccess.jdbc.UcanaccessPreparedStatement;
import net.ucanaccess.jdbc.UcanaccessResultSet;
import net.ucanaccess.jdbc.UcanaccessSQLException;
import net.ucanaccess.jdbc.UcanaccessStatement;
import net.ucanaccess.util.HibernateSupport;

public abstract class AbstractExecute {
    protected int autoGeneratedKeys;
    protected String[] columnNames;
    protected CommandType commandType;
    protected int[] indexes;
    protected String sql;
    private UcanaccessResultSet resultSet;
    private UcanaccessStatement statement;

    protected AbstractExecute(UcanaccessPreparedStatement _statement) {
        this.statement = _statement;
        this.commandType = CommandType.PREPARED_STATEMENT;
    }

    protected AbstractExecute(UcanaccessResultSet _resultSet) {
        this.resultSet = _resultSet;
        this.statement = _resultSet.getWrappedStatement();
        this.commandType = CommandType.UPDATABLE_RESULTSET;
    }

    public AbstractExecute(UcanaccessStatement _statement) {
        this.statement = _statement;
    }

    protected AbstractExecute(UcanaccessStatement _statement, String _sql) {
        this(_statement);
        this.commandType = CommandType.NO_ARGUMENTS;
        this.sql = _sql;
    }

    protected AbstractExecute(UcanaccessStatement _statement, String _sql, int _autoGeneratedKeys) {
        this(_statement, _sql);
        this.autoGeneratedKeys = _autoGeneratedKeys;
        this.commandType = CommandType.WITH_AUTO_GENERATED_KEYS;
    }

    protected AbstractExecute(UcanaccessStatement _statement, String _sql, int[] _indexes) {
        this(_statement, _sql);
        this.indexes = _indexes;
        this.commandType = CommandType.WITH_INDEXES;
    }

    protected AbstractExecute(UcanaccessStatement _statement, String _sql, String[] _columnNames) {
        this(_statement, _sql);
        this.columnNames = _columnNames;
        this.commandType = CommandType.WITH_COLUMNS_NAME;
    }

    private Object enableDiasable(SQLConverter.DDLType ddlType) throws SQLException, IOException {
        UcanaccessConnection conn;
        Metadata mtd;
        String rtn;
        String tn = ddlType.getDBObjectName();
        if (tn.startsWith("[") && tn.endsWith("]")) {
            tn = tn.substring(1, tn.length() - 1);
        }
        if ((rtn = (mtd = new Metadata((conn = (UcanaccessConnection)this.statement.getConnection()).getHSQLDBConnection())).getTableName(tn)) == null) {
            throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.TABLE_DOESNT_EXIST, tn);
        }
        boolean inable = ddlType.equals((Object)SQLConverter.DDLType.ENABLE_AUTOINCREMENT);
        conn.getDbIO().getTable(rtn).setAllowAutoNumberInsert(Boolean.valueOf(!inable));
        return this instanceof Execute ? (Comparable<Boolean>)Boolean.valueOf(false) : (Comparable<Boolean>)Integer.valueOf(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int count(String tableName) throws SQLException {
        UcanaccessConnection conn = (UcanaccessConnection)this.statement.getConnection();
        Statement st = null;
        ResultSet rs = null;
        try {
            st = conn.createStatement();
            rs = st.executeQuery("select count(*) from " + tableName);
            rs.next();
            int n = rs.getInt(1);
            return n;
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            if (st != null) {
                st.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SQLException checkDDLException() throws SQLException {
        UcanaccessConnection conn = (UcanaccessConnection)this.statement.getConnection();
        Statement ps = null;
        try {
            ps = conn.getHSQLDBConnection().prepareStatement(SQLConverter.convertSQL(this.sql).getSql());
        }
        catch (SQLException ex) {
            SQLException sQLException = ex;
            return sQLException;
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return new FeatureNotSupportedException(FeatureNotSupportedException.NotSupportedMessage.NOT_SUPPORTED_YET);
    }

    private Object addDDLCommand() throws SQLException {
        Comparable<Boolean> ret;
        try {
            String constraintName;
            SQLConverter.DDLType ddlType = SQLConverter.getDDLType(this.sql);
            if (ddlType == null) {
                throw this.checkDDLException();
            }
            if (SQLConverter.DDLType.DROP_FOREIGN_KEY.equals((Object)ddlType) && !HibernateSupport.isActive().booleanValue()) {
                throw new UnsupportedOperationException("DROP CONSTRAINT is only supported for Hibernate hbm2ddl.auto \"create\"");
            }
            if (SQLConverter.DDLType.ADD_COLUMN.equals((Object)ddlType) && SQLConverter.couldNeedDefault(ddlType.getColumnDefinition())) {
                String cn = ddlType.getSecondDBObjectName();
                String tn = ddlType.getDBObjectName();
                int count = this.count(ddlType.getDBObjectName());
                if (count > 0) {
                    throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.DEFAULT_NEEDED, cn, tn, count);
                }
            }
            String sql0 = ddlType.equals((Object)SQLConverter.DDLType.ADD_COLUMN) ? SQLConverter.convertSQL(SQLConverter.convertAddColumn(ddlType.getDBObjectName(), ddlType.getSecondDBObjectName(), ddlType.getColumnDefinition())).getSql() : SQLConverter.convertSQL(this.sql).getSql();
            boolean enDis = ddlType.in(SQLConverter.DDLType.ENABLE_AUTOINCREMENT, SQLConverter.DDLType.DISABLE_AUTOINCREMENT);
            this.statement.setEnableDisable(enDis);
            if (enDis) {
                return this.enableDiasable(ddlType);
            }
            String ddlExpr = null;
            if (ddlType.in(SQLConverter.DDLType.CREATE_TABLE, SQLConverter.DDLType.CREATE_TABLE_AS_SELECT)) {
                ddlExpr = SQLConverter.convertCreateTable(sql0);
            } else if (ddlType.equals((Object)SQLConverter.DDLType.CREATE_FOREIGN_KEY)) {
                constraintName = ddlType.getSecondDBObjectName();
                if (constraintName == null) {
                    ddlExpr = sql0;
                } else {
                    UcanaccessConnection conn;
                    Metadata mtd;
                    String tableName;
                    if (constraintName.startsWith("[") && constraintName.endsWith("]")) {
                        constraintName = constraintName.substring(1, constraintName.length() - 1);
                    }
                    if ((tableName = ddlType.getDBObjectName()).startsWith("[") && tableName.endsWith("]")) {
                        tableName = tableName.substring(1, tableName.length() - 1);
                    }
                    if ((tableName = (mtd = new Metadata((conn = (UcanaccessConnection)this.statement.getConnection()).getHSQLDBConnection())).getEscapedTableName(tableName)) == null) {
                        throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.TABLE_DOESNT_EXIST, tableName);
                    }
                    ddlExpr = sql0.replaceFirst("(?i)\\s+ADD\\s+CONSTRAINT\\s+.*\\s+FOREIGN\\s+KEY\\s+", " ADD CONSTRAINT \"" + tableName + "_" + constraintName.toUpperCase(Locale.US) + "\" FOREIGN KEY ");
                }
            } else if (ddlType.equals((Object)SQLConverter.DDLType.DROP_FOREIGN_KEY)) {
                UcanaccessConnection conn;
                Metadata mtd;
                String tableName;
                constraintName = ddlType.getSecondDBObjectName();
                if (constraintName == null) {
                    throw new UcanaccessSQLException();
                }
                if (constraintName.startsWith("[") && constraintName.endsWith("]")) {
                    constraintName = constraintName.substring(1, constraintName.length() - 1);
                }
                if ((tableName = ddlType.getDBObjectName()).startsWith("[") && tableName.endsWith("]")) {
                    tableName = tableName.substring(1, tableName.length() - 1);
                }
                if ((tableName = (mtd = new Metadata((conn = (UcanaccessConnection)this.statement.getConnection()).getHSQLDBConnection())).getEscapedTableName(tableName)) == null) {
                    throw new UcanaccessSQLException(UcanaccessSQLException.ExceptionMessages.TABLE_DOESNT_EXIST, tableName);
                }
                ddlExpr = sql0.replaceFirst("(?i)\\s+DROP\\s+CONSTRAINT\\s+.*", " DROP CONSTRAINT \"" + tableName + "_" + constraintName.toUpperCase(Locale.US) + "\"");
            } else {
                ddlExpr = sql0;
            }
            ret = this instanceof Execute ? (Comparable<Boolean>)Boolean.valueOf(this.statement.getWrapped().execute(ddlExpr)) : (Comparable<Boolean>)Integer.valueOf(this.statement.getWrapped().executeUpdate(ddlExpr));
            DDLCommandEnlist ddle = new DDLCommandEnlist();
            ddle.enlistDDLCommand(SQLConverter.restoreWorkAroundFunctions(this.sql), ddlType);
        }
        catch (Exception e) {
            throw new SQLException(e);
        }
        return ret;
    }

    private boolean checkDDL() {
        return SQLConverter.checkDDL(this.sql);
    }

    public Object executeBase() throws SQLException {
        Object retv;
        UcanaccessConnection conn = (UcanaccessConnection)this.statement.getConnection();
        UcanaccessConnection.setCtxConnection(conn);
        if (this.commandType.equals((Object)CommandType.BATCH)) {
            UcanaccessConnection.setCtxExecId("BATCH_ID");
        } else {
            UcanaccessConnection.setCtxExecId(Math.random() + "");
        }
        if (this.checkDDL()) {
            retv = this.addDDLCommand();
        } else {
            try {
                retv = this.executeWrapped();
            }
            catch (SQLException e) {
                if (conn.getAutoCommit()) {
                    conn.rollback();
                }
                throw e;
            }
        }
        if (conn.getAutoCommit()) {
            conn.commit();
        }
        return retv;
    }

    public abstract Object executeWrapped() throws SQLException;

    ResultSet getWrappedResultSet() {
        return this.resultSet.getWrapped();
    }

    Statement getWrappedStatement() {
        return this.statement.getWrapped();
    }

    void setStatement(UcanaccessStatement _statement) {
        this.statement = _statement;
    }

    protected static enum CommandType {
        BATCH,
        NO_ARGUMENTS,
        PREPARED_STATEMENT,
        UPDATABLE_RESULTSET,
        WITH_AUTO_GENERATED_KEYS,
        WITH_COLUMNS_NAME,
        WITH_INDEXES;

    }
}

