## 8. What is State in React?

In React, "state" is a fundamental concept that represents the data that can change over time in a component. It allows your components to be interactive and responsive to user input. State is what enables a component to remember and re-render with updated information.

State is typically used in two main ways:

1. **Class Components:** In class-based components, state is managed using the `this.state` object. You can initialize state in the component's constructor and update it using the `this.setState()` method. For example:
   ```jsx
   class Counter extends React.Component {
     constructor() {
       super();
       this.state = { count: 0 };
     }
     incrementCount() {
       this.setState({ count: this.state.count + 1 });
     }
     render() {
       return (
         <div>
           <p>Count: {this.state.count}</p>
           <button onClick={() => this.incrementCount()}>Increment</button>
         </div>
       );
     }
   }