#include "ctype.h"
#include "format.h"
#include <oak/oak.h>
#include <oak/debug.h>

static CFCharacterSetRef create_character_set ()
{
	static uint32_t Fixed[]      = { 0x2329, 0x232A, 0x23F0, 0x23F3, 0x267F, 0x2693, 0x26A1, 0x26CE, 0x26D4, 0x26EA, 0x26F5, 0x26FA, 0x26FD, 0x2705, 0x2728, 0x274C, 0x274E, 0x2757, 0x27B0, 0x27BF, 0x2B50, 0x2B55, 0x3004, 0x3005, 0x3006, 0x3007, 0x3008, 0x3009, 0x300A, 0x300B, 0x300C, 0x300D, 0x300E, 0x300F, 0x3010, 0x3011, 0x3014, 0x3015, 0x3016, 0x3017, 0x3018, 0x3019, 0x301A, 0x301B, 0x301C, 0x301D, 0x3020, 0x3030, 0x303B, 0x303C, 0x303D, 0x303E, 0x309F, 0x30A0, 0x30FB, 0x30FF, 0x3250, 0xA015, 0xFE17, 0xFE18, 0xFE19, 0xFE30, 0xFE35, 0xFE36, 0xFE37, 0xFE38, 0xFE39, 0xFE3A, 0xFE3B, 0xFE3C, 0xFE3D, 0xFE3E, 0xFE3F, 0xFE40, 0xFE41, 0xFE42, 0xFE43, 0xFE44, 0xFE47, 0xFE48, 0xFE58, 0xFE59, 0xFE5A, 0xFE5B, 0xFE5C, 0xFE5D, 0xFE5E, 0xFE62, 0xFE63, 0xFE68, 0xFE69, 0x16FE0, 0x1F004, 0x1F0CF, 0x1F18E, 0x1F3F4, 0x1F440, 0x1F57A, 0x1F5A4, 0x1F6CC, 0x1F930, 0x1F9C0 };
	static uint32_t RangeBegin[] = { 0x1100, 0x231A, 0x23E9, 0x25FD, 0x2614, 0x2648, 0x26AA, 0x26BD, 0x26C4, 0x26F2, 0x270A, 0x2753, 0x2795, 0x2B1B, 0x2E80, 0x2E9B, 0x2F00, 0x2FF0, 0x3001, 0x3012, 0x301E, 0x3021, 0x302A, 0x302E, 0x3031, 0x3036, 0x3038, 0x3041, 0x3099, 0x309B, 0x309D, 0x30A1, 0x30FC, 0x3105, 0x3131, 0x3190, 0x3192, 0x3196, 0x31A0, 0x31C0, 0x31F0, 0x3200, 0x3220, 0x322A, 0x3251, 0x3260, 0x3280, 0x328A, 0x32B1, 0x32C0, 0x3300, 0x3400, 0x4DB6, 0x4E00, 0x9FD6, 0xA000, 0xA016, 0xA490, 0xA960, 0xAC00, 0xF900, 0xFA6E, 0xFA70, 0xFADA, 0xFE10, 0xFE31, 0xFE33, 0xFE45, 0xFE49, 0xFE4D, 0xFE50, 0xFE54, 0xFE5F, 0xFE64, 0xFE6A, 0x17000, 0x18800, 0x1B000, 0x1F191, 0x1F200, 0x1F210, 0x1F240, 0x1F250, 0x1F300, 0x1F32D, 0x1F337, 0x1F37E, 0x1F3A0, 0x1F3CF, 0x1F3E0, 0x1F3F8, 0x1F3FB, 0x1F400, 0x1F442, 0x1F4FF, 0x1F54B, 0x1F550, 0x1F595, 0x1F5FB, 0x1F600, 0x1F680, 0x1F6D0, 0x1F6EB, 0x1F6F4, 0x1F910, 0x1F920, 0x1F933, 0x1F940, 0x1F950, 0x1F980, 0x20000, 0x2A6D7, 0x2A700, 0x2B735, 0x2B740, 0x2B81E, 0x2B820, 0x2CEA2, 0x2F800, 0x2FA1E, 0x30000 };
	static uint32_t RangeEnd[]   = { 0x115F, 0x231B, 0x23EC, 0x25FE, 0x2615, 0x2653, 0x26AB, 0x26BE, 0x26C5, 0x26F3, 0x270B, 0x2755, 0x2797, 0x2B1C, 0x2E99, 0x2EF3, 0x2FD5, 0x2FFB, 0x3003, 0x3013, 0x301F, 0x3029, 0x302D, 0x302F, 0x3035, 0x3037, 0x303A, 0x3096, 0x309A, 0x309C, 0x309E, 0x30FA, 0x30FE, 0x312D, 0x318E, 0x3191, 0x3195, 0x319F, 0x31BA, 0x31E3, 0x31FF, 0x321E, 0x3229, 0x3247, 0x325F, 0x327F, 0x3289, 0x32B0, 0x32BF, 0x32FE, 0x33FF, 0x4DB5, 0x4DBF, 0x9FD5, 0x9FFF, 0xA014, 0xA48C, 0xA4C6, 0xA97C, 0xD7A3, 0xFA6D, 0xFA6F, 0xFAD9, 0xFAFF, 0xFE16, 0xFE32, 0xFE34, 0xFE46, 0xFE4C, 0xFE4F, 0xFE52, 0xFE57, 0xFE61, 0xFE66, 0xFE6B, 0x187EC, 0x18AF2, 0x1B001, 0x1F19A, 0x1F202, 0x1F23B, 0x1F248, 0x1F251, 0x1F320, 0x1F335, 0x1F37C, 0x1F393, 0x1F3CA, 0x1F3D3, 0x1F3F0, 0x1F3FA, 0x1F3FF, 0x1F43E, 0x1F4FC, 0x1F53D, 0x1F54E, 0x1F567, 0x1F596, 0x1F5FF, 0x1F64F, 0x1F6C5, 0x1F6D2, 0x1F6EC, 0x1F6F6, 0x1F91E, 0x1F927, 0x1F93E, 0x1F94B, 0x1F95E, 0x1F991, 0x2A6D6, 0x2A6FF, 0x2B734, 0x2B73F, 0x2B81D, 0x2B81F, 0x2CEA1, 0x2F7FF, 0x2FA1D, 0x2FFFD, 0x3FFFD };

	CFMutableCharacterSetRef res = CFCharacterSetCreateMutable(kCFAllocatorDefault);
	for(auto const& ch : Fixed)
		CFCharacterSetAddCharactersInRange(res, CFRangeMake(ch, 1));
	for(size_t i = 0; i < sizeofA(RangeBegin); ++i)
		CFCharacterSetAddCharactersInRange(res, CFRangeMake(RangeBegin[i], RangeEnd[i] - RangeBegin[i] + 1));
	return res;
}

namespace text
{
	bool is_east_asian_width (uint32_t ch)
	{
		if(ch < 0x1100 || 0x3FFFD < ch)
			return false;

		static CFCharacterSetRef const cfset = create_character_set();
		return CFCharacterSetIsLongCharacterMember(cfset, ch);
	}

} /* text */
