# Awesome Devblogs

Here's a quick collection of links to **game developer** blogs and/or portfolios
that I've found interesting. This repository serves two purposes:

- Writing down cool people (and companies) that do cool things
- Showcasing various ways to showcase your work

To help showcase different types of portfolios, I've split the list into those
that are **strictly portfolios**, while others are **portfolios with a blog
attached**. Company websites are also included in their own section, reflecting
how larger organizations differ in voice and presentation.

## Contents

- [Awesome Devblogs](#awesome-devblogs)
  - [Portfolio](#portfolio)
  - [Portfolio + Blog](#portfolio--blog)
  - [Company Blogs](#companies)

## Portfolio

Portfolio websites focus on introducing a person and their past work.

- [Anton Palmqvist](https://antonpalmqvist.com/) - Simple and elegant portfolio website
  - [Mirror's Edge: Catalyst](https://antonpalmqvist.com/mirrorsedge)
- [Ben Porter](https://bp.io/) - Portfolio site w/ project-centric homepage
  - [Full Project List](https://bp.io/projects/) - a table of all notable past projects, small/personal and large/commercial
- [Freya's stuff (Freya Holmer)](https://acegikmo.com/) - Math Demiurge known for "Shapes" and "Shader Forge". Highlights current/past/side projects and talks.
- [Jack Humbert](https://jackhumbert.com/) - One-pager landing page for socials and portfolio
- [Jenn Sandercock](https://jennsand.com/) - Personal portfolio site with cute and on-brand food theme
  - [About Jenn](https://jennsand.com/about/) - Mini-bio and interactive game bibliography with sorting, filtering, and detail views
- [Lucas Meijer](http://lucasmeijer.com/) - One-pager landing page for socials and portfolio (again)
  - [C++, C# and Unity](http://lucasmeijer.com/posts/cpp_unity/) (this site was previously a blog site, so some posts are still available)
- [Lithish](https://lithish.com/) - Landing page with links to games and art portfolios + blog coming soon
  - [Xan Farley's Portfolio](https://portfolio.lithish.com/design) - Two column format with cover art on the left and brief descriptors on the right
- [Natalie Burke](http://natbird.com/index.html) - One-pager timeline of past works for portfolio
  - [Unity, Lead Technical Artist](http://natbird.com/#unity)

## Portfolio and/or Blog

Developer blogs **explore past (or present!) problems** encountered during
development and/or provide **tutorial content** on solving specific needs. They
also often contain a section for showcasing the developer's past works or
projects.

- [Adrian Courrages](http://www.adriancourreges.com/) - Performs in-depth graphics studies on recent games
  - [Metal Gear Solid V - Graphics Study](http://www.adriancourreges.com/blog/2017/12/15/mgs-v-graphics-study/)
  - [DOOM (2016) - Graphics Study](http://www.adriancourreges.com/blog/2016/09/09/doom-2016-graphics-study/)
- [Alan Zucconi](https://www.alanzucconi.com/) - Quick tutorials and breakdowns of short concepts + portfolio
  - [Inverse Kinematics in 2D](https://www.alanzucconi.com/2018/05/02/ik-2d-1/)
- [Alexander Ameye](https://alexanderameye.github.io/notes/) - Blog covering various specific graphical techniques or tools
  - [:cyclone: Circular menus in the Unity Editor](https://alexanderameye.github.io/notes/unity-circular-menu/)
- [Alex Forsythe](https://awforsythe.com) - Text-heavy portfolio site covering his personal, commercial, and other works
  - [Blueprints vs. C++ - How They Fit Together and Why You Should Use Both](https://awforsythe.com/unreal/blueprints_vs_cpp/)
  - [@AlexForsythe on YouTube](https://www.youtube.com/@AlexForsythe)
- [Amos](https://fasterthanli.me/) - Known for Rust and deep-dives on various systems
  - [A short (and mostly wrong) history of computer networking](https://fasterthanli.me/blog/2019/making-our-own-ping/)
- [Amit Patel](https://www.redblobgames.com/) - Interactive explorations of common problem spaces in game development
  - [Hexagonal grid reference](https://www.redblobgames.com/grids/hexagons/)
  - [Tower Defense pathfinding](https://www.redblobgames.com/pathfinding/tower-defense/)
- [ben :seedling: ui](https://benui.ca/) - "As I learn new things in Unreal Engine, I like to write them down so I don't forget. :seedling:" + portfolio
  - [Introduction to C++ UIs in Unreal](https://benui.ca/unreal/ui-cpp-basics/)
- [Bob Nystrom](http://journal.stuffwithstuff.com/) - Language design posts w/ a spice of personal posts
  - [What the Hero Sees: Field-of-View](http://journal.stuffwithstuff.com/2015/09/07/what-the-hero-sees/)
- [Bronson Zgeb](https://bronsonzgeb.com/) - Sharing Unity developer tips and tricks
  - [Build a better collider importer with Asset Processors](https://bronsonzgeb.com/index.php/2021/11/27/better-collider-generation-with-asset-processors/)
- [Bruce Dawson](https://randomascii.wordpress.com/) - Dives deep into profiling and various fringe topics
  - [Tricks With the Floating-Point Format](https://randomascii.wordpress.com/2012/01/11/tricks-with-the-floating-point-format/)
- [Erin Catto](https://box2d.org/) - Developer of Box2D. Posts and publications around physics and "low-level" concepts.
  - [How to Transform a Plane](https://box2d.org/posts/2018/09/how-to-transform-a-plane/)
  - [Ragdolls - GDC2012](https://box2d.org/files/ErinCatto_Ragdolls_GDC2012.pdf)
- [Evan Todd](http://etodd.io/) - Breaks down common problems in games via the "Poor Man's _x_" Series + portfolio
  - [The Poor Man's 3D Camera](http://etodd.io/2017/11/28/poor-mans-3d-camera/)
  - [The Poor Man's Character Controller](http://etodd.io/2015/04/03/poor-mans-character-controller/)
- [Eevee](https://eev.ee/) - Blog, dev blog, portfolio, and pretty much everything else that's relevant to their work or public life.
  - :warning: **Note**: This website contains links (with warnings) to content not safe for viewing by minors.
  - [Particle wipe generator](https://eev.ee/release/2019/04/20/particle-wipe-generator/)
  - [Coaxing 2D platforming out of Unity](https://eev.ee/blog/2017/10/13/coaxing-2d-platforming-out-of-unity/)
- [Erik Nordeus](https://www.habrador.com/tutorials/) - Open source implementations and tutorials for games and simulation
  - [How to Tell if You Have Passed a Waypoint?](https://www.habrador.com/tutorials/math/2-passed-waypoint/) - part of ["Use math to solve problems in Unity with C#"](https://www.habrador.com/tutorials/math/)
- [Fabien Sandlard](http://fabiensanglard.net/) - Analyzes and explores game engines and low-level functionality + portfolio
  - [Quake 3 Source Code Review](http://fabiensanglard.net/quake3/index.php) 
- [Gabriel Gambetta](http://www.gabrielgambetta.com/) - Assorted articles on networking, rendering, and writing
  - [Computer Graphics from scratch](http://www.gabrielgambetta.com/computer-graphics-from-scratch/introduction.html)
  - [Fast-Paced Multiplayer](http://www.gabrielgambetta.com/client-server-game-architecture.html)
  - [Fizzlefade](http://fabiensanglard.net/fizzlefade/index.php)
- [Glenn Fiedler](https://gafferongames.com/) - Deep dives on networking, physics, and common development patterns.
  - [Fix Your Timestep!](https://gafferongames.com/post/fix_your_timestep/)
  - [Integration Basics](https://gafferongames.com/post/integration_basics/)
  - [Networked Physics in Virtual Reality](https://gafferongames.com/post/networked_physics_in_virtual_reality/)
- [Internal Pointers](https://www.internalpointers.com/) - misc. posts on tech, math, IT, etc.
  - [Writing a custom iterator in modern C++](https://www.internalpointers.com/post/writing-custom-iterators-modern-cpp)
  - **Note:** One of the few blogs without a portfolio.
- [Liz England](https://lizengland.com/blog/) - Simple personal site with a plethora of links to works, talks, resume, and resources
  - [Game Design Library](https://lizengland.com/blog/game-design-library/) - Library of books on game design, w/o call-outs for her favorites
- [MinionsArt Tutorials](https://minionsart.github.io/tutorials/) - A large collection of shader and VFX tutorials, initially for BIRP, and now for URP
  - [World Position Radius Effects (in Shader Graph)](https://www.patreon.com/posts/26438849)
  - **Note:** This site is more of a hub/collection - each page links out to Patreon/YouTube for the actual content.
- [Nicky Case](https://ncase.me/) - Pioneer of interactive articles (a.k.a. explorable explanations)
  - [Sight & Light - how to create a 2D visibility/shadow effects for your game](https://ncase.me/sight-and-light/)
  - [To Build a Better Ballot](https://ncase.me/ballot/)
- [Noel Berry](http://noelberry.ca/) - Portfolio and mini-blog
  - [Procedural Generation - The Dungeon](http://noelberry.ca/#thedungeons)
- [Rami Ismail](https://ltpf.ramiismail.com/) (Levelling The Playing Field) - Sharing lessons learned from developing games as a business, not just a hobby
  - [Getting Feedback](https://ltpf.ramiismail.com/feedback/)
- [Simon Trümpler](https://simont.de/) + [Blog](https://www.simonschreibt.de/) - Landing page with links out to other platforms for talks/portofolio/blog etc.
  - [GTA V – Underestimated Glow](https://simonschreibt.de/gat/gta-v-underestimated-glow/) - Mini-VFX breakdown of how GTA V implements its glowing red traffic lights
- [Tom Looman](https://www.tomlooman.com) - Collection of original tutorials and resources for Unreal Engine
  - [Unreal Engine Game Optimization on a Budget](https://www.tomlooman.com/unrealengine-optimization-talk/) and [Video](https://youtu.be/G51QWcitCII)
- [Václav Vančura](https://vancura.design/) - Design + Development blog, recently focusing on their work at Microsoft
  - [Visual Studio for Mac 17 Shell](https://vancura.design/work/visual-studio-for-mac-17-shell)

## Companies

Company blogs provide players with behind-the-scenes at look at the process.
They may also have engineering posts that are relevant to other developers in
the industry.

- [Campo Santo](http://blog.camposanto.com/)
  - [Matt Wilde on Visual Effects, Lighting, and Rendering](http://blog.camposanto.com/post/171934927979/hi-im-matt-wilde-an-old-man-from-the-north-of)
- [Red Blue Games](https://blog.redbluegames.com/)
  - [Animating Top Down 2D Games in Unity](https://blog.redbluegames.com/animating-top-down-2d-games-in-unity-5e966b81790e)
- [Riot Games Engineering](https://engineering.riotgames.com/)
  - [Profiling: Measurement and Analysis](https://engineering.riotgames.com/news/profiling-measurement-and-analysis)
  - [Random Acts of Optimization](https://engineering.riotgames.com/news/random-acts-optimization)
- [Spotify Design](https://spotify.design) - Updates and thoughts around changes to the Spotify UI + UX
  - [Bringing the Spotify Heart to life](https://spotify.design/article/bringing-the-spotify-heart-to-life)
- [Unity Blog: Technology](https://blogs.unity3d.com/category/technology/page/3/)
  - [10000 Update() Calls](https://blogs.unity3d.com/2015/12/23/1k-update-calls/)
  - [An introduction to IL2CPP internals](https://blogs.unity3d.com/2015/05/06/an-introduction-to-ilcpp-internals/)
- [Wolfire Games](http://blog.wolfire.com)
  - ⚠️ WARN: HTTPS not available. HTTP only.
  - [GDC13 Summary: Animation Bootcamp Part 5/6](http://blog.wolfire.com/2013/04/GDC13-Summary-Animation-Bootcamp-Part-5-6)

## One-Off Articles

Contained below is an assorted collections of articles that are not part of a
specific blog.

- [Natalya Shelburne](https://tallys.github.io/color-theory/) - Practical Color Theory for People Who Code

## Platforms

If you're looking to start your own blog, here are some platforms/services that
are frequented by the games industry (or adjacent) that provide a space for you
to do so.

- [dev.to](https://dev.to/) - General software engineering platform with a very small game community
- [Game Developer](https://www.gamedeveloper.com/blogs)
  - [1500 Archers on a 28.8](https://www.gamedeveloper.com/programming/1500-archers-on-a-28-8-network-programming-in-age-of-empires-and-beyond) by Mark Terrano and Paul Bettner
- [GameDev.net](https://www.gamedev.net/blogs/) - A game developer forum with a blog platform
- [Ludum Dare](ldjam.com) - Homepage of the Ludum Dare game jam, which has an integrated blogging platform
- [TIGForums](https://forums.tigsource.com/index.php?PHPSESSID=bg95kgih4qf945f5dfpv2oll97&board=27.0) - Blog posts as forum threads on a well-known game development forum

There are other solutions that are less reliant on a platform like Netlify or
GitHub Pages, but they will require additional setup on your part.

# License

This is also reflected in [LICENSE.md](LICENSE.md) for visibility.

[![CC0](http://mirrors.creativecommons.org/presskit/buttons/88x31/svg/cc-zero.svg)](https://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Terry Nguyen](https://terrehbyte.com) has
waived all copyright and related or neighboring rights to this work.
