<?php

/*
 * This file is part of the overtrue/wechat.
 *
 * (c) overtrue <i@overtrue.me>
 *
 * This source file is subject to the MIT license that is bundled
 * with this source code in the file LICENSE.
 */
namespace EasyWeChat\OfficialAccount\Card;

use EasyWeChat\Kernel\BaseClient;
/**
 * Class GiftCardOrderClient.
 *
 * @author overtrue <i@overtrue.me>
 */
class GiftCardOrderClient extends BaseClient
{
    /**
     * 查询-单个礼品卡订单信息接口.
     *
     * @param $orderId
     *
     * @return mixed
     */
    public function get($orderId)
    {
        $params = ['order_id' => $orderId];
        return $this->httpPostJson('card/giftcard/order/get', $params);
    }
    /**
     * 查询-批量查询礼品卡订单信息接口.
     *
     * @param int    $beginTime
     * @param int    $endTime
     * @param int    $offset
     * @param int    $count
     * @param $sortType
     *
     * @return mixed
     */
    public function list($beginTime, $endTime, $offset = 0, $count = 10, $sortType = 'ASC')
    {
        $params = ['begin_time' => $beginTime, 'end_time' => $endTime, 'sort_type' => $sortType, 'offset' => $offset, 'count' => $count];
        return $this->httpPostJson('card/giftcard/order/batchget', $params);
    }
    /**
     * 退款接口.
     *
     * @param $orderId
     *
     * @return mixed
     */
    public function refund($orderId)
    {
        $params = ['order_id' => $orderId];
        return $this->httpPostJson('card/giftcard/order/refund', $params);
    }
}