<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Util; use Carbon\Carbon; use Illuminate\Support\Facades\Cache; use Illuminate\Support\Str; use Intervention\Image\Facades\Image; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\AgentUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\EncodeUtil; use ModStart\Core\Util\FormatUtil; use ModStart\Core\Util\LockUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\StrUtil; use ModStart\Data\DataManager; use ModStart\Data\Event\DataFileUploadedEvent; use Module\Member\Events\MemberUserLoginAttemptEvent; use Module\Member\Events\MemberUserLoginFailedEvent; use Module\Member\Type\MemberMessageStatus; use Module\Member\Type\MemberStatus; use Module\Vendor\Type\DeviceType; class MemberUtil { public static function total() { return Cache::remember('MemberUserTotal', 60, function () { return ModelUtil::count('member_user'); }); } public static function get($StE5h) { return ModelUtil::get('member_user', array('id' => $StE5h)); } public static function getCached($StE5h) { return Cache::remember('MemberUser:' . $StE5h, 60, function () use($StE5h) { return self::get($StE5h); }); } public static function processDefault(&$KAIwS) { goto KxRxa; ucWvY: if (empty($KAIwS['nickname'])) { $KAIwS['nickname'] = $KAIwS['username']; } goto gda8_; gda8_: if (empty($KAIwS['avatar'])) { $KAIwS['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto dE5CM; KxRxa: if (empty($KAIwS)) { return; } goto ucWvY; GUbdT: if (empty($KAIwS['avatarBig'])) { $KAIwS['avatarBig'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto p8DWF; dE5CM: if (empty($KAIwS['avatarMedium'])) { $KAIwS['avatarMedium'] = AssetsUtil::fixFull('asset/image/avatar.svg', false); } goto GUbdT; p8DWF: } private static function processBasicFields($OlNuV) { goto XMh7Q; mpXGq: return $OlNuV; goto fF1ij; XMh7Q: $EKt0N = array('id', 'username', 'avatar', 'created_at', 'signature', 'nickname'); goto GBgH9; GBgH9: if (null === $OlNuV) { $OlNuV = $EKt0N; } else { goto MlI2z; ovlEF: foreach ($OlNuV as $D5qRP) { if ('<basic>' == $D5qRP) { $yF_72 = array_merge($yF_72, $EKt0N); } else { $yF_72[] = $D5qRP; } } goto RbPNH; RbPNH: $OlNuV = $yF_72; goto iE1x8; MlI2z: $yF_72 = array(); goto ovlEF; iE1x8: } goto mpXGq; fF1ij: } public static function fixAvatar($D9h1F) { return AssetsUtil::fixFullOrDefault($D9h1F, 'asset/image/avatar.svg'); } public static function getBasic($StE5h, $OlNuV = null) { goto HvN99; HjK25: $e3gsP = array(); goto kcpjl; afHnA: if (empty($FSL7c)) { return null; } goto KM2dW; a2R4t: $FSL7c['avatar'] = self::fixAvatar($FSL7c['avatar']); goto HjK25; kcpjl: foreach ($OlNuV as $wXNd6) { if (isset($FSL7c[$wXNd6])) { $e3gsP[$wXNd6] = $FSL7c[$wXNd6]; } else { $e3gsP[$wXNd6] = null; } } goto JaX8q; JaX8q: return $e3gsP; goto ZmXu2; KM2dW: if (empty($FSL7c['nickname'])) { $FSL7c['nickname'] = $FSL7c['username']; } goto a2R4t; RIRpz: $FSL7c = self::get($StE5h); goto afHnA; HvN99: $OlNuV = self::processBasicFields($OlNuV); goto RIRpz; ZmXu2: } public static function listViewName($k30iT) { goto zo5m3; YgL73: $prI60 = ModelUtil::allIn('member_user', 'id', $k30iT); goto vS0z9; yeFPP: return $H_aKg; goto Rn1uA; zo5m3: $H_aKg = array(); goto YgL73; vS0z9: foreach ($prI60 as $KAIwS) { $H_aKg[] = self::viewName($KAIwS); } goto yeFPP; Rn1uA: } public static function listUsers($k30iT) { return ModelUtil::allIn('member_user', 'id', $k30iT); } public static function convertOneToBasic($KAIwS) { return array('id' => $KAIwS['id'], 'username' => $KAIwS['username'], 'nickname' => empty($KAIwS['nickname']) ? $KAIwS['username'] : $KAIwS['nickname'], 'created_at' => $KAIwS['created_at'], 'signature' => isset($KAIwS['signature']) ? $KAIwS['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($KAIwS['avatar'], 'asset/image/avatar.svg')); } public static function convertToBasic($prI60) { return array_map(function ($FSL7c) { return array('id' => $FSL7c['id'], 'username' => $FSL7c['username'], 'nickname' => empty($FSL7c['nickname']) ? $FSL7c['username'] : $FSL7c['nickname'], 'created_at' => $FSL7c['created_at'], 'signature' => isset($FSL7c['signature']) ? $FSL7c['signature'] : null, 'avatar' => AssetsUtil::fixFullOrDefault($FSL7c['avatar'], 'asset/image/avatar.svg')); }, $prI60); } public static function listUsersBasic($k30iT) { return self::convertToBasic(self::listUsers($k30iT)); } public static function getViewName($StE5h) { return self::viewName(self::get($StE5h)); } public static function viewName($KAIwS) { goto E0wWq; Dhrg5: if (empty($KAIwS)) { return '-'; } goto yz4vH; lZc3f: if (!empty($KAIwS['username'])) { return $KAIwS['username']; } goto UyGWu; yz4vH: if (!empty($KAIwS['nickname'])) { return $KAIwS['nickname']; } goto lZc3f; UyGWu: return "ID-{$KAIwS['id']}"; goto LMfgY; E0wWq: if ($KAIwS && is_numeric($KAIwS)) { return self::getViewName($KAIwS); } goto Dhrg5; LMfgY: } public static function update($StE5h, $cwaKT) { return ModelUtil::update('member_user', array('id' => $StE5h), $cwaKT); } public static function updateBasicWithUniqueCheck($StE5h, $cwaKT) { goto b9mQP; cM4YM: self::update($StE5h, $cwaKT); goto cc_M1; cc_M1: return Response::generate(0, 'ok'); goto rRf89; C7I6K: foreach (array('username' => '用户名', 'phone' => '手机', 'email' => '邮箱') as $Wvq57 => $x7DCV) { if (isset($cwaKT[$Wvq57])) { goto JQDB3; yMXkf: $U2BR2 = ModelUtil::all('member_user', array($Wvq57 => $cwaKT[$Wvq57])); goto whAUR; JQDB3: if (empty($cwaKT[$Wvq57])) { $cwaKT[$Wvq57] = null; continue; } goto yMXkf; TOv3D: if (count($U2BR2) == 1) { if ($U2BR2[0]['id'] != $StE5h) { return Response::generate(-1, $x7DCV . '重复'); } } goto eGW9s; whAUR: if (count($U2BR2) > 1) { return Response::generate(-1, $x7DCV . '重复'); } goto TOv3D; eGW9s: } } goto cM4YM; b9mQP: if (empty($cwaKT)) { return Response::generate(0, 'ok'); } goto C7I6K; rRf89: } public static function login($nfE6o = '', $ffJmI = '', $ynBrC = '', $wxnHg = '') { goto j1wN1; cOJLM: if (!$wxnHg) { return Response::generate(-2, '密码为空'); } goto uWTd1; LGrne: $ffJmI = trim($ffJmI); goto eQ1nM; Mdg7j: return Response::generateSuccessData($KAIwS); goto buNsx; uWTd1: if ($ynBrC) { if (!FormatUtil::isEmail($ynBrC)) { return Response::generate(-3, '邮箱格式不正确'); } $k3Pg0 = array('email' => $ynBrC); } else { if ($ffJmI) { if (!preg_match('/(^1[0-9]{10}$)/', $ffJmI)) { return Response::generate(-4, '手机格式不正确'); } $k3Pg0 = array('phone' => $ffJmI); } else { if ($nfE6o) { if (strpos($nfE6o, '@') !== false) { return Response::generate(-5, '用户名格式不正确'); } $k3Pg0 = array('username' => $nfE6o); } } } goto omZsh; hG0ff: if (empty($KAIwS)) { return Response::generate(-6, '登录失败:用户名或密码错误'); } goto JsD5V; omZsh: $KAIwS = ModelUtil::get('member_user', $k3Pg0); goto hG0ff; G8Ky1: if ($KAIwS['password'] != EncodeUtil::md5WithSalt($wxnHg, $KAIwS['passwordSalt'])) { MemberUserLoginFailedEvent::fire($KAIwS['id'], $KAIwS['username'], Request::ip(), AgentUtil::getUserAgent()); return Response::generate(-7, '登录失败:用户名或密码错误'); } goto tv4KN; j1wN1: $ynBrC = trim($ynBrC); goto LGrne; PXn9n: if (!($ynBrC || $ffJmI || $nfE6o)) { return Response::generate(-1, '所有登录字段均为空'); } goto cOJLM; eQ1nM: $nfE6o = trim($nfE6o); goto PXn9n; tv4KN: switch ($KAIwS['status']) { case MemberStatus::FORBIDDEN: return Response::generateError(-8, '登录失败:当前用户已被禁用'); } goto Mdg7j; JsD5V: MemberUserLoginAttemptEvent::fire($KAIwS['id'], Request::ip(), AgentUtil::getUserAgent()); goto G8Ky1; buNsx: } public static function autoSetUsernameNickname($nlOSA, $x8hcQ) { goto USaNN; nH0ux: if (preg_match('/\\{.*\\}/', $x8hcQ)) { goto gbC5D; h6hsH: $g6Mii = 0; goto MIY8l; k7DuT: $our4j = array('{Phone}' => $KAIwS['phone'], '{Phone4}' => substr($KAIwS['phone'], 7), '{Uid}' => $KAIwS['id']); goto XyZAx; gbC5D: $KAIwS = self::get($nlOSA); goto k7DuT; XyZAx: $x8hcQ = str_replace(array_keys($our4j), array_values($our4j), $x8hcQ); goto h6hsH; MIY8l: } goto WpDNp; USaNN: $g6Mii = 6; goto nH0ux; WpDNp: self::suggestUsernameNickname($nlOSA, $x8hcQ, $g6Mii); goto S6MG_; S6MG_: } public static function getSuggestUsernameNickname($aFpSu) { goto RA1c1; RA1c1: $x8hcQ = $aFpSu . Str::random(1); goto kq5y7; OBCdJ: return $x8hcQ . Str::random(10); goto q7mJg; kq5y7: for ($Iy3ah = 0; $Iy3ah < 20; $Iy3ah++) { $Zcap8 = ModelUtil::model('member_user')->where(array('username' => $x8hcQ))->orWhere(array('nickname' => $x8hcQ))->first(); if (empty($Zcap8)) { return $x8hcQ; } $x8hcQ = $x8hcQ . Str::random(1); } goto OBCdJ; q7mJg: } private static function suggestUsernameNickname($nlOSA, $w4kK_ = '用户', $g6Mii = 6) { goto xuM3Q; F3PEe: ModelUtil::update('member_user', $nlOSA, array('username' => $x8hcQ, 'nickname' => $x8hcQ)); goto FJEmz; xuM3Q: if ($g6Mii > 0) { $x8hcQ = $w4kK_ . RandomUtil::string($g6Mii); } else { $x8hcQ = $w4kK_; } goto VFH2t; VFH2t: for ($Iy3ah = 0; $Iy3ah < 20; $Iy3ah++) { $Zcap8 = ModelUtil::model('member_user')->where(array('username' => $x8hcQ))->orWhere(array('nickname' => $x8hcQ))->first(); if (empty($Zcap8)) { break; } $x8hcQ = $x8hcQ . Str::random(1); } goto F3PEe; FJEmz: } public static function registerUsernameQuick($nfE6o) { goto QVY4u; kvOKx: for ($Iy3ah = 0; $Iy3ah < 10; $Iy3ah++) { $ZrjxR = self::register($RJX1x, '', '', '', true); if ($ZrjxR['code']) { $RJX1x = $RJX1x . Str::random(1); } else { return $ZrjxR; } } goto bgSZt; QVY4u: $RJX1x = $nfE6o; goto kvOKx; bgSZt: return Response::generateError('注册失败'); goto XeJep; XeJep: } public static function register($nfE6o = '', $ffJmI = '', $ynBrC = '', $wxnHg = '', $kZEoL = false) { goto ZWx3J; xca0S: $KAIwS = ModelUtil::insert('member_user', array('status' => MemberStatus::NORMAL, 'username' => $nfE6o, 'email' => $ynBrC, 'phone' => $ffJmI, 'password' => $kZEoL ? null : EncodeUtil::md5WithSalt($wxnHg, $K2pfJ), 'passwordSalt' => $kZEoL ? null : $K2pfJ, 'vipId' => MemberVipUtil::defaultVipId(), 'groupId' => MemberGroupUtil::defaultGroupId(), 'isDeleted' => false)); goto pdWM0; NIbJu: $nfE6o = trim($nfE6o); goto w21QL; ZWx3J: $ynBrC = trim($ynBrC); goto hxWVM; Ck9hp: if ($ffJmI) { $ZrjxR = self::uniqueCheck('phone', $ffJmI); if ($ZrjxR['code']) { return $ZrjxR; } } else { $ffJmI = null; } goto UrRZz; pdWM0: return Response::generate(0, 'ok', $KAIwS); goto lY4g4; MjGCu: if ($ynBrC) { $ZrjxR = self::uniqueCheck('email', $ynBrC); if ($ZrjxR['code']) { return $ZrjxR; } } else { $ynBrC = null; } goto Ck9hp; UrRZz: if ($nfE6o) { goto AkXlk; xdlsP: if (preg_match('/^[0-9]{11}$/', $nfE6o)) { return Response::generate(-1, '用户名不能为纯数字'); } goto wzNUw; sapJI: if ($ZrjxR['code']) { return $ZrjxR; } goto EgcSf; EgcSf: if (strlen($nfE6o) < modstart_config('Member_UsernameMinLength', 3)) { return Response::generate(-1, '用户名至少3个字符'); } goto vUW8h; AkXlk: $ZrjxR = self::uniqueCheck('username', $nfE6o); goto sapJI; vUW8h: if (Str::contains($nfE6o, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto xdlsP; wzNUw: } else { $nfE6o = null; } goto hQTDu; w21QL: if (!($ynBrC || $ffJmI || $nfE6o)) { return Response::generate(-1, '所有注册字段均为空'); } goto MjGCu; hxWVM: $ffJmI = trim($ffJmI); goto NIbJu; a9J4o: $K2pfJ = Str::random(16); goto xca0S; hQTDu: if (!$kZEoL) { if (empty($wxnHg) || strlen($wxnHg) < 6) { return Response::generate(-3, '密码不合法'); } } goto a9J4o; lY4g4: } public static function uniqueCheck($AIxhN, $qQcPQ, $XPiLL = 0) { goto kVzSk; m4zpy: $KAIwS = ModelUtil::get('member_user', array($AIxhN => $qQcPQ)); goto RPJeX; RPJeX: if (empty($KAIwS)) { return Response::generate(0, 'ok'); } goto k3Msj; r24UU: switch ($AIxhN) { case 'email': if (!FormatUtil::isEmail($qQcPQ)) { return Response::generate(-1, '邮箱格式不正确'); } break; case 'phone': if (!preg_match('/(^1[0-9]{10}$)/', $qQcPQ)) { return Response::generate(-1, '手机格式不正确'); } break; case 'username': if (strpos($qQcPQ, '@') !== false) { return Response::generate(-1, '用户名格式不正确'); } break; case 'nickname': break; default: return Response::generate(-1, '未能识别的类型' . $AIxhN); } goto m4zpy; P1uxM: if ($XPiLL == $KAIwS['id']) { return Response::generate(0, 'ok'); } goto u8q75; kVzSk: $qQcPQ = trim($qQcPQ); goto r24UU; u8q75: return Response::generate(-2, $ebbU5[$AIxhN] . '已经被占用'); goto nAoZ1; k3Msj: $ebbU5 = array('username' => '用户名', 'email' => '邮箱', 'phone' => '手机号'); goto P1uxM; nAoZ1: } public static function getByUsername($nfE6o) { return ModelUtil::get('member_user', array('username' => $nfE6o)); } public static function getByEmail($ynBrC) { return ModelUtil::get('member_user', array('email' => $ynBrC)); } public static function getByPhone($ffJmI) { return ModelUtil::get('member_user', array('phone' => $ffJmI)); } public static function changeNickname($nlOSA, $VnV3b) { goto Yognw; Yognw: $ZrjxR = self::uniqueCheck('nickname', $VnV3b, $nlOSA); goto v8OXx; z2PgT: return Response::generate(0, 'ok'); goto V5IYk; v8OXx: if (Response::isError($ZrjxR)) { return $ZrjxR; } goto s1qI1; s1qI1: ModelUtil::update('member_user', $nlOSA, array('nickname' => $VnV3b)); goto z2PgT; V5IYk: } public static function changePassword($nlOSA, $hkuVz, $yz4gV = null, $fUccY = false) { goto L6zE9; DjpLG: if (empty($hkuVz)) { return Response::generate(-1, '新密码为空'); } goto a1jzC; hI2jx: ModelUtil::update('member_user', array('id' => $KAIwS['id']), array('passwordSalt' => $K2pfJ, 'password' => EncodeUtil::md5WithSalt($hkuVz, $K2pfJ))); goto U6iWb; VTabE: $KAIwS = ModelUtil::get('member_user', array('id' => $nlOSA)); goto lpLxP; U6iWb: return Response::generate(0, 'ok'); goto rvrNP; a1jzC: if (!$fUccY && EncodeUtil::md5WithSalt($yz4gV, $KAIwS['passwordSalt']) != $KAIwS['password']) { return Response::generate(-1, '旧密码不正确'); } goto fgAZi; L6zE9: if (!$fUccY && empty($yz4gV)) { return Response::generate(-1, '旧密码不能为空'); } goto VTabE; lpLxP: if (empty($KAIwS)) { return Response::generate(-1, '用户不存在'); } goto DjpLG; fgAZi: $K2pfJ = Str::random(16); goto hI2jx; rvrNP: } public static function setAvatar($wEeRo, $siWDc, $qp27r = 'jpg') { goto VvWWC; BOmZV: $OulD6 = DataManager::upload('image', 'U' . $wEeRo . '_AvatarBig.' . $qp27r, $mx_Y6, null, $s8IDO); goto jOvdo; mQgl7: $S5T8W = (string) Image::make($siWDc)->resize(200, 200)->encode($qp27r, 75); goto w7WDB; TOTgO: $s8IDO = array('eventOpt' => array(DataFileUploadedEvent::OPT_IMAGE_COMPRESS_IGNORE => true, DataFileUploadedEvent::OPT_IMAGE_WATERMARK_IGNORE => true)); goto BOmZV; QG_56: $ZrjxR = DataManager::upload('image', 'U_' . $wEeRo . '_Avatar.' . $qp27r, $uKj64, null, $s8IDO); goto GJKo_; XI_qj: return Response::generateSuccess(); goto RS6Ef; WUJly: $mx_Y6 = (string) Image::make($siWDc)->resize(400, 400)->encode($qp27r, 75); goto mQgl7; GJKo_: if ($ZrjxR['code']) { goto AyPqV; AyPqV: DataManager::deleteById($OulD6['data']['id']); goto UDTJT; xWped: if ($OulD6['code']) { return Response::generate(-1, '头像存储失败（' . $ZrjxR['msg'] . '）'); } goto YuD1w; UDTJT: DataManager::deleteById($zPbBS['data']['id']); goto xWped; YuD1w: } goto tzsI2; R34qO: if (empty($siWDc)) { return Response::generate(-1, '图片数据为空'); } goto WUJly; UJI__: if ($zPbBS['code']) { DataManager::deleteById($OulD6['data']['id']); if ($OulD6['code']) { return Response::generate(-1, '头像存储失败（' . $zPbBS['msg'] . '）'); } } goto QG_56; w7WDB: $uKj64 = (string) Image::make($siWDc)->resize(50, 50)->encode($qp27r, 75); goto TOTgO; tzsI2: self::update($KAIwS['id'], array('avatarBig' => $OulD6['data']['fullPath'], 'avatarMedium' => $zPbBS['data']['fullPath'], 'avatar' => $ZrjxR['data']['fullPath'])); goto XI_qj; esgVH: $zPbBS = DataManager::upload('image', 'U' . $wEeRo . '_AvatarMiddle.' . $qp27r, $S5T8W, null, $s8IDO); goto UJI__; jOvdo: if ($OulD6['code']) { return Response::generate(-1, '头像存储失败（' . $OulD6['msg'] . '）'); } goto esgVH; mzUVB: if (empty($KAIwS)) { return Response::generate(-1, '用户不存在'); } goto R34qO; VvWWC: $KAIwS = self::get($wEeRo); goto mzUVB; RS6Ef: } public static function findUsers($dlzdo) { goto aIsl4; VYBsP: $prI60 = ModelUtil::model('member_user')->whereIn('id', $dlzdo)->get(); goto rPr3s; AK3lo: $ntjs_ = array(); goto VYBsP; aIsl4: if (empty($dlzdo)) { return array(); } goto AK3lo; sn0dS: return $ntjs_; goto JPU1v; rPr3s: foreach ($prI60 as &$H1o_x) { $ntjs_[$H1o_x->id] = $H1o_x->toArray(); } goto sn0dS; JPU1v: } public static function filterUserIds($dlzdo) { goto CU7Fc; D2yU9: foreach ($prI60 as &$H1o_x) { $our4j[$H1o_x->id] = true; } goto G310q; YgCR5: $our4j = array(); goto GnDX_; GnDX_: $prI60 = ModelUtil::model('member_user')->whereIn('id', $dlzdo)->get(array('id')); goto D2yU9; CU7Fc: if (empty($dlzdo)) { return array(); } goto YgCR5; G310q: return array_keys($our4j); goto SezR8; SezR8: } public static function mergeMemberUsers(&$Y9WQp, $bKj6m = 'memberUserId', $M4bKA = '_memberUser') { ModelUtil::join($Y9WQp, $bKj6m, $M4bKA, 'member_user', 'id'); } public static function mergeMemberUserBasics(&$Y9WQp, $bKj6m = 'memberUserId', $M4bKA = '_memberUser', $OlNuV = null) { $OlNuV = self::processBasicFields($OlNuV); if (is_array($Y9WQp)) { ModelUtil::join($Y9WQp, $bKj6m, $M4bKA, 'member_user', 'id'); foreach ($Y9WQp as $D5qRP => $qGgGl) { goto R9RJA; sv7fk: $KAIwS = ArrayUtil::keepKeys($qGgGl[$M4bKA], $OlNuV); goto wo3OV; VA9Wa: if (empty($KAIwS['avatar'])) { $KAIwS['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $KAIwS['avatar'] = AssetsUtil::fixFull($KAIwS['avatar']); } goto rAU2o; wo3OV: if (empty($KAIwS['nickname'])) { $KAIwS['nickname'] = $KAIwS['username']; } goto VA9Wa; R9RJA: if (empty($qGgGl[$M4bKA])) { continue; } goto sv7fk; rAU2o: $Y9WQp[$D5qRP][$M4bKA] = $KAIwS; goto heDYn; heDYn: } } else { ModelUtil::joinItems($Y9WQp, $bKj6m, $M4bKA, 'member_user', 'id'); foreach ($Y9WQp as $FSL7c) { goto M6Kg5; M6Kg5: if (empty($FSL7c->{$M4bKA})) { continue; } goto OyJa6; OyJa6: $KAIwS = ArrayUtil::keepKeys($FSL7c->{$M4bKA}, $OlNuV); goto dVptk; GSoRD: if (empty($KAIwS['avatar'])) { $KAIwS['avatar'] = AssetsUtil::fixFull('asset/image/avatar.svg'); } else { $KAIwS['avatar'] = AssetsUtil::fixFull($KAIwS['avatar']); } goto fxcsx; dVptk: if (empty($KAIwS['nickname'])) { $KAIwS['nickname'] = $KAIwS['username']; } goto GSoRD; fxcsx: $FSL7c->{$M4bKA} = $KAIwS; goto Ahzst; Ahzst: } } } public static function insert($cwaKT) { return ModelUtil::insert('member_user', $cwaKT); } public static function getIdByOauth($zs_EH, $bWm8l) { goto S5IYy; yW57e: if (empty($a_yFh)) { return 0; } goto ABsl3; ABsl3: return intval($a_yFh['memberUserId']); goto xEqMV; S5IYy: $a_yFh = ModelUtil::get('member_oauth', array('type' => $zs_EH, 'openId' => $bWm8l)); goto yW57e; xEqMV: } public static function getIdByOauthAndCheck($zs_EH, $bWm8l) { goto jTUl4; dKc5D: return 0; goto afjS3; jTUl4: $nlOSA = self::getIdByOauth($zs_EH, $bWm8l); goto dOpQ4; dOpQ4: if (self::get($nlOSA)) { return $nlOSA; } goto Z5RTc; Z5RTc: MemberUtil::forgetOauth($zs_EH, $bWm8l); goto dKc5D; afjS3: } public static function getOauthOpenId($nlOSA, $zs_EH) { goto Ysyvo; xlwTS: if (empty($a_yFh)) { return null; } goto HN742; HN742: return $a_yFh['openId']; goto aW0Of; Y1XGe: $a_yFh = ModelUtil::get('member_oauth', $k3Pg0); goto xlwTS; Ysyvo: $k3Pg0 = array('memberUserId' => $nlOSA, 'type' => $zs_EH); goto Y1XGe; aW0Of: } public static function getOauth($nlOSA, $zs_EH) { $k3Pg0 = array('memberUserId' => $nlOSA, 'type' => $zs_EH); return ModelUtil::get('member_oauth', $k3Pg0); } public static function listOauths($nlOSA) { return ModelUtil::all('member_oauth', array('memberUserId' => $nlOSA), array('*'), array('type', 'asc')); } public static function putOauth($nlOSA, $zs_EH, $bWm8l, $bOB_A = array()) { goto j4cFc; j4cFc: $k3Pg0 = array('memberUserId' => $nlOSA, 'type' => $zs_EH); goto RgAkf; RgAkf: $Vcsrk = "MemberOauth:{$nlOSA}"; goto pQ_jY; pQ_jY: if (!LockUtil::acquire($Vcsrk)) { BizException::throws('正在处理中，请稍后再试'); } goto BfoCp; FNR0I: if (empty($a_yFh)) { ModelUtil::delete('member_oauth', array('type' => $zs_EH, 'openId' => $bWm8l)); ModelUtil::insert('member_oauth', array_merge($k3Pg0, $jNwg7)); } else { if ($a_yFh['openId'] != $bWm8l) { ModelUtil::update('member_oauth', $a_yFh['id'], $jNwg7); } } goto dAU3Q; dAU3Q: LockUtil::release($Vcsrk); goto PBWhF; BfoCp: $a_yFh = ModelUtil::get('member_oauth', $k3Pg0); goto oQ94U; oQ94U: $jNwg7 = array_merge(array('openId' => $bWm8l), $bOB_A); goto FNR0I; PBWhF: } public static function forgetOauth($zs_EH, $bWm8l) { ModelUtil::delete('member_oauth', array('type' => $zs_EH, 'openId' => $bWm8l)); } public static function updateNewMessageStatus($nlOSA) { ModelUtil::update('member_user', array('id' => $nlOSA), array('newMessageCount' => ModelUtil::count('member_message', array('userId' => $nlOSA, 'status' => MemberMessageStatus::UNREAD)))); } public static function updateNewChatMsgStatus($nlOSA) { if (modstart_module_enabled('MemberChat')) { ModelUtil::update('member_user', array('id' => $nlOSA), array('newChatMsgCount' => ModelUtil::sum('member_chat', 'unreadMsgCount', array('memberUserId' => $nlOSA)))); } } public static function paginate($WLCMC, $Aqj3Z, $f2U49 = array()) { return ModelUtil::paginate('member_user', $WLCMC, $Aqj3Z, $f2U49); } public static function updateStatus($nWsy8, $Y4aKN) { goto mczMd; KZmn2: ModelUtil::model('member_user')->whereIn('id', $nWsy8)->update(array('status' => $Y4aKN)); goto R3N_G; Q1UdH: if (empty($nWsy8)) { return; } goto KZmn2; mczMd: if (!is_array($nWsy8)) { $nWsy8 = array($nWsy8); } goto Q1UdH; R3N_G: } public static function delete($nlOSA) { goto ua2nH; MJD7Z: ModelUtil::update('member_user', $nlOSA, array('deleteAtTime' => 0, 'isDeleted' => true, 'username' => null, 'phone' => null, 'email' => null)); goto NRfjt; iIbJL: ModelUtil::insert('member_deleted', array('id' => $KAIwS['id'], 'username' => $KAIwS['username'], 'phone' => $KAIwS['phone'], 'email' => $KAIwS['email'], 'content' => json_encode($V0Dls, JSON_UNESCAPED_UNICODE))); goto MJD7Z; r2jkC: ModelUtil::transactionBegin(); goto W8Sx4; YxoFh: BizException::throwsIfEmpty('用户不存在', $KAIwS); goto r2jkC; W8Sx4: $V0Dls = array(); goto RY891; RY891: $blWQB = ModelUtil::all('member_oauth', array('memberUserId' => $KAIwS['id'])); goto c1Uxd; ua2nH: $KAIwS = self::get($nlOSA); goto YxoFh; NRfjt: ModelUtil::transactionCommit(); goto QUrJO; c1Uxd: $V0Dls['oauth'] = ArrayUtil::keepItemsKeys($blWQB, array('type', 'openId', 'infoUsername', 'infoAvatar')); goto iIbJL; QUrJO: } public static function fireLogin($nlOSA) { goto lL3zk; S8JRx: ModelUtil::insert('member_login_log', array('memberUserId' => $nlOSA, 'deviceType' => DeviceType::current(), 'ip' => StrUtil::mbLimit($aZl1j, 20), 'userAgent' => StrUtil::mbLimit(AgentUtil::getUserAgent(), 400))); goto GFjLV; eT9_A: ModelUtil::update('member_user', $nlOSA, array('lastLoginTime' => Carbon::now(), 'lastLoginIp' => StrUtil::mbLimit($aZl1j, 20))); goto S8JRx; lL3zk: $aZl1j = Request::ip(); goto eT9_A; GFjLV: } }