<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Api\Controller; use Illuminate\Support\Facades\Log; use Illuminate\Support\Facades\Session; use Illuminate\Support\Str; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Util\CurlUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\FileUtil; use ModStart\Core\Util\StrUtil; use ModStart\Misc\Captcha\CaptchaFacade; use ModStart\Module\ModuleBaseController; use Module\Member\Auth\MemberUser; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserLoginedEvent; use Module\Member\Events\MemberUserLogoutEvent; use Module\Member\Events\MemberUserPasswordResetedEvent; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Oauth\AbstractOauth; use Module\Member\Provider\RegisterProcessor\AbstractMemberRegisterProcessorProvider; use Module\Member\Provider\RegisterProcessor\MemberRegisterProcessorProvider; use Module\Member\Util\MemberUtil; use Module\Member\Util\SecurityUtil; use Module\Vendor\Job\MailSendJob; use Module\Vendor\Job\SmsSendJob; use Module\Vendor\Support\ResponseCodes; use Module\Vendor\Util\SessionUtil; class AuthController extends ModuleBaseController { public function checkRedirectSafety($yTnoO) { goto OZVzp; rjI1g: BizException::throws('登录跳转路径异常'); goto JjhQQ; gfSaN: $cZCsD = modstart_config('Member_LoginRedirectWhiteList', ''); goto Ng6Cb; EkqyL: $bOB_A = parse_url($yTnoO); goto Q5jrm; Ng6Cb: $cZCsD = explode('
', $cZCsD); goto ZBG4w; Q5jrm: if (empty($bOB_A['host'])) { return; } goto nNXJf; nNXJf: if ($bOB_A['host'] == Request::domain()) { return; } goto gfSaN; PhBeN: foreach ($cZCsD as $FSL7c) { if ($bOB_A['host'] == $FSL7c) { return; } } goto rjI1g; ZBG4w: $cZCsD = array_filter($cZCsD); goto PhBeN; OZVzp: if (!modstart_config('Member_LoginRedirectCheckEnable', false)) { return; } goto EkqyL; JjhQQ: } public function oauthTryLogin($zs_EH = null) { goto pWVQP; Czf9y: $i_ZUL = MemberOauth::getOrFail($zs_EH); goto rJLzX; WUp1G: if (empty($czUqd)) { return Response::generate(-1, '用户授权数据为空'); } goto RROp1; mjfM3: if ($ZrjxR['data']['memberUserId'] > 0) { goto cbyc1; cbyc1: Session::put('memberUserId', $ZrjxR['data']['memberUserId']); goto RxDch; RxDch: MemberUtil::fireLogin($ZrjxR['data']['memberUserId']); goto K8_g6; K8_g6: Session::forget('oauthUserInfo'); goto qwAAb; qwAAb: return Response::generateSuccessData(array('memberUserId' => $ZrjxR['data']['memberUserId'])); goto QwY2O; QwY2O: } goto KCZOr; KCZOr: return Response::generate(0, null, array('memberUserId' => 0)); goto RQe5c; rJLzX: $ZrjxR = $i_ZUL->processTryLogin(array('userInfo' => $czUqd)); goto t_8FW; t_8FW: BizException::throwsIfResponseError($ZrjxR); goto mjfM3; CrRZj: BizException::throwsIfEmpty('授权类型为空', $zs_EH); goto Czf9y; RROp1: if (empty($zs_EH)) { $tBuXm = InputPackage::buildFromInput(); $zs_EH = $tBuXm->getTrimString('type'); } goto CrRZj; pWVQP: $czUqd = Session::get('oauthUserInfo', array()); goto WUp1G; RQe5c: } public function oauthBind($zs_EH = null) { goto FrxCC; Y5pSw: $i_ZUL = MemberOauth::getOrFail($zs_EH); goto u51HJ; qTIuM: if (modstart_config('Member_OauthBindEmailEnable')) { goto Ers5D; xcMwq: if (Session::get('oauthBindEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '邮箱验证码已过期'); } goto l6u2P; Ers5D: if (empty($ynBrC)) { return Response::generate(-1, '请输入邮箱'); } goto uFhPt; uFhPt: $KQoLJ = Session::get('oauthBindEmailVerify'); goto BGgI6; BGgI6: if ($w300c != $KQoLJ) { Log::info('Member.OauthBind.EmailVerifyError - ' . $w300c . ' - ' . $KQoLJ); return Response::generate(-1, '邮箱验证码不正确.'); } goto xcMwq; l6u2P: if ($ynBrC != Session::get('oauthBindEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto nTwWw; nTwWw: } goto zybDq; zybDq: $ZrjxR = MemberUtil::register($nfE6o, $ffJmI, $ynBrC, null, true); goto zHR6O; yHBN7: $ffJmI = $tBuXm->getPhone('phone'); goto rM3kg; b_cFO: if (!empty($jNwg7)) { MemberUtil::update($nlOSA, $jNwg7); } goto HA0CV; InE9t: $ynBrC = $tBuXm->getEmail('email'); goto pZM05; HA0CV: $ZrjxR = $i_ZUL->processBindToUser(array('memberUserId' => $nlOSA, 'userInfo' => $czUqd)); goto tU6SP; i6LqT: if (modstart_config()->getWithEnv('registerDisable', false) && !modstart_config()->getWithEnv('registerOauthEnable', false)) { return Response::generate(-1, '用户注册已禁用'); } goto GaV3B; FVa6P: if ($FD8Fe > 0) { goto CwJtq; wsovQ: return Response::generate(0, null, null, $yTnoO); goto JPvL_; wkis7: BizException::throwsIfResponseError($ZrjxR); goto rhRVk; CwJtq: $ZrjxR = $i_ZUL->processBindToUser(array('memberUserId' => $FD8Fe, 'userInfo' => $czUqd)); goto wkis7; rhRVk: Session::forget('oauthUserInfo'); goto wsovQ; JPvL_: } goto bPA1r; J3Rwl: $czUqd = Session::get('oauthUserInfo', array()); goto H963v; gVJQ9: Session::forget('oauthUserInfo'); goto kLXpl; CD_Wm: $jNwg7['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto b_cFO; GaV3B: $nfE6o = $tBuXm->getTrimString('username'); goto dr10S; fuNSs: BizException::throwsIfResponseError($ZrjxR); goto jswTG; pYpmP: if (modstart_config('Member_OauthBindPhoneEnable')) { goto EApIc; I8OTA: if (Session::get('oauthBindPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto MreVD; yMSd8: if ($VgJ2i != $LOsdl) { Log::info('Member.OauthBind.PhoneVerifyError - ' . $VgJ2i . ' - ' . $LOsdl); return Response::generate(-1, '手机验证码不正确.'); } goto I8OTA; EApIc: if (empty($ffJmI)) { return Response::generate(-1, '请输入手机'); } goto rprWm; rprWm: $LOsdl = Session::get('oauthBindPhoneVerify'); goto yMSd8; MreVD: if ($ffJmI != Session::get('oauthBindPhone')) { return Response::generate(-1, '两次手机不一致'); } goto HcXPG; HcXPG: } goto qTIuM; kLXpl: return Response::generate(0, null); goto wsvOt; oPuAW: $zs_EH = $tBuXm->getTrimString('type', $zs_EH); goto J3Rwl; aHmQk: MemberUtil::fireLogin($nlOSA); goto gVJQ9; TxyNN: if (!Session::get('oauthBindCaptchaPass', false)) { if (!CaptchaFacade::check($IU3nb)) { SessionUtil::atomicProduce('oauthBindCaptchaPassCount', 1); return Response::generate(-1, '请重新进行安全验证'); } } goto cIMZN; zHR6O: if ($ZrjxR['code']) { return Response::generate(-1, $ZrjxR['msg']); } goto LJowv; tU6SP: BizException::throwsIfResponseError($ZrjxR); goto UQ6xJ; v7_Yj: if (!empty($czUqd['avatar'])) { goto gJQMF; kbvzr: $lvJrZ = CurlUtil::get($czUqd['avatar'], array(), array('returnHeader' => true)); goto WXUYX; WXUYX: if (!empty($lvJrZ['body'])) { if (empty($qp27r) && !empty($ZrjxR['headerMap']['content-type'])) { $qp27r = FileUtil::mimeToExt($ZrjxR['headerMap']['content-type']); if (!in_array($qp27r, $ix0Ek)) { Log::info('Member.Auth.OauthBind.AvatarExtGuessError - ' . $qp27r . ' - ' . $czUqd['avatar']); $qp27r = null; } } if (!empty($qp27r)) { MemberUtil::setAvatar($nlOSA, $lvJrZ['body'], $qp27r); } } goto CMXF8; ScUaA: $ix0Ek = array('jpg', 'jpeg', 'png', 'gif'); goto jQJpb; jQJpb: if (!in_array($qp27r, $ix0Ek)) { Log::info('Member.Auth.OauthBind.AvatarExtError - ' . $qp27r . ' - ' . $czUqd['avatar']); $qp27r = null; } goto kbvzr; gJQMF: $qp27r = FileUtil::extension($czUqd['avatar']); goto ScUaA; CMXF8: } goto qyW1J; G2GAl: $jNwg7 = array(); goto Kxo8j; cIMZN: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto pYpmP; rM3kg: $VgJ2i = $tBuXm->getTrimString('phoneVerify'); goto InE9t; dr10S: if (Str::contains($nfE6o, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto x3IjB; UOUqk: if (modstart_config('Member_OauthBindEmailEnable')) { $jNwg7['emailVerified'] = true; } goto CD_Wm; qyW1J: Session::put('memberUserId', $nlOSA); goto aHmQk; jswTG: if ($ZrjxR['data']['memberUserId'] > 0) { goto OOI9Y; OOI9Y: Session::put('memberUserId', $ZrjxR['data']['memberUserId']); goto MHAhB; MHAhB: MemberUtil::fireLogin($ZrjxR['data']['memberUserId']); goto ESbDY; XR0SN: return Response::generateSuccessData(array('memberUserId' => $ZrjxR['data']['memberUserId'])); goto pbzol; ESbDY: Session::forget('oauthUserInfo'); goto XR0SN; pbzol: } goto i6LqT; c4JFj: $yTnoO = $tBuXm->getTrimString('redirect', modstart_web_url('member')); goto oPuAW; x3IjB: if (preg_match('/^\\d{11}$/', $nfE6o)) { return Response::generate(-1, '用户名不能为纯数字'); } goto yHBN7; lyjth: $IU3nb = $tBuXm->getTrimString('captcha'); goto TxyNN; u51HJ: $FD8Fe = Session::get('memberUserId', 0); goto FVa6P; Kxo8j: if (modstart_config('Member_OauthBindPhoneEnable')) { $jNwg7['phoneVerified'] = true; } goto UOUqk; FrxCC: $tBuXm = InputPackage::buildFromInput(); goto c4JFj; LJowv: $nlOSA = $ZrjxR['data']['id']; goto G2GAl; bPA1r: $ZrjxR = $i_ZUL->processTryLogin(array('userInfo' => $czUqd)); goto fuNSs; pZM05: $w300c = $tBuXm->getTrimString('emailVerify'); goto lyjth; UQ6xJ: EventUtil::fire(new MemberUserRegisteredEvent($nlOSA)); goto v7_Yj; H963v: if (empty($czUqd)) { return Response::generate(-1, '用户授权数据为空'); } goto Y5pSw; wsvOt: } public function oauthCallback($zs_EH = null, $jlZvo = null) { goto P5eqN; jlDWF: if (!isset($ZrjxR['code'])) { return Response::generate(-1, '登录失败(返回结果为空)'); } goto YMSE2; Y1U1z: $i_ZUL = MemberOauth::getOrFail($zs_EH); goto rzPxv; YMSE2: if (0 != $ZrjxR['code']) { return $ZrjxR; } goto YfYDX; j1S1g: if ($faKDa) { Session::put('oauthViewOpenId_' . $zs_EH, $M3MKX['openid']); return Response::generateSuccess(); } goto fFqgq; eFNQZ: if (empty($x9nqh)) { $x9nqh = $tBuXm->getTrimString('auth_code'); } goto NUhY3; fFqgq: Session::put('oauthUserInfo', $M3MKX); goto GJLb0; GJLb0: return Response::generate(0, 'ok', array('user' => $M3MKX)); goto an6xe; twpQN: $x9nqh = $tBuXm->getTrimString('code'); goto eFNQZ; kA3rl: $ZrjxR = $i_ZUL->processLogin(array_merge($uxJUJ, array('code' => $x9nqh, 'callback' => $jlZvo))); goto jlDWF; HSHJg: if (empty($jlZvo)) { $jlZvo = $tBuXm->getTrimString('callback', null); } goto twpQN; oVBoi: $faKDa = $tBuXm->getBoolean('view', false); goto j1S1g; P5eqN: $tBuXm = InputPackage::buildFromInput(); goto QhlDA; NUhY3: if (empty($x9nqh)) { return Response::generate(-1, '登录失败(code为空)', null, '/'); } goto Y1U1z; YfYDX: $M3MKX = $ZrjxR['data']['userInfo']; goto oVBoi; QhlDA: if (empty($zs_EH)) { $zs_EH = $tBuXm->getTrimString('type'); } goto HSHJg; rzPxv: $uxJUJ = Session::get('oauthLoginParam', array()); goto sYYfz; sYYfz: Session::forget('oauthLoginParam'); goto kA3rl; an6xe: } public function oauthLogin($zs_EH = null, $jlZvo = null) { goto do6aT; HdS2n: return Response::generate(0, 'ok', array('redirect' => $ZrjxR['data']['redirect'])); goto ycZZm; wbcdQ: BizException::throwsIfResponseError($ZrjxR); goto HdS2n; l5p1w: $uxJUJ = array('callback' => $jlZvo, 'silence' => $d2AJk); goto gViJg; gViJg: Session::put('oauthLoginParam', $uxJUJ); goto HlW0N; Nyzo1: $d2AJk = $tBuXm->getBoolean('silence', false); goto Hztl1; S5tfc: if (empty($zs_EH)) { $zs_EH = $tBuXm->getTrimString('type'); } goto J73GA; HlW0N: $ZrjxR = $i_ZUL->processRedirect($uxJUJ); goto wbcdQ; J73GA: if (empty($jlZvo)) { $jlZvo = $tBuXm->getTrimString('callback', 'NO_CALLBACK'); } goto Nyzo1; Hztl1: $i_ZUL = MemberOauth::getOrFail($zs_EH); goto l5p1w; pBa2O: $tBuXm = InputPackage::buildFromInput(); goto S5tfc; do6aT: if ($G2eQu = modstart_config()->getWithEnv('oauthDisableText')) { return Response::generateError($G2eQu); } goto pBa2O; ycZZm: } public function ssoClientLogoutPrepare() { goto ShKFC; YaJqR: $o1RSB = $tBuXm->getTrimString('domainUrl'); goto GZHEi; GZHEi: $zqQco = modstart_config('ssoClientServer', ''); goto mtKFT; zqESD: $tBuXm = InputPackage::buildFromInput(); goto YaJqR; bub1R: return Response::generate(0, 'ok', array('redirect' => $yTnoO)); goto wFb0F; mtKFT: if (empty($zqQco)) { return Response::generate(-1, '请配置 同步登录服务端地址'); } goto HhpM3; ShKFC: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto zqESD; HhpM3: $yTnoO = $zqQco . '_logout' . '?' . http_build_query(array('redirect' => $o1RSB . '/sso/client_logout')); goto bub1R; wFb0F: } public function ssoClientLogout() { goto Nodkp; tUFRu: Session::forget('memberUserId'); goto DnO2t; Nodkp: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto tUFRu; DnO2t: return Response::generate(0, 'ok'); goto vm4x0; vm4x0: } public function ssoServerLogout() { goto adbdW; vUG9S: Session::forget('memberUserId'); goto vO5Bc; vO5Bc: return Response::generate(0, 'ok'); goto a8lZ8; adbdW: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto vUG9S; a8lZ8: } public function ssoServerSuccess() { goto DmWJZ; FAfsd: if (!$nlOSA) { return Response::generate(-1, '未登录'); } goto KqjoE; dsJvd: $tBuXm = InputPackage::buildFromInput(); goto AsG2o; JKa8t: if (empty($o1RSB) || empty($CkJ6J)) { return Response::generate(-1, '数据错误'); } goto Z5dS2; Zmnhh: $yTnoO = $CkJ6J . '?server=' . urlencode($g5fcb) . '&timestamp=' . $FSN2O . '&username=' . urlencode(base64_encode($nfE6o)) . '&sign=' . $wH3g6; goto m4B25; zveyD: $FSN2O = time(); goto AbR4f; j_rNs: foreach ($pDI1K as $FSL7c) { if (trim($FSL7c) == $CkJ6J) { $Raowb = true; } } goto QUA8p; AbR4f: $nfE6o = $KAIwS['username']; goto Cw_bW; AsG2o: $CkJ6J = $tBuXm->getTrimString('client'); goto h2Hr3; DmWJZ: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto NAB11; Z5dS2: $pDI1K = explode('
', modstart_config('ssoServerClientList', '')); goto c6SJ7; QUA8p: if (!$Raowb) { return Response::generate(-1, '数据错误(2)'); } goto F_LqO; Cw_bW: $wH3g6 = md5(md5($NQLi0) . md5($FSN2O . '') . md5($g5fcb) . md5($nfE6o)); goto Zmnhh; m4B25: return Response::generate(0, null, array('redirect' => $yTnoO)); goto aBTVS; JxkRS: $NQLi0 = modstart_config('ssoServerSecret'); goto QtA9b; KqjoE: $KAIwS = MemberUtil::get($nlOSA); goto JxkRS; NAB11: $nlOSA = Session::get('memberUserId', 0); goto FAfsd; F_LqO: $g5fcb = $o1RSB . '/sso/server'; goto zveyD; h2Hr3: $o1RSB = $tBuXm->getTrimString('domainUrl'); goto JKa8t; QtA9b: if (empty($NQLi0)) { return Response::generate(-1, '请设置 同步登录服务端通讯秘钥'); } goto dsJvd; c6SJ7: $Raowb = false; goto j_rNs; aBTVS: } public function ssoServer() { goto pIN6h; wg8TO: $tBuXm = InputPackage::buildFromInput(); goto AiAlF; eohiK: return Response::generate(0, 'ok', array('isLogin' => $gqbAL)); goto FVeAj; SQnQs: $Raowb = false; goto fKeAF; tDwdL: if (empty($CkJ6J)) { return Response::generate(-1, 'client 为空'); } goto CAtkt; YbBbZ: if (abs(time() - $FSN2O) > 3600) { return Response::generate(-1, 'timestamp 错误'); } goto g29Oq; uxyo4: if (empty($wH3g6)) { return Response::generate(-1, 'sign 为空'); } goto Vmoen; QqGQW: $sb7hO = md5(md5($qGhQl) . md5($FSN2O . '') . md5($CkJ6J)); goto nzhYd; r2Nnk: $FSN2O = $tBuXm->getInteger('timestamp'); goto BIfAG; BIfAG: $wH3g6 = $tBuXm->getTrimString('sign'); goto tDwdL; g29Oq: $pDI1K = explode('
', modstart_config('ssoServerClientList', '')); goto SQnQs; IEKUp: $gqbAL = false; goto GDYSl; AiAlF: $CkJ6J = $tBuXm->getTrimString('client'); goto r2Nnk; jHF2u: if (empty($qGhQl)) { return Response::generate(-1, '请设置 同步登录服务端通讯秘钥'); } goto QqGQW; GDYSl: if (intval(Session::get('memberUserId', 0)) > 0) { $gqbAL = true; } goto eohiK; pIN6h: if (!modstart_config('ssoServerEnable', false)) { return Response::generate(-1, '请开启 同步登录服务端'); } goto wg8TO; fKeAF: foreach ($pDI1K as $FSL7c) { if (trim($FSL7c) == $CkJ6J) { $Raowb = true; } } goto AeChn; nzhYd: if ($wH3g6 != $sb7hO) { return Response::generate(-1, 'sign 错误'); } goto YbBbZ; AeChn: if (!$Raowb) { return Response::generate(-1, '请在 同步登陆服务端增加客户端地址 ' . $CkJ6J); } goto IEKUp; Vmoen: $qGhQl = modstart_config('ssoServerSecret'); goto jHF2u; CAtkt: if (empty($FSN2O)) { return Response::generate(-1, 'timestamp 为空'); } goto uxyo4; FVeAj: } public function ssoClient() { goto gKhLT; lMg_o: if ($wH3g6 != $sb7hO) { return Response::generate(-1, 'sign错误'); } goto pw1kn; AZHh9: $MXYYs = modstart_config('ssoClientSecret'); goto O_X0J; uMVmp: $wH3g6 = $tBuXm->getTrimString('sign'); goto KZ5PP; v8ZHI: if (empty($KAIwS)) { goto Zy4GT; WlGMQ: if ($ZrjxR['code']) { return Response::generate(-1, $ZrjxR['msg']); } goto RR7JP; Zy4GT: $ZrjxR = MemberUtil::register($nfE6o, null, null, null, true); goto WlGMQ; RR7JP: $KAIwS = MemberUtil::get($ZrjxR['data']['id']); goto yWAgw; yWAgw: } goto jxKF3; MNshD: MemberUtil::fireLogin($KAIwS['id']); goto fG2k8; SVnn5: if (empty($FSN2O)) { return Response::generate(-1, 'timestamp为空'); } goto wrDVq; pw1kn: if (abs(time() - $FSN2O) > 3600) { return Response::generate(-1, 'timestamp错误'); } goto WBidq; bGvcn: $zqQco = modstart_config('ssoClientServer', ''); goto RjBm5; QVTPc: if (empty($nfE6o)) { return Response::generate(-1, '同步登录返回的用户名为空'); } goto SVnn5; WBidq: if ($g5fcb != $zqQco) { return Response::generate(-1, '同步登录 服务端地址不是配置的' . $zqQco); } goto QA60o; pTn2g: $g5fcb = $tBuXm->getTrimString('server'); goto ozm5g; ozm5g: $FSN2O = $tBuXm->getInteger('timestamp'); goto uMVmp; fG2k8: return Response::generate(0, 'ok'); goto Pn4Jv; gKhLT: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, '请开启 同步登录客户端'); } goto bGvcn; KZ5PP: $nfE6o = @base64_decode($tBuXm->getTrimString('username')); goto QVTPc; O_X0J: if (empty($MXYYs)) { return Response::generate(-1, '请设置 同步登录客户端通讯秘钥'); } goto snBkV; jxKF3: Session::put('memberUserId', $KAIwS['id']); goto MNshD; snBkV: $tBuXm = InputPackage::buildFromInput(); goto pTn2g; RjBm5: if (empty($zqQco)) { return Response::generate(-1, '请配置 同步登录服务端地址'); } goto AZHh9; QA60o: $KAIwS = MemberUtil::getByUsername($nfE6o); goto v8ZHI; wrDVq: if (empty($wH3g6)) { return Response::generate(-1, 'sign为空'); } goto ve3eI; ve3eI: $sb7hO = md5(md5($MXYYs) . md5($FSN2O . '') . md5($g5fcb) . md5($nfE6o)); goto lMg_o; Pn4Jv: } public function ssoClientPrepare() { goto iZ3ci; K_O30: $yTnoO = $zqQco . '?client=' . urlencode($CkJ6J) . '&timestamp=' . $FSN2O . '&sign=' . $wH3g6; goto FeyH4; uKSb6: $tBuXm = InputPackage::buildFromInput(); goto jxzj_; iZ3ci: if (!modstart_config('ssoClientEnable', false)) { return Response::generate(-1, 'SSO未开启'); } goto D8RwM; FyTCf: $FSN2O = time(); goto mXbvV; FeyH4: return Response::generate(0, 'ok', array('redirect' => $yTnoO)); goto AqQY1; jxzj_: $CkJ6J = $tBuXm->getTrimString('client', '/'); goto DK4UW; mWxdJ: $MXYYs = modstart_config('ssoClientSecret'); goto uKSb6; D8RwM: $zqQco = modstart_config('ssoClientServer'); goto mWxdJ; mXbvV: $wH3g6 = md5(md5($MXYYs) . md5($FSN2O . '') . md5($CkJ6J)); goto K_O30; DK4UW: if (!Str::endsWith($CkJ6J, '/sso/client')) { return Response::generate(-1, 'client参数错误'); } goto FyTCf; AqQY1: } public function logout() { goto kr1GY; kr1GY: $nlOSA = MemberUser::id(); goto EFMK9; EFMK9: Session::forget('memberUserId'); goto HGCJb; HGCJb: if ($nlOSA > 0) { EventUtil::fire(new MemberUserLogoutEvent($nlOSA)); } goto u4Dm1; u4Dm1: return Response::generateSuccess(); goto kiZol; kiZol: } public function login() { goto P0ry7; UxBCu: if (empty($wxnHg)) { return Response::generate(-1, '请输入密码'); } goto Nken4; AAaIN: $nfE6o = $tBuXm->getTrimString('username'); goto XJeic; QpRad: $KAIwS = null; goto zAbTA; yNldj: if (!$KAIwS) { $ZrjxR = MemberUtil::login(null, $nfE6o, null, $wxnHg); if (0 == $ZrjxR['code']) { $KAIwS = $ZrjxR['data']; } } goto ULQ6v; eGQsZ: return Response::generateSuccess(); goto eOX8q; oxbJv: if (empty($nfE6o)) { return Response::generate(-1, '请输入用户'); } goto UxBCu; XJeic: $wxnHg = $tBuXm->getTrimString('password'); goto oxbJv; IggZH: MemberUtil::fireLogin($KAIwS['id']); goto YDGcZ; T6thp: if (!$KAIwS) { $mrKpF = Session::pull('memberUserLoginFailedTip', null); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '登录失败:用户或密码错误' . ($mrKpF ? '，' . $mrKpF : '')); } goto CpeRO; YDGcZ: EventUtil::fire(new MemberUserLoginedEvent($KAIwS['id'])); goto eGQsZ; P0ry7: $tBuXm = InputPackage::buildFromInput(); goto AAaIN; J36Fs: if (!$KAIwS) { $ZrjxR = MemberUtil::login($nfE6o, null, null, $wxnHg); if (0 == $ZrjxR['code']) { $KAIwS = $ZrjxR['data']; } } goto yNldj; CpeRO: Session::put('memberUserId', $KAIwS['id']); goto IggZH; ULQ6v: if (!$KAIwS) { $ZrjxR = MemberUtil::login(null, null, $nfE6o, $wxnHg); if (0 == $ZrjxR['code']) { $KAIwS = $ZrjxR['data']; } } goto T6thp; Nken4: if (modstart_config('loginCaptchaEnable', false)) { $jYH0b = SecurityUtil::loginCaptchaProvider(); if ($jYH0b) { $ZrjxR = $jYH0b->validate(); if (Response::isError($ZrjxR)) { return Response::generate(-1, $ZrjxR['msg']); } } else { if (!CaptchaFacade::check($tBuXm->getTrimString('captcha'))) { return Response::generate(ResponseCodes::CAPTCHA_ERROR, '登录失败:图片验证码错误', null, '[js]$(\'[data-captcha]\').click();'); } } } goto QpRad; zAbTA: $cUOBo = null; goto J36Fs; eOX8q: } public function loginCaptchaRaw() { return CaptchaFacade::create('default'); } public function loginPhoneCaptchaRaw() { return CaptchaFacade::create('default'); } public function loginPhone() { goto irh0F; oAYQf: MemberUtil::fireLogin($KAIwS['id']); goto bDaSw; xcnTo: Session::forget('loginPhoneVerify'); goto nk71r; DrbPH: $KAIwS = MemberUtil::getByPhone($ffJmI); goto qPHJ7; R6ye1: $m57kA = $tBuXm->getTrimString('verify'); goto uu9ZO; uu9ZO: if (empty($ffJmI)) { return Response::generate(-1, '手机为空或不正确'); } goto f9GvV; n24mK: if ($m57kA != $qX9y8) { Log::info('Member.LoginPhone.LoginVerifyError - ' . $m57kA . ' - ' . $qX9y8); return Response::generate(-1, '手机验证码不正确'); } goto cVDtH; zklYd: $qX9y8 = Session::get('loginPhoneVerify'); goto n24mK; G6y8Z: $ffJmI = $tBuXm->getPhone('phone'); goto R6ye1; qPHJ7: if (empty($KAIwS) && modstart_config('Member_LoginPhoneAutoRegister', false)) { goto oejNw; Ci5Sw: $KAIwS = MemberUtil::get($nlOSA); goto L5wRZ; ehd6N: $jNwg7 = array(); goto Y6ctF; oejNw: foreach (MemberRegisterProcessorProvider::listAll() as $kHDkQ) { $ZrjxR = $kHDkQ->preCheck(); if (Response::isError($ZrjxR)) { return $ZrjxR; } } goto GPcYB; Y6ctF: $jNwg7['phoneVerified'] = true; goto qFTdY; XIUGr: MemberUtil::autoSetUsernameNickname($nlOSA, modstart_config('Member_LoginPhoneNameSuggest', '用户')); goto ehd6N; Eh13l: Session::forget('registerCaptchaPass'); goto vniZE; roc8U: if ($ZrjxR['code']) { return Response::generate(-1, $ZrjxR['msg']); } goto AvTgy; L9e4I: EventUtil::fire(new MemberUserRegisteredEvent($nlOSA)); goto Eh13l; G83yM: if (!empty($jNwg7)) { MemberUtil::update($nlOSA, $jNwg7); } goto L9e4I; vniZE: foreach (MemberRegisterProcessorProvider::listAll() as $kHDkQ) { $kHDkQ->postProcess($nlOSA); } goto Ci5Sw; AvTgy: $nlOSA = $ZrjxR['data']['id']; goto XIUGr; qFTdY: $jNwg7['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto G83yM; GPcYB: $ZrjxR = MemberUtil::register(null, $ffJmI, null, null, true); goto roc8U; L5wRZ: } goto ewFC0; sLtvl: if ($ffJmI != Session::get('loginPhone')) { return Response::generate(-1, '两次手机不一致'); } goto DrbPH; nk71r: Session::forget('loginPhoneVerifyTime'); goto G2cPf; Cf0Al: Session::put('memberUserId', $KAIwS['id']); goto oAYQf; f8KQ7: $tBuXm = InputPackage::buildFromInput(); goto G6y8Z; cVDtH: if (Session::get('loginPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '手机验证码已过期'); } goto sLtvl; f9GvV: if (empty($m57kA)) { return Response::generate(-1, '验证码不能为空'); } goto zklYd; irh0F: if (!modstart_config('Member_LoginPhoneEnable', false)) { return Response::generate(-1, '手机快捷登录未开启'); } goto f8KQ7; bDaSw: EventUtil::fire(new MemberUserLoginedEvent($KAIwS)); goto PzEqw; PzEqw: return Response::generate(0, null); goto EYpVm; G2cPf: Session::forget('loginPhone'); goto Cf0Al; ewFC0: if (empty($KAIwS)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto xcnTo; EYpVm: } public function loginPhoneVerify() { goto TJVaq; Mxf8w: $m57kA = rand(100000, 999999); goto vi7So; Jric7: $tBuXm = InputPackage::buildFromInput(); goto cmJB5; TJVaq: if (!modstart_config('Member_LoginPhoneEnable', false)) { return Response::generate(-1, '手机快捷登录未开启'); } goto Jric7; mfdUa: if ($kHDkQ) { $ZrjxR = $kHDkQ->validate(); if (Response::isError($ZrjxR)) { return $ZrjxR; } } else { $IU3nb = $tBuXm->getTrimString('captcha'); if (!CaptchaFacade::check($IU3nb)) { return Response::generate(-1, '图片验证码错误'); } } goto qeBdo; cmJB5: $ffJmI = $tBuXm->getPhone('target'); goto nuNsK; vi7So: Session::put('loginPhoneVerify', $m57kA); goto YzrQF; U3gnr: if (empty($KAIwS) && !modstart_config('Member_LoginPhoneAutoRegister', false)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto u9sdD; YzrQF: Session::put('loginPhoneVerifyTime', time()); goto w91RR; T5pNr: SmsSendJob::create($ffJmI, 'verify', array('code' => $m57kA)); goto LwhDD; nuNsK: if (empty($ffJmI)) { return Response::generate(-1, '手机为空或格式不正确'); } goto iMC6C; iMC6C: $kHDkQ = SecurityUtil::loginCaptchaProvider(); goto mfdUa; w91RR: Session::put('loginPhone', $ffJmI); goto T5pNr; qeBdo: $KAIwS = MemberUtil::getByPhone($ffJmI); goto U3gnr; LwhDD: return Response::generate(0, '验证码发送成功'); goto dt4yP; u9sdD: if (Session::get('loginPhoneVerifyTime') && $ffJmI == Session::get('loginPhone')) { if (Session::get('loginPhoneVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto Mxf8w; dt4yP: } public function loginPhoneCaptcha() { $IU3nb = $this->loginCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($IU3nb->getOriginalContent()))); } public function loginCaptcha() { $IU3nb = $this->loginCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($IU3nb->getOriginalContent()))); } public function registerPhone() { goto fEbLx; XUfdk: Session::forget('registerCaptchaPass'); goto AruFL; w_1ZC: $jNwg7['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto TN1S2; IZcrk: foreach (MemberRegisterProcessorProvider::listAll() as $kHDkQ) { $ZrjxR = $kHDkQ->preCheck(); if (Response::isError($ZrjxR)) { return $ZrjxR; } } goto Zm_Eu; QOtN5: $LOsdl = Session::get('registerPhoneVerify'); goto Y115J; OU1KR: if (Session::get('registerPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto UnJM3; UEJNR: $ffJmI = $tBuXm->getPhone('phone'); goto VSDpK; c2g6c: return Response::generate(0, '注册成功', array('id' => $nlOSA)); goto qEYYG; z18Sz: EventUtil::fire(new MemberUserRegisteredEvent($nlOSA)); goto XUfdk; vpwCY: if ($ZrjxR['code']) { return Response::generate(-1, $ZrjxR['msg']); } goto DyX1t; QGM4W: MemberUtil::fireLogin($nlOSA); goto PRRD5; fEbLx: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto hWObU; g3T55: $jNwg7['phoneVerified'] = true; goto w_1ZC; TN1S2: if (!empty($jNwg7)) { MemberUtil::update($nlOSA, $jNwg7); } goto z18Sz; bQxwR: if (modstart_config('Member_AgreementEnable', false)) { if (!$tBuXm->getBoolean('agreement')) { return Response::generateError('请先同意 ' . modstart_config('Member_AgreementTitle', '用户使用协议')); } } goto UEJNR; PRRD5: EventUtil::fire(new MemberUserLoginedEvent($nlOSA)); goto c2g6c; hWObU: if (!modstart_config('Member_RegisterPhoneEnable', false)) { return Response::generate(-1, '手机快速注册未开启'); } goto wfbbm; lMJYt: Session::put('memberUserId', $nlOSA); goto QGM4W; AruFL: foreach (MemberRegisterProcessorProvider::listAll() as $kHDkQ) { $kHDkQ->postProcess($nlOSA); } goto lMJYt; wfbbm: $tBuXm = InputPackage::buildFromInput(); goto bQxwR; Zm_Eu: $ZrjxR = MemberUtil::register(null, $ffJmI, null, null, true); goto vpwCY; Y115J: if ($VgJ2i != $LOsdl) { Log::info('Member.RegisterPhone.PhoneVerifyError - ' . $VgJ2i . ' - ' . $LOsdl); return Response::generate(-1, '手机验证码不正确.'); } goto OU1KR; t2AJS: MemberUtil::autoSetUsernameNickname($nlOSA, modstart_config('Member_LoginPhoneNameSuggest', '用户')); goto C5nR3; VSDpK: $VgJ2i = $tBuXm->getTrimString('phoneVerify'); goto NEGKM; C5nR3: $jNwg7 = array(); goto g3T55; DyX1t: $nlOSA = $ZrjxR['data']['id']; goto t2AJS; NEGKM: if (empty($ffJmI)) { return Response::generate(-1, '请输入手机'); } goto QOtN5; UnJM3: if ($ffJmI != Session::get('registerPhone')) { return Response::generate(-1, '两次手机不一致'); } goto IZcrk; qEYYG: } public function register() { goto P8PMv; Q5hfO: return Response::generate(0, '注册成功', array('id' => $nlOSA)); goto INOmF; pQnJT: if (modstart_config('registerEmailEnable')) { $jNwg7['emailVerified'] = true; } goto Sorx1; vAWdd: EventUtil::fire(new MemberUserRegisteredEvent($nlOSA)); goto TaVd5; Fjynw: $g0IgS = $tBuXm->getTrimString('passwordRepeat'); goto UMILN; w7xzW: if (preg_match('/^\\d{11}$/', $nfE6o)) { return Response::generate(-1, '用户名不能为纯数字'); } goto RGqoW; banft: $nfE6o = $tBuXm->getTrimString('username'); goto GWu6L; McO7M: if (empty($nfE6o)) { return Response::generate(-1, '用户名不能为空'); } goto Cr_Wo; UwAaG: if (!empty($jNwg7)) { MemberUtil::update($nlOSA, $jNwg7); } goto vAWdd; JYOvU: if (modstart_config('Member_AgreementEnable', false)) { if (!$tBuXm->getBoolean('agreement')) { return Response::generateError('请先同意 ' . modstart_config('Member_AgreementTitle', '用户使用协议')); } } goto banft; elcyA: $nlOSA = $ZrjxR['data']['id']; goto wLRTy; OMorW: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto k6LRB; plben: foreach (MemberRegisterProcessorProvider::listAll() as $kHDkQ) { $kHDkQ->postProcess($nlOSA); } goto Q5hfO; Cr_Wo: if (Str::contains($nfE6o, '@')) { return Response::generate(-1, '用户名不能包含特殊字符'); } goto w7xzW; P8PMv: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto j2Yso; xSHSO: if (modstart_config('registerPhoneEnable')) { $jNwg7['phoneVerified'] = true; } goto pQnJT; X9g4I: $VgJ2i = $tBuXm->getTrimString('phoneVerify'); goto qnO78; k6LRB: if (modstart_config('registerPhoneEnable')) { goto nVGvR; FHtpq: if ($VgJ2i != $LOsdl) { Log::info('Member.Register.PhoneVerifyError - ' . $VgJ2i . ' - ' . $LOsdl); return Response::generate(-1, '手机验证码不正确.'); } goto NV4Y_; nVGvR: if (empty($ffJmI)) { return Response::generate(-1, '请输入手机'); } goto ulSeW; ulSeW: $LOsdl = Session::get('registerPhoneVerify'); goto FHtpq; NV4Y_: if (Session::get('registerPhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '手机验证码已过期'); } goto LflKV; LflKV: if ($ffJmI != Session::get('registerPhone')) { return Response::generate(-1, '两次手机不一致'); } goto UX0R7; UX0R7: } goto S2iNF; qnO78: $ynBrC = $tBuXm->getEmail('email'); goto GAk53; GAk53: $w300c = $tBuXm->getTrimString('emailVerify'); goto Swbo3; RGqoW: if (!Session::get('registerCaptchaPass', false)) { if (!CaptchaFacade::check($IU3nb)) { SessionUtil::atomicProduce('registerCaptchaPassCount', 1); return Response::generate(-1, '请重新进行安全验证'); } } goto OMorW; oz8sd: if ($ZrjxR['code']) { return Response::generate(-1, $ZrjxR['msg']); } goto elcyA; j2Yso: $tBuXm = InputPackage::buildFromInput(); goto JYOvU; U_fea: if ($wxnHg != $g0IgS) { return Response::generate(-1, '两次输入密码不一致'); } goto ZXpZG; Swbo3: $wxnHg = $tBuXm->getTrimString('password'); goto Fjynw; Sorx1: $jNwg7['registerIp'] = StrUtil::mbLimit(Request::ip(), 20); goto UwAaG; r5ntt: $ZrjxR = MemberUtil::register($nfE6o, $ffJmI, $ynBrC, $wxnHg); goto oz8sd; ZXpZG: foreach (MemberRegisterProcessorProvider::listAll() as $kHDkQ) { $ZrjxR = $kHDkQ->preCheck(); if (Response::isError($ZrjxR)) { return $ZrjxR; } } goto r5ntt; S2iNF: if (modstart_config('registerEmailEnable')) { goto I02dF; YCiUf: if (Session::get('registerEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(-1, '邮箱验证码已过期'); } goto AWYap; HPXxk: if ($w300c != $KQoLJ) { Log::info('Member.Register.EmailVerifyError - ' . $w300c . ' - ' . $KQoLJ); return Response::generate(-1, '邮箱验证码不正确.'); } goto YCiUf; uSGDq: $KQoLJ = Session::get('registerEmailVerify'); goto HPXxk; AWYap: if ($ynBrC != Session::get('registerEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto Fr5bC; I02dF: if (empty($ynBrC)) { return Response::generate(-1, '请输入邮箱'); } goto uSGDq; Fr5bC: } goto qoqWG; UMILN: $IU3nb = $tBuXm->getTrimString('captcha'); goto McO7M; TaVd5: Session::forget('registerCaptchaPass'); goto plben; GWu6L: $ffJmI = $tBuXm->getPhone('phone'); goto X9g4I; qoqWG: if (empty($wxnHg)) { return Response::generate(-1, '请输入密码'); } goto U_fea; wLRTy: $jNwg7 = array(); goto xSHSO; INOmF: } public function registerEmailVerify() { goto kG_3C; kG_3C: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto NrJ3Z; FZPCj: $ynBrC = $tBuXm->getEmail('target'); goto Y02rG; u2dk1: if (!Session::get('registerCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto y3GPh; Gd2GO: $tBuXm = InputPackage::buildFromInput(); goto FZPCj; uSLbA: if (Session::get('registerEmailVerifyTime') && $ynBrC == Session::get('registerEmail')) { if (Session::get('registerEmailVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto FwVSq; NrJ3Z: if (!modstart_config('registerEmailEnable')) { return Response::generate(-1, '注册未开启邮箱'); } goto Gd2GO; HD7OX: Session::put('registerEmailVerify', $m57kA); goto dD1x6; soqdK: if (!empty($KAIwS)) { return Response::generate(-1, '邮箱已经被占用'); } goto uSLbA; FwVSq: $m57kA = rand(100000, 999999); goto NBYKM; dbwNZ: return Response::generate(0, '验证码发送成功'); goto J57DC; Y02rG: if (empty($ynBrC)) { return Response::generate(-1, '邮箱不能为空'); } goto u2dk1; y3GPh: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto WFxrv; sSOFb: Session::put('registerEmail', $ynBrC); goto dbwNZ; WFxrv: $KAIwS = MemberUtil::getByEmail($ynBrC); goto soqdK; NBYKM: MailSendJob::create($ynBrC, '注册账户验证码', 'verify', array('code' => $m57kA)); goto HD7OX; dD1x6: Session::put('registerEmailVerifyTime', time()); goto sSOFb; J57DC: } public function registerPhoneVerify() { goto Ug6Jr; lfS6W: return Response::generate(0, '验证码发送成功'); goto Z4EsD; e2lwP: if (!Session::get('registerCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto DxW2c; obka4: if (!empty($KAIwS)) { return Response::generate(-1, '手机已经被占用'); } goto KAh3O; KAh3O: if (Session::get('registerPhoneVerifyTime') && $ffJmI == Session::get('registerPhone')) { if (Session::get('registerPhoneVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto ldOnR; ldOnR: $m57kA = rand(100000, 999999); goto IqTCS; IqTCS: SmsSendJob::create($ffJmI, 'verify', array('code' => $m57kA)); goto levQ0; wnfp0: $tBuXm = InputPackage::buildFromInput(); goto Eo7s2; DxW2c: if (!SessionUtil::atomicConsume('registerCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto Ay5_H; Ug6Jr: if (modstart_config('registerDisable', false)) { return Response::generate(-1, '禁止注册'); } goto VbVlu; yJliU: if (empty($ffJmI)) { return Response::generate(-1, '手机不能为空'); } goto e2lwP; fSyKF: Session::put('registerPhoneVerifyTime', time()); goto IvYJb; Eo7s2: $ffJmI = $tBuXm->getPhone('target'); goto yJliU; levQ0: Session::put('registerPhoneVerify', $m57kA); goto fSyKF; VbVlu: if (!modstart_config('registerPhoneEnable')) { return Response::generate(-1, '注册未开启手机'); } goto wnfp0; IvYJb: Session::put('registerPhone', $ffJmI); goto lfS6W; Ay5_H: $KAIwS = MemberUtil::getByPhone($ffJmI); goto obka4; Z4EsD: } public function registerCaptchaVerify() { goto Aok0M; UzgE_: if (modstart_config('registerPhoneEnable')) { $Rr3Sd++; } goto tX4DA; UIQd5: return Response::generateSuccess(); goto z5r13; Aok0M: $kHDkQ = SecurityUtil::registerCaptchaProvider(); goto vv1HC; tX4DA: SessionUtil::atomicProduce('registerCaptchaPassCount', $Rr3Sd); goto UIQd5; vv1HC: if ($kHDkQ) { $ZrjxR = $kHDkQ->validate(); if (Response::isError($ZrjxR)) { return $ZrjxR; } } else { goto JhsHh; JhsHh: $tBuXm = InputPackage::buildFromInput(); goto lWWAv; lWWAv: $IU3nb = $tBuXm->getTrimString('captcha'); goto A5rv0; A5rv0: if (!CaptchaFacade::check($IU3nb)) { SessionUtil::atomicRemove('registerCaptchaPassCount'); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto rGt8g; rGt8g: } goto CVl4c; uwX09: $Rr3Sd = 1; goto GOjQ3; GOjQ3: if (modstart_config('registerEmailEnable')) { $Rr3Sd++; } goto UzgE_; CVl4c: Session::put('registerCaptchaPass', true); goto uwX09; z5r13: } public function oauthBindCaptchaVerify() { goto GSztq; Dn4LR: if (modstart_config('Member_OauthBindPhoneEnable')) { $Clp9D++; } goto bSYi3; bSYi3: if (modstart_config('Member_OauthBindEmailEnable')) { $Clp9D++; } goto hbvpd; olzdL: $Clp9D = 1; goto Dn4LR; lzJud: if (!CaptchaFacade::check($IU3nb)) { SessionUtil::atomicRemove('oauthBindCaptchaPassCount'); return Response::generate(ResponseCodes::CAPTCHA_ERROR, '验证码错误'); } goto Zzn1h; UTdKt: return Response::generateSuccess(); goto PZ65P; Zzn1h: Session::put('oauthBindCaptchaPass', true); goto olzdL; hbvpd: SessionUtil::atomicProduce('oauthBindCaptchaPassCount', $Clp9D); goto UTdKt; ieH8O: $IU3nb = $tBuXm->getTrimString('captcha'); goto lzJud; GSztq: $tBuXm = InputPackage::buildFromInput(); goto ieH8O; PZ65P: } public function oauthBindCaptchaRaw() { return CaptchaFacade::create('default'); } public function oauthBindCaptcha() { goto jKog3; RNepf: $IU3nb = $this->oauthBindCaptchaRaw(); goto YTxUJ; jKog3: Session::forget('oauthBindCaptchaPass'); goto RNepf; YTxUJ: return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($IU3nb->getOriginalContent()))); goto Bn3o7; Bn3o7: } public function oauthBindEmailVerify() { goto Ro4b4; n7VyE: Session::put('oauthBindEmailVerifyTime', time()); goto FWcPB; J8Luw: Session::put('oauthBindEmailVerify', $m57kA); goto n7VyE; wpEJa: if (empty($ynBrC)) { return Response::generate(-1, '邮箱不能为空'); } goto uMjX_; uMjX_: if (!Session::get('oauthBindCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto UNiMY; qOUpS: return Response::generate(0, '验证码发送成功'); goto OixFL; OZZca: $ynBrC = $tBuXm->getEmail('target'); goto wpEJa; FWcPB: Session::put('oauthBindEmail', $ynBrC); goto qOUpS; ECZsJ: MailSendJob::create($ynBrC, '注册账户验证码', 'verify', array('code' => $m57kA)); goto J8Luw; AFa1u: if (Session::get('oauthBindEmailVerifyTime') && $ynBrC == Session::get('oauthBindEmail')) { if (Session::get('oauthBindEmailVerifyTime') + 60 > time()) { return Response::generate(-1, '验证码发送频繁，请稍后再试!'); } } goto jkksc; aY1EX: $tBuXm = InputPackage::buildFromInput(); goto OZZca; Ro4b4: if (!modstart_config('Member_OauthBindEmailEnable')) { return Response::generate(-1, '授权登录未开启邮箱'); } goto aY1EX; UNiMY: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto dCBEj; dCBEj: $KAIwS = MemberUtil::getByEmail($ynBrC); goto dwieG; jkksc: $m57kA = rand(100000, 999999); goto ECZsJ; dwieG: if (!empty($KAIwS)) { return Response::generate(-1, '邮箱已经被占用'); } goto AFa1u; OixFL: } public function oauthBindPhoneVerify() { goto swI3C; dvHJC: Session::put('oauthBindPhoneVerifyTime', time()); goto x2tIX; HqIyw: SmsSendJob::create($ffJmI, 'verify', array('code' => $m57kA)); goto wx9Kw; XepBp: if (empty($ffJmI)) { return Response::generate(-1, '手机不能为空'); } goto G60uW; hEH7h: $KAIwS = MemberUtil::getByPhone($ffJmI); goto fXwKO; eKQnG: if (!SessionUtil::atomicConsume('oauthBindCaptchaPassCount')) { return Response::generate(-1, '请进行安全验证'); } goto hEH7h; iNPER: $tBuXm = InputPackage::buildFromInput(); goto OAShH; x2tIX: Session::put('oauthBindPhone', $ffJmI); goto NqKpF; wx9Kw: Session::put('oauthBindPhoneVerify', $m57kA); goto dvHJC; hZ6Ie: if (Session::get('oauthBindPhoneVerifyTime') && $ffJmI == Session::get('oauthBindPhone')) { if (Session::get('oauthBindPhoneVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto Bf1_Y; swI3C: if (!modstart_config('Member_OauthBindPhoneEnable')) { return Response::generate(-1, '注册未开启手机'); } goto iNPER; Bf1_Y: $m57kA = rand(100000, 999999); goto HqIyw; NqKpF: return Response::generate(0, '验证码发送成功'); goto JrbPa; G60uW: if (!Session::get('oauthBindCaptchaPass', false)) { return Response::generate(-1, '请先进行安全验证'); } goto eKQnG; fXwKO: if (!empty($KAIwS)) { return Response::generate(-1, '手机已经被占用'); } goto hZ6Ie; OAShH: $ffJmI = $tBuXm->getPhone('target'); goto XepBp; JrbPa: } public function registerCaptchaRaw() { return CaptchaFacade::create('default'); } public function registerCaptcha() { goto UUyjU; UUyjU: Session::forget('registerCaptchaPass'); goto Zr6Qk; OH4OJ: return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($IU3nb->getOriginalContent()))); goto ONbSF; Zr6Qk: $IU3nb = $this->registerCaptchaRaw(); goto OH4OJ; ONbSF: } public function retrievePhone() { goto L0Gk8; UsVwW: $KAIwS = MemberUtil::getByPhone($ffJmI); goto Ywe2p; VFaDs: if (Session::get('retrievePhoneVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '手机验证码已过期'); } goto CZO7b; VeJJl: $qX9y8 = Session::get('retrievePhoneVerify'); goto s6lUv; Is8py: $tBuXm = InputPackage::buildFromInput(); goto mzDsj; I0wCU: Session::put('retrieveMemberUserId', $KAIwS['id']); goto bPsLE; Ns4v1: $ffJmI = $tBuXm->getPhone('phone'); goto jTqRC; mzDsj: if (!modstart_config('retrievePhoneEnable', false)) { return Response::generate(-1, '找回密码没有开启'); } goto Ns4v1; bPsLE: return Response::generate(0, null); goto QhAt2; CZO7b: if ($ffJmI != Session::get('retrievePhone')) { return Response::generate(-1, '两次手机不一致'); } goto UsVwW; jTqRC: $m57kA = $tBuXm->getTrimString('verify'); goto t4g9E; gFFpz: Session::forget('retrievePhoneVerifyTime'); goto GKg08; L0Gk8: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto Is8py; xotN3: if (empty($m57kA)) { return Response::generate(-1, '验证码不能为空'); } goto VeJJl; iTinC: Session::forget('retrievePhoneVerify'); goto gFFpz; t4g9E: if (empty($ffJmI)) { return Response::generate(-1, '手机为空或不正确'); } goto xotN3; s6lUv: if ($m57kA != $qX9y8) { Log::info('Member.RetrievePhone.PhoneVerifyError - ' . $m57kA . ' - ' . $qX9y8); return Response::generate(-1, '手机验证码不正确'); } goto VFaDs; GKg08: Session::forget('retrievePhone'); goto I0wCU; Ywe2p: if (empty($KAIwS)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto iTinC; QhAt2: } public function retrievePhoneVerify() { goto YZtPM; EkpjD: $m57kA = rand(100000, 999999); goto t3cZL; YvQR2: if (Session::get('retrievePhoneVerifyTime') && $ffJmI == Session::get('retrievePhone')) { if (Session::get('retrievePhoneVerifyTime') + 60 * 2 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto EkpjD; t3cZL: Session::put('retrievePhoneVerify', $m57kA); goto gDNe3; ViDj4: Session::put('retrievePhone', $ffJmI); goto hoUBg; YZtPM: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto It1yY; It1yY: $tBuXm = InputPackage::buildFromInput(); goto Udv9_; cvMJl: if (empty($KAIwS)) { return Response::generate(-1, '手机没有绑定任何账号'); } goto YvQR2; gDNe3: Session::put('retrievePhoneVerifyTime', time()); goto ViDj4; NSriT: $KAIwS = MemberUtil::getByPhone($ffJmI); goto cvMJl; Udv9_: $ffJmI = $tBuXm->getPhone('target'); goto Fagke; hoUBg: SmsSendJob::create($ffJmI, 'verify', array('code' => $m57kA)); goto Sn4K7; Fagke: if (empty($ffJmI)) { return Response::generate(-1, '手机为空或格式不正确'); } goto T_lDc; Sn4K7: return Response::generate(0, '验证码发送成功'); goto zdCn6; T_lDc: $IU3nb = $tBuXm->getTrimString('captcha'); goto h9Spq; h9Spq: if (!CaptchaFacade::check($IU3nb)) { return Response::generate(-1, '图片验证码错误'); } goto NSriT; zdCn6: } public function retrieveEmail() { goto aF9bT; cj08M: if (Session::get('retrieveEmailVerifyTime') + 60 * 60 < time()) { return Response::generate(0, '邮箱验证码已过期'); } goto ahz25; jUUO6: if (empty($ynBrC)) { return Response::generate(-1, '邮箱为空或格式不正确'); } goto NbqIl; isznK: Session::forget('retrieveEmailVerify'); goto VQ1VD; O1hx8: $ynBrC = $tBuXm->getEmail('email'); goto nfhA9; NbqIl: if (empty($m57kA)) { return Response::generate(-1, '验证码不能为空'); } goto zBNvb; nfhA9: $m57kA = $tBuXm->getTrimString('verify'); goto jUUO6; ifr2R: $tBuXm = InputPackage::buildFromInput(); goto O1hx8; OEzDe: Session::put('retrieveMemberUserId', $KAIwS['id']); goto Jxer3; zBNvb: $qX9y8 = Session::get('retrieveEmailVerify'); goto CH4XQ; X9Vy5: if (empty($KAIwS)) { return Response::generate(-1, '邮箱没有绑定任何账号'); } goto isznK; TyIBX: Session::forget('retrieveEmail'); goto OEzDe; aF9bT: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto Bg_Zq; Jxer3: return Response::generate(0, null); goto YMRqr; Bg_Zq: if (!modstart_config('retrieveEmailEnable', false)) { return Response::generate(-1, '找回密码没有开启'); } goto ifr2R; ahz25: if ($ynBrC != Session::get('retrieveEmail')) { return Response::generate(-1, '两次邮箱不一致'); } goto fS_8s; CH4XQ: if ($m57kA != $qX9y8) { Log::info('Member.RetrieveEmail.PhoneVerifyError - ' . $m57kA . '- ' . $qX9y8); return Response::generate(-1, '邮箱验证码不正确'); } goto cj08M; VQ1VD: Session::forget('retrieveEmailVerifyTime'); goto TyIBX; fS_8s: $KAIwS = MemberUtil::getByEmail($ynBrC); goto X9Vy5; YMRqr: } public function retrieveEmailVerify() { goto btjLS; yygA0: $IU3nb = $tBuXm->getTrimString('captcha'); goto WKkZE; yGzKA: $tBuXm = InputPackage::buildFromInput(); goto THF9M; WKkZE: if (!CaptchaFacade::check($IU3nb)) { return Response::generate(-1, '图片验证码错误'); } goto V8OYc; dgr_p: $m57kA = rand(100000, 999999); goto yr1qd; OLbth: Session::put('retrieveEmailVerifyTime', time()); goto TWlWa; V8OYc: $KAIwS = MemberUtil::getByEmail($ynBrC); goto y2JYE; hOwhQ: if (empty($ynBrC)) { return Response::generate(-1, '邮箱格式不正确或为空'); } goto yygA0; qIWe8: if (Session::get('retrieveEmailVerifyTime') && $ynBrC == Session::get('retrieveEmail')) { if (Session::get('retrieveEmailVerifyTime') + 60 > time()) { return Response::generate(0, '验证码发送成功!'); } } goto dgr_p; yr1qd: MailSendJob::create($ynBrC, '找回密码验证码', 'verify', array('code' => $m57kA)); goto Rpau3; btjLS: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto yGzKA; Rpau3: Session::put('retrieveEmailVerify', $m57kA); goto OLbth; THF9M: $ynBrC = $tBuXm->getEmail('target'); goto hOwhQ; vciUe: return Response::generate(0, '验证码发送成功'); goto oPO_y; TWlWa: Session::put('retrieveEmail', $ynBrC); goto vciUe; y2JYE: if (empty($KAIwS)) { return Response::generate(-1, '邮箱没有绑定任何账号'); } goto qIWe8; oPO_y: } public function retrieveResetInfo() { goto V6gnP; yx0OY: return Response::generate(0, null, array('memberUser' => array('username' => $nfE6o))); goto NyedU; BPDYT: if (empty($nfE6o)) { $nfE6o = $KAIwS['phone']; } goto K2Dxl; yG2eP: $KAIwS = MemberUtil::get($QwbKN); goto bor32; Hf2en: if (empty($QwbKN)) { return Response::generate(-1, '请求错误'); } goto yG2eP; K2Dxl: if (empty($nfE6o)) { $nfE6o = $KAIwS['email']; } goto yx0OY; V6gnP: $QwbKN = Session::get('retrieveMemberUserId'); goto Hf2en; bor32: $nfE6o = $KAIwS['username']; goto BPDYT; NyedU: } public function retrieveReset() { goto acOlX; TTs4u: if (empty($QwbKN)) { return Response::generate(-1, '请求错误'); } goto nyWeo; y_lKd: if ($wxnHg != $g0IgS) { return Response::generate(-1, '两次输入密码不一致'); } goto hf02x; hf02x: $KAIwS = MemberUtil::get($QwbKN); goto Ospjp; hd_v6: if (empty($wxnHg)) { return Response::generate(-1, '请输入密码'); } goto y_lKd; VWSUp: $g0IgS = $tBuXm->getTrimString('passwordRepeat'); goto hd_v6; nyWeo: $wxnHg = $tBuXm->getTrimString('password'); goto VWSUp; HaIPx: Session::forget('retrieveMemberUserId'); goto Sp00D; IRV9m: EventUtil::fire(new MemberUserPasswordResetedEvent($KAIwS['id'], $wxnHg)); goto HaIPx; U91Rn: $ZrjxR = MemberUtil::changePassword($KAIwS['id'], $wxnHg, null, true); goto p6XD9; LGwP2: $QwbKN = Session::get('retrieveMemberUserId'); goto TTs4u; Ospjp: if (empty($KAIwS)) { return Response::generate(-1, '用户不存在'); } goto U91Rn; Sp00D: return Response::generate(0, '成功设置新密码,请您登录'); goto b4Oh4; r3y27: $tBuXm = InputPackage::buildFromInput(); goto LGwP2; p6XD9: if ($ZrjxR['code']) { return Response::generate(-1, $ZrjxR['msg']); } goto IRV9m; acOlX: if (modstart_config('retrieveDisable', false)) { return Response::generate(-1, '找回密码已禁用'); } goto r3y27; b4Oh4: } public function retrieveCaptchaRaw() { return CaptchaFacade::create('default'); } public function retrieveCaptcha() { $IU3nb = $this->retrieveCaptchaRaw(); return Response::generate(0, 'ok', array('image' => 'data:image/png;base64,' . base64_encode($IU3nb->getOriginalContent()))); } }