<?php
/**
 * ------------------------ 
 *  版权所有  www.tecmz.com
 *  商业版本请购买正版授权使用
 * ------------------------
*/ namespace Module\Member\Admin\Controller; use Illuminate\Routing\Controller; use ModStart\Admin\Auth\AdminPermission; use ModStart\Admin\Concern\HasAdminQuickCRUD; use ModStart\Admin\Layout\AdminConfigBuilder; use ModStart\Admin\Layout\AdminCRUDBuilder; use ModStart\Admin\Layout\AdminDialogPage; use ModStart\Core\Assets\AssetsUtil; use ModStart\Core\Dao\ModelUtil; use ModStart\Core\Exception\BizException; use ModStart\Core\Input\InputPackage; use ModStart\Core\Input\Request; use ModStart\Core\Input\Response; use ModStart\Core\Type\TypeUtil; use ModStart\Core\Util\ArrayUtil; use ModStart\Core\Util\ColorUtil; use ModStart\Core\Util\CRUDUtil; use ModStart\Core\Util\EventUtil; use ModStart\Core\Util\RandomUtil; use ModStart\Core\Util\TimeUtil; use ModStart\Field\AbstractField; use ModStart\Field\AutoRenderedFieldValue; use ModStart\Field\Select; use ModStart\Field\Type\FieldRenderMode; use ModStart\Form\Form; use ModStart\Grid\Displayer\ItemOperate; use ModStart\Grid\GridFilter; use ModStart\Module\ModuleManager; use ModStart\Repository\Filter\RepositoryFilter; use ModStart\Support\Concern\HasFields; use ModStart\Widget\TextDialogRequest; use Module\Member\Config\MemberAdminList; use Module\Member\Config\MemberOauth; use Module\Member\Events\MemberUserRegisteredEvent; use Module\Member\Provider\MemberAdminShowPanel\MemberAdminShowPanelProvider; use Module\Member\Type\Gender; use Module\Member\Type\MemberStatus; use Module\Member\Util\MemberGroupUtil; use Module\Member\Util\MemberMessageUtil; use Module\Member\Util\MemberUtil; use Module\Member\Util\MemberVipUtil; use Module\Vendor\QuickRun\Export\ExportHandle; class MemberController extends Controller { use HasAdminQuickCRUD; protected function crud(AdminCRUDBuilder $enw1u) { $enw1u->init('member_user')->field(function ($enw1u) { $enw1u->id('id', 'ID'); MemberAdminList::callGridField($enw1u); $enw1u->display('avatar', '头像')->hookRendering(function (AbstractField $Wvq57, $FSL7c, $xZl3o) { $fh5Vx = AssetsUtil::fixOrDefault($FSL7c->avatar, 'asset/image/avatar.svg'); $yKycj = AssetsUtil::fixOrDefault($FSL7c->avatarBig, 'asset/image/avatar.svg'); return AutoRenderedFieldValue::make("<a href='{$yKycj}' class='tw-inline-block' data-image-preview>\n                        <img src='{$fh5Vx}' class='tw-rounded-full tw-w-8 tw-h-8 tw-shadow'></a>"); }); $enw1u->text('username', '用户名')->required()->ruleUnique('member_user')->hookRendering(function (AbstractField $Wvq57, $FSL7c, $xZl3o) { switch ($Wvq57->renderMode()) { case FieldRenderMode::GRID: case FieldRenderMode::DETAIL: return AutoRenderedFieldValue::make(TextDialogRequest::make('primary', htmlspecialchars($FSL7c->username), modstart_admin_url('member/show', array('_id' => $FSL7c->id)))->width('90%')->height('90%')->render()); break; } }); $enw1u->text('email', '邮箱'); $enw1u->text('phone', '手机'); $enw1u->text('nickname', '昵称'); if (MemberOauth::hasEnableItems()) { $enw1u->display('_oauth', '授权')->hookRendering(function (AbstractField $Wvq57, $FSL7c, $xZl3o) { $CAXvi = array(); $D5x7h = MemberUtil::listOauths($FSL7c->id); foreach ($D5x7h as $dTDOC) { goto Q7bII; Ss0V2: $SLZ1j = $dTDOC['type']; goto LTqL3; XTF0Q: if ($i_ZUL) { $EOvXu = $i_ZUL->color(); $SLZ1j = $i_ZUL->title(); } goto sOAiY; sOAiY: if (empty($EOvXu)) { $EOvXu = ColorUtil::pick($dTDOC['type']); } goto PGnFb; Q7bII: $EOvXu = null; goto Ss0V2; LTqL3: $i_ZUL = MemberOauth::getByOauthKey($dTDOC['type']); goto XTF0Q; PGnFb: $CAXvi[] = '<a style="color:' . $EOvXu . ';" href="javascript:;" data-tip-popover="' . $SLZ1j . '"><i class="iconfont icon-dot"></i></a>'; goto lWbPX; lWbPX: } return join('', $CAXvi); }); } $enw1u->type('status', '状态')->type(MemberStatus::class, array(MemberStatus::NORMAL => 'success', MemberStatus::FORBIDDEN => 'danger'))->required(); $tbjtW = ModuleManager::getModuleConfig('Member', 'groupEnable', false); if ($tbjtW) { $enw1u->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } $nfafT = ModuleManager::getModuleConfig('Member', 'vipEnable', false); if ($nfafT) { $enw1u->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $enw1u->date('vipExpire', 'VIP过期'); } $enw1u->display('registerIp', '注册IP'); $enw1u->display('created_at', '注册时间'); $enw1u->canBatchSelect(true); $enw1u->batchOperatePrepend('<button class="btn" data-batch-confirm="确认禁用 %d 个用户？" data-batch-operate="' . modstart_admin_url('member/status_forbidden') . '"><i class="iconfont icon-warning"></i> 禁用</button>'); })->repositoryFilter(function (RepositoryFilter $zBPGV) { $zBPGV->where(array('isDeleted' => false)); })->gridFilter(function (GridFilter $zBPGV) { $zBPGV->eq('id', L('ID')); $zBPGV->like('username', '用户名'); $zBPGV->like('email', '邮箱')->autoHide(true); $zBPGV->like('phone', '手机')->autoHide(true); $zBPGV->eq('status', '状态')->autoHide(true)->select(MemberStatus::class); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $zBPGV->eq('groupId', '分组')->autoHide(true)->select(MemberGroupUtil::mapIdTitle()); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $zBPGV->eq('vipId', 'VIP')->autoHide(true)->select(MemberVipUtil::mapTitle()); } })->operateFixed('right')->hookItemOperateRendering(function (ItemOperate $TZSL3) { $FSL7c = $TZSL3->item(); $TZSL3->prepend(TextDialogRequest::make('primary', '查看', modstart_admin_url('member/show', array('_id' => $FSL7c->id)))->width('90%')->height('90%')->render()); })->title('用户管理')->canShow(false)->canDelete(true)->canEdit(false)->canExport(ModuleManager::getModuleConfig('Member', 'exportEnable', false)); } public function selectRemote() { return Select::optionRemoteHandleModel('member_user', 'id', 'username'); } public function add(AdminDialogPage $WLCMC) { goto s2Dgl; iiw5X: $hUMbi->showSubmit(false)->showReset(false); goto b2zO6; s2Dgl: $hUMbi = Form::make(''); goto sDUEH; c243c: $hUMbi->layoutPanel('高级', function (Form $hUMbi) { $hUMbi->text('nickname', '昵称'); $hUMbi->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $hUMbi->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $hUMbi->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $hUMbi->date('vipExpire', 'VIP过期'); } }); goto iiw5X; b2zO6: return $WLCMC->pageTitle('创建用户')->body($hUMbi)->handleForm($hUMbi, function (Form $hUMbi) { AdminPermission::demoCheck(); $cwaKT = $hUMbi->dataForming(); $nfE6o = !empty($cwaKT['username']) ? $cwaKT['username'] : null; $ffJmI = !empty($cwaKT['phone']) ? $cwaKT['phone'] : null; $ynBrC = !empty($cwaKT['email']) ? $cwaKT['email'] : null; $Tic2y = ArrayUtil::keepKeys($cwaKT, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $ZrjxR = MemberUtil::register($nfE6o, $ffJmI, $ynBrC, $cwaKT['password']); BizException::throwsIfResponseError($ZrjxR); if (!empty($Tic2y)) { if (isset($Tic2y['vipExpire']) && TimeUtil::isDateEmpty($Tic2y['vipExpire'])) { $Tic2y['vipExpire'] = null; } MemberUtil::update($ZrjxR['data']['id'], $Tic2y); } EventUtil::fire(new MemberUserRegisteredEvent($ZrjxR['data']['id'])); return Response::redirect(CRUDUtil::jsDialogCloseAndParentGridRefresh()); }); goto qtilN; sDUEH: $hUMbi->layoutPanel('基础（用户、手机、邮箱不能同时为空）', function (Form $hUMbi) { $hUMbi->text('username', '用户名'); $hUMbi->text('phone', '手机'); $hUMbi->text('email', '邮箱'); $hUMbi->text('password', '初始密码')->defaultValue(RandomUtil::lowerString(8)); }); goto c243c; qtilN: } public function edit(AdminDialogPage $WLCMC) { goto f7EMt; Yib24: $hUMbi->layoutPanel('高级', function (Form $hUMbi) { $hUMbi->text('nickname', '昵称'); $hUMbi->radio('status', '状态')->optionType(MemberStatus::class)->defaultValue(MemberStatus::NORMAL); if (ModuleManager::getModuleConfig('Member', 'groupEnable', false)) { $hUMbi->radio('groupId', '分组')->options(MemberGroupUtil::mapIdTitle())->required(); } if (ModuleManager::getModuleConfig('Member', 'vipEnable', false)) { $hUMbi->radio('vipId', 'VIP')->options(MemberVipUtil::mapTitle())->required(); $hUMbi->date('vipExpire', 'VIP过期')->help('VIP过期留空表示永久'); } }); goto i7Bo3; pbmjr: if (Request::isPost()) { goto L7JJS; WURei: $tBuXm = InputPackage::buildFromInput(); goto Ch7zY; L7JJS: AdminPermission::demoCheck(); goto WURei; Ch7zY: switch ($tBuXm->getTrimString('_action')) { case 'itemCellEdit': goto JpOaW; JpOaW: $jNwg7 = array(); goto Ul9JT; MgfX4: return Response::generateSuccess(); goto Cs7dT; Ul9JT: switch ($tBuXm->getTrimString('column')) { case 'status': $jNwg7['status'] = $tBuXm->getInteger('value'); break; } goto UMlRs; UMlRs: if (!empty($jNwg7)) { MemberUtil::update($KAIwS['id'], $jNwg7); } goto MgfX4; Cs7dT: } goto GTERm; GTERm: } goto yq_0M; AQy9x: return $WLCMC->pageTitle('修改信息')->body($hUMbi)->handleForm($hUMbi, function (Form $hUMbi) use($KAIwS) { AdminPermission::demoCheck(); $cwaKT = $hUMbi->dataForming(); $WYJs0 = ArrayUtil::keepKeys($cwaKT, array('username', 'phone', 'email')); $Tic2y = ArrayUtil::keepKeys($cwaKT, array('nickname', 'groupId', 'status', 'vipId', 'vipExpire')); $ZrjxR = MemberUtil::updateBasicWithUniqueCheck($KAIwS['id'], $WYJs0); BizException::throwsIfResponseError($ZrjxR); if (isset($Tic2y['vipExpire']) && TimeUtil::isDateEmpty($Tic2y['vipExpire'])) { $Tic2y['vipExpire'] = null; } MemberUtil::update($KAIwS['id'], $Tic2y); return Response::redirect(CRUDUtil::jsDialogCloseAndParentRefresh()); }); goto iMa7z; Hrgfg: BizException::throwsIfEmpty('用户不存在', $KAIwS); goto pbmjr; QgJeZ: $hUMbi->layoutPanel('基础', function (Form $hUMbi) { $hUMbi->display('id', '用户ID')->addable(true); $hUMbi->text('username', '用户名'); $hUMbi->text('phone', '手机'); $hUMbi->text('email', '邮箱'); }); goto Yib24; f7EMt: $KAIwS = ModelUtil::get('member_user', CRUDUtil::id()); goto Hrgfg; ug2M5: $hUMbi->showSubmit(false)->showReset(false); goto AQy9x; yq_0M: $hUMbi = Form::make(''); goto QgJeZ; i7Bo3: $hUMbi->item($KAIwS)->fillFields(); goto ug2M5; iMa7z: } public function select(AdminDialogPage $WLCMC) { goto oqL1L; UWBXV: if (Request::isPost()) { return $ExhHT->request(); } goto JwJ9Q; oqL1L: $ExhHT = $this->grid(); goto rhb3D; rhb3D: $ExhHT->disableCUD(); goto R2R6I; R2R6I: $ExhHT->canSingleSelectItem(true); goto qkXBB; qkXBB: CRUDUtil::registerGridResource($ExhHT, '\\' . __CLASS__); goto UWBXV; JwJ9Q: return $WLCMC->pageTitle('选择用户')->body($ExhHT); goto BoY34; BoY34: } public function search() { goto WYskW; Ud6Lk: $Y9WQp = array_map(function ($FSL7c) { return array('value' => intval($FSL7c['id']), 'name' => htmlspecialchars(MemberUtil::viewName($FSL7c)), 'avatar' => AssetsUtil::fixOrDefault($FSL7c['avatar'], 'asset/image/avatar.svg')); }, $Nv2EE['records']); goto WqXMJ; j5d1G: $Nv2EE = MemberUtil::paginate(1, 10, $f2U49); goto Ud6Lk; WqXMJ: return Response::jsonSuccessData($Y9WQp); goto pvxtu; z4t5x: $f2U49 = array(); goto x5CdJ; WYskW: $tBuXm = InputPackage::buildFromInput(); goto xKdI4; xKdI4: $NBkX5 = $tBuXm->getTrimString('keywords'); goto z4t5x; x5CdJ: $f2U49['whereOperate'] = array('username', 'like', "%{$NBkX5}%"); goto j5d1G; pvxtu: } public function resetPassword(AdminConfigBuilder $enw1u) { goto RYuNf; uy7z0: if (Request::isPost()) { return $enw1u->formRequest(function (Form $hUMbi) use($KAIwS) { AdminPermission::demoCheck(); $cwaKT = $hUMbi->dataForming(); $ZrjxR = MemberUtil::changePassword($KAIwS['id'], $cwaKT['passwordNew'], null, true); BizException::throwsIfResponseError($ZrjxR); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto Y1O0W; bGleO: $enw1u->text('passwordNew', '新密码')->required()->defaultValue(RandomUtil::upperString(6)); goto uy7z0; RYuNf: $StE5h = CRUDUtil::id(); goto Zckao; qRBWQ: $enw1u->pageTitle('重置密码'); goto bGleO; Y1O0W: return $enw1u; goto QZEnF; Zckao: $KAIwS = MemberUtil::get($StE5h); goto Mz2JM; YSnuR: $enw1u->useDialog(); goto qRBWQ; Mz2JM: BizException::throwsIfEmpty('用户不存在', $KAIwS); goto YSnuR; QZEnF: } public function sendMessage(AdminConfigBuilder $enw1u) { goto P_LFo; GqDEf: BizException::throwsIfEmpty('用户不存在', $KAIwS); goto y8MV_; VYY7c: $enw1u->richHtml('content', '消息内容')->required(); goto y_E2v; y8MV_: $enw1u->useDialog(); goto K8Ct3; K8Ct3: $enw1u->pageTitle('发送消息'); goto VYY7c; Ubjne: return $enw1u; goto SdNPb; y_E2v: if (Request::isPost()) { return $enw1u->formRequest(function (Form $hUMbi) use($KAIwS) { AdminPermission::demoCheck(); $cwaKT = $hUMbi->dataForming(); $ZrjxR = MemberMessageUtil::send($KAIwS['id'], $cwaKT['content']); BizException::throwsIfResponseError($ZrjxR); return Response::redirect(CRUDUtil::jsDialogClose()); }); } goto Ubjne; vi2UA: $KAIwS = MemberUtil::get($StE5h); goto GqDEf; P_LFo: $StE5h = CRUDUtil::id(); goto vi2UA; SdNPb: } public function show() { goto CANxK; pb8bL: $JwPe6 = MemberAdminShowPanelProvider::listAll(); goto vSDvY; vSDvY: return view('module::Member.View.admin.memberUser.show', array('record' => $rpy90, 'showPanelProviders' => $JwPe6)); goto Xsoio; CANxK: $rpy90 = MemberUtil::get(CRUDUtil::id()); goto pb8bL; Xsoio: } public function delete() { goto gea2w; C1c2x: MemberUtil::delete(CRUDUtil::id()); goto y7QIP; y7QIP: return Response::redirect(CRUDUtil::jsGridRefresh()); goto cwr8i; gea2w: AdminPermission::demoCheck(); goto C1c2x; cwr8i: } public function statusForbidden() { goto LroGu; b9csi: MemberUtil::updateStatus(CRUDUtil::ids(), MemberStatus::FORBIDDEN); goto WRt6b; WRt6b: return Response::redirect(CRUDUtil::jsGridRefresh()); goto JlEN8; LroGu: AdminPermission::demoCheck(); goto b9csi; JlEN8: } public function export(ExportHandle $tqu7M) { $U1vxU = array('ID', '用户名', '邮箱', '手机', '注册时间', '性别', '姓名', '签名'); return $tqu7M->withPageTitle('导出用户信息')->withDefaultExportName('用户信息')->withHeadTitles($U1vxU)->handleFetch(function ($WLCMC, $Aqj3Z, $mNCUj, $uxJUJ) { $Pn_v2 = ModelUtil::model('member_user'); $Pn_v2 = $Pn_v2->where(array('isDeleted' => false))->orderBy('id', 'desc'); foreach ($mNCUj as $OmTgl) { if (!empty($OmTgl['id']['eq'])) { $Pn_v2 = $Pn_v2->where('id', $OmTgl['id']['eq']); } elseif (!empty($OmTgl['status']['eq'])) { $Pn_v2 = $Pn_v2->where('status', $OmTgl['status']['eq']); } elseif (!empty($OmTgl['groupId']['eq'])) { $Pn_v2 = $Pn_v2->where('groupId', $OmTgl['groupId']['eq']); } elseif (!empty($OmTgl['vipId']['eq'])) { $Pn_v2 = $Pn_v2->where('vipId', $OmTgl['vipId']['eq']); } elseif (!empty($OmTgl['username']['like'])) { $Pn_v2 = $Pn_v2->where('username', 'like', '%' . $OmTgl['username']['like'] . '%'); } elseif (!empty($OmTgl['email']['like'])) { $Pn_v2 = $Pn_v2->where('email', 'like', '%' . $OmTgl['email']['like'] . '%'); } elseif (!empty($OmTgl['phone']['like'])) { $Pn_v2 = $Pn_v2->where('phone', 'like', '%' . $OmTgl['phone']['like'] . '%'); } } $e3gsP = $Pn_v2->paginate($Aqj3Z, array('*'), 'page', $WLCMC)->toArray(); $hmq1P = array(); foreach ($e3gsP['data'] as $FSL7c) { goto IWfIf; z1azE: $zB1g3[] = $FSL7c['realname']; goto uvFOU; IWfIf: $zB1g3 = array(); goto HjHyz; gS8Lp: $zB1g3[] = $FSL7c['created_at']; goto N7vVV; N7vVV: $zB1g3[] = TypeUtil::name(Gender::class, $FSL7c['gender']); goto z1azE; uvFOU: $zB1g3[] = $FSL7c['signature']; goto Nc6Om; Nc6Om: $hmq1P[] = $zB1g3; goto NSY2i; AXAwz: $zB1g3[] = $FSL7c['email']; goto ntaVU; BASqH: $zB1g3[] = $FSL7c['username']; goto AXAwz; ntaVU: $zB1g3[] = $FSL7c['phone']; goto gS8Lp; HjHyz: $zB1g3[] = $FSL7c['id']; goto BASqH; NSY2i: } return array('list' => $hmq1P, 'total' => $e3gsP['total']); })->performCommon(); } }