# Stage 0 Proposals

Stage 0 proposals which appear below are either:

* planned to be presented to the committee by a TC39 champion, or
* have been presented to the committee and not rejected definitively, but have not yet achieved any of the criteria to get into stage 1.

| Proposal                                                           | Author                                | Champion                              | Last Presented                    |
| ------------------------------------------------------------------ | ------------------------------------- | ------------------------------------- | --------------------------------- |
| [Additional metaproperties][metaprops]                             | Allen Wirfs-Brock                     | Allen Wirfs-Brock                     |                                   |
| [Defensible Classes][defensible-classes]                           | Mark Miller<br />Doug Crockford       | Mark Miller<br />Doug Crockford       |                                   |
| [Function bind syntax][bind-syntax]                                | Kevin Smith                           | Brian Terlson<br />Matthew Podwysocki | [March 2015][bind-notes]          |
| [Function expression decorators][func-expr-decorators]             | Igor Minar                            | Igor Minar                            |                                   |
| [Method parameter decorators][method-param-decorators]             | Igor Minar                            | Igor Minar                            |                                   |
| [Nested `import` declarations][nested-imports]                     | Ben Newman                            | Ben Newman                            | [July 2016][nested-notes]         |
| [Orthogonal Classes][ortho]                                        | Mark Miller<br />Allen Wirfs-Brock    | Mark Miller<br />Allen Wirfs-Brock    | [March 2017][ortho-notes]         |
| [`Reflect.{isCallable,isConstructor}`][is-callable-is-constructor] | Caitlin Potter                        | Caitlin Potter                        |                                   |
| [Relationships][relationships]                                     | Mark Miller<br />Waldemar Horwat      | Mark Miller<br />Waldemar Horwat      |                                   |
| [Structured Clone][clone]                                          | Dmitry Lomov                          | Dmitry Lomov                          | [Jan 2014][clone-notes]           |
| [WHATWG URL][url]                                                  | James M Snell                         | James M Snell                         |                                   |
| [Object Shorthand Improvements][object-shorthand-improvements]     | Ron Buckton                           | Ron Buckton                           | [Sep 2017][shorthand-notes]       |
| [`as` destructuring patterns][as-patterns]                         | Kat Marchán                           | Kat Marchán                           |                                   |
| [String trim characters][string-trim-characters]                   | Wenlu Wang                            | Wenlu Wang                            |                                   |
| [Catch Guard][catch-guard]                                         | Willian Martins                       | Willian Martins                       |                                   |

See also the [active proposals](README.md), [stage 1 proposals](stage-1-proposals.md), [finished proposals](finished-proposals.md), and [inactive proposals](inactive-proposals.md) documents.

[metaprops]: https://github.com/allenwb/ESideas/blob/HEAD/ES7MetaProps.md
[defensible-classes]: https://web.archive.org/web/20160804042547/http://wiki.ecmascript.org/doku.php?id=strawman:defensible_classes
[bind-syntax]: https://github.com/tc39/proposal-bind-operator
[func-expr-decorators]: https://goo.gl/8MmCMG
[method-param-decorators]: https://goo.gl/r1XT9b
[nested-imports]: https://github.com/benjamn/reify/blob/HEAD/PROPOSAL.md
[ortho]: https://github.com/erights/Orthogonal-Classes
[is-callable-is-constructor]: https://github.com/caitp/TC39-Proposals/blob/HEAD/tc39-reflect-isconstructor-iscallable.md
[relationships]: https://web.archive.org/web/20160804042554/http://wiki.ecmascript.org/doku.php?id=strawman:relationships
[clone]: https://github.com/dslomov/ecmascript-structured-clone
[url]: https://github.com/jasnell/proposal-url
[object-shorthand-improvements]: https://github.com/rbuckton/proposal-shorthand-improvements
[as-patterns]: https://github.com/zkat/proposal-as-patterns
[bind-notes]: https://github.com/tc39/notes/blob/HEAD/meetings/2015-03/mar-25.md#6vi-function-bind-and-private-fields-redux-kevin-smith
[nested-notes]: https://github.com/tc39/notes/blob/HEAD/meetings/2016-07/jul-27.md#10iiic-nested-import-declaration
[ortho-notes]: https://github.com/tc39/notes/blob/HEAD/meetings/2017-03/mar-22.md#10iiia-orthogonal-classes
[clone-notes]: https://github.com/tc39/notes/blob/HEAD/meetings/2014-01/jan-30.md#structured-clone
[shorthand-notes]: https://github.com/tc39/notes/blob/HEAD/meetings/2017-09/sept-28.md#13i-object-shorthand-improvements
[builtins-notes]: https://github.com/tc39/notes/blob/HEAD/meetings/2017-09/sept-28.md#14ia-builtinstypeof-and-builtinsis
[string-trim-characters]: https://github.com/Kingwl/proposal-string-trim-characters
[catch-guard]: https://github.com/wmsbill/proposal-catch-guards
