// @ts-nocheck
/* tslint:disable */
/* eslint-disable */
//----------------------
// <auto-generated>
//     Generated using the NSwag toolchain v13.15.5.0 (NJsonSchema v10.6.6.0 (Newtonsoft.Json v13.0.0.0)) (http://NSwag.org)
// </auto-generated>
//----------------------
// ReSharper disable InconsistentNaming
import {IHttpClient} from "@aurelia/fetch-client";
import {ApiClientBase} from "@application/api-client-base";


export interface IOmniSharpApiClient {

    restartServer(scriptId: string, signal?: AbortSignal | undefined): Promise<boolean>;

    getCompletion(scriptId: string, request: CompletionRequest, signal?: AbortSignal | undefined): Promise<CompletionResponse>;

    getCompletionResolution(scriptId: string, completionItem: CompletionItem2, signal?: AbortSignal | undefined): Promise<CompletionResolveResponse>;

    getCompletionAfterInsert(scriptId: string, completionItem: CompletionItem2, signal?: AbortSignal | undefined): Promise<CompletionAfterInsertResponse>;

    formatRange(scriptId: string, request: FormatRangeRequest, signal?: AbortSignal | undefined): Promise<FormatRangeResponse>;

    formatAfterKeystroke(scriptId: string, request: FormatAfterKeystrokeRequest, signal?: AbortSignal | undefined): Promise<FormatRangeResponse>;

    getSemanticHighlights(scriptId: string, request: SemanticHighlightRequest, signal?: AbortSignal | undefined): Promise<SemanticHighlightResponse>;

    findImplementations(scriptId: string, request: FindImplementationsRequest, signal?: AbortSignal | undefined): Promise<QuickFixResponse>;

    getQuickInfo(scriptId: string, request: QuickInfoRequest, signal?: AbortSignal | undefined): Promise<QuickInfoResponse>;

    getSignatureHelp(scriptId: string, request: SignatureHelpRequest, signal?: AbortSignal | undefined): Promise<SignatureHelpResponse>;

    findUsages(scriptId: string, request: FindUsagesRequest, signal?: AbortSignal | undefined): Promise<QuickFixResponse>;

    getCodeStructure(scriptId: string, signal?: AbortSignal | undefined): Promise<CodeStructureResponse>;

    getInlayHints(scriptId: string, request: InlayHintRequest, signal?: AbortSignal | undefined): Promise<InlayHintResponse>;

    resolveInlayHint(scriptId: string, request: InlayHintResolveRequest, signal?: AbortSignal | undefined): Promise<InlayHint>;

    getCodeActions(scriptId: string, request: GetCodeActionsRequest, signal?: AbortSignal | undefined): Promise<GetCodeActionsResponse>;

    runCodeAction(scriptId: string, request: RunCodeActionRequest, signal?: AbortSignal | undefined): Promise<RunCodeActionResponse>;

    codeCheck(scriptId: string, request: CodeCheckRequest, signal?: AbortSignal | undefined): Promise<QuickFixResponse>;

    startDiagnostics(scriptId: string, signal?: AbortSignal | undefined): Promise<void>;

    getBlockStructure(scriptId: string, signal?: AbortSignal | undefined): Promise<BlockStructureResponse>;

    rename(scriptId: string, request: RenameRequest, signal?: AbortSignal | undefined): Promise<RenameResponse>;
}

export class OmniSharpApiClient extends ApiClientBase implements IOmniSharpApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    restartServer(scriptId: string, signal?: AbortSignal | undefined): Promise<boolean> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/restart-server";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processRestartServer(_response);
        });
    }

    protected processRestartServer(response: Response): Promise<boolean> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = resultData200 !== undefined ? resultData200 : <any>null;

            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<boolean>(<any>null);
    }

    getCompletion(scriptId: string, request: CompletionRequest, signal?: AbortSignal | undefined): Promise<CompletionResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/completion";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetCompletion(_response);
        });
    }

    protected processGetCompletion(response: Response): Promise<CompletionResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = CompletionResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<CompletionResponse>(<any>null);
    }

    getCompletionResolution(scriptId: string, completionItem: CompletionItem2, signal?: AbortSignal | undefined): Promise<CompletionResolveResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/completion/resolve";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(completionItem);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetCompletionResolution(_response);
        });
    }

    protected processGetCompletionResolution(response: Response): Promise<CompletionResolveResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = CompletionResolveResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<CompletionResolveResponse>(<any>null);
    }

    getCompletionAfterInsert(scriptId: string, completionItem: CompletionItem2, signal?: AbortSignal | undefined): Promise<CompletionAfterInsertResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/completion/after-insert";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(completionItem);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetCompletionAfterInsert(_response);
        });
    }

    protected processGetCompletionAfterInsert(response: Response): Promise<CompletionAfterInsertResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = CompletionAfterInsertResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<CompletionAfterInsertResponse>(<any>null);
    }

    formatRange(scriptId: string, request: FormatRangeRequest, signal?: AbortSignal | undefined): Promise<FormatRangeResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/format/range";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processFormatRange(_response);
        });
    }

    protected processFormatRange(response: Response): Promise<FormatRangeResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = FormatRangeResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FormatRangeResponse>(<any>null);
    }

    formatAfterKeystroke(scriptId: string, request: FormatAfterKeystrokeRequest, signal?: AbortSignal | undefined): Promise<FormatRangeResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/format/after-keystroke";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processFormatAfterKeystroke(_response);
        });
    }

    protected processFormatAfterKeystroke(response: Response): Promise<FormatRangeResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = FormatRangeResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FormatRangeResponse>(<any>null);
    }

    getSemanticHighlights(scriptId: string, request: SemanticHighlightRequest, signal?: AbortSignal | undefined): Promise<SemanticHighlightResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/semantic-highlights";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetSemanticHighlights(_response);
        });
    }

    protected processGetSemanticHighlights(response: Response): Promise<SemanticHighlightResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = SemanticHighlightResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<SemanticHighlightResponse>(<any>null);
    }

    findImplementations(scriptId: string, request: FindImplementationsRequest, signal?: AbortSignal | undefined): Promise<QuickFixResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/find-implementations";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processFindImplementations(_response);
        });
    }

    protected processFindImplementations(response: Response): Promise<QuickFixResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = QuickFixResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<QuickFixResponse>(<any>null);
    }

    getQuickInfo(scriptId: string, request: QuickInfoRequest, signal?: AbortSignal | undefined): Promise<QuickInfoResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/quick-info";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetQuickInfo(_response);
        });
    }

    protected processGetQuickInfo(response: Response): Promise<QuickInfoResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = QuickInfoResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<QuickInfoResponse>(<any>null);
    }

    getSignatureHelp(scriptId: string, request: SignatureHelpRequest, signal?: AbortSignal | undefined): Promise<SignatureHelpResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/signature-help";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetSignatureHelp(_response);
        });
    }

    protected processGetSignatureHelp(response: Response): Promise<SignatureHelpResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = SignatureHelpResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<SignatureHelpResponse>(<any>null);
    }

    findUsages(scriptId: string, request: FindUsagesRequest, signal?: AbortSignal | undefined): Promise<QuickFixResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/find-usages";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processFindUsages(_response);
        });
    }

    protected processFindUsages(response: Response): Promise<QuickFixResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = QuickFixResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<QuickFixResponse>(<any>null);
    }

    getCodeStructure(scriptId: string, signal?: AbortSignal | undefined): Promise<CodeStructureResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/code-structure";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetCodeStructure(_response);
        });
    }

    protected processGetCodeStructure(response: Response): Promise<CodeStructureResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = CodeStructureResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<CodeStructureResponse>(<any>null);
    }

    getInlayHints(scriptId: string, request: InlayHintRequest, signal?: AbortSignal | undefined): Promise<InlayHintResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/inlay-hints";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetInlayHints(_response);
        });
    }

    protected processGetInlayHints(response: Response): Promise<InlayHintResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = InlayHintResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<InlayHintResponse>(<any>null);
    }

    resolveInlayHint(scriptId: string, request: InlayHintResolveRequest, signal?: AbortSignal | undefined): Promise<InlayHint> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/inlay-hints/resolve";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processResolveInlayHint(_response);
        });
    }

    protected processResolveInlayHint(response: Response): Promise<InlayHint> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = InlayHint.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<InlayHint>(<any>null);
    }

    getCodeActions(scriptId: string, request: GetCodeActionsRequest, signal?: AbortSignal | undefined): Promise<GetCodeActionsResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/code-actions";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetCodeActions(_response);
        });
    }

    protected processGetCodeActions(response: Response): Promise<GetCodeActionsResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = GetCodeActionsResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<GetCodeActionsResponse>(<any>null);
    }

    runCodeAction(scriptId: string, request: RunCodeActionRequest, signal?: AbortSignal | undefined): Promise<RunCodeActionResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/code-actions/run";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processRunCodeAction(_response);
        });
    }

    protected processRunCodeAction(response: Response): Promise<RunCodeActionResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = RunCodeActionResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<RunCodeActionResponse>(<any>null);
    }

    codeCheck(scriptId: string, request: CodeCheckRequest, signal?: AbortSignal | undefined): Promise<QuickFixResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/code-check";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processCodeCheck(_response);
        });
    }

    protected processCodeCheck(response: Response): Promise<QuickFixResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = QuickFixResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<QuickFixResponse>(<any>null);
    }

    startDiagnostics(scriptId: string, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/diagnostics/start";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processStartDiagnostics(_response);
        });
    }

    protected processStartDiagnostics(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    getBlockStructure(scriptId: string, signal?: AbortSignal | undefined): Promise<BlockStructureResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/block-structure";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "POST",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetBlockStructure(_response);
        });
    }

    protected processGetBlockStructure(response: Response): Promise<BlockStructureResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = BlockStructureResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<BlockStructureResponse>(<any>null);
    }

    rename(scriptId: string, request: RenameRequest, signal?: AbortSignal | undefined): Promise<RenameResponse> {
        let url_ = this.baseUrl + "/omnisharp/{scriptId}/rename";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(request);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processRename(_response);
        });
    }

    protected processRename(response: Response): Promise<RenameResponse> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = RenameResponse.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<RenameResponse>(<any>null);
    }
}

export interface ITypesApiClient {

    additionalTypes(signal?: AbortSignal | undefined): Promise<Types>;
}

export class TypesApiClient extends ApiClientBase implements ITypesApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    additionalTypes(signal?: AbortSignal | undefined): Promise<Types> {
        let url_ = this.baseUrl + "/omnisharp/types";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processAdditionalTypes(_response);
        });
    }

    protected processAdditionalTypes(response: Response): Promise<Types> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = Types.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Types>(<any>null);
    }
}

export class CompletionResponse implements ICompletionResponse {
    isIncomplete!: boolean;
    items!: CompletionItem[];

    constructor(data?: ICompletionResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.items = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            this.isIncomplete = _data["isIncomplete"];
            if (Array.isArray(_data["items"])) {
                this.items = [] as any;
                for (let item of _data["items"])
                    this.items!.push(CompletionItem.fromJS(item));
            }
        }
    }

    static fromJS(data: any): CompletionResponse {
        data = typeof data === 'object' ? data : {};
        let result = new CompletionResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["isIncomplete"] = this.isIncomplete;
        if (Array.isArray(this.items)) {
            data["items"] = [];
            for (let item of this.items)
                data["items"].push(item.toJSON());
        }
        return data;
    }

    clone(): CompletionResponse {
        const json = this.toJSON();
        let result = new CompletionResponse();
        result.init(json);
        return result;
    }
}

export interface ICompletionResponse {
    isIncomplete: boolean;
    items: CompletionItem[];
}

export class CompletionItem implements ICompletionItem {
    label!: string;
    kind!: CompletionItemKind;
    tags?: CompletionItemTag[] | undefined;
    detail?: string | undefined;
    documentation?: string | undefined;
    preselect!: boolean;
    sortText?: string | undefined;
    filterText?: string | undefined;
    insertTextFormat!: InsertTextFormat;
    textEdit?: LinePositionSpanTextChange | undefined;
    commitCharacters?: string[] | undefined;
    additionalTextEdits?: LinePositionSpanTextChange[] | undefined;
    data!: ValueTupleOfLongAndInteger;
    hasAfterInsertStep!: boolean;

    constructor(data?: ICompletionItem) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.data = new ValueTupleOfLongAndInteger();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.label = _data["label"];
            this.kind = _data["kind"];
            if (Array.isArray(_data["tags"])) {
                this.tags = [] as any;
                for (let item of _data["tags"])
                    this.tags!.push(item);
            }
            this.detail = _data["detail"];
            this.documentation = _data["documentation"];
            this.preselect = _data["preselect"];
            this.sortText = _data["sortText"];
            this.filterText = _data["filterText"];
            this.insertTextFormat = _data["insertTextFormat"];
            this.textEdit = _data["textEdit"] ? LinePositionSpanTextChange.fromJS(_data["textEdit"]) : <any>undefined;
            if (Array.isArray(_data["commitCharacters"])) {
                this.commitCharacters = [] as any;
                for (let item of _data["commitCharacters"])
                    this.commitCharacters!.push(item);
            }
            if (Array.isArray(_data["additionalTextEdits"])) {
                this.additionalTextEdits = [] as any;
                for (let item of _data["additionalTextEdits"])
                    this.additionalTextEdits!.push(LinePositionSpanTextChange.fromJS(item));
            }
            this.data = _data["data"] ? ValueTupleOfLongAndInteger.fromJS(_data["data"]) : new ValueTupleOfLongAndInteger();
            this.hasAfterInsertStep = _data["hasAfterInsertStep"];
        }
    }

    static fromJS(data: any): CompletionItem {
        data = typeof data === 'object' ? data : {};
        let result = new CompletionItem();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["label"] = this.label;
        data["kind"] = this.kind;
        if (Array.isArray(this.tags)) {
            data["tags"] = [];
            for (let item of this.tags)
                data["tags"].push(item);
        }
        data["detail"] = this.detail;
        data["documentation"] = this.documentation;
        data["preselect"] = this.preselect;
        data["sortText"] = this.sortText;
        data["filterText"] = this.filterText;
        data["insertTextFormat"] = this.insertTextFormat;
        data["textEdit"] = this.textEdit ? this.textEdit.toJSON() : <any>undefined;
        if (Array.isArray(this.commitCharacters)) {
            data["commitCharacters"] = [];
            for (let item of this.commitCharacters)
                data["commitCharacters"].push(item);
        }
        if (Array.isArray(this.additionalTextEdits)) {
            data["additionalTextEdits"] = [];
            for (let item of this.additionalTextEdits)
                data["additionalTextEdits"].push(item.toJSON());
        }
        data["data"] = this.data ? this.data.toJSON() : <any>undefined;
        data["hasAfterInsertStep"] = this.hasAfterInsertStep;
        return data;
    }

    clone(): CompletionItem {
        const json = this.toJSON();
        let result = new CompletionItem();
        result.init(json);
        return result;
    }
}

export interface ICompletionItem {
    label: string;
    kind: CompletionItemKind;
    tags?: CompletionItemTag[] | undefined;
    detail?: string | undefined;
    documentation?: string | undefined;
    preselect: boolean;
    sortText?: string | undefined;
    filterText?: string | undefined;
    insertTextFormat: InsertTextFormat;
    textEdit?: LinePositionSpanTextChange | undefined;
    commitCharacters?: string[] | undefined;
    additionalTextEdits?: LinePositionSpanTextChange[] | undefined;
    data: ValueTupleOfLongAndInteger;
    hasAfterInsertStep: boolean;
}

export type CompletionItemKind = "Text" | "Method" | "Function" | "Constructor" | "Field" | "Variable" | "Class" | "Interface" | "Module" | "Property" | "Unit" | "Value" | "Enum" | "Keyword" | "Snippet" | "Color" | "File" | "Reference" | "Folder" | "EnumMember" | "Constant" | "Struct" | "Event" | "Operator" | "TypeParameter";

export type CompletionItemTag = "Deprecated";

export type InsertTextFormat = "PlainText" | "Snippet";

export class LinePositionSpanTextChange implements ILinePositionSpanTextChange {
    newText?: string | undefined;
    startLine!: number;
    startColumn!: number;
    endLine!: number;
    endColumn!: number;

    constructor(data?: ILinePositionSpanTextChange) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.newText = _data["newText"];
            this.startLine = _data["startLine"];
            this.startColumn = _data["startColumn"];
            this.endLine = _data["endLine"];
            this.endColumn = _data["endColumn"];
        }
    }

    static fromJS(data: any): LinePositionSpanTextChange {
        data = typeof data === 'object' ? data : {};
        let result = new LinePositionSpanTextChange();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["newText"] = this.newText;
        data["startLine"] = this.startLine;
        data["startColumn"] = this.startColumn;
        data["endLine"] = this.endLine;
        data["endColumn"] = this.endColumn;
        return data;
    }

    clone(): LinePositionSpanTextChange {
        const json = this.toJSON();
        let result = new LinePositionSpanTextChange();
        result.init(json);
        return result;
    }
}

export interface ILinePositionSpanTextChange {
    newText?: string | undefined;
    startLine: number;
    startColumn: number;
    endLine: number;
    endColumn: number;
}

export class ValueTupleOfLongAndInteger implements IValueTupleOfLongAndInteger {
    item1!: number;
    item2!: number;

    constructor(data?: IValueTupleOfLongAndInteger) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.item1 = _data["item1"];
            this.item2 = _data["item2"];
        }
    }

    static fromJS(data: any): ValueTupleOfLongAndInteger {
        data = typeof data === 'object' ? data : {};
        let result = new ValueTupleOfLongAndInteger();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["item1"] = this.item1;
        data["item2"] = this.item2;
        return data;
    }

    clone(): ValueTupleOfLongAndInteger {
        const json = this.toJSON();
        let result = new ValueTupleOfLongAndInteger();
        result.init(json);
        return result;
    }
}

export interface IValueTupleOfLongAndInteger {
    item1: number;
    item2: number;
}

export class SimpleFileRequest implements ISimpleFileRequest {
    fileName?: string | undefined;

    constructor(data?: ISimpleFileRequest) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.fileName = _data["fileName"];
        }
    }

    static fromJS(data: any): SimpleFileRequest {
        data = typeof data === 'object' ? data : {};
        let result = new SimpleFileRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["fileName"] = this.fileName;
        return data;
    }

    clone(): SimpleFileRequest {
        const json = this.toJSON();
        let result = new SimpleFileRequest();
        result.init(json);
        return result;
    }
}

export interface ISimpleFileRequest {
    fileName?: string | undefined;
}

export class Request extends SimpleFileRequest implements IRequest {
    line!: number;
    column!: number;
    buffer?: string | undefined;
    changes?: LinePositionSpanTextChange[] | undefined;
    applyChangesTogether!: boolean;

    constructor(data?: IRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.line = _data["line"];
            this.column = _data["column"];
            this.buffer = _data["buffer"];
            if (Array.isArray(_data["changes"])) {
                this.changes = [] as any;
                for (let item of _data["changes"])
                    this.changes!.push(LinePositionSpanTextChange.fromJS(item));
            }
            this.applyChangesTogether = _data["applyChangesTogether"];
        }
    }

    static fromJS(data: any): Request {
        data = typeof data === 'object' ? data : {};
        let result = new Request();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["line"] = this.line;
        data["column"] = this.column;
        data["buffer"] = this.buffer;
        if (Array.isArray(this.changes)) {
            data["changes"] = [];
            for (let item of this.changes)
                data["changes"].push(item.toJSON());
        }
        data["applyChangesTogether"] = this.applyChangesTogether;
        super.toJSON(data);
        return data;
    }

    clone(): Request {
        const json = this.toJSON();
        let result = new Request();
        result.init(json);
        return result;
    }
}

export interface IRequest extends ISimpleFileRequest {
    line: number;
    column: number;
    buffer?: string | undefined;
    changes?: LinePositionSpanTextChange[] | undefined;
    applyChangesTogether: boolean;
}

export class CompletionRequest extends Request implements ICompletionRequest {
    completionTrigger!: CompletionTriggerKind;
    triggerCharacter?: string | undefined;

    constructor(data?: ICompletionRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.completionTrigger = _data["completionTrigger"];
            this.triggerCharacter = _data["triggerCharacter"];
        }
    }

    static fromJS(data: any): CompletionRequest {
        data = typeof data === 'object' ? data : {};
        let result = new CompletionRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["completionTrigger"] = this.completionTrigger;
        data["triggerCharacter"] = this.triggerCharacter;
        super.toJSON(data);
        return data;
    }

    clone(): CompletionRequest {
        const json = this.toJSON();
        let result = new CompletionRequest();
        result.init(json);
        return result;
    }
}

export interface ICompletionRequest extends IRequest {
    completionTrigger: CompletionTriggerKind;
    triggerCharacter?: string | undefined;
}

export type CompletionTriggerKind = "Invoked" | "TriggerCharacter" | "TriggerForIncompleteCompletions";

export class CompletionResolveResponse implements ICompletionResolveResponse {
    item?: CompletionItem | undefined;

    constructor(data?: ICompletionResolveResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.item = _data["item"] ? CompletionItem.fromJS(_data["item"]) : <any>undefined;
        }
    }

    static fromJS(data: any): CompletionResolveResponse {
        data = typeof data === 'object' ? data : {};
        let result = new CompletionResolveResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["item"] = this.item ? this.item.toJSON() : <any>undefined;
        return data;
    }

    clone(): CompletionResolveResponse {
        const json = this.toJSON();
        let result = new CompletionResolveResponse();
        result.init(json);
        return result;
    }
}

export interface ICompletionResolveResponse {
    item?: CompletionItem | undefined;
}

export class CompletionItem2 extends CompletionItem implements ICompletionItem2 {
    data?: CompletionItemData | undefined;

    constructor(data?: ICompletionItem2) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.data = _data["data"] ? CompletionItemData.fromJS(_data["data"]) : <any>undefined;
        }
    }

    static fromJS(data: any): CompletionItem2 {
        data = typeof data === 'object' ? data : {};
        let result = new CompletionItem2();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["data"] = this.data ? this.data.toJSON() : <any>undefined;
        super.toJSON(data);
        return data;
    }

    clone(): CompletionItem2 {
        const json = this.toJSON();
        let result = new CompletionItem2();
        result.init(json);
        return result;
    }
}

export interface ICompletionItem2 extends ICompletionItem {
    data?: CompletionItemData | undefined;
}

export class CompletionItemData implements ICompletionItemData {
    item1!: number;
    item2!: number;

    constructor(data?: ICompletionItemData) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.item1 = _data["item1"];
            this.item2 = _data["item2"];
        }
    }

    static fromJS(data: any): CompletionItemData {
        data = typeof data === 'object' ? data : {};
        let result = new CompletionItemData();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["item1"] = this.item1;
        data["item2"] = this.item2;
        return data;
    }

    clone(): CompletionItemData {
        const json = this.toJSON();
        let result = new CompletionItemData();
        result.init(json);
        return result;
    }
}

export interface ICompletionItemData {
    item1: number;
    item2: number;
}

export class CompletionAfterInsertResponse implements ICompletionAfterInsertResponse {
    changes?: LinePositionSpanTextChange[] | undefined;
    line?: number | undefined;
    column?: number | undefined;

    constructor(data?: ICompletionAfterInsertResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["changes"])) {
                this.changes = [] as any;
                for (let item of _data["changes"])
                    this.changes!.push(LinePositionSpanTextChange.fromJS(item));
            }
            this.line = _data["line"];
            this.column = _data["column"];
        }
    }

    static fromJS(data: any): CompletionAfterInsertResponse {
        data = typeof data === 'object' ? data : {};
        let result = new CompletionAfterInsertResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.changes)) {
            data["changes"] = [];
            for (let item of this.changes)
                data["changes"].push(item.toJSON());
        }
        data["line"] = this.line;
        data["column"] = this.column;
        return data;
    }

    clone(): CompletionAfterInsertResponse {
        const json = this.toJSON();
        let result = new CompletionAfterInsertResponse();
        result.init(json);
        return result;
    }
}

export interface ICompletionAfterInsertResponse {
    changes?: LinePositionSpanTextChange[] | undefined;
    line?: number | undefined;
    column?: number | undefined;
}

export class FormatRangeResponse implements IFormatRangeResponse {
    changes?: LinePositionSpanTextChange[] | undefined;

    constructor(data?: IFormatRangeResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["changes"])) {
                this.changes = [] as any;
                for (let item of _data["changes"])
                    this.changes!.push(LinePositionSpanTextChange.fromJS(item));
            }
        }
    }

    static fromJS(data: any): FormatRangeResponse {
        data = typeof data === 'object' ? data : {};
        let result = new FormatRangeResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.changes)) {
            data["changes"] = [];
            for (let item of this.changes)
                data["changes"].push(item.toJSON());
        }
        return data;
    }

    clone(): FormatRangeResponse {
        const json = this.toJSON();
        let result = new FormatRangeResponse();
        result.init(json);
        return result;
    }
}

export interface IFormatRangeResponse {
    changes?: LinePositionSpanTextChange[] | undefined;
}

export class FormatRangeRequest extends Request implements IFormatRangeRequest {
    endLine!: number;
    endColumn!: number;

    constructor(data?: IFormatRangeRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.endLine = _data["endLine"];
            this.endColumn = _data["endColumn"];
        }
    }

    static fromJS(data: any): FormatRangeRequest {
        data = typeof data === 'object' ? data : {};
        let result = new FormatRangeRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["endLine"] = this.endLine;
        data["endColumn"] = this.endColumn;
        super.toJSON(data);
        return data;
    }

    clone(): FormatRangeRequest {
        const json = this.toJSON();
        let result = new FormatRangeRequest();
        result.init(json);
        return result;
    }
}

export interface IFormatRangeRequest extends IRequest {
    endLine: number;
    endColumn: number;
}

export class FormatAfterKeystrokeRequest extends Request implements IFormatAfterKeystrokeRequest {
    character?: string | undefined;
    char!: string;

    constructor(data?: IFormatAfterKeystrokeRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.character = _data["character"];
            this.char = _data["char"];
        }
    }

    static fromJS(data: any): FormatAfterKeystrokeRequest {
        data = typeof data === 'object' ? data : {};
        let result = new FormatAfterKeystrokeRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["character"] = this.character;
        data["char"] = this.char;
        super.toJSON(data);
        return data;
    }

    clone(): FormatAfterKeystrokeRequest {
        const json = this.toJSON();
        let result = new FormatAfterKeystrokeRequest();
        result.init(json);
        return result;
    }
}

export interface IFormatAfterKeystrokeRequest extends IRequest {
    character?: string | undefined;
    char: string;
}

export class SemanticHighlightResponse implements ISemanticHighlightResponse {
    spans?: SemanticHighlightSpan[] | undefined;

    constructor(data?: ISemanticHighlightResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["spans"])) {
                this.spans = [] as any;
                for (let item of _data["spans"])
                    this.spans!.push(SemanticHighlightSpan.fromJS(item));
            }
        }
    }

    static fromJS(data: any): SemanticHighlightResponse {
        data = typeof data === 'object' ? data : {};
        let result = new SemanticHighlightResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.spans)) {
            data["spans"] = [];
            for (let item of this.spans)
                data["spans"].push(item.toJSON());
        }
        return data;
    }

    clone(): SemanticHighlightResponse {
        const json = this.toJSON();
        let result = new SemanticHighlightResponse();
        result.init(json);
        return result;
    }
}

export interface ISemanticHighlightResponse {
    spans?: SemanticHighlightSpan[] | undefined;
}

export class SemanticHighlightSpan implements ISemanticHighlightSpan {
    startLine!: number;
    startColumn!: number;
    endLine!: number;
    endColumn!: number;
    type!: SemanticHighlightClassification;
    modifiers?: SemanticHighlightModifier[] | undefined;

    constructor(data?: ISemanticHighlightSpan) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.startLine = _data["startLine"];
            this.startColumn = _data["startColumn"];
            this.endLine = _data["endLine"];
            this.endColumn = _data["endColumn"];
            this.type = _data["type"];
            if (Array.isArray(_data["modifiers"])) {
                this.modifiers = [] as any;
                for (let item of _data["modifiers"])
                    this.modifiers!.push(item);
            }
        }
    }

    static fromJS(data: any): SemanticHighlightSpan {
        data = typeof data === 'object' ? data : {};
        let result = new SemanticHighlightSpan();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["startLine"] = this.startLine;
        data["startColumn"] = this.startColumn;
        data["endLine"] = this.endLine;
        data["endColumn"] = this.endColumn;
        data["type"] = this.type;
        if (Array.isArray(this.modifiers)) {
            data["modifiers"] = [];
            for (let item of this.modifiers)
                data["modifiers"].push(item);
        }
        return data;
    }

    clone(): SemanticHighlightSpan {
        const json = this.toJSON();
        let result = new SemanticHighlightSpan();
        result.init(json);
        return result;
    }
}

export interface ISemanticHighlightSpan {
    startLine: number;
    startColumn: number;
    endLine: number;
    endColumn: number;
    type: SemanticHighlightClassification;
    modifiers?: SemanticHighlightModifier[] | undefined;
}

export type SemanticHighlightClassification = "Comment" | "ExcludedCode" | "Identifier" | "Keyword" | "ControlKeyword" | "NumericLiteral" | "Operator" | "OperatorOverloaded" | "PreprocessorKeyword" | "StringLiteral" | "WhiteSpace" | "Text" | "StaticSymbol" | "PreprocessorText" | "Punctuation" | "VerbatimStringLiteral" | "StringEscapeCharacter" | "ClassName" | "DelegateName" | "EnumName" | "InterfaceName" | "ModuleName" | "StructName" | "TypeParameterName" | "FieldName" | "EnumMemberName" | "ConstantName" | "LocalName" | "ParameterName" | "MethodName" | "ExtensionMethodName" | "PropertyName" | "EventName" | "NamespaceName" | "LabelName" | "XmlDocCommentAttributeName" | "XmlDocCommentAttributeQuotes" | "XmlDocCommentAttributeValue" | "XmlDocCommentCDataSection" | "XmlDocCommentComment" | "XmlDocCommentDelimiter" | "XmlDocCommentEntityReference" | "XmlDocCommentName" | "XmlDocCommentProcessingInstruction" | "XmlDocCommentText" | "XmlLiteralAttributeName" | "XmlLiteralAttributeQuotes" | "XmlLiteralAttributeValue" | "XmlLiteralCDataSection" | "XmlLiteralComment" | "XmlLiteralDelimiter" | "XmlLiteralEmbeddedExpression" | "XmlLiteralEntityReference" | "XmlLiteralName" | "XmlLiteralProcessingInstruction" | "XmlLiteralText" | "RegexComment" | "RegexCharacterClass" | "RegexAnchor" | "RegexQuantifier" | "RegexGrouping" | "RegexAlternation" | "RegexText" | "RegexSelfEscapedCharacter" | "RegexOtherEscape";

export type SemanticHighlightModifier = "Static";

export class SemanticHighlightRequest extends Request implements ISemanticHighlightRequest {
    range?: Range | undefined;
    versionedText?: string | undefined;

    constructor(data?: ISemanticHighlightRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.range = _data["range"] ? Range.fromJS(_data["range"]) : <any>undefined;
            this.versionedText = _data["versionedText"];
        }
    }

    static fromJS(data: any): SemanticHighlightRequest {
        data = typeof data === 'object' ? data : {};
        let result = new SemanticHighlightRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["range"] = this.range ? this.range.toJSON() : <any>undefined;
        data["versionedText"] = this.versionedText;
        super.toJSON(data);
        return data;
    }

    clone(): SemanticHighlightRequest {
        const json = this.toJSON();
        let result = new SemanticHighlightRequest();
        result.init(json);
        return result;
    }
}

export interface ISemanticHighlightRequest extends IRequest {
    range?: Range | undefined;
    versionedText?: string | undefined;
}

export class Range implements IRange {
    start?: Point | undefined;
    end?: Point | undefined;

    constructor(data?: IRange) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.start = _data["start"] ? Point.fromJS(_data["start"]) : <any>undefined;
            this.end = _data["end"] ? Point.fromJS(_data["end"]) : <any>undefined;
        }
    }

    static fromJS(data: any): Range {
        data = typeof data === 'object' ? data : {};
        let result = new Range();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["start"] = this.start ? this.start.toJSON() : <any>undefined;
        data["end"] = this.end ? this.end.toJSON() : <any>undefined;
        return data;
    }

    clone(): Range {
        const json = this.toJSON();
        let result = new Range();
        result.init(json);
        return result;
    }
}

export interface IRange {
    start?: Point | undefined;
    end?: Point | undefined;
}

export class Point implements IPoint {
    line!: number;
    column!: number;

    constructor(data?: IPoint) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.line = _data["line"];
            this.column = _data["column"];
        }
    }

    static fromJS(data: any): Point {
        data = typeof data === 'object' ? data : {};
        let result = new Point();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["line"] = this.line;
        data["column"] = this.column;
        return data;
    }

    clone(): Point {
        const json = this.toJSON();
        let result = new Point();
        result.init(json);
        return result;
    }
}

export interface IPoint {
    line: number;
    column: number;
}

export class QuickFixResponse implements IQuickFixResponse {
    quickFixes?: QuickFix[] | undefined;

    constructor(data?: IQuickFixResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["quickFixes"])) {
                this.quickFixes = [] as any;
                for (let item of _data["quickFixes"])
                    this.quickFixes!.push(QuickFix.fromJS(item));
            }
        }
    }

    static fromJS(data: any): QuickFixResponse {
        data = typeof data === 'object' ? data : {};
        let result = new QuickFixResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.quickFixes)) {
            data["quickFixes"] = [];
            for (let item of this.quickFixes)
                data["quickFixes"].push(item.toJSON());
        }
        return data;
    }

    clone(): QuickFixResponse {
        const json = this.toJSON();
        let result = new QuickFixResponse();
        result.init(json);
        return result;
    }
}

export interface IQuickFixResponse {
    quickFixes?: QuickFix[] | undefined;
}

export class QuickFix implements IQuickFix {
    fileName?: string | undefined;
    line!: number;
    column!: number;
    endLine!: number;
    endColumn!: number;
    text?: string | undefined;
    projects?: string[] | undefined;

    constructor(data?: IQuickFix) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.fileName = _data["fileName"];
            this.line = _data["line"];
            this.column = _data["column"];
            this.endLine = _data["endLine"];
            this.endColumn = _data["endColumn"];
            this.text = _data["text"];
            if (Array.isArray(_data["projects"])) {
                this.projects = [] as any;
                for (let item of _data["projects"])
                    this.projects!.push(item);
            }
        }
    }

    static fromJS(data: any): QuickFix {
        data = typeof data === 'object' ? data : {};
        let result = new QuickFix();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["fileName"] = this.fileName;
        data["line"] = this.line;
        data["column"] = this.column;
        data["endLine"] = this.endLine;
        data["endColumn"] = this.endColumn;
        data["text"] = this.text;
        if (Array.isArray(this.projects)) {
            data["projects"] = [];
            for (let item of this.projects)
                data["projects"].push(item);
        }
        return data;
    }

    clone(): QuickFix {
        const json = this.toJSON();
        let result = new QuickFix();
        result.init(json);
        return result;
    }
}

export interface IQuickFix {
    fileName?: string | undefined;
    line: number;
    column: number;
    endLine: number;
    endColumn: number;
    text?: string | undefined;
    projects?: string[] | undefined;
}

export class FindImplementationsRequest extends Request implements IFindImplementationsRequest {

    constructor(data?: IFindImplementationsRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): FindImplementationsRequest {
        data = typeof data === 'object' ? data : {};
        let result = new FindImplementationsRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): FindImplementationsRequest {
        const json = this.toJSON();
        let result = new FindImplementationsRequest();
        result.init(json);
        return result;
    }
}

export interface IFindImplementationsRequest extends IRequest {
}

export class QuickInfoResponse implements IQuickInfoResponse {
    markdown!: string;

    constructor(data?: IQuickInfoResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.markdown = _data["markdown"];
        }
    }

    static fromJS(data: any): QuickInfoResponse {
        data = typeof data === 'object' ? data : {};
        let result = new QuickInfoResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["markdown"] = this.markdown;
        return data;
    }

    clone(): QuickInfoResponse {
        const json = this.toJSON();
        let result = new QuickInfoResponse();
        result.init(json);
        return result;
    }
}

export interface IQuickInfoResponse {
    markdown: string;
}

export class QuickInfoRequest extends Request implements IQuickInfoRequest {

    constructor(data?: IQuickInfoRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): QuickInfoRequest {
        data = typeof data === 'object' ? data : {};
        let result = new QuickInfoRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): QuickInfoRequest {
        const json = this.toJSON();
        let result = new QuickInfoRequest();
        result.init(json);
        return result;
    }
}

export interface IQuickInfoRequest extends IRequest {
}

export class SignatureHelpResponse implements ISignatureHelpResponse {
    signatures?: SignatureHelpItem[] | undefined;
    activeSignature!: number;
    activeParameter!: number;

    constructor(data?: ISignatureHelpResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["signatures"])) {
                this.signatures = [] as any;
                for (let item of _data["signatures"])
                    this.signatures!.push(SignatureHelpItem.fromJS(item));
            }
            this.activeSignature = _data["activeSignature"];
            this.activeParameter = _data["activeParameter"];
        }
    }

    static fromJS(data: any): SignatureHelpResponse {
        data = typeof data === 'object' ? data : {};
        let result = new SignatureHelpResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.signatures)) {
            data["signatures"] = [];
            for (let item of this.signatures)
                data["signatures"].push(item.toJSON());
        }
        data["activeSignature"] = this.activeSignature;
        data["activeParameter"] = this.activeParameter;
        return data;
    }

    clone(): SignatureHelpResponse {
        const json = this.toJSON();
        let result = new SignatureHelpResponse();
        result.init(json);
        return result;
    }
}

export interface ISignatureHelpResponse {
    signatures?: SignatureHelpItem[] | undefined;
    activeSignature: number;
    activeParameter: number;
}

export class SignatureHelpItem implements ISignatureHelpItem {
    name?: string | undefined;
    label?: string | undefined;
    documentation?: string | undefined;
    parameters?: SignatureHelpParameter[] | undefined;
    structuredDocumentation?: DocumentationComment | undefined;

    constructor(data?: ISignatureHelpItem) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.name = _data["name"];
            this.label = _data["label"];
            this.documentation = _data["documentation"];
            if (Array.isArray(_data["parameters"])) {
                this.parameters = [] as any;
                for (let item of _data["parameters"])
                    this.parameters!.push(SignatureHelpParameter.fromJS(item));
            }
            this.structuredDocumentation = _data["structuredDocumentation"] ? DocumentationComment.fromJS(_data["structuredDocumentation"]) : <any>undefined;
        }
    }

    static fromJS(data: any): SignatureHelpItem {
        data = typeof data === 'object' ? data : {};
        let result = new SignatureHelpItem();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["name"] = this.name;
        data["label"] = this.label;
        data["documentation"] = this.documentation;
        if (Array.isArray(this.parameters)) {
            data["parameters"] = [];
            for (let item of this.parameters)
                data["parameters"].push(item.toJSON());
        }
        data["structuredDocumentation"] = this.structuredDocumentation ? this.structuredDocumentation.toJSON() : <any>undefined;
        return data;
    }

    clone(): SignatureHelpItem {
        const json = this.toJSON();
        let result = new SignatureHelpItem();
        result.init(json);
        return result;
    }
}

export interface ISignatureHelpItem {
    name?: string | undefined;
    label?: string | undefined;
    documentation?: string | undefined;
    parameters?: SignatureHelpParameter[] | undefined;
    structuredDocumentation?: DocumentationComment | undefined;
}

export class SignatureHelpParameter implements ISignatureHelpParameter {
    name?: string | undefined;
    label?: string | undefined;
    documentation?: string | undefined;

    constructor(data?: ISignatureHelpParameter) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.name = _data["name"];
            this.label = _data["label"];
            this.documentation = _data["documentation"];
        }
    }

    static fromJS(data: any): SignatureHelpParameter {
        data = typeof data === 'object' ? data : {};
        let result = new SignatureHelpParameter();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["name"] = this.name;
        data["label"] = this.label;
        data["documentation"] = this.documentation;
        return data;
    }

    clone(): SignatureHelpParameter {
        const json = this.toJSON();
        let result = new SignatureHelpParameter();
        result.init(json);
        return result;
    }
}

export interface ISignatureHelpParameter {
    name?: string | undefined;
    label?: string | undefined;
    documentation?: string | undefined;
}

export class DocumentationComment implements IDocumentationComment {
    summaryText?: string | undefined;
    typeParamElements?: DocumentationItem[] | undefined;
    paramElements?: DocumentationItem[] | undefined;
    returnsText?: string | undefined;
    remarksText?: string | undefined;
    exampleText?: string | undefined;
    valueText?: string | undefined;
    exception?: DocumentationItem[] | undefined;

    constructor(data?: IDocumentationComment) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.summaryText = _data["summaryText"];
            if (Array.isArray(_data["typeParamElements"])) {
                this.typeParamElements = [] as any;
                for (let item of _data["typeParamElements"])
                    this.typeParamElements!.push(DocumentationItem.fromJS(item));
            }
            if (Array.isArray(_data["paramElements"])) {
                this.paramElements = [] as any;
                for (let item of _data["paramElements"])
                    this.paramElements!.push(DocumentationItem.fromJS(item));
            }
            this.returnsText = _data["returnsText"];
            this.remarksText = _data["remarksText"];
            this.exampleText = _data["exampleText"];
            this.valueText = _data["valueText"];
            if (Array.isArray(_data["exception"])) {
                this.exception = [] as any;
                for (let item of _data["exception"])
                    this.exception!.push(DocumentationItem.fromJS(item));
            }
        }
    }

    static fromJS(data: any): DocumentationComment {
        data = typeof data === 'object' ? data : {};
        let result = new DocumentationComment();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["summaryText"] = this.summaryText;
        if (Array.isArray(this.typeParamElements)) {
            data["typeParamElements"] = [];
            for (let item of this.typeParamElements)
                data["typeParamElements"].push(item.toJSON());
        }
        if (Array.isArray(this.paramElements)) {
            data["paramElements"] = [];
            for (let item of this.paramElements)
                data["paramElements"].push(item.toJSON());
        }
        data["returnsText"] = this.returnsText;
        data["remarksText"] = this.remarksText;
        data["exampleText"] = this.exampleText;
        data["valueText"] = this.valueText;
        if (Array.isArray(this.exception)) {
            data["exception"] = [];
            for (let item of this.exception)
                data["exception"].push(item.toJSON());
        }
        return data;
    }

    clone(): DocumentationComment {
        const json = this.toJSON();
        let result = new DocumentationComment();
        result.init(json);
        return result;
    }
}

export interface IDocumentationComment {
    summaryText?: string | undefined;
    typeParamElements?: DocumentationItem[] | undefined;
    paramElements?: DocumentationItem[] | undefined;
    returnsText?: string | undefined;
    remarksText?: string | undefined;
    exampleText?: string | undefined;
    valueText?: string | undefined;
    exception?: DocumentationItem[] | undefined;
}

export class DocumentationItem implements IDocumentationItem {
    name?: string | undefined;
    documentation?: string | undefined;

    constructor(data?: IDocumentationItem) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.name = _data["name"];
            this.documentation = _data["documentation"];
        }
    }

    static fromJS(data: any): DocumentationItem {
        data = typeof data === 'object' ? data : {};
        let result = new DocumentationItem();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["name"] = this.name;
        data["documentation"] = this.documentation;
        return data;
    }

    clone(): DocumentationItem {
        const json = this.toJSON();
        let result = new DocumentationItem();
        result.init(json);
        return result;
    }
}

export interface IDocumentationItem {
    name?: string | undefined;
    documentation?: string | undefined;
}

export class SignatureHelpRequest extends Request implements ISignatureHelpRequest {

    constructor(data?: ISignatureHelpRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): SignatureHelpRequest {
        data = typeof data === 'object' ? data : {};
        let result = new SignatureHelpRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): SignatureHelpRequest {
        const json = this.toJSON();
        let result = new SignatureHelpRequest();
        result.init(json);
        return result;
    }
}

export interface ISignatureHelpRequest extends IRequest {
}

export class FindUsagesRequest extends Request implements IFindUsagesRequest {
    onlyThisFile!: boolean;
    excludeDefinition!: boolean;

    constructor(data?: IFindUsagesRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.onlyThisFile = _data["onlyThisFile"];
            this.excludeDefinition = _data["excludeDefinition"];
        }
    }

    static fromJS(data: any): FindUsagesRequest {
        data = typeof data === 'object' ? data : {};
        let result = new FindUsagesRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["onlyThisFile"] = this.onlyThisFile;
        data["excludeDefinition"] = this.excludeDefinition;
        super.toJSON(data);
        return data;
    }

    clone(): FindUsagesRequest {
        const json = this.toJSON();
        let result = new FindUsagesRequest();
        result.init(json);
        return result;
    }
}

export interface IFindUsagesRequest extends IRequest {
    onlyThisFile: boolean;
    excludeDefinition: boolean;
}

export class CodeStructureResponse implements ICodeStructureResponse {
    elements?: CodeElement[] | undefined;

    constructor(data?: ICodeStructureResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["elements"])) {
                this.elements = [] as any;
                for (let item of _data["elements"])
                    this.elements!.push(CodeElement.fromJS(item));
            }
        }
    }

    static fromJS(data: any): CodeStructureResponse {
        data = typeof data === 'object' ? data : {};
        let result = new CodeStructureResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.elements)) {
            data["elements"] = [];
            for (let item of this.elements)
                data["elements"].push(item.toJSON());
        }
        return data;
    }

    clone(): CodeStructureResponse {
        const json = this.toJSON();
        let result = new CodeStructureResponse();
        result.init(json);
        return result;
    }
}

export interface ICodeStructureResponse {
    elements?: CodeElement[] | undefined;
}

export class CodeElement implements ICodeElement {
    kind!: string;
    name!: string;
    displayName!: string;
    children!: CodeElement[];
    ranges!: { [key: string]: Range; };
    properties!: { [key: string]: any; };

    constructor(data?: ICodeElement) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.children = [];
            this.ranges = {};
            this.properties = {};
        }
    }

    init(_data?: any) {
        if (_data) {
            this.kind = _data["kind"];
            this.name = _data["name"];
            this.displayName = _data["displayName"];
            if (Array.isArray(_data["children"])) {
                this.children = [] as any;
                for (let item of _data["children"])
                    this.children!.push(CodeElement.fromJS(item));
            }
            if (_data["ranges"]) {
                this.ranges = {} as any;
                for (let key in _data["ranges"]) {
                    if (_data["ranges"].hasOwnProperty(key))
                        (<any>this.ranges)![key] = _data["ranges"][key] ? Range.fromJS(_data["ranges"][key]) : new Range();
                }
            }
            if (_data["properties"]) {
                this.properties = {} as any;
                for (let key in _data["properties"]) {
                    if (_data["properties"].hasOwnProperty(key))
                        (<any>this.properties)![key] = _data["properties"][key];
                }
            }
        }
    }

    static fromJS(data: any): CodeElement {
        data = typeof data === 'object' ? data : {};
        let result = new CodeElement();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["kind"] = this.kind;
        data["name"] = this.name;
        data["displayName"] = this.displayName;
        if (Array.isArray(this.children)) {
            data["children"] = [];
            for (let item of this.children)
                data["children"].push(item.toJSON());
        }
        if (this.ranges) {
            data["ranges"] = {};
            for (let key in this.ranges) {
                if (this.ranges.hasOwnProperty(key))
                    (<any>data["ranges"])[key] = this.ranges[key] ? this.ranges[key].toJSON() : <any>undefined;
            }
        }
        if (this.properties) {
            data["properties"] = {};
            for (let key in this.properties) {
                if (this.properties.hasOwnProperty(key))
                    (<any>data["properties"])[key] = this.properties[key];
            }
        }
        return data;
    }

    clone(): CodeElement {
        const json = this.toJSON();
        let result = new CodeElement();
        result.init(json);
        return result;
    }
}

export interface ICodeElement {
    kind: string;
    name: string;
    displayName: string;
    children: CodeElement[];
    ranges: { [key: string]: Range; };
    properties: { [key: string]: any; };
}

export class InlayHintResponse implements IInlayHintResponse {
    inlayHints!: InlayHint[];

    constructor(data?: IInlayHintResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.inlayHints = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["inlayHints"])) {
                this.inlayHints = [] as any;
                for (let item of _data["inlayHints"])
                    this.inlayHints!.push(InlayHint.fromJS(item));
            }
        }
    }

    static fromJS(data: any): InlayHintResponse {
        data = typeof data === 'object' ? data : {};
        let result = new InlayHintResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.inlayHints)) {
            data["inlayHints"] = [];
            for (let item of this.inlayHints)
                data["inlayHints"].push(item.toJSON());
        }
        return data;
    }

    clone(): InlayHintResponse {
        const json = this.toJSON();
        let result = new InlayHintResponse();
        result.init(json);
        return result;
    }
}

export interface IInlayHintResponse {
    inlayHints: InlayHint[];
}

export class InlayHint implements IInlayHint {
    position!: Point;
    label!: string;
    tooltip?: string | undefined;
    textEdits?: LinePositionSpanTextChange[] | undefined;
    data!: ValueTupleOfStringAndInteger;

    constructor(data?: IInlayHint) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.position = new Point();
            this.data = new ValueTupleOfStringAndInteger();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.position = _data["position"] ? Point.fromJS(_data["position"]) : new Point();
            this.label = _data["label"];
            this.tooltip = _data["tooltip"];
            if (Array.isArray(_data["textEdits"])) {
                this.textEdits = [] as any;
                for (let item of _data["textEdits"])
                    this.textEdits!.push(LinePositionSpanTextChange.fromJS(item));
            }
            this.data = _data["data"] ? ValueTupleOfStringAndInteger.fromJS(_data["data"]) : new ValueTupleOfStringAndInteger();
        }
    }

    static fromJS(data: any): InlayHint {
        data = typeof data === 'object' ? data : {};
        let result = new InlayHint();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["position"] = this.position ? this.position.toJSON() : <any>undefined;
        data["label"] = this.label;
        data["tooltip"] = this.tooltip;
        if (Array.isArray(this.textEdits)) {
            data["textEdits"] = [];
            for (let item of this.textEdits)
                data["textEdits"].push(item.toJSON());
        }
        data["data"] = this.data ? this.data.toJSON() : <any>undefined;
        return data;
    }

    clone(): InlayHint {
        const json = this.toJSON();
        let result = new InlayHint();
        result.init(json);
        return result;
    }
}

export interface IInlayHint {
    position: Point;
    label: string;
    tooltip?: string | undefined;
    textEdits?: LinePositionSpanTextChange[] | undefined;
    data: ValueTupleOfStringAndInteger;
}

export class ValueTupleOfStringAndInteger implements IValueTupleOfStringAndInteger {
    item1!: string;
    item2!: number;

    constructor(data?: IValueTupleOfStringAndInteger) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.item1 = _data["item1"];
            this.item2 = _data["item2"];
        }
    }

    static fromJS(data: any): ValueTupleOfStringAndInteger {
        data = typeof data === 'object' ? data : {};
        let result = new ValueTupleOfStringAndInteger();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["item1"] = this.item1;
        data["item2"] = this.item2;
        return data;
    }

    clone(): ValueTupleOfStringAndInteger {
        const json = this.toJSON();
        let result = new ValueTupleOfStringAndInteger();
        result.init(json);
        return result;
    }
}

export interface IValueTupleOfStringAndInteger {
    item1: string;
    item2: number;
}

export class InlayHintRequest implements IInlayHintRequest {
    location!: Location;

    constructor(data?: IInlayHintRequest) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.location = new Location();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.location = _data["location"] ? Location.fromJS(_data["location"]) : new Location();
        }
    }

    static fromJS(data: any): InlayHintRequest {
        data = typeof data === 'object' ? data : {};
        let result = new InlayHintRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["location"] = this.location ? this.location.toJSON() : <any>undefined;
        return data;
    }

    clone(): InlayHintRequest {
        const json = this.toJSON();
        let result = new InlayHintRequest();
        result.init(json);
        return result;
    }
}

export interface IInlayHintRequest {
    location: Location;
}

export class Location implements ILocation {
    fileName!: string;
    range!: Range;

    constructor(data?: ILocation) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.range = new Range();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.fileName = _data["fileName"];
            this.range = _data["range"] ? Range.fromJS(_data["range"]) : new Range();
        }
    }

    static fromJS(data: any): Location {
        data = typeof data === 'object' ? data : {};
        let result = new Location();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["fileName"] = this.fileName;
        data["range"] = this.range ? this.range.toJSON() : <any>undefined;
        return data;
    }

    clone(): Location {
        const json = this.toJSON();
        let result = new Location();
        result.init(json);
        return result;
    }
}

export interface ILocation {
    fileName: string;
    range: Range;
}

export class InlayHintResolveRequest2 implements IInlayHintResolveRequest2 {
    hint?: InlayHint | undefined;

    constructor(data?: IInlayHintResolveRequest2) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.hint = _data["hint"] ? InlayHint.fromJS(_data["hint"]) : <any>undefined;
        }
    }

    static fromJS(data: any): InlayHintResolveRequest2 {
        data = typeof data === 'object' ? data : {};
        let result = new InlayHintResolveRequest2();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["hint"] = this.hint ? this.hint.toJSON() : <any>undefined;
        return data;
    }

    clone(): InlayHintResolveRequest2 {
        const json = this.toJSON();
        let result = new InlayHintResolveRequest2();
        result.init(json);
        return result;
    }
}

export interface IInlayHintResolveRequest2 {
    hint?: InlayHint | undefined;
}

export class InlayHintResolveRequest extends InlayHintResolveRequest2 implements IInlayHintResolveRequest {
    hint!: InlayHint2;

    constructor(data?: IInlayHintResolveRequest) {
        super(data);
        if (!data) {
            this.hint = new InlayHint2();
        }
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.hint = _data["hint"] ? InlayHint2.fromJS(_data["hint"]) : new InlayHint2();
        }
    }

    static fromJS(data: any): InlayHintResolveRequest {
        data = typeof data === 'object' ? data : {};
        let result = new InlayHintResolveRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["hint"] = this.hint ? this.hint.toJSON() : <any>undefined;
        super.toJSON(data);
        return data;
    }

    clone(): InlayHintResolveRequest {
        const json = this.toJSON();
        let result = new InlayHintResolveRequest();
        result.init(json);
        return result;
    }
}

export interface IInlayHintResolveRequest extends IInlayHintResolveRequest2 {
    hint: InlayHint2;
}

export class InlayHint2 implements IInlayHint2 {
    position!: Point;
    label!: string;
    tooltip?: string | undefined;
    data!: InlayHintData;

    constructor(data?: IInlayHint2) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.position = new Point();
            this.data = new InlayHintData();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.position = _data["position"] ? Point.fromJS(_data["position"]) : new Point();
            this.label = _data["label"];
            this.tooltip = _data["tooltip"];
            this.data = _data["data"] ? InlayHintData.fromJS(_data["data"]) : new InlayHintData();
        }
    }

    static fromJS(data: any): InlayHint2 {
        data = typeof data === 'object' ? data : {};
        let result = new InlayHint2();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["position"] = this.position ? this.position.toJSON() : <any>undefined;
        data["label"] = this.label;
        data["tooltip"] = this.tooltip;
        data["data"] = this.data ? this.data.toJSON() : <any>undefined;
        return data;
    }

    clone(): InlayHint2 {
        const json = this.toJSON();
        let result = new InlayHint2();
        result.init(json);
        return result;
    }
}

export interface IInlayHint2 {
    position: Point;
    label: string;
    tooltip?: string | undefined;
    data: InlayHintData;
}

export class InlayHintData implements IInlayHintData {
    item1!: string;
    item2!: number;

    constructor(data?: IInlayHintData) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.item1 = _data["item1"];
            this.item2 = _data["item2"];
        }
    }

    static fromJS(data: any): InlayHintData {
        data = typeof data === 'object' ? data : {};
        let result = new InlayHintData();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["item1"] = this.item1;
        data["item2"] = this.item2;
        return data;
    }

    clone(): InlayHintData {
        const json = this.toJSON();
        let result = new InlayHintData();
        result.init(json);
        return result;
    }
}

export interface IInlayHintData {
    item1: string;
    item2: number;
}

export class GetCodeActionsResponse implements IGetCodeActionsResponse {
    codeActions?: OmniSharpCodeAction[] | undefined;

    constructor(data?: IGetCodeActionsResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["codeActions"])) {
                this.codeActions = [] as any;
                for (let item of _data["codeActions"])
                    this.codeActions!.push(OmniSharpCodeAction.fromJS(item));
            }
        }
    }

    static fromJS(data: any): GetCodeActionsResponse {
        data = typeof data === 'object' ? data : {};
        let result = new GetCodeActionsResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.codeActions)) {
            data["codeActions"] = [];
            for (let item of this.codeActions)
                data["codeActions"].push(item.toJSON());
        }
        return data;
    }

    clone(): GetCodeActionsResponse {
        const json = this.toJSON();
        let result = new GetCodeActionsResponse();
        result.init(json);
        return result;
    }
}

export interface IGetCodeActionsResponse {
    codeActions?: OmniSharpCodeAction[] | undefined;
}

export class OmniSharpCodeAction implements IOmniSharpCodeAction {
    identifier?: string | undefined;
    name?: string | undefined;
    codeActionKind?: string | undefined;

    constructor(data?: IOmniSharpCodeAction) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.identifier = _data["identifier"];
            this.name = _data["name"];
            this.codeActionKind = _data["codeActionKind"];
        }
    }

    static fromJS(data: any): OmniSharpCodeAction {
        data = typeof data === 'object' ? data : {};
        let result = new OmniSharpCodeAction();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["identifier"] = this.identifier;
        data["name"] = this.name;
        data["codeActionKind"] = this.codeActionKind;
        return data;
    }

    clone(): OmniSharpCodeAction {
        const json = this.toJSON();
        let result = new OmniSharpCodeAction();
        result.init(json);
        return result;
    }
}

export interface IOmniSharpCodeAction {
    identifier?: string | undefined;
    name?: string | undefined;
    codeActionKind?: string | undefined;
}

export class GetCodeActionsRequest extends Request implements IGetCodeActionsRequest {
    selection?: Range | undefined;

    constructor(data?: IGetCodeActionsRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.selection = _data["selection"] ? Range.fromJS(_data["selection"]) : <any>undefined;
        }
    }

    static fromJS(data: any): GetCodeActionsRequest {
        data = typeof data === 'object' ? data : {};
        let result = new GetCodeActionsRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["selection"] = this.selection ? this.selection.toJSON() : <any>undefined;
        super.toJSON(data);
        return data;
    }

    clone(): GetCodeActionsRequest {
        const json = this.toJSON();
        let result = new GetCodeActionsRequest();
        result.init(json);
        return result;
    }
}

export interface IGetCodeActionsRequest extends IRequest {
    selection?: Range | undefined;
}

export class RunCodeActionResponse implements IRunCodeActionResponse {
    changes?: FileOperationResponse[] | undefined;

    constructor(data?: IRunCodeActionResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["changes"])) {
                this.changes = [] as any;
                for (let item of _data["changes"])
                    this.changes!.push(FileOperationResponse.fromJS(item));
            }
        }
    }

    static fromJS(data: any): RunCodeActionResponse {
        data = typeof data === 'object' ? data : {};
        let result = new RunCodeActionResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.changes)) {
            data["changes"] = [];
            for (let item of this.changes)
                data["changes"].push(item.toJSON());
        }
        return data;
    }

    clone(): RunCodeActionResponse {
        const json = this.toJSON();
        let result = new RunCodeActionResponse();
        result.init(json);
        return result;
    }
}

export interface IRunCodeActionResponse {
    changes?: FileOperationResponse[] | undefined;
}

export abstract class FileOperationResponse implements IFileOperationResponse {
    fileName!: string;
    modificationType!: FileModificationType;

    protected _discriminator: string;

    constructor(data?: IFileOperationResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        this._discriminator = "FileOperationResponse";
    }

    init(_data?: any) {
        if (_data) {
            this.fileName = _data["fileName"];
            this.modificationType = _data["modificationType"];
        }
    }

    static fromJS(data: any): FileOperationResponse {
        data = typeof data === 'object' ? data : {};
        if (data["discriminator"] === "ModifiedFileResponse") {
            let result = new ModifiedFileResponse();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "OpenFileResponse") {
            let result = new OpenFileResponse();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "RenamedFileResponse") {
            let result = new RenamedFileResponse();
            result.init(data);
            return result;
        }
        throw new Error("The abstract class 'FileOperationResponse' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["discriminator"] = this._discriminator;
        data["fileName"] = this.fileName;
        data["modificationType"] = this.modificationType;
        return data;
    }

    clone(): FileOperationResponse {
        throw new Error("The abstract class 'FileOperationResponse' cannot be instantiated.");
    }
}

export interface IFileOperationResponse {
    fileName: string;
    modificationType: FileModificationType;
}

export type FileModificationType = "Modified" | "Opened" | "Renamed";

export class ModifiedFileResponse extends FileOperationResponse implements IModifiedFileResponse {
    buffer!: string;
    changes!: LinePositionSpanTextChange[];

    constructor(data?: IModifiedFileResponse) {
        super(data);
        if (!data) {
            this.changes = [];
        }
        this._discriminator = "ModifiedFileResponse";
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.buffer = _data["buffer"];
            if (Array.isArray(_data["changes"])) {
                this.changes = [] as any;
                for (let item of _data["changes"])
                    this.changes!.push(LinePositionSpanTextChange.fromJS(item));
            }
        }
    }

    static fromJS(data: any): ModifiedFileResponse {
        data = typeof data === 'object' ? data : {};
        let result = new ModifiedFileResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["buffer"] = this.buffer;
        if (Array.isArray(this.changes)) {
            data["changes"] = [];
            for (let item of this.changes)
                data["changes"].push(item.toJSON());
        }
        super.toJSON(data);
        return data;
    }

    clone(): ModifiedFileResponse {
        const json = this.toJSON();
        let result = new ModifiedFileResponse();
        result.init(json);
        return result;
    }
}

export interface IModifiedFileResponse extends IFileOperationResponse {
    buffer: string;
    changes: LinePositionSpanTextChange[];
}

export class OpenFileResponse extends FileOperationResponse implements IOpenFileResponse {

    constructor(data?: IOpenFileResponse) {
        super(data);
        this._discriminator = "OpenFileResponse";
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): OpenFileResponse {
        data = typeof data === 'object' ? data : {};
        let result = new OpenFileResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): OpenFileResponse {
        const json = this.toJSON();
        let result = new OpenFileResponse();
        result.init(json);
        return result;
    }
}

export interface IOpenFileResponse extends IFileOperationResponse {
}

export class RenamedFileResponse extends FileOperationResponse implements IRenamedFileResponse {
    newFileName!: string;

    constructor(data?: IRenamedFileResponse) {
        super(data);
        this._discriminator = "RenamedFileResponse";
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.newFileName = _data["newFileName"];
        }
    }

    static fromJS(data: any): RenamedFileResponse {
        data = typeof data === 'object' ? data : {};
        let result = new RenamedFileResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["newFileName"] = this.newFileName;
        super.toJSON(data);
        return data;
    }

    clone(): RenamedFileResponse {
        const json = this.toJSON();
        let result = new RenamedFileResponse();
        result.init(json);
        return result;
    }
}

export interface IRenamedFileResponse extends IFileOperationResponse {
    newFileName: string;
}

export class RunCodeActionRequest extends Request implements IRunCodeActionRequest {
    identifier?: string | undefined;
    selection?: Range | undefined;
    wantsTextChanges!: boolean;
    applyTextChanges!: boolean;
    wantsAllCodeActionOperations!: boolean;

    constructor(data?: IRunCodeActionRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.identifier = _data["identifier"];
            this.selection = _data["selection"] ? Range.fromJS(_data["selection"]) : <any>undefined;
            this.wantsTextChanges = _data["wantsTextChanges"];
            this.applyTextChanges = _data["applyTextChanges"];
            this.wantsAllCodeActionOperations = _data["wantsAllCodeActionOperations"];
        }
    }

    static fromJS(data: any): RunCodeActionRequest {
        data = typeof data === 'object' ? data : {};
        let result = new RunCodeActionRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["identifier"] = this.identifier;
        data["selection"] = this.selection ? this.selection.toJSON() : <any>undefined;
        data["wantsTextChanges"] = this.wantsTextChanges;
        data["applyTextChanges"] = this.applyTextChanges;
        data["wantsAllCodeActionOperations"] = this.wantsAllCodeActionOperations;
        super.toJSON(data);
        return data;
    }

    clone(): RunCodeActionRequest {
        const json = this.toJSON();
        let result = new RunCodeActionRequest();
        result.init(json);
        return result;
    }
}

export interface IRunCodeActionRequest extends IRequest {
    identifier?: string | undefined;
    selection?: Range | undefined;
    wantsTextChanges: boolean;
    applyTextChanges: boolean;
    wantsAllCodeActionOperations: boolean;
}

export class CodeCheckRequest extends Request implements ICodeCheckRequest {

    constructor(data?: ICodeCheckRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): CodeCheckRequest {
        data = typeof data === 'object' ? data : {};
        let result = new CodeCheckRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): CodeCheckRequest {
        const json = this.toJSON();
        let result = new CodeCheckRequest();
        result.init(json);
        return result;
    }
}

export interface ICodeCheckRequest extends IRequest {
}

export class BlockStructureResponse implements IBlockStructureResponse {
    spans!: CodeFoldingBlock[];

    constructor(data?: IBlockStructureResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.spans = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["spans"])) {
                this.spans = [] as any;
                for (let item of _data["spans"])
                    this.spans!.push(CodeFoldingBlock.fromJS(item));
            }
        }
    }

    static fromJS(data: any): BlockStructureResponse {
        data = typeof data === 'object' ? data : {};
        let result = new BlockStructureResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.spans)) {
            data["spans"] = [];
            for (let item of this.spans)
                data["spans"].push(item.toJSON());
        }
        return data;
    }

    clone(): BlockStructureResponse {
        const json = this.toJSON();
        let result = new BlockStructureResponse();
        result.init(json);
        return result;
    }
}

export interface IBlockStructureResponse {
    spans: CodeFoldingBlock[];
}

export class CodeFoldingBlock implements ICodeFoldingBlock {
    range!: Range;
    kind?: string | undefined;

    constructor(data?: ICodeFoldingBlock) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.range = new Range();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.range = _data["range"] ? Range.fromJS(_data["range"]) : new Range();
            this.kind = _data["kind"];
        }
    }

    static fromJS(data: any): CodeFoldingBlock {
        data = typeof data === 'object' ? data : {};
        let result = new CodeFoldingBlock();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["range"] = this.range ? this.range.toJSON() : <any>undefined;
        data["kind"] = this.kind;
        return data;
    }

    clone(): CodeFoldingBlock {
        const json = this.toJSON();
        let result = new CodeFoldingBlock();
        result.init(json);
        return result;
    }
}

export interface ICodeFoldingBlock {
    range: Range;
    kind?: string | undefined;
}

export class RenameResponse implements IRenameResponse {
    changes?: ModifiedFileResponse[] | undefined;
    errorMessage?: string | undefined;

    constructor(data?: IRenameResponse) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["changes"])) {
                this.changes = [] as any;
                for (let item of _data["changes"])
                    this.changes!.push(ModifiedFileResponse.fromJS(item));
            }
            this.errorMessage = _data["errorMessage"];
        }
    }

    static fromJS(data: any): RenameResponse {
        data = typeof data === 'object' ? data : {};
        let result = new RenameResponse();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.changes)) {
            data["changes"] = [];
            for (let item of this.changes)
                data["changes"].push(item.toJSON());
        }
        data["errorMessage"] = this.errorMessage;
        return data;
    }

    clone(): RenameResponse {
        const json = this.toJSON();
        let result = new RenameResponse();
        result.init(json);
        return result;
    }
}

export interface IRenameResponse {
    changes?: ModifiedFileResponse[] | undefined;
    errorMessage?: string | undefined;
}

export class RenameRequest extends Request implements IRenameRequest {
    wantsTextChanges!: boolean;
    applyTextChanges!: boolean;
    renameTo?: string | undefined;

    constructor(data?: IRenameRequest) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.wantsTextChanges = _data["wantsTextChanges"];
            this.applyTextChanges = _data["applyTextChanges"];
            this.renameTo = _data["renameTo"];
        }
    }

    static fromJS(data: any): RenameRequest {
        data = typeof data === 'object' ? data : {};
        let result = new RenameRequest();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["wantsTextChanges"] = this.wantsTextChanges;
        data["applyTextChanges"] = this.applyTextChanges;
        data["renameTo"] = this.renameTo;
        super.toJSON(data);
        return data;
    }

    clone(): RenameRequest {
        const json = this.toJSON();
        let result = new RenameRequest();
        result.init(json);
        return result;
    }
}

export interface IRenameRequest extends IRequest {
    wantsTextChanges: boolean;
    applyTextChanges: boolean;
    renameTo?: string | undefined;
}

export class Types implements ITypes {
    omniSharpDiagnosticsEvent?: OmniSharpDiagnosticsEvent | undefined;
    omniSharpAsyncBufferUpdateCompletedEvent?: OmniSharpAsyncBufferUpdateCompletedEvent | undefined;

    constructor(data?: ITypes) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.omniSharpDiagnosticsEvent = _data["omniSharpDiagnosticsEvent"] ? OmniSharpDiagnosticsEvent.fromJS(_data["omniSharpDiagnosticsEvent"]) : <any>undefined;
            this.omniSharpAsyncBufferUpdateCompletedEvent = _data["omniSharpAsyncBufferUpdateCompletedEvent"] ? OmniSharpAsyncBufferUpdateCompletedEvent.fromJS(_data["omniSharpAsyncBufferUpdateCompletedEvent"]) : <any>undefined;
        }
    }

    static fromJS(data: any): Types {
        data = typeof data === 'object' ? data : {};
        let result = new Types();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["omniSharpDiagnosticsEvent"] = this.omniSharpDiagnosticsEvent ? this.omniSharpDiagnosticsEvent.toJSON() : <any>undefined;
        data["omniSharpAsyncBufferUpdateCompletedEvent"] = this.omniSharpAsyncBufferUpdateCompletedEvent ? this.omniSharpAsyncBufferUpdateCompletedEvent.toJSON() : <any>undefined;
        return data;
    }

    clone(): Types {
        const json = this.toJSON();
        let result = new Types();
        result.init(json);
        return result;
    }
}

export interface ITypes {
    omniSharpDiagnosticsEvent?: OmniSharpDiagnosticsEvent | undefined;
    omniSharpAsyncBufferUpdateCompletedEvent?: OmniSharpAsyncBufferUpdateCompletedEvent | undefined;
}

export class OmniSharpDiagnosticsEvent implements IOmniSharpDiagnosticsEvent {
    scriptId!: string;
    diagnostics!: DiagnosticMessage;

    constructor(data?: IOmniSharpDiagnosticsEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.diagnostics = new DiagnosticMessage();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.scriptId = _data["scriptId"];
            this.diagnostics = _data["diagnostics"] ? DiagnosticMessage.fromJS(_data["diagnostics"]) : new DiagnosticMessage();
        }
    }

    static fromJS(data: any): OmniSharpDiagnosticsEvent {
        data = typeof data === 'object' ? data : {};
        let result = new OmniSharpDiagnosticsEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["scriptId"] = this.scriptId;
        data["diagnostics"] = this.diagnostics ? this.diagnostics.toJSON() : <any>undefined;
        return data;
    }

    clone(): OmniSharpDiagnosticsEvent {
        const json = this.toJSON();
        let result = new OmniSharpDiagnosticsEvent();
        result.init(json);
        return result;
    }
}

export interface IOmniSharpDiagnosticsEvent {
    scriptId: string;
    diagnostics: DiagnosticMessage;
}

export class DiagnosticMessage implements IDiagnosticMessage {
    results?: DiagnosticResult[] | undefined;

    constructor(data?: IDiagnosticMessage) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["results"])) {
                this.results = [] as any;
                for (let item of _data["results"])
                    this.results!.push(DiagnosticResult.fromJS(item));
            }
        }
    }

    static fromJS(data: any): DiagnosticMessage {
        data = typeof data === 'object' ? data : {};
        let result = new DiagnosticMessage();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.results)) {
            data["results"] = [];
            for (let item of this.results)
                data["results"].push(item.toJSON());
        }
        return data;
    }

    clone(): DiagnosticMessage {
        const json = this.toJSON();
        let result = new DiagnosticMessage();
        result.init(json);
        return result;
    }
}

export interface IDiagnosticMessage {
    results?: DiagnosticResult[] | undefined;
}

export class DiagnosticResult implements IDiagnosticResult {
    fileName?: string | undefined;
    quickFixes?: DiagnosticLocation[] | undefined;

    constructor(data?: IDiagnosticResult) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.fileName = _data["fileName"];
            if (Array.isArray(_data["quickFixes"])) {
                this.quickFixes = [] as any;
                for (let item of _data["quickFixes"])
                    this.quickFixes!.push(DiagnosticLocation.fromJS(item));
            }
        }
    }

    static fromJS(data: any): DiagnosticResult {
        data = typeof data === 'object' ? data : {};
        let result = new DiagnosticResult();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["fileName"] = this.fileName;
        if (Array.isArray(this.quickFixes)) {
            data["quickFixes"] = [];
            for (let item of this.quickFixes)
                data["quickFixes"].push(item.toJSON());
        }
        return data;
    }

    clone(): DiagnosticResult {
        const json = this.toJSON();
        let result = new DiagnosticResult();
        result.init(json);
        return result;
    }
}

export interface IDiagnosticResult {
    fileName?: string | undefined;
    quickFixes?: DiagnosticLocation[] | undefined;
}

export class DiagnosticLocation extends QuickFix implements IDiagnosticLocation {
    logLevel?: string | undefined;
    id?: string | undefined;
    tags?: string[] | undefined;

    constructor(data?: IDiagnosticLocation) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.logLevel = _data["logLevel"];
            this.id = _data["id"];
            if (Array.isArray(_data["tags"])) {
                this.tags = [] as any;
                for (let item of _data["tags"])
                    this.tags!.push(item);
            }
        }
    }

    static fromJS(data: any): DiagnosticLocation {
        data = typeof data === 'object' ? data : {};
        let result = new DiagnosticLocation();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["logLevel"] = this.logLevel;
        data["id"] = this.id;
        if (Array.isArray(this.tags)) {
            data["tags"] = [];
            for (let item of this.tags)
                data["tags"].push(item);
        }
        super.toJSON(data);
        return data;
    }

    clone(): DiagnosticLocation {
        const json = this.toJSON();
        let result = new DiagnosticLocation();
        result.init(json);
        return result;
    }
}

export interface IDiagnosticLocation extends IQuickFix {
    logLevel?: string | undefined;
    id?: string | undefined;
    tags?: string[] | undefined;
}

export class OmniSharpAsyncBufferUpdateCompletedEvent implements IOmniSharpAsyncBufferUpdateCompletedEvent {
    scriptId!: string;

    constructor(data?: IOmniSharpAsyncBufferUpdateCompletedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.scriptId = _data["scriptId"];
        }
    }

    static fromJS(data: any): OmniSharpAsyncBufferUpdateCompletedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new OmniSharpAsyncBufferUpdateCompletedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["scriptId"] = this.scriptId;
        return data;
    }

    clone(): OmniSharpAsyncBufferUpdateCompletedEvent {
        const json = this.toJSON();
        let result = new OmniSharpAsyncBufferUpdateCompletedEvent();
        result.init(json);
        return result;
    }
}

export interface IOmniSharpAsyncBufferUpdateCompletedEvent {
    scriptId: string;
}

export class ApiException extends Error {
    message: string;
    status: number;
    response: string;
    headers: { [key: string]: any; };
    result: any;

    constructor(message: string, status: number, response: string, headers: { [key: string]: any; }, result: any) {
        super();

        this.message = message;
        this.status = status;
        this.response = response;
        this.headers = headers;
        this.result = result;
    }

    protected isApiException = true;

    private _errorResponse: ErrorResult | undefined | null;
    public get errorResponse(): ErrorResult | undefined {
        if (this._errorResponse !== undefined)
            return this._errorResponse || undefined;

        if (!this.response) {
            this._errorResponse = null;
            return undefined;
        }

        try {
            this._errorResponse = JSON.parse(this.response) as ErrorResult;
            return this._errorResponse;
        } catch {
            this._errorResponse = null;
            return undefined;
        }
    }

    static isApiException(obj: any): obj is ApiException {
        return obj.isApiException === true;
    }
}

function throwException(message: string, status: number, response: string, headers: { [key: string]: any; }, result?: any): any {
    if (result !== null && result !== undefined)
        throw result;
    else
        throw new ApiException(message, status, response, headers, null);
}
