import {DI} from "aurelia";
import {IWindowApiClient} from "@application";
import {WindowState} from "./window-state";

export interface IWindowService extends IWindowApiClient {
    getState(): Promise<WindowState>;

    close(): Promise<void>;

    maximize(): Promise<void>;

    minimize(): Promise<void>;

    zoomIn(): Promise<void>;

    zoomOut(): Promise<void>;

    resetZoom(): Promise<void>;

    toggleFullScreen(): Promise<void>;

    toggleAlwaysOnTop(): Promise<void>;

    toggleDeveloperTools(): Promise<void>;
}

export const IWindowService = DI.createInterface<IWindowService>();
