// @ts-nocheck
/* tslint:disable */
/* eslint-disable */
//----------------------
// <auto-generated>
//     Generated using the NSwag toolchain v13.15.5.0 (NJsonSchema v10.6.6.0 (Newtonsoft.Json v13.0.0.0)) (http://NSwag.org)
// </auto-generated>
//----------------------
// ReSharper disable InconsistentNaming
import {IHttpClient} from "@aurelia/fetch-client";
import {ApiClientBase} from "@application/api-client-base";


export interface IAppApiClient {

    getIdentifier(signal?: AbortSignal | undefined): Promise<AppIdentifier>;

    getLatestVersion(signal?: AbortSignal | undefined): Promise<string>;

    notifyClientAppIsReady(signal?: AbortSignal | undefined): Promise<void>;

    checkDependencies(signal?: AbortSignal | undefined): Promise<AppDependencyCheckResult>;

    openFolderContainingScript(scriptPath: string | null | undefined, signal?: AbortSignal | undefined): Promise<void>;

    openScriptsFolder(path: string | null | undefined, signal?: AbortSignal | undefined): Promise<void>;

    openPackageCacheFolder(signal?: AbortSignal | undefined): Promise<void>;

    sendRemoteLog(source: LogSource, logs: RemoteLogMessage[], signal?: AbortSignal | undefined): Promise<void>;
}

export class AppApiClient extends ApiClientBase implements IAppApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    getIdentifier(signal?: AbortSignal | undefined): Promise<AppIdentifier> {
        let url_ = this.baseUrl + "/app/identifier";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetIdentifier(_response);
        });
    }

    protected processGetIdentifier(response: Response): Promise<AppIdentifier> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = AppIdentifier.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<AppIdentifier>(<any>null);
    }

    getLatestVersion(signal?: AbortSignal | undefined): Promise<string> {
        let url_ = this.baseUrl + "/app/latest-version";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetLatestVersion(_response);
        });
    }

    protected processGetLatestVersion(response: Response): Promise<string> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = resultData200 !== undefined ? resultData200 : <any>null;
    
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<string>(<any>null);
    }

    notifyClientAppIsReady(signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/app/client/ready";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "POST",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processNotifyClientAppIsReady(_response);
        });
    }

    protected processNotifyClientAppIsReady(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    checkDependencies(signal?: AbortSignal | undefined): Promise<AppDependencyCheckResult> {
        let url_ = this.baseUrl + "/app/check-dependencies";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processCheckDependencies(_response);
        });
    }

    protected processCheckDependencies(response: Response): Promise<AppDependencyCheckResult> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = AppDependencyCheckResult.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<AppDependencyCheckResult>(<any>null);
    }

    openFolderContainingScript(scriptPath: string | null | undefined, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/app/open-folder-containing-script?";
        if (scriptPath !== undefined && scriptPath !== null)
            url_ += "scriptPath=" + encodeURIComponent("" + scriptPath) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processOpenFolderContainingScript(_response);
        });
    }

    protected processOpenFolderContainingScript(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    openScriptsFolder(path: string | null | undefined, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/app/open-scripts-folder?";
        if (path !== undefined && path !== null)
            url_ += "path=" + encodeURIComponent("" + path) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processOpenScriptsFolder(_response);
        });
    }

    protected processOpenScriptsFolder(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    openPackageCacheFolder(signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/app/open-package-cache-folder";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processOpenPackageCacheFolder(_response);
        });
    }

    protected processOpenPackageCacheFolder(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    sendRemoteLog(source: LogSource, logs: RemoteLogMessage[], signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/app/log/{source}";
        if (source === undefined || source === null)
            throw new Error("The parameter 'source' must be defined.");
        url_ = url_.replace("{source}", encodeURIComponent("" + source));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(logs);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processSendRemoteLog(_response);
        });
    }

    protected processSendRemoteLog(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }
}

export interface IAssembliesApiClient {

    getNamespaces(reference: Reference, signal?: AbortSignal | undefined): Promise<string[]>;
}

export class AssembliesApiClient extends ApiClientBase implements IAssembliesApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    getNamespaces(reference: Reference, signal?: AbortSignal | undefined): Promise<string[]> {
        let url_ = this.baseUrl + "/assemblies/namespaces";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(reference);

        let options_ = <RequestInit>{
            body: content_,
            method: "PATCH",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetNamespaces(_response);
        });
    }

    protected processGetNamespaces(response: Response): Promise<string[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (Array.isArray(resultData200)) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(item);
            }
            else {
                result200 = <any>null;
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<string[]>(<any>null);
    }
}

export interface ICodeApiClient {

    getSyntaxTree(scriptId: string, signal?: AbortSignal | undefined): Promise<SyntaxNodeOrTokenSlim>;
}

export class CodeApiClient extends ApiClientBase implements ICodeApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    getSyntaxTree(scriptId: string, signal?: AbortSignal | undefined): Promise<SyntaxNodeOrTokenSlim> {
        let url_ = this.baseUrl + "/code/{scriptId}/syntax-tree";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetSyntaxTree(_response);
        });
    }

    protected processGetSyntaxTree(response: Response): Promise<SyntaxNodeOrTokenSlim> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = SyntaxNodeOrTokenSlim.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<SyntaxNodeOrTokenSlim>(<any>null);
    }
}

export interface IDataConnectionsApiClient {

    openDataConnectionWindow(dataConnectionId: string | null | undefined, copy: boolean | undefined, signal?: AbortSignal | undefined): Promise<void>;

    getAll(signal?: AbortSignal | undefined): Promise<DataConnection[]>;

    save(dataConnection: DataConnection, signal?: AbortSignal | undefined): Promise<void>;

    get(id: string, signal?: AbortSignal | undefined): Promise<DataConnection>;

    delete(id: string, signal?: AbortSignal | undefined): Promise<void>;

    getAllNames(signal?: AbortSignal | undefined): Promise<string[]>;

    refresh(id: string, signal?: AbortSignal | undefined): Promise<void>;

    getConnectionString(dataConnection: DataConnection, signal?: AbortSignal | undefined): Promise<string>;

    test(dataConnection: DataConnection, signal?: AbortSignal | undefined): Promise<DataConnectionTestResult>;

    protectPassword(unprotectedPassword: string, signal?: AbortSignal | undefined): Promise<string | null>;

    getDatabases(dataConnection: DataConnection, signal?: AbortSignal | undefined): Promise<string[]>;

    getDatabaseStructure(id: string, signal?: AbortSignal | undefined): Promise<DatabaseStructure>;
}

export class DataConnectionsApiClient extends ApiClientBase implements IDataConnectionsApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    openDataConnectionWindow(dataConnectionId: string | null | undefined, copy: boolean | undefined, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/data-connections/open?";
        if (dataConnectionId !== undefined && dataConnectionId !== null)
            url_ += "dataConnectionId=" + encodeURIComponent("" + dataConnectionId) + "&";
        if (copy === null)
            throw new Error("The parameter 'copy' cannot be null.");
        else if (copy !== undefined)
            url_ += "copy=" + encodeURIComponent("" + copy) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processOpenDataConnectionWindow(_response);
        });
    }

    protected processOpenDataConnectionWindow(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    getAll(signal?: AbortSignal | undefined): Promise<DataConnection[]> {
        let url_ = this.baseUrl + "/data-connections";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetAll(_response);
        });
    }

    protected processGetAll(response: Response): Promise<DataConnection[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (Array.isArray(resultData200)) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(DataConnection.fromJS(item));
            }
            else {
                result200 = <any>null;
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<DataConnection[]>(<any>null);
    }

    save(dataConnection: DataConnection, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/data-connections";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(dataConnection);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processSave(_response);
        });
    }

    protected processSave(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    get(id: string, signal?: AbortSignal | undefined): Promise<DataConnection> {
        let url_ = this.baseUrl + "/data-connections/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGet(_response);
        });
    }

    protected processGet(response: Response): Promise<DataConnection> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = DataConnection.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<DataConnection>(<any>null);
    }

    delete(id: string, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/data-connections/{id}";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "DELETE",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processDelete(_response);
        });
    }

    protected processDelete(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    getAllNames(signal?: AbortSignal | undefined): Promise<string[]> {
        let url_ = this.baseUrl + "/data-connections/names";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetAllNames(_response);
        });
    }

    protected processGetAllNames(response: Response): Promise<string[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (Array.isArray(resultData200)) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(item);
            }
            else {
                result200 = <any>null;
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<string[]>(<any>null);
    }

    refresh(id: string, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/data-connections/{id}/refresh";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processRefresh(_response);
        });
    }

    protected processRefresh(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    getConnectionString(dataConnection: DataConnection, signal?: AbortSignal | undefined): Promise<string> {
        let url_ = this.baseUrl + "/data-connections/connection-string";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(dataConnection);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetConnectionString(_response);
        });
    }

    protected processGetConnectionString(response: Response): Promise<string> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = resultData200 !== undefined ? resultData200 : <any>null;
    
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<string>(<any>null);
    }

    test(dataConnection: DataConnection, signal?: AbortSignal | undefined): Promise<DataConnectionTestResult> {
        let url_ = this.baseUrl + "/data-connections/test";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(dataConnection);

        let options_ = <RequestInit>{
            body: content_,
            method: "PATCH",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processTest(_response);
        });
    }

    protected processTest(response: Response): Promise<DataConnectionTestResult> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = DataConnectionTestResult.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<DataConnectionTestResult>(<any>null);
    }

    protectPassword(unprotectedPassword: string, signal?: AbortSignal | undefined): Promise<string | null> {
        let url_ = this.baseUrl + "/data-connections/protect-password";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(unprotectedPassword);

        let options_ = <RequestInit>{
            body: content_,
            method: "PATCH",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processProtectPassword(_response);
        });
    }

    protected processProtectPassword(response: Response): Promise<string | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = resultData200 !== undefined ? resultData200 : <any>null;
    
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<string | null>(<any>null);
    }

    getDatabases(dataConnection: DataConnection, signal?: AbortSignal | undefined): Promise<string[]> {
        let url_ = this.baseUrl + "/data-connections/databases";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(dataConnection);

        let options_ = <RequestInit>{
            body: content_,
            method: "PATCH",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetDatabases(_response);
        });
    }

    protected processGetDatabases(response: Response): Promise<string[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (Array.isArray(resultData200)) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(item);
            }
            else {
                result200 = <any>null;
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<string[]>(<any>null);
    }

    getDatabaseStructure(id: string, signal?: AbortSignal | undefined): Promise<DatabaseStructure> {
        let url_ = this.baseUrl + "/data-connections/{id}/database-structure";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetDatabaseStructure(_response);
        });
    }

    protected processGetDatabaseStructure(response: Response): Promise<DatabaseStructure> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = DatabaseStructure.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<DatabaseStructure>(<any>null);
    }
}

export interface IPackagesApiClient {

    getCachedPackages(loadMetadata: boolean | undefined, signal?: AbortSignal | undefined): Promise<CachedPackage[]>;

    deleteCachedPackage(packageId: string | null | undefined, packageVersion: string | null | undefined, signal?: AbortSignal | undefined): Promise<FileResponse | null>;

    getExplicitlyInstalledCachedPackages(loadMetadata: boolean | undefined, signal?: AbortSignal | undefined): Promise<CachedPackage[]>;

    purgePackageCache(signal?: AbortSignal | undefined): Promise<FileResponse | null>;

    getPackageVersions(packageId: string | null | undefined, includePrerelease: boolean | undefined, signal?: AbortSignal | undefined): Promise<string[]>;

    getPackageMetadata(packages: PackageIdentity[], signal?: AbortSignal | undefined): Promise<PackageMetadata[]>;

    search(term: string | null | undefined, skip: number | null | undefined, take: number | null | undefined, includePrerelease: boolean | null | undefined, signal?: AbortSignal | undefined): Promise<PackageMetadata[]>;

    install(packageId: string | null | undefined, packageVersion: string | null | undefined, dotNetFrameworkVersion: DotNetFrameworkVersion | null | undefined, signal?: AbortSignal | undefined): Promise<FileResponse | null>;
}

export class PackagesApiClient extends ApiClientBase implements IPackagesApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    getCachedPackages(loadMetadata: boolean | undefined, signal?: AbortSignal | undefined): Promise<CachedPackage[]> {
        let url_ = this.baseUrl + "/packages/cache?";
        if (loadMetadata === null)
            throw new Error("The parameter 'loadMetadata' cannot be null.");
        else if (loadMetadata !== undefined)
            url_ += "loadMetadata=" + encodeURIComponent("" + loadMetadata) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetCachedPackages(_response);
        });
    }

    protected processGetCachedPackages(response: Response): Promise<CachedPackage[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (Array.isArray(resultData200)) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(CachedPackage.fromJS(item));
            }
            else {
                result200 = <any>null;
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<CachedPackage[]>(<any>null);
    }

    deleteCachedPackage(packageId: string | null | undefined, packageVersion: string | null | undefined, signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/packages/cache?";
        if (packageId !== undefined && packageId !== null)
            url_ += "packageId=" + encodeURIComponent("" + packageId) + "&";
        if (packageVersion !== undefined && packageVersion !== null)
            url_ += "packageVersion=" + encodeURIComponent("" + packageVersion) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "DELETE",
            signal,
            headers: {
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processDeleteCachedPackage(_response);
        });
    }

    protected processDeleteCachedPackage(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    getExplicitlyInstalledCachedPackages(loadMetadata: boolean | undefined, signal?: AbortSignal | undefined): Promise<CachedPackage[]> {
        let url_ = this.baseUrl + "/packages/cache/explicitly-installed?";
        if (loadMetadata === null)
            throw new Error("The parameter 'loadMetadata' cannot be null.");
        else if (loadMetadata !== undefined)
            url_ += "loadMetadata=" + encodeURIComponent("" + loadMetadata) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetExplicitlyInstalledCachedPackages(_response);
        });
    }

    protected processGetExplicitlyInstalledCachedPackages(response: Response): Promise<CachedPackage[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (Array.isArray(resultData200)) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(CachedPackage.fromJS(item));
            }
            else {
                result200 = <any>null;
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<CachedPackage[]>(<any>null);
    }

    purgePackageCache(signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/packages/cache/purge";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processPurgePackageCache(_response);
        });
    }

    protected processPurgePackageCache(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    getPackageVersions(packageId: string | null | undefined, includePrerelease: boolean | undefined, signal?: AbortSignal | undefined): Promise<string[]> {
        let url_ = this.baseUrl + "/packages/versions?";
        if (packageId !== undefined && packageId !== null)
            url_ += "packageId=" + encodeURIComponent("" + packageId) + "&";
        if (includePrerelease === null)
            throw new Error("The parameter 'includePrerelease' cannot be null.");
        else if (includePrerelease !== undefined)
            url_ += "includePrerelease=" + encodeURIComponent("" + includePrerelease) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetPackageVersions(_response);
        });
    }

    protected processGetPackageVersions(response: Response): Promise<string[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (Array.isArray(resultData200)) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(item);
            }
            else {
                result200 = <any>null;
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<string[]>(<any>null);
    }

    getPackageMetadata(packages: PackageIdentity[], signal?: AbortSignal | undefined): Promise<PackageMetadata[]> {
        let url_ = this.baseUrl + "/packages/metadata";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(packages);

        let options_ = <RequestInit>{
            body: content_,
            method: "POST",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetPackageMetadata(_response);
        });
    }

    protected processGetPackageMetadata(response: Response): Promise<PackageMetadata[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (Array.isArray(resultData200)) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(PackageMetadata.fromJS(item));
            }
            else {
                result200 = <any>null;
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<PackageMetadata[]>(<any>null);
    }

    search(term: string | null | undefined, skip: number | null | undefined, take: number | null | undefined, includePrerelease: boolean | null | undefined, signal?: AbortSignal | undefined): Promise<PackageMetadata[]> {
        let url_ = this.baseUrl + "/packages/search?";
        if (term !== undefined && term !== null)
            url_ += "term=" + encodeURIComponent("" + term) + "&";
        if (skip !== undefined && skip !== null)
            url_ += "skip=" + encodeURIComponent("" + skip) + "&";
        if (take !== undefined && take !== null)
            url_ += "take=" + encodeURIComponent("" + take) + "&";
        if (includePrerelease !== undefined && includePrerelease !== null)
            url_ += "includePrerelease=" + encodeURIComponent("" + includePrerelease) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processSearch(_response);
        });
    }

    protected processSearch(response: Response): Promise<PackageMetadata[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (Array.isArray(resultData200)) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(PackageMetadata.fromJS(item));
            }
            else {
                result200 = <any>null;
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<PackageMetadata[]>(<any>null);
    }

    install(packageId: string | null | undefined, packageVersion: string | null | undefined, dotNetFrameworkVersion: DotNetFrameworkVersion | null | undefined, signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/packages/install?";
        if (packageId !== undefined && packageId !== null)
            url_ += "packageId=" + encodeURIComponent("" + packageId) + "&";
        if (packageVersion !== undefined && packageVersion !== null)
            url_ += "packageVersion=" + encodeURIComponent("" + packageVersion) + "&";
        if (dotNetFrameworkVersion !== undefined && dotNetFrameworkVersion !== null)
            url_ += "dotNetFrameworkVersion=" + encodeURIComponent("" + dotNetFrameworkVersion) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processInstall(_response);
        });
    }

    protected processInstall(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }
}

export interface IScriptsApiClient {

    getScripts(signal?: AbortSignal | undefined): Promise<ScriptSummary[]>;

    create(dto: CreateScriptDto, signal?: AbortSignal | undefined): Promise<void>;

    rename(id: string, newName: string, signal?: AbortSignal | undefined): Promise<void>;

    duplicate(id: string, signal?: AbortSignal | undefined): Promise<void>;

    save(id: string, signal?: AbortSignal | undefined): Promise<void>;

    run(id: string, options: RunOptions, signal?: AbortSignal | undefined): Promise<void>;

    stop(id: string, signal?: AbortSignal | undefined): Promise<void>;

    updateCode(id: string, code: string, signal?: AbortSignal | undefined): Promise<void>;

    openConfigWindow(id: string, tab: string | null | undefined, signal?: AbortSignal | undefined): Promise<void>;

    setScriptNamespaces(id: string, namespaces: string[], signal?: AbortSignal | undefined): Promise<FileResponse | null>;

    setReferences(id: string, newReferences: Reference[], signal?: AbortSignal | undefined): Promise<FileResponse | null>;

    setScriptKind(id: string, scriptKind: ScriptKind, signal?: AbortSignal | undefined): Promise<FileResponse | null>;

    setTargetFrameworkVersion(id: string, targetFrameworkVersion: DotNetFrameworkVersion, signal?: AbortSignal | undefined): Promise<FileResponse | null>;

    setOptimizationLevel(id: string, optimizationLevel: OptimizationLevel, signal?: AbortSignal | undefined): Promise<FileResponse | null>;

    setUseAspNet(id: string, useAspNet: boolean, signal?: AbortSignal | undefined): Promise<FileResponse | null>;

    setDataConnection(id: string, dataConnectionId: string | null | undefined, signal?: AbortSignal | undefined): Promise<FileResponse | null>;
}

export class ScriptsApiClient extends ApiClientBase implements IScriptsApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    getScripts(signal?: AbortSignal | undefined): Promise<ScriptSummary[]> {
        let url_ = this.baseUrl + "/scripts";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetScripts(_response);
        });
    }

    protected processGetScripts(response: Response): Promise<ScriptSummary[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (Array.isArray(resultData200)) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(ScriptSummary.fromJS(item));
            }
            else {
                result200 = <any>null;
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ScriptSummary[]>(<any>null);
    }

    create(dto: CreateScriptDto, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/scripts/create";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(dto);

        let options_ = <RequestInit>{
            body: content_,
            method: "PATCH",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processCreate(_response);
        });
    }

    protected processCreate(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    rename(id: string, newName: string, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/scripts/{id}/rename";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(newName);

        let options_ = <RequestInit>{
            body: content_,
            method: "PATCH",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processRename(_response);
        });
    }

    protected processRename(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    duplicate(id: string, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/scripts/{id}/duplicate";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processDuplicate(_response);
        });
    }

    protected processDuplicate(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    save(id: string, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/scripts/{id}/save";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processSave(_response);
        });
    }

    protected processSave(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    run(id: string, options: RunOptions, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/scripts/{id}/run";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(options);

        let options_ = <RequestInit>{
            body: content_,
            method: "PATCH",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processRun(_response);
        });
    }

    protected processRun(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    stop(id: string, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/scripts/{id}/stop";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processStop(_response);
        });
    }

    protected processStop(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    updateCode(id: string, code: string, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/scripts/{id}/code";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(code);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processUpdateCode(_response);
        });
    }

    protected processUpdateCode(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    openConfigWindow(id: string, tab: string | null | undefined, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/scripts/{id}/open-config?";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        if (tab !== undefined && tab !== null)
            url_ += "tab=" + encodeURIComponent("" + tab) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processOpenConfigWindow(_response);
        });
    }

    protected processOpenConfigWindow(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    setScriptNamespaces(id: string, namespaces: string[], signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/scripts/{id}/namespaces";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(namespaces);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processSetScriptNamespaces(_response);
        });
    }

    protected processSetScriptNamespaces(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    setReferences(id: string, newReferences: Reference[], signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/scripts/{id}/references";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(newReferences);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processSetReferences(_response);
        });
    }

    protected processSetReferences(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    setScriptKind(id: string, scriptKind: ScriptKind, signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/scripts/{id}/kind";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(scriptKind);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processSetScriptKind(_response);
        });
    }

    protected processSetScriptKind(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    setTargetFrameworkVersion(id: string, targetFrameworkVersion: DotNetFrameworkVersion, signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/scripts/{id}/target-framework-version";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(targetFrameworkVersion);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processSetTargetFrameworkVersion(_response);
        });
    }

    protected processSetTargetFrameworkVersion(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    setOptimizationLevel(id: string, optimizationLevel: OptimizationLevel, signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/scripts/{id}/optimization-level";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(optimizationLevel);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processSetOptimizationLevel(_response);
        });
    }

    protected processSetOptimizationLevel(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    setUseAspNet(id: string, useAspNet: boolean, signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/scripts/{id}/use-asp-net";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(useAspNet);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processSetUseAspNet(_response);
        });
    }

    protected processSetUseAspNet(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    setDataConnection(id: string, dataConnectionId: string | null | undefined, signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/scripts/{id}/data-connection?";
        if (id === undefined || id === null)
            throw new Error("The parameter 'id' must be defined.");
        url_ = url_.replace("{id}", encodeURIComponent("" + id));
        if (dataConnectionId !== undefined && dataConnectionId !== null)
            url_ += "dataConnectionId=" + encodeURIComponent("" + dataConnectionId) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PUT",
            signal,
            headers: {
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processSetDataConnection(_response);
        });
    }

    protected processSetDataConnection(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }
}

export interface ISessionApiClient {

    getEnvironment(scriptId: string, signal?: AbortSignal | undefined): Promise<ScriptEnvironment>;

    getEnvironments(signal?: AbortSignal | undefined): Promise<ScriptEnvironment[]>;

    openByPath(scriptPath: string, signal?: AbortSignal | undefined): Promise<void>;

    close(scriptId: string, signal?: AbortSignal | undefined): Promise<void>;

    getActive(signal?: AbortSignal | undefined): Promise<string | null>;

    activate(scriptId: string, signal?: AbortSignal | undefined): Promise<void>;

    activateLastActive(signal?: AbortSignal | undefined): Promise<void>;
}

export class SessionApiClient extends ApiClientBase implements ISessionApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    getEnvironment(scriptId: string, signal?: AbortSignal | undefined): Promise<ScriptEnvironment> {
        let url_ = this.baseUrl + "/session/environments/{scriptId}";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetEnvironment(_response);
        });
    }

    protected processGetEnvironment(response: Response): Promise<ScriptEnvironment> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = ScriptEnvironment.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ScriptEnvironment>(<any>null);
    }

    getEnvironments(signal?: AbortSignal | undefined): Promise<ScriptEnvironment[]> {
        let url_ = this.baseUrl + "/session/environments";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetEnvironments(_response);
        });
    }

    protected processGetEnvironments(response: Response): Promise<ScriptEnvironment[]> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            if (Array.isArray(resultData200)) {
                result200 = [] as any;
                for (let item of resultData200)
                    result200!.push(ScriptEnvironment.fromJS(item));
            }
            else {
                result200 = <any>null;
            }
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<ScriptEnvironment[]>(<any>null);
    }

    openByPath(scriptPath: string, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/session/open/path";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(scriptPath);

        let options_ = <RequestInit>{
            body: content_,
            method: "PATCH",
            signal,
            headers: {
                "Content-Type": "application/json",
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processOpenByPath(_response);
        });
    }

    protected processOpenByPath(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    close(scriptId: string, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/session/{scriptId}/close";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processClose(_response);
        });
    }

    protected processClose(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    getActive(signal?: AbortSignal | undefined): Promise<string | null> {
        let url_ = this.baseUrl + "/session/active";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGetActive(_response);
        });
    }

    protected processGetActive(response: Response): Promise<string | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
                result200 = resultData200 !== undefined ? resultData200 : <any>null;
    
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<string | null>(<any>null);
    }

    activate(scriptId: string, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/session/{scriptId}/activate";
        if (scriptId === undefined || scriptId === null)
            throw new Error("The parameter 'scriptId' must be defined.");
        url_ = url_.replace("{scriptId}", encodeURIComponent("" + scriptId));
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processActivate(_response);
        });
    }

    protected processActivate(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    activateLastActive(signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/session/activate-last-active";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processActivateLastActive(_response);
        });
    }

    protected processActivateLastActive(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }
}

export interface ISettingsApiClient {

    get(signal?: AbortSignal | undefined): Promise<Settings>;

    update(update: Settings, signal?: AbortSignal | undefined): Promise<FileResponse | null>;

    openSettingsWindow(tab: string | null | undefined, signal?: AbortSignal | undefined): Promise<void>;

    showSettingsFile(signal?: AbortSignal | undefined): Promise<FileResponse | null>;
}

export class SettingsApiClient extends ApiClientBase implements ISettingsApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    get(signal?: AbortSignal | undefined): Promise<Settings> {
        let url_ = this.baseUrl + "/settings";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processGet(_response);
        });
    }

    protected processGet(response: Response): Promise<Settings> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = Settings.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Settings>(<any>null);
    }

    update(update: Settings, signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/settings";
        url_ = url_.replace(/[?&]$/, "");

        const content_ = JSON.stringify(update);

        let options_ = <RequestInit>{
            body: content_,
            method: "PUT",
            signal,
            headers: {
                "Content-Type": "application/json",
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processUpdate(_response);
        });
    }

    protected processUpdate(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }

    openSettingsWindow(tab: string | null | undefined, signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/settings/open?";
        if (tab !== undefined && tab !== null)
            url_ += "tab=" + encodeURIComponent("" + tab) + "&";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processOpenSettingsWindow(_response);
        });
    }

    protected processOpenSettingsWindow(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    showSettingsFile(signal?: AbortSignal | undefined): Promise<FileResponse | null> {
        let url_ = this.baseUrl + "/settings/show-settings-file";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
                "Accept": "application/octet-stream"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processShowSettingsFile(_response);
        });
    }

    protected processShowSettingsFile(response: Response): Promise<FileResponse | null> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200 || status === 206) {
            const contentDisposition = response.headers ? response.headers.get("content-disposition") : undefined;
            const fileNameMatch = contentDisposition ? /filename="?([^"]*?)"?(;|$)/g.exec(contentDisposition) : undefined;
            const fileName = fileNameMatch && fileNameMatch.length > 1 ? fileNameMatch[1] : undefined;
            return response.blob().then(blob => { return { fileName: fileName, data: blob, status: status, headers: _headers }; });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<FileResponse | null>(<any>null);
    }
}

export interface ITypesApiClient {

    additionalTypes(signal?: AbortSignal | undefined): Promise<Types>;
}

export class TypesApiClient extends ApiClientBase implements ITypesApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    additionalTypes(signal?: AbortSignal | undefined): Promise<Types> {
        let url_ = this.baseUrl + "/types";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "GET",
            signal,
            headers: {
                "Accept": "application/json"
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processAdditionalTypes(_response);
        });
    }

    protected processAdditionalTypes(response: Response): Promise<Types> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            let result200: any = null;
            let resultData200 = _responseText === "" ? null : JSON.parse(_responseText, this.jsonParseReviver);
            result200 = Types.fromJS(resultData200);
            return result200;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<Types>(<any>null);
    }
}

export interface IWindowApiClient {

    openOutputWindow(signal?: AbortSignal | undefined): Promise<void>;

    openCodeWindow(signal?: AbortSignal | undefined): Promise<void>;
}

export class WindowApiClient extends ApiClientBase implements IWindowApiClient {
    private http: IHttpClient;
    private baseUrl: string;
    protected jsonParseReviver: ((key: string, value: any) => any) | undefined = undefined;

    constructor(baseUrl?: string, @IHttpClient http?: IHttpClient) {
        super();
        this.http = http ? http : <any>window;
        this.baseUrl = baseUrl !== undefined && baseUrl !== null ? baseUrl : "";
    }

    openOutputWindow(signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/window/open-output-window";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processOpenOutputWindow(_response);
        });
    }

    protected processOpenOutputWindow(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }

    openCodeWindow(signal?: AbortSignal | undefined): Promise<void> {
        let url_ = this.baseUrl + "/window/open-code-window";
        url_ = url_.replace(/[?&]$/, "");

        let options_ = <RequestInit>{
            method: "PATCH",
            signal,
            headers: {
            }
        };

        return this.makeFetchCall(url_, options_, () => this.http.fetch(url_, options_)).then((_response: Response) => {
            return this.processOpenCodeWindow(_response);
        });
    }

    protected processOpenCodeWindow(response: Response): Promise<void> {
        const status = response.status;
        let _headers: any = {}; if (response.headers && response.headers.forEach) { response.headers.forEach((v: any, k: any) => _headers[k] = v); };
        if (status === 200) {
            return response.text().then((_responseText) => {
            return;
            });
        } else if (status !== 200 && status !== 204) {
            return response.text().then((_responseText) => {
            return throwException("An unexpected server error occurred.", status, _responseText, _headers);
            });
        }
        return Promise.resolve<void>(<any>null);
    }
}

export class AppIdentifier implements IAppIdentifier {
    name!: string;
    version!: string;
    productVersion!: string;

    constructor(data?: IAppIdentifier) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.name = _data["name"];
            this.version = _data["version"];
            this.productVersion = _data["productVersion"];
        }
    }

    static fromJS(data: any): AppIdentifier {
        data = typeof data === 'object' ? data : {};
        let result = new AppIdentifier();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["name"] = this.name;
        data["version"] = this.version;
        data["productVersion"] = this.productVersion;
        return data;
    }

    clone(): AppIdentifier {
        const json = this.toJSON();
        let result = new AppIdentifier();
        result.init(json);
        return result;
    }
}

export interface IAppIdentifier {
    name: string;
    version: string;
    productVersion: string;
}

export class AppDependencyCheckResult implements IAppDependencyCheckResult {
    dotNetRuntimeVersion!: string;
    dotNetSdkVersions!: SemanticVersion[];
    dotNetEfToolVersion?: SemanticVersion | undefined;
    supportedDotNetSdkVersionsInstalled!: SemanticVersion[];
    isSupportedDotNetEfToolInstalled!: boolean;

    constructor(data?: IAppDependencyCheckResult) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.dotNetSdkVersions = [];
            this.supportedDotNetSdkVersionsInstalled = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            this.dotNetRuntimeVersion = _data["dotNetRuntimeVersion"];
            if (Array.isArray(_data["dotNetSdkVersions"])) {
                this.dotNetSdkVersions = [] as any;
                for (let item of _data["dotNetSdkVersions"])
                    this.dotNetSdkVersions!.push(SemanticVersion.fromJS(item));
            }
            this.dotNetEfToolVersion = _data["dotNetEfToolVersion"] ? SemanticVersion.fromJS(_data["dotNetEfToolVersion"]) : <any>undefined;
            if (Array.isArray(_data["supportedDotNetSdkVersionsInstalled"])) {
                this.supportedDotNetSdkVersionsInstalled = [] as any;
                for (let item of _data["supportedDotNetSdkVersionsInstalled"])
                    this.supportedDotNetSdkVersionsInstalled!.push(SemanticVersion.fromJS(item));
            }
            this.isSupportedDotNetEfToolInstalled = _data["isSupportedDotNetEfToolInstalled"];
        }
    }

    static fromJS(data: any): AppDependencyCheckResult {
        data = typeof data === 'object' ? data : {};
        let result = new AppDependencyCheckResult();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["dotNetRuntimeVersion"] = this.dotNetRuntimeVersion;
        if (Array.isArray(this.dotNetSdkVersions)) {
            data["dotNetSdkVersions"] = [];
            for (let item of this.dotNetSdkVersions)
                data["dotNetSdkVersions"].push(item.toJSON());
        }
        data["dotNetEfToolVersion"] = this.dotNetEfToolVersion ? this.dotNetEfToolVersion.toJSON() : <any>undefined;
        if (Array.isArray(this.supportedDotNetSdkVersionsInstalled)) {
            data["supportedDotNetSdkVersionsInstalled"] = [];
            for (let item of this.supportedDotNetSdkVersionsInstalled)
                data["supportedDotNetSdkVersionsInstalled"].push(item.toJSON());
        }
        data["isSupportedDotNetEfToolInstalled"] = this.isSupportedDotNetEfToolInstalled;
        return data;
    }

    clone(): AppDependencyCheckResult {
        const json = this.toJSON();
        let result = new AppDependencyCheckResult();
        result.init(json);
        return result;
    }
}

export interface IAppDependencyCheckResult {
    dotNetRuntimeVersion: string;
    dotNetSdkVersions: SemanticVersion[];
    dotNetEfToolVersion?: SemanticVersion | undefined;
    supportedDotNetSdkVersionsInstalled: SemanticVersion[];
    isSupportedDotNetEfToolInstalled: boolean;
}

/** An implementation of semantic versioning (https://semver.org) */
export class SemanticVersion implements ISemanticVersion {
    /** The major version number, never negative. */
    major!: number;
    /** The minor version number, never negative. */
    minor!: number;
    /** The patch version, -1 if not specified. */
    patch!: number;
    /** PreReleaseLabel position in the SymVer string 'major.minor.patch-PreReleaseLabel+BuildLabel'. */
    preReleaseLabel?: string | undefined;
    /** BuildLabel position in the SymVer string 'major.minor.patch-PreReleaseLabel+BuildLabel'. */
    buildLabel?: string | undefined;
    /** Whether the version is a prerelease. */
    isPrerelease!: boolean;
    /** String representation. */
    string!: string;

    constructor(data?: ISemanticVersion) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.major = _data["major"];
            this.minor = _data["minor"];
            this.patch = _data["patch"];
            this.preReleaseLabel = _data["preReleaseLabel"];
            this.buildLabel = _data["buildLabel"];
            this.isPrerelease = _data["isPrerelease"];
            this.string = _data["string"];
        }
    }

    static fromJS(data: any): SemanticVersion {
        data = typeof data === 'object' ? data : {};
        let result = new SemanticVersion();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["major"] = this.major;
        data["minor"] = this.minor;
        data["patch"] = this.patch;
        data["preReleaseLabel"] = this.preReleaseLabel;
        data["buildLabel"] = this.buildLabel;
        data["isPrerelease"] = this.isPrerelease;
        data["string"] = this.string;
        return data;
    }

    clone(): SemanticVersion {
        const json = this.toJSON();
        let result = new SemanticVersion();
        result.init(json);
        return result;
    }
}

/** An implementation of semantic versioning (https://semver.org) */
export interface ISemanticVersion {
    /** The major version number, never negative. */
    major: number;
    /** The minor version number, never negative. */
    minor: number;
    /** The patch version, -1 if not specified. */
    patch: number;
    /** PreReleaseLabel position in the SymVer string 'major.minor.patch-PreReleaseLabel+BuildLabel'. */
    preReleaseLabel?: string | undefined;
    /** BuildLabel position in the SymVer string 'major.minor.patch-PreReleaseLabel+BuildLabel'. */
    buildLabel?: string | undefined;
    /** Whether the version is a prerelease. */
    isPrerelease: boolean;
    /** String representation. */
    string: string;
}

export type LogSource = "WebApp" | "ElectronApp";

export class RemoteLogMessage implements IRemoteLogMessage {
    logger?: string | undefined;
    logLevel!: LogLevel;
    message?: string | undefined;
    optionalParams?: string[] | undefined;
    date!: Date;

    constructor(data?: IRemoteLogMessage) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.logger = _data["logger"];
            this.logLevel = _data["logLevel"];
            this.message = _data["message"];
            if (Array.isArray(_data["optionalParams"])) {
                this.optionalParams = [] as any;
                for (let item of _data["optionalParams"])
                    this.optionalParams!.push(item);
            }
            this.date = _data["date"] ? new Date(_data["date"].toString()) : <any>undefined;
        }
    }

    static fromJS(data: any): RemoteLogMessage {
        data = typeof data === 'object' ? data : {};
        let result = new RemoteLogMessage();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["logger"] = this.logger;
        data["logLevel"] = this.logLevel;
        data["message"] = this.message;
        if (Array.isArray(this.optionalParams)) {
            data["optionalParams"] = [];
            for (let item of this.optionalParams)
                data["optionalParams"].push(item);
        }
        data["date"] = this.date ? this.date.toISOString() : <any>undefined;
        return data;
    }

    clone(): RemoteLogMessage {
        const json = this.toJSON();
        let result = new RemoteLogMessage();
        result.init(json);
        return result;
    }
}

export interface IRemoteLogMessage {
    logger?: string | undefined;
    logLevel: LogLevel;
    message?: string | undefined;
    optionalParams?: string[] | undefined;
    date: Date;
}

export type LogLevel = "Trace" | "Debug" | "Information" | "Warning" | "Error" | "Critical" | "None";

export abstract class Reference implements IReference {
    title!: string;

    protected _discriminator: string;

    constructor(data?: IReference) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        this._discriminator = "Reference";
    }

    init(_data?: any) {
        if (_data) {
            this.title = _data["title"];
        }
    }

    static fromJS(data: any): Reference {
        data = typeof data === 'object' ? data : {};
        if (data["discriminator"] === "AssemblyFileReference") {
            let result = new AssemblyFileReference();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "AssemblyImageReference") {
            let result = new AssemblyImageReference();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "PackageReference") {
            let result = new PackageReference();
            result.init(data);
            return result;
        }
        throw new Error("The abstract class 'Reference' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["discriminator"] = this._discriminator;
        data["title"] = this.title;
        return data;
    }

    clone(): Reference {
        throw new Error("The abstract class 'Reference' cannot be instantiated.");
    }
}

export interface IReference {
    title: string;
}

export class AssemblyFileReference extends Reference implements IAssemblyFileReference {
    assemblyPath!: string;

    constructor(data?: IAssemblyFileReference) {
        super(data);
        this._discriminator = "AssemblyFileReference";
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.assemblyPath = _data["assemblyPath"];
        }
    }

    static fromJS(data: any): AssemblyFileReference {
        data = typeof data === 'object' ? data : {};
        let result = new AssemblyFileReference();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["assemblyPath"] = this.assemblyPath;
        super.toJSON(data);
        return data;
    }

    clone(): AssemblyFileReference {
        const json = this.toJSON();
        let result = new AssemblyFileReference();
        result.init(json);
        return result;
    }
}

export interface IAssemblyFileReference extends IReference {
    assemblyPath: string;
}

export class AssemblyImageReference extends Reference implements IAssemblyImageReference {
    assemblyImage!: AssemblyImage;

    constructor(data?: IAssemblyImageReference) {
        super(data);
        if (!data) {
            this.assemblyImage = new AssemblyImage();
        }
        this._discriminator = "AssemblyImageReference";
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.assemblyImage = _data["assemblyImage"] ? AssemblyImage.fromJS(_data["assemblyImage"]) : new AssemblyImage();
        }
    }

    static fromJS(data: any): AssemblyImageReference {
        data = typeof data === 'object' ? data : {};
        let result = new AssemblyImageReference();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["assemblyImage"] = this.assemblyImage ? this.assemblyImage.toJSON() : <any>undefined;
        super.toJSON(data);
        return data;
    }

    clone(): AssemblyImageReference {
        const json = this.toJSON();
        let result = new AssemblyImageReference();
        result.init(json);
        return result;
    }
}

export interface IAssemblyImageReference extends IReference {
    assemblyImage: AssemblyImage;
}

export class AssemblyImage implements IAssemblyImage {
    assemblyName!: AssemblyName;
    image!: string;

    constructor(data?: IAssemblyImage) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.assemblyName = new AssemblyName();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.assemblyName = _data["assemblyName"] ? AssemblyName.fromJS(_data["assemblyName"]) : new AssemblyName();
            this.image = _data["image"];
        }
    }

    static fromJS(data: any): AssemblyImage {
        data = typeof data === 'object' ? data : {};
        let result = new AssemblyImage();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["assemblyName"] = this.assemblyName ? this.assemblyName.toJSON() : <any>undefined;
        data["image"] = this.image;
        return data;
    }

    clone(): AssemblyImage {
        const json = this.toJSON();
        let result = new AssemblyImage();
        result.init(json);
        return result;
    }
}

export interface IAssemblyImage {
    assemblyName: AssemblyName;
    image: string;
}

export class AssemblyName implements IAssemblyName {
    name?: string | undefined;
    version?: string | undefined;
    cultureInfo?: string | undefined;
    cultureName?: string | undefined;
    codeBase?: string | undefined;
    escapedCodeBase?: string | undefined;
    processorArchitecture!: ProcessorArchitecture;
    contentType!: AssemblyContentType;
    flags!: AssemblyNameFlags;
    hashAlgorithm!: AssemblyHashAlgorithm;
    versionCompatibility!: AssemblyVersionCompatibility;
    keyPair?: StrongNameKeyPair | undefined;
    fullName!: string;

    constructor(data?: IAssemblyName) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.name = _data["name"];
            this.version = _data["version"];
            this.cultureInfo = _data["cultureInfo"];
            this.cultureName = _data["cultureName"];
            this.codeBase = _data["codeBase"];
            this.escapedCodeBase = _data["escapedCodeBase"];
            this.processorArchitecture = _data["processorArchitecture"];
            this.contentType = _data["contentType"];
            this.flags = _data["flags"];
            this.hashAlgorithm = _data["hashAlgorithm"];
            this.versionCompatibility = _data["versionCompatibility"];
            this.keyPair = _data["keyPair"] ? StrongNameKeyPair.fromJS(_data["keyPair"]) : <any>undefined;
            this.fullName = _data["fullName"];
        }
    }

    static fromJS(data: any): AssemblyName {
        data = typeof data === 'object' ? data : {};
        let result = new AssemblyName();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["name"] = this.name;
        data["version"] = this.version;
        data["cultureInfo"] = this.cultureInfo;
        data["cultureName"] = this.cultureName;
        data["codeBase"] = this.codeBase;
        data["escapedCodeBase"] = this.escapedCodeBase;
        data["processorArchitecture"] = this.processorArchitecture;
        data["contentType"] = this.contentType;
        data["flags"] = this.flags;
        data["hashAlgorithm"] = this.hashAlgorithm;
        data["versionCompatibility"] = this.versionCompatibility;
        data["keyPair"] = this.keyPair ? this.keyPair.toJSON() : <any>undefined;
        data["fullName"] = this.fullName;
        return data;
    }

    clone(): AssemblyName {
        const json = this.toJSON();
        let result = new AssemblyName();
        result.init(json);
        return result;
    }
}

export interface IAssemblyName {
    name?: string | undefined;
    version?: string | undefined;
    cultureInfo?: string | undefined;
    cultureName?: string | undefined;
    codeBase?: string | undefined;
    escapedCodeBase?: string | undefined;
    processorArchitecture: ProcessorArchitecture;
    contentType: AssemblyContentType;
    flags: AssemblyNameFlags;
    hashAlgorithm: AssemblyHashAlgorithm;
    versionCompatibility: AssemblyVersionCompatibility;
    keyPair?: StrongNameKeyPair | undefined;
    fullName: string;
}

export type ProcessorArchitecture = "None" | "MSIL" | "X86" | "IA64" | "Amd64" | "Arm";

export type AssemblyContentType = "Default" | "WindowsRuntime";

export type AssemblyNameFlags = "None" | "PublicKey" | "Retargetable" | "EnableJITcompileOptimizer" | "EnableJITcompileTracking";

export type AssemblyHashAlgorithm = "None" | "MD5" | "SHA1" | "SHA256" | "SHA384" | "SHA512";

export type AssemblyVersionCompatibility = "SameMachine" | "SameProcess" | "SameDomain";

export class StrongNameKeyPair implements IStrongNameKeyPair {
    publicKey!: string;

    constructor(data?: IStrongNameKeyPair) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.publicKey = _data["publicKey"];
        }
    }

    static fromJS(data: any): StrongNameKeyPair {
        data = typeof data === 'object' ? data : {};
        let result = new StrongNameKeyPair();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["publicKey"] = this.publicKey;
        return data;
    }

    clone(): StrongNameKeyPair {
        const json = this.toJSON();
        let result = new StrongNameKeyPair();
        result.init(json);
        return result;
    }
}

export interface IStrongNameKeyPair {
    publicKey: string;
}

export class PackageReference extends Reference implements IPackageReference {
    packageId!: string;
    version!: string;

    constructor(data?: IPackageReference) {
        super(data);
        this._discriminator = "PackageReference";
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.packageId = _data["packageId"];
            this.version = _data["version"];
        }
    }

    static fromJS(data: any): PackageReference {
        data = typeof data === 'object' ? data : {};
        let result = new PackageReference();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["packageId"] = this.packageId;
        data["version"] = this.version;
        super.toJSON(data);
        return data;
    }

    clone(): PackageReference {
        const json = this.toJSON();
        let result = new PackageReference();
        result.init(json);
        return result;
    }
}

export interface IPackageReference extends IReference {
    packageId: string;
    version: string;
}

export class SyntaxNodeOrTokenSlim implements ISyntaxNodeOrTokenSlim {
    isToken!: boolean;
    isNode!: boolean;
    kind!: SyntaxKind;
    type!: string;
    span!: LinePositionSpan;
    isMissing!: boolean;
    valueText?: string | undefined;
    leadingTrivia!: SyntaxTriviaSlim[];
    trailingTrivia!: SyntaxTriviaSlim[];
    children!: SyntaxNodeOrTokenSlim[];

    constructor(data?: ISyntaxNodeOrTokenSlim) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.span = new LinePositionSpan();
            this.leadingTrivia = [];
            this.trailingTrivia = [];
            this.children = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            this.isToken = _data["isToken"];
            this.isNode = _data["isNode"];
            this.kind = _data["kind"];
            this.type = _data["type"];
            this.span = _data["span"] ? LinePositionSpan.fromJS(_data["span"]) : new LinePositionSpan();
            this.isMissing = _data["isMissing"];
            this.valueText = _data["valueText"];
            if (Array.isArray(_data["leadingTrivia"])) {
                this.leadingTrivia = [] as any;
                for (let item of _data["leadingTrivia"])
                    this.leadingTrivia!.push(SyntaxTriviaSlim.fromJS(item));
            }
            if (Array.isArray(_data["trailingTrivia"])) {
                this.trailingTrivia = [] as any;
                for (let item of _data["trailingTrivia"])
                    this.trailingTrivia!.push(SyntaxTriviaSlim.fromJS(item));
            }
            if (Array.isArray(_data["children"])) {
                this.children = [] as any;
                for (let item of _data["children"])
                    this.children!.push(SyntaxNodeOrTokenSlim.fromJS(item));
            }
        }
    }

    static fromJS(data: any): SyntaxNodeOrTokenSlim {
        data = typeof data === 'object' ? data : {};
        let result = new SyntaxNodeOrTokenSlim();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["isToken"] = this.isToken;
        data["isNode"] = this.isNode;
        data["kind"] = this.kind;
        data["type"] = this.type;
        data["span"] = this.span ? this.span.toJSON() : <any>undefined;
        data["isMissing"] = this.isMissing;
        data["valueText"] = this.valueText;
        if (Array.isArray(this.leadingTrivia)) {
            data["leadingTrivia"] = [];
            for (let item of this.leadingTrivia)
                data["leadingTrivia"].push(item.toJSON());
        }
        if (Array.isArray(this.trailingTrivia)) {
            data["trailingTrivia"] = [];
            for (let item of this.trailingTrivia)
                data["trailingTrivia"].push(item.toJSON());
        }
        if (Array.isArray(this.children)) {
            data["children"] = [];
            for (let item of this.children)
                data["children"].push(item.toJSON());
        }
        return data;
    }

    clone(): SyntaxNodeOrTokenSlim {
        const json = this.toJSON();
        let result = new SyntaxNodeOrTokenSlim();
        result.init(json);
        return result;
    }
}

export interface ISyntaxNodeOrTokenSlim {
    isToken: boolean;
    isNode: boolean;
    kind: SyntaxKind;
    type: string;
    span: LinePositionSpan;
    isMissing: boolean;
    valueText?: string | undefined;
    leadingTrivia: SyntaxTriviaSlim[];
    trailingTrivia: SyntaxTriviaSlim[];
    children: SyntaxNodeOrTokenSlim[];
}

export type SyntaxKind = "None" | "List" | "TildeToken" | "ExclamationToken" | "DollarToken" | "PercentToken" | "CaretToken" | "AmpersandToken" | "AsteriskToken" | "OpenParenToken" | "CloseParenToken" | "MinusToken" | "PlusToken" | "EqualsToken" | "OpenBraceToken" | "CloseBraceToken" | "OpenBracketToken" | "CloseBracketToken" | "BarToken" | "BackslashToken" | "ColonToken" | "SemicolonToken" | "DoubleQuoteToken" | "SingleQuoteToken" | "LessThanToken" | "CommaToken" | "GreaterThanToken" | "DotToken" | "QuestionToken" | "HashToken" | "SlashToken" | "DotDotToken" | "SlashGreaterThanToken" | "LessThanSlashToken" | "XmlCommentStartToken" | "XmlCommentEndToken" | "XmlCDataStartToken" | "XmlCDataEndToken" | "XmlProcessingInstructionStartToken" | "XmlProcessingInstructionEndToken" | "BarBarToken" | "AmpersandAmpersandToken" | "MinusMinusToken" | "PlusPlusToken" | "ColonColonToken" | "QuestionQuestionToken" | "MinusGreaterThanToken" | "ExclamationEqualsToken" | "EqualsEqualsToken" | "EqualsGreaterThanToken" | "LessThanEqualsToken" | "LessThanLessThanToken" | "LessThanLessThanEqualsToken" | "GreaterThanEqualsToken" | "GreaterThanGreaterThanToken" | "GreaterThanGreaterThanEqualsToken" | "SlashEqualsToken" | "AsteriskEqualsToken" | "BarEqualsToken" | "AmpersandEqualsToken" | "PlusEqualsToken" | "MinusEqualsToken" | "CaretEqualsToken" | "PercentEqualsToken" | "QuestionQuestionEqualsToken" | "GreaterThanGreaterThanGreaterThanToken" | "GreaterThanGreaterThanGreaterThanEqualsToken" | "BoolKeyword" | "ByteKeyword" | "SByteKeyword" | "ShortKeyword" | "UShortKeyword" | "IntKeyword" | "UIntKeyword" | "LongKeyword" | "ULongKeyword" | "DoubleKeyword" | "FloatKeyword" | "DecimalKeyword" | "StringKeyword" | "CharKeyword" | "VoidKeyword" | "ObjectKeyword" | "TypeOfKeyword" | "SizeOfKeyword" | "NullKeyword" | "TrueKeyword" | "FalseKeyword" | "IfKeyword" | "ElseKeyword" | "WhileKeyword" | "ForKeyword" | "ForEachKeyword" | "DoKeyword" | "SwitchKeyword" | "CaseKeyword" | "DefaultKeyword" | "TryKeyword" | "CatchKeyword" | "FinallyKeyword" | "LockKeyword" | "GotoKeyword" | "BreakKeyword" | "ContinueKeyword" | "ReturnKeyword" | "ThrowKeyword" | "PublicKeyword" | "PrivateKeyword" | "InternalKeyword" | "ProtectedKeyword" | "StaticKeyword" | "ReadOnlyKeyword" | "SealedKeyword" | "ConstKeyword" | "FixedKeyword" | "StackAllocKeyword" | "VolatileKeyword" | "NewKeyword" | "OverrideKeyword" | "AbstractKeyword" | "VirtualKeyword" | "EventKeyword" | "ExternKeyword" | "RefKeyword" | "OutKeyword" | "InKeyword" | "IsKeyword" | "AsKeyword" | "ParamsKeyword" | "ArgListKeyword" | "MakeRefKeyword" | "RefTypeKeyword" | "RefValueKeyword" | "ThisKeyword" | "BaseKeyword" | "NamespaceKeyword" | "UsingKeyword" | "ClassKeyword" | "StructKeyword" | "InterfaceKeyword" | "EnumKeyword" | "DelegateKeyword" | "CheckedKeyword" | "UncheckedKeyword" | "UnsafeKeyword" | "OperatorKeyword" | "ExplicitKeyword" | "ImplicitKeyword" | "YieldKeyword" | "PartialKeyword" | "AliasKeyword" | "GlobalKeyword" | "AssemblyKeyword" | "ModuleKeyword" | "TypeKeyword" | "FieldKeyword" | "MethodKeyword" | "ParamKeyword" | "PropertyKeyword" | "TypeVarKeyword" | "GetKeyword" | "SetKeyword" | "AddKeyword" | "RemoveKeyword" | "WhereKeyword" | "FromKeyword" | "GroupKeyword" | "JoinKeyword" | "IntoKeyword" | "LetKeyword" | "ByKeyword" | "SelectKeyword" | "OrderByKeyword" | "OnKeyword" | "EqualsKeyword" | "AscendingKeyword" | "DescendingKeyword" | "NameOfKeyword" | "AsyncKeyword" | "AwaitKeyword" | "WhenKeyword" | "OrKeyword" | "AndKeyword" | "NotKeyword" | "WithKeyword" | "InitKeyword" | "RecordKeyword" | "ManagedKeyword" | "UnmanagedKeyword" | "RequiredKeyword" | "ScopedKeyword" | "FileKeyword" | "ElifKeyword" | "EndIfKeyword" | "RegionKeyword" | "EndRegionKeyword" | "DefineKeyword" | "UndefKeyword" | "WarningKeyword" | "ErrorKeyword" | "LineKeyword" | "PragmaKeyword" | "HiddenKeyword" | "ChecksumKeyword" | "DisableKeyword" | "RestoreKeyword" | "ReferenceKeyword" | "InterpolatedStringStartToken" | "InterpolatedStringEndToken" | "InterpolatedVerbatimStringStartToken" | "LoadKeyword" | "NullableKeyword" | "EnableKeyword" | "WarningsKeyword" | "AnnotationsKeyword" | "VarKeyword" | "UnderscoreToken" | "OmittedTypeArgumentToken" | "OmittedArraySizeExpressionToken" | "EndOfDirectiveToken" | "EndOfDocumentationCommentToken" | "EndOfFileToken" | "BadToken" | "IdentifierToken" | "NumericLiteralToken" | "CharacterLiteralToken" | "StringLiteralToken" | "XmlEntityLiteralToken" | "XmlTextLiteralToken" | "XmlTextLiteralNewLineToken" | "InterpolatedStringToken" | "InterpolatedStringTextToken" | "SingleLineRawStringLiteralToken" | "MultiLineRawStringLiteralToken" | "Utf8StringLiteralToken" | "Utf8SingleLineRawStringLiteralToken" | "Utf8MultiLineRawStringLiteralToken" | "EndOfLineTrivia" | "WhitespaceTrivia" | "SingleLineCommentTrivia" | "MultiLineCommentTrivia" | "DocumentationCommentExteriorTrivia" | "SingleLineDocumentationCommentTrivia" | "MultiLineDocumentationCommentTrivia" | "DisabledTextTrivia" | "PreprocessingMessageTrivia" | "IfDirectiveTrivia" | "ElifDirectiveTrivia" | "ElseDirectiveTrivia" | "EndIfDirectiveTrivia" | "RegionDirectiveTrivia" | "EndRegionDirectiveTrivia" | "DefineDirectiveTrivia" | "UndefDirectiveTrivia" | "ErrorDirectiveTrivia" | "WarningDirectiveTrivia" | "LineDirectiveTrivia" | "PragmaWarningDirectiveTrivia" | "PragmaChecksumDirectiveTrivia" | "ReferenceDirectiveTrivia" | "BadDirectiveTrivia" | "SkippedTokensTrivia" | "ConflictMarkerTrivia" | "XmlElement" | "XmlElementStartTag" | "XmlElementEndTag" | "XmlEmptyElement" | "XmlTextAttribute" | "XmlCrefAttribute" | "XmlNameAttribute" | "XmlName" | "XmlPrefix" | "XmlText" | "XmlCDataSection" | "XmlComment" | "XmlProcessingInstruction" | "TypeCref" | "QualifiedCref" | "NameMemberCref" | "IndexerMemberCref" | "OperatorMemberCref" | "ConversionOperatorMemberCref" | "CrefParameterList" | "CrefBracketedParameterList" | "CrefParameter" | "IdentifierName" | "QualifiedName" | "GenericName" | "TypeArgumentList" | "AliasQualifiedName" | "PredefinedType" | "ArrayType" | "ArrayRankSpecifier" | "PointerType" | "NullableType" | "OmittedTypeArgument" | "ParenthesizedExpression" | "ConditionalExpression" | "InvocationExpression" | "ElementAccessExpression" | "ArgumentList" | "BracketedArgumentList" | "Argument" | "NameColon" | "CastExpression" | "AnonymousMethodExpression" | "SimpleLambdaExpression" | "ParenthesizedLambdaExpression" | "ObjectInitializerExpression" | "CollectionInitializerExpression" | "ArrayInitializerExpression" | "AnonymousObjectMemberDeclarator" | "ComplexElementInitializerExpression" | "ObjectCreationExpression" | "AnonymousObjectCreationExpression" | "ArrayCreationExpression" | "ImplicitArrayCreationExpression" | "StackAllocArrayCreationExpression" | "OmittedArraySizeExpression" | "InterpolatedStringExpression" | "ImplicitElementAccess" | "IsPatternExpression" | "RangeExpression" | "ImplicitObjectCreationExpression" | "AddExpression" | "SubtractExpression" | "MultiplyExpression" | "DivideExpression" | "ModuloExpression" | "LeftShiftExpression" | "RightShiftExpression" | "LogicalOrExpression" | "LogicalAndExpression" | "BitwiseOrExpression" | "BitwiseAndExpression" | "ExclusiveOrExpression" | "EqualsExpression" | "NotEqualsExpression" | "LessThanExpression" | "LessThanOrEqualExpression" | "GreaterThanExpression" | "GreaterThanOrEqualExpression" | "IsExpression" | "AsExpression" | "CoalesceExpression" | "SimpleMemberAccessExpression" | "PointerMemberAccessExpression" | "ConditionalAccessExpression" | "UnsignedRightShiftExpression" | "MemberBindingExpression" | "ElementBindingExpression" | "SimpleAssignmentExpression" | "AddAssignmentExpression" | "SubtractAssignmentExpression" | "MultiplyAssignmentExpression" | "DivideAssignmentExpression" | "ModuloAssignmentExpression" | "AndAssignmentExpression" | "ExclusiveOrAssignmentExpression" | "OrAssignmentExpression" | "LeftShiftAssignmentExpression" | "RightShiftAssignmentExpression" | "CoalesceAssignmentExpression" | "UnsignedRightShiftAssignmentExpression" | "UnaryPlusExpression" | "UnaryMinusExpression" | "BitwiseNotExpression" | "LogicalNotExpression" | "PreIncrementExpression" | "PreDecrementExpression" | "PointerIndirectionExpression" | "AddressOfExpression" | "PostIncrementExpression" | "PostDecrementExpression" | "AwaitExpression" | "IndexExpression" | "ThisExpression" | "BaseExpression" | "ArgListExpression" | "NumericLiteralExpression" | "StringLiteralExpression" | "CharacterLiteralExpression" | "TrueLiteralExpression" | "FalseLiteralExpression" | "NullLiteralExpression" | "DefaultLiteralExpression" | "Utf8StringLiteralExpression" | "TypeOfExpression" | "SizeOfExpression" | "CheckedExpression" | "UncheckedExpression" | "DefaultExpression" | "MakeRefExpression" | "RefValueExpression" | "RefTypeExpression" | "QueryExpression" | "QueryBody" | "FromClause" | "LetClause" | "JoinClause" | "JoinIntoClause" | "WhereClause" | "OrderByClause" | "AscendingOrdering" | "DescendingOrdering" | "SelectClause" | "GroupClause" | "QueryContinuation" | "Block" | "LocalDeclarationStatement" | "VariableDeclaration" | "VariableDeclarator" | "EqualsValueClause" | "ExpressionStatement" | "EmptyStatement" | "LabeledStatement" | "GotoStatement" | "GotoCaseStatement" | "GotoDefaultStatement" | "BreakStatement" | "ContinueStatement" | "ReturnStatement" | "YieldReturnStatement" | "YieldBreakStatement" | "ThrowStatement" | "WhileStatement" | "DoStatement" | "ForStatement" | "ForEachStatement" | "UsingStatement" | "FixedStatement" | "CheckedStatement" | "UncheckedStatement" | "UnsafeStatement" | "LockStatement" | "IfStatement" | "ElseClause" | "SwitchStatement" | "SwitchSection" | "CaseSwitchLabel" | "DefaultSwitchLabel" | "TryStatement" | "CatchClause" | "CatchDeclaration" | "CatchFilterClause" | "FinallyClause" | "LocalFunctionStatement" | "CompilationUnit" | "GlobalStatement" | "NamespaceDeclaration" | "UsingDirective" | "ExternAliasDirective" | "FileScopedNamespaceDeclaration" | "AttributeList" | "AttributeTargetSpecifier" | "Attribute" | "AttributeArgumentList" | "AttributeArgument" | "NameEquals" | "ClassDeclaration" | "StructDeclaration" | "InterfaceDeclaration" | "EnumDeclaration" | "DelegateDeclaration" | "BaseList" | "SimpleBaseType" | "TypeParameterConstraintClause" | "ConstructorConstraint" | "ClassConstraint" | "StructConstraint" | "TypeConstraint" | "ExplicitInterfaceSpecifier" | "EnumMemberDeclaration" | "FieldDeclaration" | "EventFieldDeclaration" | "MethodDeclaration" | "OperatorDeclaration" | "ConversionOperatorDeclaration" | "ConstructorDeclaration" | "BaseConstructorInitializer" | "ThisConstructorInitializer" | "DestructorDeclaration" | "PropertyDeclaration" | "EventDeclaration" | "IndexerDeclaration" | "AccessorList" | "GetAccessorDeclaration" | "SetAccessorDeclaration" | "AddAccessorDeclaration" | "RemoveAccessorDeclaration" | "UnknownAccessorDeclaration" | "ParameterList" | "BracketedParameterList" | "Parameter" | "TypeParameterList" | "TypeParameter" | "IncompleteMember" | "ArrowExpressionClause" | "Interpolation" | "InterpolatedStringText" | "InterpolationAlignmentClause" | "InterpolationFormatClause" | "ShebangDirectiveTrivia" | "LoadDirectiveTrivia" | "TupleType" | "TupleElement" | "TupleExpression" | "SingleVariableDesignation" | "ParenthesizedVariableDesignation" | "ForEachVariableStatement" | "DeclarationPattern" | "ConstantPattern" | "CasePatternSwitchLabel" | "WhenClause" | "DiscardDesignation" | "RecursivePattern" | "PropertyPatternClause" | "Subpattern" | "PositionalPatternClause" | "DiscardPattern" | "SwitchExpression" | "SwitchExpressionArm" | "VarPattern" | "ParenthesizedPattern" | "RelationalPattern" | "TypePattern" | "OrPattern" | "AndPattern" | "NotPattern" | "SlicePattern" | "ListPattern" | "DeclarationExpression" | "RefExpression" | "RefType" | "ThrowExpression" | "ImplicitStackAllocArrayCreationExpression" | "SuppressNullableWarningExpression" | "NullableDirectiveTrivia" | "FunctionPointerType" | "FunctionPointerParameter" | "FunctionPointerParameterList" | "FunctionPointerCallingConvention" | "InitAccessorDeclaration" | "WithExpression" | "WithInitializerExpression" | "RecordDeclaration" | "DefaultConstraint" | "PrimaryConstructorBaseType" | "FunctionPointerUnmanagedCallingConventionList" | "FunctionPointerUnmanagedCallingConvention" | "RecordStructDeclaration" | "ExpressionColon" | "LineDirectivePosition" | "LineSpanDirectiveTrivia" | "InterpolatedSingleLineRawStringStartToken" | "InterpolatedMultiLineRawStringStartToken" | "InterpolatedRawStringEndToken" | "ScopedType" | "CollectionExpression" | "ExpressionElement" | "SpreadElement";

export class LinePositionSpan implements ILinePositionSpan {
    start!: LinePosition;
    end!: LinePosition;
    _start!: LinePosition;
    _end!: LinePosition;

    constructor(data?: ILinePositionSpan) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.start = new LinePosition();
            this.end = new LinePosition();
            this._start = new LinePosition();
            this._end = new LinePosition();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.start = _data["start"] ? LinePosition.fromJS(_data["start"]) : new LinePosition();
            this.end = _data["end"] ? LinePosition.fromJS(_data["end"]) : new LinePosition();
            this._start = _data["_start"] ? LinePosition.fromJS(_data["_start"]) : new LinePosition();
            this._end = _data["_end"] ? LinePosition.fromJS(_data["_end"]) : new LinePosition();
        }
    }

    static fromJS(data: any): LinePositionSpan {
        data = typeof data === 'object' ? data : {};
        let result = new LinePositionSpan();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["start"] = this.start ? this.start.toJSON() : <any>undefined;
        data["end"] = this.end ? this.end.toJSON() : <any>undefined;
        data["_start"] = this._start ? this._start.toJSON() : <any>undefined;
        data["_end"] = this._end ? this._end.toJSON() : <any>undefined;
        return data;
    }

    clone(): LinePositionSpan {
        const json = this.toJSON();
        let result = new LinePositionSpan();
        result.init(json);
        return result;
    }
}

export interface ILinePositionSpan {
    start: LinePosition;
    end: LinePosition;
    _start: LinePosition;
    _end: LinePosition;
}

export class LinePosition implements ILinePosition {
    line!: number;
    character!: number;
    _line!: number;
    _character!: number;

    constructor(data?: ILinePosition) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.line = _data["line"];
            this.character = _data["character"];
            this._line = _data["_line"];
            this._character = _data["_character"];
        }
    }

    static fromJS(data: any): LinePosition {
        data = typeof data === 'object' ? data : {};
        let result = new LinePosition();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["line"] = this.line;
        data["character"] = this.character;
        data["_line"] = this._line;
        data["_character"] = this._character;
        return data;
    }

    clone(): LinePosition {
        const json = this.toJSON();
        let result = new LinePosition();
        result.init(json);
        return result;
    }
}

export interface ILinePosition {
    line: number;
    character: number;
    _line: number;
    _character: number;
}

export class SyntaxTriviaSlim implements ISyntaxTriviaSlim {
    kind!: SyntaxKind;
    span!: LinePositionSpan;
    displayValue?: string | undefined;

    constructor(data?: ISyntaxTriviaSlim) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.span = new LinePositionSpan();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.kind = _data["kind"];
            this.span = _data["span"] ? LinePositionSpan.fromJS(_data["span"]) : new LinePositionSpan();
            this.displayValue = _data["displayValue"];
        }
    }

    static fromJS(data: any): SyntaxTriviaSlim {
        data = typeof data === 'object' ? data : {};
        let result = new SyntaxTriviaSlim();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["kind"] = this.kind;
        data["span"] = this.span ? this.span.toJSON() : <any>undefined;
        data["displayValue"] = this.displayValue;
        return data;
    }

    clone(): SyntaxTriviaSlim {
        const json = this.toJSON();
        let result = new SyntaxTriviaSlim();
        result.init(json);
        return result;
    }
}

export interface ISyntaxTriviaSlim {
    kind: SyntaxKind;
    span: LinePositionSpan;
    displayValue?: string | undefined;
}

export abstract class DataConnection implements IDataConnection {
    id!: string;
    name!: string;
    type!: DataConnectionType;

    protected _discriminator: string;

    constructor(data?: IDataConnection) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        this._discriminator = "DataConnection";
    }

    init(_data?: any) {
        if (_data) {
            this.id = _data["id"];
            this.name = _data["name"];
            this.type = _data["type"];
        }
    }

    static fromJS(data: any): DataConnection {
        data = typeof data === 'object' ? data : {};
        if (data["discriminator"] === "DatabaseConnection") {
            throw new Error("The abstract class 'DatabaseConnection' cannot be instantiated.");
        }
        if (data["discriminator"] === "EntityFrameworkDatabaseConnection") {
            throw new Error("The abstract class 'EntityFrameworkDatabaseConnection' cannot be instantiated.");
        }
        if (data["discriminator"] === "EntityFrameworkRelationalDatabaseConnection") {
            throw new Error("The abstract class 'EntityFrameworkRelationalDatabaseConnection' cannot be instantiated.");
        }
        if (data["discriminator"] === "MsSqlServerDatabaseConnection") {
            let result = new MsSqlServerDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "PostgreSqlDatabaseConnection") {
            let result = new PostgreSqlDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "SQLiteDatabaseConnection") {
            let result = new SQLiteDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "MySqlDatabaseConnection") {
            let result = new MySqlDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "MariaDbDatabaseConnection") {
            let result = new MariaDbDatabaseConnection();
            result.init(data);
            return result;
        }
        throw new Error("The abstract class 'DataConnection' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["discriminator"] = this._discriminator;
        data["id"] = this.id;
        data["name"] = this.name;
        data["type"] = this.type;
        return data;
    }

    clone(): DataConnection {
        throw new Error("The abstract class 'DataConnection' cannot be instantiated.");
    }
}

export interface IDataConnection {
    id: string;
    name: string;
    type: DataConnectionType;
}

export type DataConnectionType = "MSSQLServer" | "PostgreSQL" | "SQLite" | "MySQL" | "MariaDB";

export class DataConnectionTestResult implements IDataConnectionTestResult {
    success!: boolean;
    message?: string | undefined;

    constructor(data?: IDataConnectionTestResult) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.success = _data["success"];
            this.message = _data["message"];
        }
    }

    static fromJS(data: any): DataConnectionTestResult {
        data = typeof data === 'object' ? data : {};
        let result = new DataConnectionTestResult();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["success"] = this.success;
        data["message"] = this.message;
        return data;
    }

    clone(): DataConnectionTestResult {
        const json = this.toJSON();
        let result = new DataConnectionTestResult();
        result.init(json);
        return result;
    }
}

export interface IDataConnectionTestResult {
    success: boolean;
    message?: string | undefined;
}

export class DatabaseStructure implements IDatabaseStructure {
    databaseName!: string;
    schemas!: DatabaseSchema[];

    constructor(data?: IDatabaseStructure) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.schemas = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            this.databaseName = _data["databaseName"];
            if (Array.isArray(_data["schemas"])) {
                this.schemas = [] as any;
                for (let item of _data["schemas"])
                    this.schemas!.push(DatabaseSchema.fromJS(item));
            }
        }
    }

    static fromJS(data: any): DatabaseStructure {
        data = typeof data === 'object' ? data : {};
        let result = new DatabaseStructure();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["databaseName"] = this.databaseName;
        if (Array.isArray(this.schemas)) {
            data["schemas"] = [];
            for (let item of this.schemas)
                data["schemas"].push(item.toJSON());
        }
        return data;
    }

    clone(): DatabaseStructure {
        const json = this.toJSON();
        let result = new DatabaseStructure();
        result.init(json);
        return result;
    }
}

export interface IDatabaseStructure {
    databaseName: string;
    schemas: DatabaseSchema[];
}

export class DatabaseSchema implements IDatabaseSchema {
    name?: string | undefined;
    tables!: DatabaseTable[];

    constructor(data?: IDatabaseSchema) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.tables = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            this.name = _data["name"];
            if (Array.isArray(_data["tables"])) {
                this.tables = [] as any;
                for (let item of _data["tables"])
                    this.tables!.push(DatabaseTable.fromJS(item));
            }
        }
    }

    static fromJS(data: any): DatabaseSchema {
        data = typeof data === 'object' ? data : {};
        let result = new DatabaseSchema();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["name"] = this.name;
        if (Array.isArray(this.tables)) {
            data["tables"] = [];
            for (let item of this.tables)
                data["tables"].push(item.toJSON());
        }
        return data;
    }

    clone(): DatabaseSchema {
        const json = this.toJSON();
        let result = new DatabaseSchema();
        result.init(json);
        return result;
    }
}

export interface IDatabaseSchema {
    name?: string | undefined;
    tables: DatabaseTable[];
}

export class DatabaseTable implements IDatabaseTable {
    name!: string;
    displayName!: string;
    columns!: DatabaseTableColumn[];
    indexes!: DatabaseIndex[];
    navigations!: DatabaseTableNavigation[];

    constructor(data?: IDatabaseTable) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.columns = [];
            this.indexes = [];
            this.navigations = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            this.name = _data["name"];
            this.displayName = _data["displayName"];
            if (Array.isArray(_data["columns"])) {
                this.columns = [] as any;
                for (let item of _data["columns"])
                    this.columns!.push(DatabaseTableColumn.fromJS(item));
            }
            if (Array.isArray(_data["indexes"])) {
                this.indexes = [] as any;
                for (let item of _data["indexes"])
                    this.indexes!.push(DatabaseIndex.fromJS(item));
            }
            if (Array.isArray(_data["navigations"])) {
                this.navigations = [] as any;
                for (let item of _data["navigations"])
                    this.navigations!.push(DatabaseTableNavigation.fromJS(item));
            }
        }
    }

    static fromJS(data: any): DatabaseTable {
        data = typeof data === 'object' ? data : {};
        let result = new DatabaseTable();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["name"] = this.name;
        data["displayName"] = this.displayName;
        if (Array.isArray(this.columns)) {
            data["columns"] = [];
            for (let item of this.columns)
                data["columns"].push(item.toJSON());
        }
        if (Array.isArray(this.indexes)) {
            data["indexes"] = [];
            for (let item of this.indexes)
                data["indexes"].push(item.toJSON());
        }
        if (Array.isArray(this.navigations)) {
            data["navigations"] = [];
            for (let item of this.navigations)
                data["navigations"].push(item.toJSON());
        }
        return data;
    }

    clone(): DatabaseTable {
        const json = this.toJSON();
        let result = new DatabaseTable();
        result.init(json);
        return result;
    }
}

export interface IDatabaseTable {
    name: string;
    displayName: string;
    columns: DatabaseTableColumn[];
    indexes: DatabaseIndex[];
    navigations: DatabaseTableNavigation[];
}

export class DatabaseTableColumn implements IDatabaseTableColumn {
    name!: string;
    type!: string;
    clrType!: string;
    isPrimaryKey!: boolean;
    isForeignKey!: boolean;
    order?: number | undefined;

    constructor(data?: IDatabaseTableColumn) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.name = _data["name"];
            this.type = _data["type"];
            this.clrType = _data["clrType"];
            this.isPrimaryKey = _data["isPrimaryKey"];
            this.isForeignKey = _data["isForeignKey"];
            this.order = _data["order"];
        }
    }

    static fromJS(data: any): DatabaseTableColumn {
        data = typeof data === 'object' ? data : {};
        let result = new DatabaseTableColumn();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["name"] = this.name;
        data["type"] = this.type;
        data["clrType"] = this.clrType;
        data["isPrimaryKey"] = this.isPrimaryKey;
        data["isForeignKey"] = this.isForeignKey;
        data["order"] = this.order;
        return data;
    }

    clone(): DatabaseTableColumn {
        const json = this.toJSON();
        let result = new DatabaseTableColumn();
        result.init(json);
        return result;
    }
}

export interface IDatabaseTableColumn {
    name: string;
    type: string;
    clrType: string;
    isPrimaryKey: boolean;
    isForeignKey: boolean;
    order?: number | undefined;
}

export class DatabaseIndex implements IDatabaseIndex {
    name!: string;
    isUnique!: boolean;
    columns!: string[];

    constructor(data?: IDatabaseIndex) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.columns = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            this.name = _data["name"];
            this.isUnique = _data["isUnique"];
            if (Array.isArray(_data["columns"])) {
                this.columns = [] as any;
                for (let item of _data["columns"])
                    this.columns!.push(item);
            }
        }
    }

    static fromJS(data: any): DatabaseIndex {
        data = typeof data === 'object' ? data : {};
        let result = new DatabaseIndex();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["name"] = this.name;
        data["isUnique"] = this.isUnique;
        if (Array.isArray(this.columns)) {
            data["columns"] = [];
            for (let item of this.columns)
                data["columns"].push(item);
        }
        return data;
    }

    clone(): DatabaseIndex {
        const json = this.toJSON();
        let result = new DatabaseIndex();
        result.init(json);
        return result;
    }
}

export interface IDatabaseIndex {
    name: string;
    isUnique: boolean;
    columns: string[];
}

export class DatabaseTableNavigation implements IDatabaseTableNavigation {
    name!: string;
    target!: string;
    clrType?: string | undefined;

    constructor(data?: IDatabaseTableNavigation) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.name = _data["name"];
            this.target = _data["target"];
            this.clrType = _data["clrType"];
        }
    }

    static fromJS(data: any): DatabaseTableNavigation {
        data = typeof data === 'object' ? data : {};
        let result = new DatabaseTableNavigation();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["name"] = this.name;
        data["target"] = this.target;
        data["clrType"] = this.clrType;
        return data;
    }

    clone(): DatabaseTableNavigation {
        const json = this.toJSON();
        let result = new DatabaseTableNavigation();
        result.init(json);
        return result;
    }
}

export interface IDatabaseTableNavigation {
    name: string;
    target: string;
    clrType?: string | undefined;
}

export class PackageMetadata implements IPackageMetadata {
    packageId!: string;
    version?: string | undefined;
    title!: string;
    authors?: string | undefined;
    description?: string | undefined;
    iconUrl?: string | undefined;
    projectUrl?: string | undefined;
    packageDetailsUrl?: string | undefined;
    licenseUrl?: string | undefined;
    readmeUrl?: string | undefined;
    reportAbuseUrl?: string | undefined;
    requireLicenseAcceptance?: boolean | undefined;
    dependencies!: PackageDependencySet[];
    downloadCount?: number | undefined;
    publishedDate?: Date | undefined;
    latestAvailableVersion?: string | undefined;

    constructor(data?: IPackageMetadata) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.dependencies = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            this.packageId = _data["packageId"];
            this.version = _data["version"];
            this.title = _data["title"];
            this.authors = _data["authors"];
            this.description = _data["description"];
            this.iconUrl = _data["iconUrl"];
            this.projectUrl = _data["projectUrl"];
            this.packageDetailsUrl = _data["packageDetailsUrl"];
            this.licenseUrl = _data["licenseUrl"];
            this.readmeUrl = _data["readmeUrl"];
            this.reportAbuseUrl = _data["reportAbuseUrl"];
            this.requireLicenseAcceptance = _data["requireLicenseAcceptance"];
            if (Array.isArray(_data["dependencies"])) {
                this.dependencies = [] as any;
                for (let item of _data["dependencies"])
                    this.dependencies!.push(PackageDependencySet.fromJS(item));
            }
            this.downloadCount = _data["downloadCount"];
            this.publishedDate = _data["publishedDate"] ? new Date(_data["publishedDate"].toString()) : <any>undefined;
            this.latestAvailableVersion = _data["latestAvailableVersion"];
        }
    }

    static fromJS(data: any): PackageMetadata {
        data = typeof data === 'object' ? data : {};
        let result = new PackageMetadata();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["packageId"] = this.packageId;
        data["version"] = this.version;
        data["title"] = this.title;
        data["authors"] = this.authors;
        data["description"] = this.description;
        data["iconUrl"] = this.iconUrl;
        data["projectUrl"] = this.projectUrl;
        data["packageDetailsUrl"] = this.packageDetailsUrl;
        data["licenseUrl"] = this.licenseUrl;
        data["readmeUrl"] = this.readmeUrl;
        data["reportAbuseUrl"] = this.reportAbuseUrl;
        data["requireLicenseAcceptance"] = this.requireLicenseAcceptance;
        if (Array.isArray(this.dependencies)) {
            data["dependencies"] = [];
            for (let item of this.dependencies)
                data["dependencies"].push(item.toJSON());
        }
        data["downloadCount"] = this.downloadCount;
        data["publishedDate"] = this.publishedDate ? this.publishedDate.toISOString() : <any>undefined;
        data["latestAvailableVersion"] = this.latestAvailableVersion;
        return data;
    }

    clone(): PackageMetadata {
        const json = this.toJSON();
        let result = new PackageMetadata();
        result.init(json);
        return result;
    }
}

export interface IPackageMetadata {
    packageId: string;
    version?: string | undefined;
    title: string;
    authors?: string | undefined;
    description?: string | undefined;
    iconUrl?: string | undefined;
    projectUrl?: string | undefined;
    packageDetailsUrl?: string | undefined;
    licenseUrl?: string | undefined;
    readmeUrl?: string | undefined;
    reportAbuseUrl?: string | undefined;
    requireLicenseAcceptance?: boolean | undefined;
    dependencies: PackageDependencySet[];
    downloadCount?: number | undefined;
    publishedDate?: Date | undefined;
    latestAvailableVersion?: string | undefined;
}

export class CachedPackage extends PackageMetadata implements ICachedPackage {
    installReason!: PackageInstallReason;
    directoryPath?: string | undefined;

    constructor(data?: ICachedPackage) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.installReason = _data["installReason"];
            this.directoryPath = _data["directoryPath"];
        }
    }

    static fromJS(data: any): CachedPackage {
        data = typeof data === 'object' ? data : {};
        let result = new CachedPackage();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["installReason"] = this.installReason;
        data["directoryPath"] = this.directoryPath;
        super.toJSON(data);
        return data;
    }

    clone(): CachedPackage {
        const json = this.toJSON();
        let result = new CachedPackage();
        result.init(json);
        return result;
    }
}

export interface ICachedPackage extends IPackageMetadata {
    installReason: PackageInstallReason;
    directoryPath?: string | undefined;
}

export type PackageInstallReason = "Explicit" | "Dependency";

export class PackageDependencySet implements IPackageDependencySet {
    targetFramework!: string;
    packages?: string[] | undefined;

    constructor(data?: IPackageDependencySet) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.targetFramework = _data["targetFramework"];
            if (Array.isArray(_data["packages"])) {
                this.packages = [] as any;
                for (let item of _data["packages"])
                    this.packages!.push(item);
            }
        }
    }

    static fromJS(data: any): PackageDependencySet {
        data = typeof data === 'object' ? data : {};
        let result = new PackageDependencySet();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["targetFramework"] = this.targetFramework;
        if (Array.isArray(this.packages)) {
            data["packages"] = [];
            for (let item of this.packages)
                data["packages"].push(item);
        }
        return data;
    }

    clone(): PackageDependencySet {
        const json = this.toJSON();
        let result = new PackageDependencySet();
        result.init(json);
        return result;
    }
}

export interface IPackageDependencySet {
    targetFramework: string;
    packages?: string[] | undefined;
}

export class PackageIdentity implements IPackageIdentity {
    id!: string;
    version!: string;

    constructor(data?: IPackageIdentity) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.id = _data["id"];
            this.version = _data["version"];
        }
    }

    static fromJS(data: any): PackageIdentity {
        data = typeof data === 'object' ? data : {};
        let result = new PackageIdentity();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["id"] = this.id;
        data["version"] = this.version;
        return data;
    }

    clone(): PackageIdentity {
        const json = this.toJSON();
        let result = new PackageIdentity();
        result.init(json);
        return result;
    }
}

export interface IPackageIdentity {
    id: string;
    version: string;
}

export type DotNetFrameworkVersion = "DotNet5" | "DotNet6" | "DotNet7" | "DotNet8" | "DotNet9";

export class ScriptSummary implements IScriptSummary {
    id!: string;
    name!: string;
    path!: string;
    kind!: ScriptKind;

    constructor(data?: IScriptSummary) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.id = _data["id"];
            this.name = _data["name"];
            this.path = _data["path"];
            this.kind = _data["kind"];
        }
    }

    static fromJS(data: any): ScriptSummary {
        data = typeof data === 'object' ? data : {};
        let result = new ScriptSummary();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["id"] = this.id;
        data["name"] = this.name;
        data["path"] = this.path;
        data["kind"] = this.kind;
        return data;
    }

    clone(): ScriptSummary {
        const json = this.toJSON();
        let result = new ScriptSummary();
        result.init(json);
        return result;
    }
}

export interface IScriptSummary {
    id: string;
    name: string;
    path: string;
    kind: ScriptKind;
}

export type ScriptKind = "Expression" | "Program" | "SQL";

export class CreateScriptDto implements ICreateScriptDto {
    code?: string | undefined;
    dataConnectionId?: string | undefined;
    runImmediately!: boolean;

    constructor(data?: ICreateScriptDto) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.code = _data["code"];
            this.dataConnectionId = _data["dataConnectionId"];
            this.runImmediately = _data["runImmediately"];
        }
    }

    static fromJS(data: any): CreateScriptDto {
        data = typeof data === 'object' ? data : {};
        let result = new CreateScriptDto();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["code"] = this.code;
        data["dataConnectionId"] = this.dataConnectionId;
        data["runImmediately"] = this.runImmediately;
        return data;
    }

    clone(): CreateScriptDto {
        const json = this.toJSON();
        let result = new CreateScriptDto();
        result.init(json);
        return result;
    }
}

export interface ICreateScriptDto {
    code?: string | undefined;
    dataConnectionId?: string | undefined;
    runImmediately: boolean;
}

/** Options that configure the running of a script. */
export class RunOptions implements IRunOptions {
    /** If not null, this code will run instead of script code. Typically used to only run code that user has
highlighted in the editor. */
    specificCodeToRun?: string | undefined;

    constructor(data?: IRunOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.specificCodeToRun = _data["specificCodeToRun"];
        }
    }

    static fromJS(data: any): RunOptions {
        data = typeof data === 'object' ? data : {};
        let result = new RunOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["specificCodeToRun"] = this.specificCodeToRun;
        return data;
    }

    clone(): RunOptions {
        const json = this.toJSON();
        let result = new RunOptions();
        result.init(json);
        return result;
    }
}

/** Options that configure the running of a script. */
export interface IRunOptions {
    /** If not null, this code will run instead of script code. Typically used to only run code that user has
highlighted in the editor. */
    specificCodeToRun?: string | undefined;
}

export type OptimizationLevel = "Debug" | "Release";

export class ScriptEnvironment implements IScriptEnvironment {
    script!: Script;
    status!: ScriptStatus;
    runDurationMilliseconds!: number;

    constructor(data?: IScriptEnvironment) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.script = new Script();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.script = _data["script"] ? Script.fromJS(_data["script"]) : new Script();
            this.status = _data["status"];
            this.runDurationMilliseconds = _data["runDurationMilliseconds"];
        }
    }

    static fromJS(data: any): ScriptEnvironment {
        data = typeof data === 'object' ? data : {};
        let result = new ScriptEnvironment();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["script"] = this.script ? this.script.toJSON() : <any>undefined;
        data["status"] = this.status;
        data["runDurationMilliseconds"] = this.runDurationMilliseconds;
        return data;
    }

    clone(): ScriptEnvironment {
        const json = this.toJSON();
        let result = new ScriptEnvironment();
        result.init(json);
        return result;
    }
}

export interface IScriptEnvironment {
    script: Script;
    status: ScriptStatus;
    runDurationMilliseconds: number;
}

export class Script implements IScript {
    id!: string;
    name!: string;
    path?: string | undefined;
    config!: ScriptConfig;
    dataConnection?: DataConnection | undefined;
    code!: string;
    isDirty!: boolean;
    directoryPath?: string | undefined;
    isNew!: boolean;

    constructor(data?: IScript) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.config = new ScriptConfig();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.id = _data["id"];
            this.name = _data["name"];
            this.path = _data["path"];
            this.config = _data["config"] ? ScriptConfig.fromJS(_data["config"]) : new ScriptConfig();
            this.dataConnection = _data["dataConnection"] ? DataConnection.fromJS(_data["dataConnection"]) : <any>undefined;
            this.code = _data["code"];
            this.isDirty = _data["isDirty"];
            this.directoryPath = _data["directoryPath"];
            this.isNew = _data["isNew"];
        }
    }

    static fromJS(data: any): Script {
        data = typeof data === 'object' ? data : {};
        let result = new Script();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["id"] = this.id;
        data["name"] = this.name;
        data["path"] = this.path;
        data["config"] = this.config ? this.config.toJSON() : <any>undefined;
        data["dataConnection"] = this.dataConnection ? this.dataConnection.toJSON() : <any>undefined;
        data["code"] = this.code;
        data["isDirty"] = this.isDirty;
        data["directoryPath"] = this.directoryPath;
        data["isNew"] = this.isNew;
        return data;
    }

    clone(): Script {
        const json = this.toJSON();
        let result = new Script();
        result.init(json);
        return result;
    }
}

export interface IScript {
    id: string;
    name: string;
    path?: string | undefined;
    config: ScriptConfig;
    dataConnection?: DataConnection | undefined;
    code: string;
    isDirty: boolean;
    directoryPath?: string | undefined;
    isNew: boolean;
}

export class ScriptConfig implements IScriptConfig {
    kind!: ScriptKind;
    targetFrameworkVersion!: DotNetFrameworkVersion;
    optimizationLevel!: OptimizationLevel;
    useAspNet!: boolean;
    namespaces!: string[];
    references!: Reference[];

    constructor(data?: IScriptConfig) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.namespaces = [];
            this.references = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            this.kind = _data["kind"];
            this.targetFrameworkVersion = _data["targetFrameworkVersion"];
            this.optimizationLevel = _data["optimizationLevel"];
            this.useAspNet = _data["useAspNet"];
            if (Array.isArray(_data["namespaces"])) {
                this.namespaces = [] as any;
                for (let item of _data["namespaces"])
                    this.namespaces!.push(item);
            }
            if (Array.isArray(_data["references"])) {
                this.references = [] as any;
                for (let item of _data["references"])
                    this.references!.push(Reference.fromJS(item));
            }
        }
    }

    static fromJS(data: any): ScriptConfig {
        data = typeof data === 'object' ? data : {};
        let result = new ScriptConfig();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["kind"] = this.kind;
        data["targetFrameworkVersion"] = this.targetFrameworkVersion;
        data["optimizationLevel"] = this.optimizationLevel;
        data["useAspNet"] = this.useAspNet;
        if (Array.isArray(this.namespaces)) {
            data["namespaces"] = [];
            for (let item of this.namespaces)
                data["namespaces"].push(item);
        }
        if (Array.isArray(this.references)) {
            data["references"] = [];
            for (let item of this.references)
                data["references"].push(item.toJSON());
        }
        return data;
    }

    clone(): ScriptConfig {
        const json = this.toJSON();
        let result = new ScriptConfig();
        result.init(json);
        return result;
    }
}

export interface IScriptConfig {
    kind: ScriptKind;
    targetFrameworkVersion: DotNetFrameworkVersion;
    optimizationLevel: OptimizationLevel;
    useAspNet: boolean;
    namespaces: string[];
    references: Reference[];
}

export type ScriptStatus = "Ready" | "Running" | "Stopping" | "Error";

export class Settings implements ISettings {
    version!: string;
    autoCheckUpdates?: boolean | undefined;
    dotNetSdkDirectoryPath?: string | undefined;
    scriptsDirectoryPath!: string;
    autoSaveScriptsDirectoryPath!: string;
    packageCacheDirectoryPath!: string;
    appearance!: AppearanceOptions;
    editor!: EditorOptions;
    results!: ResultsOptions;
    styles!: StyleOptions;
    keyboardShortcuts!: KeyboardShortcutOptions;
    omniSharp!: OmniSharpOptions;

    constructor(data?: ISettings) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.appearance = new AppearanceOptions();
            this.editor = new EditorOptions();
            this.results = new ResultsOptions();
            this.styles = new StyleOptions();
            this.keyboardShortcuts = new KeyboardShortcutOptions();
            this.omniSharp = new OmniSharpOptions();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.version = _data["version"];
            this.autoCheckUpdates = _data["autoCheckUpdates"];
            this.dotNetSdkDirectoryPath = _data["dotNetSdkDirectoryPath"];
            this.scriptsDirectoryPath = _data["scriptsDirectoryPath"];
            this.autoSaveScriptsDirectoryPath = _data["autoSaveScriptsDirectoryPath"];
            this.packageCacheDirectoryPath = _data["packageCacheDirectoryPath"];
            this.appearance = _data["appearance"] ? AppearanceOptions.fromJS(_data["appearance"]) : new AppearanceOptions();
            this.editor = _data["editor"] ? EditorOptions.fromJS(_data["editor"]) : new EditorOptions();
            this.results = _data["results"] ? ResultsOptions.fromJS(_data["results"]) : new ResultsOptions();
            this.styles = _data["styles"] ? StyleOptions.fromJS(_data["styles"]) : new StyleOptions();
            this.keyboardShortcuts = _data["keyboardShortcuts"] ? KeyboardShortcutOptions.fromJS(_data["keyboardShortcuts"]) : new KeyboardShortcutOptions();
            this.omniSharp = _data["omniSharp"] ? OmniSharpOptions.fromJS(_data["omniSharp"]) : new OmniSharpOptions();
        }
    }

    static fromJS(data: any): Settings {
        data = typeof data === 'object' ? data : {};
        let result = new Settings();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["version"] = this.version;
        data["autoCheckUpdates"] = this.autoCheckUpdates;
        data["dotNetSdkDirectoryPath"] = this.dotNetSdkDirectoryPath;
        data["scriptsDirectoryPath"] = this.scriptsDirectoryPath;
        data["autoSaveScriptsDirectoryPath"] = this.autoSaveScriptsDirectoryPath;
        data["packageCacheDirectoryPath"] = this.packageCacheDirectoryPath;
        data["appearance"] = this.appearance ? this.appearance.toJSON() : <any>undefined;
        data["editor"] = this.editor ? this.editor.toJSON() : <any>undefined;
        data["results"] = this.results ? this.results.toJSON() : <any>undefined;
        data["styles"] = this.styles ? this.styles.toJSON() : <any>undefined;
        data["keyboardShortcuts"] = this.keyboardShortcuts ? this.keyboardShortcuts.toJSON() : <any>undefined;
        data["omniSharp"] = this.omniSharp ? this.omniSharp.toJSON() : <any>undefined;
        return data;
    }

    clone(): Settings {
        const json = this.toJSON();
        let result = new Settings();
        result.init(json);
        return result;
    }
}

export interface ISettings {
    version: string;
    autoCheckUpdates?: boolean | undefined;
    dotNetSdkDirectoryPath?: string | undefined;
    scriptsDirectoryPath: string;
    autoSaveScriptsDirectoryPath: string;
    packageCacheDirectoryPath: string;
    appearance: AppearanceOptions;
    editor: EditorOptions;
    results: ResultsOptions;
    styles: StyleOptions;
    keyboardShortcuts: KeyboardShortcutOptions;
    omniSharp: OmniSharpOptions;
}

export class AppearanceOptions implements IAppearanceOptions {
    theme!: Theme;
    iconTheme!: IconTheme;
    showScriptRunStatusIndicatorInTab!: boolean;
    showScriptRunStatusIndicatorInScriptsList!: boolean;
    showScriptRunningIndicatorInScriptsList!: boolean;
    titlebar!: TitlebarOptions;

    constructor(data?: IAppearanceOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.titlebar = new TitlebarOptions();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.theme = _data["theme"];
            this.iconTheme = _data["iconTheme"];
            this.showScriptRunStatusIndicatorInTab = _data["showScriptRunStatusIndicatorInTab"];
            this.showScriptRunStatusIndicatorInScriptsList = _data["showScriptRunStatusIndicatorInScriptsList"];
            this.showScriptRunningIndicatorInScriptsList = _data["showScriptRunningIndicatorInScriptsList"];
            this.titlebar = _data["titlebar"] ? TitlebarOptions.fromJS(_data["titlebar"]) : new TitlebarOptions();
        }
    }

    static fromJS(data: any): AppearanceOptions {
        data = typeof data === 'object' ? data : {};
        let result = new AppearanceOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["theme"] = this.theme;
        data["iconTheme"] = this.iconTheme;
        data["showScriptRunStatusIndicatorInTab"] = this.showScriptRunStatusIndicatorInTab;
        data["showScriptRunStatusIndicatorInScriptsList"] = this.showScriptRunStatusIndicatorInScriptsList;
        data["showScriptRunningIndicatorInScriptsList"] = this.showScriptRunningIndicatorInScriptsList;
        data["titlebar"] = this.titlebar ? this.titlebar.toJSON() : <any>undefined;
        return data;
    }

    clone(): AppearanceOptions {
        const json = this.toJSON();
        let result = new AppearanceOptions();
        result.init(json);
        return result;
    }
}

export interface IAppearanceOptions {
    theme: Theme;
    iconTheme: IconTheme;
    showScriptRunStatusIndicatorInTab: boolean;
    showScriptRunStatusIndicatorInScriptsList: boolean;
    showScriptRunningIndicatorInScriptsList: boolean;
    titlebar: TitlebarOptions;
}

export type Theme = "Dark" | "Light";

export type IconTheme = "Default" | "Colorful";

export class TitlebarOptions implements ITitlebarOptions {
    type!: TitlebarType;
    windowControlsPosition!: WindowControlsPosition;
    mainMenuVisibility!: MainMenuVisibility;

    constructor(data?: ITitlebarOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.type = _data["type"];
            this.windowControlsPosition = _data["windowControlsPosition"];
            this.mainMenuVisibility = _data["mainMenuVisibility"];
        }
    }

    static fromJS(data: any): TitlebarOptions {
        data = typeof data === 'object' ? data : {};
        let result = new TitlebarOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["type"] = this.type;
        data["windowControlsPosition"] = this.windowControlsPosition;
        data["mainMenuVisibility"] = this.mainMenuVisibility;
        return data;
    }

    clone(): TitlebarOptions {
        const json = this.toJSON();
        let result = new TitlebarOptions();
        result.init(json);
        return result;
    }
}

export interface ITitlebarOptions {
    type: TitlebarType;
    windowControlsPosition: WindowControlsPosition;
    mainMenuVisibility: MainMenuVisibility;
}

export type TitlebarType = "Integrated" | "Native";

export type WindowControlsPosition = "Right" | "Left";

export type MainMenuVisibility = "AlwaysVisible" | "AutoHidden";

export class EditorOptions implements IEditorOptions {
    monacoOptions!: any;

    constructor(data?: IEditorOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.monacoOptions = _data["monacoOptions"];
        }
    }

    static fromJS(data: any): EditorOptions {
        data = typeof data === 'object' ? data : {};
        let result = new EditorOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["monacoOptions"] = this.monacoOptions;
        return data;
    }

    clone(): EditorOptions {
        const json = this.toJSON();
        let result = new EditorOptions();
        result.init(json);
        return result;
    }
}

export interface IEditorOptions {
    monacoOptions: any;
}

export class ResultsOptions implements IResultsOptions {
    openOnRun!: boolean;
    textWrap!: boolean;
    font?: string | undefined;
    maxSerializationDepth!: number;
    maxCollectionSerializeLength!: number;

    constructor(data?: IResultsOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.openOnRun = _data["openOnRun"];
            this.textWrap = _data["textWrap"];
            this.font = _data["font"];
            this.maxSerializationDepth = _data["maxSerializationDepth"];
            this.maxCollectionSerializeLength = _data["maxCollectionSerializeLength"];
        }
    }

    static fromJS(data: any): ResultsOptions {
        data = typeof data === 'object' ? data : {};
        let result = new ResultsOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["openOnRun"] = this.openOnRun;
        data["textWrap"] = this.textWrap;
        data["font"] = this.font;
        data["maxSerializationDepth"] = this.maxSerializationDepth;
        data["maxCollectionSerializeLength"] = this.maxCollectionSerializeLength;
        return data;
    }

    clone(): ResultsOptions {
        const json = this.toJSON();
        let result = new ResultsOptions();
        result.init(json);
        return result;
    }
}

export interface IResultsOptions {
    openOnRun: boolean;
    textWrap: boolean;
    font?: string | undefined;
    maxSerializationDepth: number;
    maxCollectionSerializeLength: number;
}

export class StyleOptions implements IStyleOptions {
    enabled!: boolean;
    customCss?: string | undefined;

    constructor(data?: IStyleOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.enabled = _data["enabled"];
            this.customCss = _data["customCss"];
        }
    }

    static fromJS(data: any): StyleOptions {
        data = typeof data === 'object' ? data : {};
        let result = new StyleOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["enabled"] = this.enabled;
        data["customCss"] = this.customCss;
        return data;
    }

    clone(): StyleOptions {
        const json = this.toJSON();
        let result = new StyleOptions();
        result.init(json);
        return result;
    }
}

export interface IStyleOptions {
    enabled: boolean;
    customCss?: string | undefined;
}

export class KeyboardShortcutOptions implements IKeyboardShortcutOptions {
    shortcuts!: KeyboardShortcutConfiguration[];

    constructor(data?: IKeyboardShortcutOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.shortcuts = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["shortcuts"])) {
                this.shortcuts = [] as any;
                for (let item of _data["shortcuts"])
                    this.shortcuts!.push(KeyboardShortcutConfiguration.fromJS(item));
            }
        }
    }

    static fromJS(data: any): KeyboardShortcutOptions {
        data = typeof data === 'object' ? data : {};
        let result = new KeyboardShortcutOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.shortcuts)) {
            data["shortcuts"] = [];
            for (let item of this.shortcuts)
                data["shortcuts"].push(item.toJSON());
        }
        return data;
    }

    clone(): KeyboardShortcutOptions {
        const json = this.toJSON();
        let result = new KeyboardShortcutOptions();
        result.init(json);
        return result;
    }
}

export interface IKeyboardShortcutOptions {
    shortcuts: KeyboardShortcutConfiguration[];
}

export class KeyboardShortcutConfiguration implements IKeyboardShortcutConfiguration {
    id!: string;
    meta!: boolean;
    alt!: boolean;
    ctrl!: boolean;
    shift!: boolean;
    key?: KeyCode | undefined;

    constructor(data?: IKeyboardShortcutConfiguration) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.id = _data["id"];
            this.meta = _data["meta"];
            this.alt = _data["alt"];
            this.ctrl = _data["ctrl"];
            this.shift = _data["shift"];
            this.key = _data["key"];
        }
    }

    static fromJS(data: any): KeyboardShortcutConfiguration {
        data = typeof data === 'object' ? data : {};
        let result = new KeyboardShortcutConfiguration();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["id"] = this.id;
        data["meta"] = this.meta;
        data["alt"] = this.alt;
        data["ctrl"] = this.ctrl;
        data["shift"] = this.shift;
        data["key"] = this.key;
        return data;
    }

    clone(): KeyboardShortcutConfiguration {
        const json = this.toJSON();
        let result = new KeyboardShortcutConfiguration();
        result.init(json);
        return result;
    }
}

export interface IKeyboardShortcutConfiguration {
    id: string;
    meta: boolean;
    alt: boolean;
    ctrl: boolean;
    shift: boolean;
    key?: KeyCode | undefined;
}

export type KeyCode = "Unknown" | "Backspace" | "Tab" | "Enter" | "ShiftLeft" | "ShiftRight" | "ControlLeft" | "ControlRight" | "AltLeft" | "AltRight" | "Pause" | "CapsLock" | "Escape" | "Space" | "PageUp" | "PageDown" | "End" | "Home" | "ArrowLeft" | "ArrowUp" | "ArrowRight" | "ArrowDown" | "PrintScreen" | "Insert" | "Delete" | "Digit0" | "Digit1" | "Digit2" | "Digit3" | "Digit4" | "Digit5" | "Digit6" | "Digit7" | "Digit8" | "Digit9" | "KeyA" | "KeyB" | "KeyC" | "KeyD" | "KeyE" | "KeyF" | "KeyG" | "KeyH" | "KeyI" | "KeyJ" | "KeyK" | "KeyL" | "KeyM" | "KeyN" | "KeyO" | "KeyP" | "KeyQ" | "KeyR" | "KeyS" | "KeyT" | "KeyU" | "KeyV" | "KeyW" | "KeyX" | "KeyY" | "KeyZ" | "MetaLeft" | "MetaRight" | "ContextMenu" | "Numpad0" | "Numpad1" | "Numpad2" | "Numpad3" | "Numpad4" | "Numpad5" | "Numpad6" | "Numpad7" | "Numpad8" | "Numpad9" | "NumpadMultiply" | "NumpadAdd" | "NumpadSubtract" | "NumpadDecimal" | "NumpadDivide" | "F1" | "F2" | "F3" | "F4" | "F5" | "F6" | "F7" | "F8" | "F9" | "F10" | "F11" | "F12" | "NumLock" | "ScrollLock" | "Semicolon" | "Equal" | "Comma" | "Minus" | "Period" | "Slash" | "Backquote" | "BracketLeft" | "Backslash" | "BracketRight" | "Quote";

/** This should be moved to the OmniSharp plugin */
export class OmniSharpOptions implements IOmniSharpOptions {
    enabled!: boolean;
    executablePath?: string | undefined;
    enableAnalyzersSupport!: boolean;
    enableImportCompletion!: boolean;
    enableSemanticHighlighting!: boolean;
    enableCodeLensReferences!: boolean;
    diagnostics!: OmniSharpDiagnosticsOptions;
    inlayHints!: OmniSharpInlayHintsOptions;

    constructor(data?: IOmniSharpOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.diagnostics = new OmniSharpDiagnosticsOptions();
            this.inlayHints = new OmniSharpInlayHintsOptions();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.enabled = _data["enabled"];
            this.executablePath = _data["executablePath"];
            this.enableAnalyzersSupport = _data["enableAnalyzersSupport"];
            this.enableImportCompletion = _data["enableImportCompletion"];
            this.enableSemanticHighlighting = _data["enableSemanticHighlighting"];
            this.enableCodeLensReferences = _data["enableCodeLensReferences"];
            this.diagnostics = _data["diagnostics"] ? OmniSharpDiagnosticsOptions.fromJS(_data["diagnostics"]) : new OmniSharpDiagnosticsOptions();
            this.inlayHints = _data["inlayHints"] ? OmniSharpInlayHintsOptions.fromJS(_data["inlayHints"]) : new OmniSharpInlayHintsOptions();
        }
    }

    static fromJS(data: any): OmniSharpOptions {
        data = typeof data === 'object' ? data : {};
        let result = new OmniSharpOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["enabled"] = this.enabled;
        data["executablePath"] = this.executablePath;
        data["enableAnalyzersSupport"] = this.enableAnalyzersSupport;
        data["enableImportCompletion"] = this.enableImportCompletion;
        data["enableSemanticHighlighting"] = this.enableSemanticHighlighting;
        data["enableCodeLensReferences"] = this.enableCodeLensReferences;
        data["diagnostics"] = this.diagnostics ? this.diagnostics.toJSON() : <any>undefined;
        data["inlayHints"] = this.inlayHints ? this.inlayHints.toJSON() : <any>undefined;
        return data;
    }

    clone(): OmniSharpOptions {
        const json = this.toJSON();
        let result = new OmniSharpOptions();
        result.init(json);
        return result;
    }
}

/** This should be moved to the OmniSharp plugin */
export interface IOmniSharpOptions {
    enabled: boolean;
    executablePath?: string | undefined;
    enableAnalyzersSupport: boolean;
    enableImportCompletion: boolean;
    enableSemanticHighlighting: boolean;
    enableCodeLensReferences: boolean;
    diagnostics: OmniSharpDiagnosticsOptions;
    inlayHints: OmniSharpInlayHintsOptions;
}

export class OmniSharpDiagnosticsOptions implements IOmniSharpDiagnosticsOptions {
    enabled!: boolean;
    enableInfo!: boolean;
    enableWarnings!: boolean;
    enableHints!: boolean;

    constructor(data?: IOmniSharpDiagnosticsOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.enabled = _data["enabled"];
            this.enableInfo = _data["enableInfo"];
            this.enableWarnings = _data["enableWarnings"];
            this.enableHints = _data["enableHints"];
        }
    }

    static fromJS(data: any): OmniSharpDiagnosticsOptions {
        data = typeof data === 'object' ? data : {};
        let result = new OmniSharpDiagnosticsOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["enabled"] = this.enabled;
        data["enableInfo"] = this.enableInfo;
        data["enableWarnings"] = this.enableWarnings;
        data["enableHints"] = this.enableHints;
        return data;
    }

    clone(): OmniSharpDiagnosticsOptions {
        const json = this.toJSON();
        let result = new OmniSharpDiagnosticsOptions();
        result.init(json);
        return result;
    }
}

export interface IOmniSharpDiagnosticsOptions {
    enabled: boolean;
    enableInfo: boolean;
    enableWarnings: boolean;
    enableHints: boolean;
}

export class OmniSharpInlayHintsOptions implements IOmniSharpInlayHintsOptions {
    enableParameters!: boolean;
    enableIndexerParameters!: boolean;
    enableLiteralParameters!: boolean;
    enableObjectCreationParameters!: boolean;
    enableOtherParameters!: boolean;
    suppressForParametersThatDifferOnlyBySuffix!: boolean;
    suppressForParametersThatMatchMethodIntent!: boolean;
    suppressForParametersThatMatchArgumentName!: boolean;
    enableTypes!: boolean;
    enableImplicitVariableTypes!: boolean;
    enableLambdaParameterTypes!: boolean;
    enableImplicitObjectCreation!: boolean;

    constructor(data?: IOmniSharpInlayHintsOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.enableParameters = _data["enableParameters"];
            this.enableIndexerParameters = _data["enableIndexerParameters"];
            this.enableLiteralParameters = _data["enableLiteralParameters"];
            this.enableObjectCreationParameters = _data["enableObjectCreationParameters"];
            this.enableOtherParameters = _data["enableOtherParameters"];
            this.suppressForParametersThatDifferOnlyBySuffix = _data["suppressForParametersThatDifferOnlyBySuffix"];
            this.suppressForParametersThatMatchMethodIntent = _data["suppressForParametersThatMatchMethodIntent"];
            this.suppressForParametersThatMatchArgumentName = _data["suppressForParametersThatMatchArgumentName"];
            this.enableTypes = _data["enableTypes"];
            this.enableImplicitVariableTypes = _data["enableImplicitVariableTypes"];
            this.enableLambdaParameterTypes = _data["enableLambdaParameterTypes"];
            this.enableImplicitObjectCreation = _data["enableImplicitObjectCreation"];
        }
    }

    static fromJS(data: any): OmniSharpInlayHintsOptions {
        data = typeof data === 'object' ? data : {};
        let result = new OmniSharpInlayHintsOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["enableParameters"] = this.enableParameters;
        data["enableIndexerParameters"] = this.enableIndexerParameters;
        data["enableLiteralParameters"] = this.enableLiteralParameters;
        data["enableObjectCreationParameters"] = this.enableObjectCreationParameters;
        data["enableOtherParameters"] = this.enableOtherParameters;
        data["suppressForParametersThatDifferOnlyBySuffix"] = this.suppressForParametersThatDifferOnlyBySuffix;
        data["suppressForParametersThatMatchMethodIntent"] = this.suppressForParametersThatMatchMethodIntent;
        data["suppressForParametersThatMatchArgumentName"] = this.suppressForParametersThatMatchArgumentName;
        data["enableTypes"] = this.enableTypes;
        data["enableImplicitVariableTypes"] = this.enableImplicitVariableTypes;
        data["enableLambdaParameterTypes"] = this.enableLambdaParameterTypes;
        data["enableImplicitObjectCreation"] = this.enableImplicitObjectCreation;
        return data;
    }

    clone(): OmniSharpInlayHintsOptions {
        const json = this.toJSON();
        let result = new OmniSharpInlayHintsOptions();
        result.init(json);
        return result;
    }
}

export interface IOmniSharpInlayHintsOptions {
    enableParameters: boolean;
    enableIndexerParameters: boolean;
    enableLiteralParameters: boolean;
    enableObjectCreationParameters: boolean;
    enableOtherParameters: boolean;
    suppressForParametersThatDifferOnlyBySuffix: boolean;
    suppressForParametersThatMatchMethodIntent: boolean;
    suppressForParametersThatMatchArgumentName: boolean;
    enableTypes: boolean;
    enableImplicitVariableTypes: boolean;
    enableLambdaParameterTypes: boolean;
    enableImplicitObjectCreation: boolean;
}

export class Types implements ITypes {
    yesNoCancel!: YesNoCancel;
    ipcMessageBatch?: IpcMessageBatch | undefined;
    errorResult?: ErrorResult | undefined;
    script?: Script | undefined;
    htmlResultsScriptOutput?: HtmlResultsScriptOutput | undefined;
    htmlErrorScriptOutput?: HtmlErrorScriptOutput | undefined;
    htmlRawScriptOutput?: HtmlRawScriptOutput | undefined;
    htmlSqlScriptOutput?: HtmlSqlScriptOutput | undefined;
    settingsUpdated?: SettingsUpdatedEvent | undefined;
    appStatusMessagePublished?: AppStatusMessagePublishedEvent | undefined;
    scriptPropertyChanged?: ScriptPropertyChangedEvent | undefined;
    scriptConfigPropertyChanged?: ScriptConfigPropertyChangedEvent | undefined;
    scriptOutputEmitted?: ScriptOutputEmittedEvent | undefined;
    environmentsAdded?: EnvironmentsAddedEvent | undefined;
    environmentsRemoved?: EnvironmentsRemovedEvent | undefined;
    environmentPropertyChanged?: EnvironmentPropertyChangedEvent | undefined;
    activeEnvironmentChanged?: ActiveEnvironmentChangedEvent | undefined;
    scriptDirectoryChanged?: ScriptDirectoryChangedEvent | undefined;
    dataConnectionSavedEvent?: DataConnectionSavedEvent | undefined;
    dataConnectionDeletedEvent?: DataConnectionDeletedEvent | undefined;
    dataConnectionResourcesUpdatingEvent?: DataConnectionResourcesUpdatingEvent | undefined;
    dataConnectionResourcesUpdatedEvent?: DataConnectionResourcesUpdatedEvent | undefined;
    dataConnectionResourcesUpdateFailedEvent?: DataConnectionResourcesUpdateFailedEvent | undefined;
    dataConnectionSchemaValidationStartedEvent?: DataConnectionSchemaValidationStartedEvent | undefined;
    dataConnectionSchemaValidationCompletedEvent?: DataConnectionSchemaValidationCompletedEvent | undefined;
    openWindowCommand?: OpenWindowCommand | undefined;
    confirmSaveCommand?: ConfirmSaveCommand | undefined;
    requestScriptSavePath?: RequestScriptSavePathCommand | undefined;
    alertUserCommand?: AlertUserCommand | undefined;
    confirmWithUserCommand?: ConfirmWithUserCommand | undefined;
    promptUserCommand?: PromptUserCommand | undefined;
    promptUserForInputCommand?: PromptUserForInputCommand | undefined;
    alertUserAboutMissingAppDependencies?: AlertUserAboutMissingAppDependencies | undefined;
    msSqlServerDatabaseConnection?: MsSqlServerDatabaseConnection | undefined;
    postgreSqlDatabaseConnection?: PostgreSqlDatabaseConnection | undefined;
    sqLiteDatabaseConnection?: SQLiteDatabaseConnection | undefined;
    mySqlDatabaseConnection?: MySqlDatabaseConnection | undefined;
    mariaDbDatabaseConnection?: MariaDbDatabaseConnection | undefined;

    constructor(data?: ITypes) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.yesNoCancel = _data["yesNoCancel"];
            this.ipcMessageBatch = _data["ipcMessageBatch"] ? IpcMessageBatch.fromJS(_data["ipcMessageBatch"]) : <any>undefined;
            this.errorResult = _data["errorResult"] ? ErrorResult.fromJS(_data["errorResult"]) : <any>undefined;
            this.script = _data["script"] ? Script.fromJS(_data["script"]) : <any>undefined;
            this.htmlResultsScriptOutput = _data["htmlResultsScriptOutput"] ? HtmlResultsScriptOutput.fromJS(_data["htmlResultsScriptOutput"]) : <any>undefined;
            this.htmlErrorScriptOutput = _data["htmlErrorScriptOutput"] ? HtmlErrorScriptOutput.fromJS(_data["htmlErrorScriptOutput"]) : <any>undefined;
            this.htmlRawScriptOutput = _data["htmlRawScriptOutput"] ? HtmlRawScriptOutput.fromJS(_data["htmlRawScriptOutput"]) : <any>undefined;
            this.htmlSqlScriptOutput = _data["htmlSqlScriptOutput"] ? HtmlSqlScriptOutput.fromJS(_data["htmlSqlScriptOutput"]) : <any>undefined;
            this.settingsUpdated = _data["settingsUpdated"] ? SettingsUpdatedEvent.fromJS(_data["settingsUpdated"]) : <any>undefined;
            this.appStatusMessagePublished = _data["appStatusMessagePublished"] ? AppStatusMessagePublishedEvent.fromJS(_data["appStatusMessagePublished"]) : <any>undefined;
            this.scriptPropertyChanged = _data["scriptPropertyChanged"] ? ScriptPropertyChangedEvent.fromJS(_data["scriptPropertyChanged"]) : <any>undefined;
            this.scriptConfigPropertyChanged = _data["scriptConfigPropertyChanged"] ? ScriptConfigPropertyChangedEvent.fromJS(_data["scriptConfigPropertyChanged"]) : <any>undefined;
            this.scriptOutputEmitted = _data["scriptOutputEmitted"] ? ScriptOutputEmittedEvent.fromJS(_data["scriptOutputEmitted"]) : <any>undefined;
            this.environmentsAdded = _data["environmentsAdded"] ? EnvironmentsAddedEvent.fromJS(_data["environmentsAdded"]) : <any>undefined;
            this.environmentsRemoved = _data["environmentsRemoved"] ? EnvironmentsRemovedEvent.fromJS(_data["environmentsRemoved"]) : <any>undefined;
            this.environmentPropertyChanged = _data["environmentPropertyChanged"] ? EnvironmentPropertyChangedEvent.fromJS(_data["environmentPropertyChanged"]) : <any>undefined;
            this.activeEnvironmentChanged = _data["activeEnvironmentChanged"] ? ActiveEnvironmentChangedEvent.fromJS(_data["activeEnvironmentChanged"]) : <any>undefined;
            this.scriptDirectoryChanged = _data["scriptDirectoryChanged"] ? ScriptDirectoryChangedEvent.fromJS(_data["scriptDirectoryChanged"]) : <any>undefined;
            this.dataConnectionSavedEvent = _data["dataConnectionSavedEvent"] ? DataConnectionSavedEvent.fromJS(_data["dataConnectionSavedEvent"]) : <any>undefined;
            this.dataConnectionDeletedEvent = _data["dataConnectionDeletedEvent"] ? DataConnectionDeletedEvent.fromJS(_data["dataConnectionDeletedEvent"]) : <any>undefined;
            this.dataConnectionResourcesUpdatingEvent = _data["dataConnectionResourcesUpdatingEvent"] ? DataConnectionResourcesUpdatingEvent.fromJS(_data["dataConnectionResourcesUpdatingEvent"]) : <any>undefined;
            this.dataConnectionResourcesUpdatedEvent = _data["dataConnectionResourcesUpdatedEvent"] ? DataConnectionResourcesUpdatedEvent.fromJS(_data["dataConnectionResourcesUpdatedEvent"]) : <any>undefined;
            this.dataConnectionResourcesUpdateFailedEvent = _data["dataConnectionResourcesUpdateFailedEvent"] ? DataConnectionResourcesUpdateFailedEvent.fromJS(_data["dataConnectionResourcesUpdateFailedEvent"]) : <any>undefined;
            this.dataConnectionSchemaValidationStartedEvent = _data["dataConnectionSchemaValidationStartedEvent"] ? DataConnectionSchemaValidationStartedEvent.fromJS(_data["dataConnectionSchemaValidationStartedEvent"]) : <any>undefined;
            this.dataConnectionSchemaValidationCompletedEvent = _data["dataConnectionSchemaValidationCompletedEvent"] ? DataConnectionSchemaValidationCompletedEvent.fromJS(_data["dataConnectionSchemaValidationCompletedEvent"]) : <any>undefined;
            this.openWindowCommand = _data["openWindowCommand"] ? OpenWindowCommand.fromJS(_data["openWindowCommand"]) : <any>undefined;
            this.confirmSaveCommand = _data["confirmSaveCommand"] ? ConfirmSaveCommand.fromJS(_data["confirmSaveCommand"]) : <any>undefined;
            this.requestScriptSavePath = _data["requestScriptSavePath"] ? RequestScriptSavePathCommand.fromJS(_data["requestScriptSavePath"]) : <any>undefined;
            this.alertUserCommand = _data["alertUserCommand"] ? AlertUserCommand.fromJS(_data["alertUserCommand"]) : <any>undefined;
            this.confirmWithUserCommand = _data["confirmWithUserCommand"] ? ConfirmWithUserCommand.fromJS(_data["confirmWithUserCommand"]) : <any>undefined;
            this.promptUserCommand = _data["promptUserCommand"] ? PromptUserCommand.fromJS(_data["promptUserCommand"]) : <any>undefined;
            this.promptUserForInputCommand = _data["promptUserForInputCommand"] ? PromptUserForInputCommand.fromJS(_data["promptUserForInputCommand"]) : <any>undefined;
            this.alertUserAboutMissingAppDependencies = _data["alertUserAboutMissingAppDependencies"] ? AlertUserAboutMissingAppDependencies.fromJS(_data["alertUserAboutMissingAppDependencies"]) : <any>undefined;
            this.msSqlServerDatabaseConnection = _data["msSqlServerDatabaseConnection"] ? MsSqlServerDatabaseConnection.fromJS(_data["msSqlServerDatabaseConnection"]) : <any>undefined;
            this.postgreSqlDatabaseConnection = _data["postgreSqlDatabaseConnection"] ? PostgreSqlDatabaseConnection.fromJS(_data["postgreSqlDatabaseConnection"]) : <any>undefined;
            this.sqLiteDatabaseConnection = _data["sqLiteDatabaseConnection"] ? SQLiteDatabaseConnection.fromJS(_data["sqLiteDatabaseConnection"]) : <any>undefined;
            this.mySqlDatabaseConnection = _data["mySqlDatabaseConnection"] ? MySqlDatabaseConnection.fromJS(_data["mySqlDatabaseConnection"]) : <any>undefined;
            this.mariaDbDatabaseConnection = _data["mariaDbDatabaseConnection"] ? MariaDbDatabaseConnection.fromJS(_data["mariaDbDatabaseConnection"]) : <any>undefined;
        }
    }

    static fromJS(data: any): Types {
        data = typeof data === 'object' ? data : {};
        let result = new Types();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["yesNoCancel"] = this.yesNoCancel;
        data["ipcMessageBatch"] = this.ipcMessageBatch ? this.ipcMessageBatch.toJSON() : <any>undefined;
        data["errorResult"] = this.errorResult ? this.errorResult.toJSON() : <any>undefined;
        data["script"] = this.script ? this.script.toJSON() : <any>undefined;
        data["htmlResultsScriptOutput"] = this.htmlResultsScriptOutput ? this.htmlResultsScriptOutput.toJSON() : <any>undefined;
        data["htmlErrorScriptOutput"] = this.htmlErrorScriptOutput ? this.htmlErrorScriptOutput.toJSON() : <any>undefined;
        data["htmlRawScriptOutput"] = this.htmlRawScriptOutput ? this.htmlRawScriptOutput.toJSON() : <any>undefined;
        data["htmlSqlScriptOutput"] = this.htmlSqlScriptOutput ? this.htmlSqlScriptOutput.toJSON() : <any>undefined;
        data["settingsUpdated"] = this.settingsUpdated ? this.settingsUpdated.toJSON() : <any>undefined;
        data["appStatusMessagePublished"] = this.appStatusMessagePublished ? this.appStatusMessagePublished.toJSON() : <any>undefined;
        data["scriptPropertyChanged"] = this.scriptPropertyChanged ? this.scriptPropertyChanged.toJSON() : <any>undefined;
        data["scriptConfigPropertyChanged"] = this.scriptConfigPropertyChanged ? this.scriptConfigPropertyChanged.toJSON() : <any>undefined;
        data["scriptOutputEmitted"] = this.scriptOutputEmitted ? this.scriptOutputEmitted.toJSON() : <any>undefined;
        data["environmentsAdded"] = this.environmentsAdded ? this.environmentsAdded.toJSON() : <any>undefined;
        data["environmentsRemoved"] = this.environmentsRemoved ? this.environmentsRemoved.toJSON() : <any>undefined;
        data["environmentPropertyChanged"] = this.environmentPropertyChanged ? this.environmentPropertyChanged.toJSON() : <any>undefined;
        data["activeEnvironmentChanged"] = this.activeEnvironmentChanged ? this.activeEnvironmentChanged.toJSON() : <any>undefined;
        data["scriptDirectoryChanged"] = this.scriptDirectoryChanged ? this.scriptDirectoryChanged.toJSON() : <any>undefined;
        data["dataConnectionSavedEvent"] = this.dataConnectionSavedEvent ? this.dataConnectionSavedEvent.toJSON() : <any>undefined;
        data["dataConnectionDeletedEvent"] = this.dataConnectionDeletedEvent ? this.dataConnectionDeletedEvent.toJSON() : <any>undefined;
        data["dataConnectionResourcesUpdatingEvent"] = this.dataConnectionResourcesUpdatingEvent ? this.dataConnectionResourcesUpdatingEvent.toJSON() : <any>undefined;
        data["dataConnectionResourcesUpdatedEvent"] = this.dataConnectionResourcesUpdatedEvent ? this.dataConnectionResourcesUpdatedEvent.toJSON() : <any>undefined;
        data["dataConnectionResourcesUpdateFailedEvent"] = this.dataConnectionResourcesUpdateFailedEvent ? this.dataConnectionResourcesUpdateFailedEvent.toJSON() : <any>undefined;
        data["dataConnectionSchemaValidationStartedEvent"] = this.dataConnectionSchemaValidationStartedEvent ? this.dataConnectionSchemaValidationStartedEvent.toJSON() : <any>undefined;
        data["dataConnectionSchemaValidationCompletedEvent"] = this.dataConnectionSchemaValidationCompletedEvent ? this.dataConnectionSchemaValidationCompletedEvent.toJSON() : <any>undefined;
        data["openWindowCommand"] = this.openWindowCommand ? this.openWindowCommand.toJSON() : <any>undefined;
        data["confirmSaveCommand"] = this.confirmSaveCommand ? this.confirmSaveCommand.toJSON() : <any>undefined;
        data["requestScriptSavePath"] = this.requestScriptSavePath ? this.requestScriptSavePath.toJSON() : <any>undefined;
        data["alertUserCommand"] = this.alertUserCommand ? this.alertUserCommand.toJSON() : <any>undefined;
        data["confirmWithUserCommand"] = this.confirmWithUserCommand ? this.confirmWithUserCommand.toJSON() : <any>undefined;
        data["promptUserCommand"] = this.promptUserCommand ? this.promptUserCommand.toJSON() : <any>undefined;
        data["promptUserForInputCommand"] = this.promptUserForInputCommand ? this.promptUserForInputCommand.toJSON() : <any>undefined;
        data["alertUserAboutMissingAppDependencies"] = this.alertUserAboutMissingAppDependencies ? this.alertUserAboutMissingAppDependencies.toJSON() : <any>undefined;
        data["msSqlServerDatabaseConnection"] = this.msSqlServerDatabaseConnection ? this.msSqlServerDatabaseConnection.toJSON() : <any>undefined;
        data["postgreSqlDatabaseConnection"] = this.postgreSqlDatabaseConnection ? this.postgreSqlDatabaseConnection.toJSON() : <any>undefined;
        data["sqLiteDatabaseConnection"] = this.sqLiteDatabaseConnection ? this.sqLiteDatabaseConnection.toJSON() : <any>undefined;
        data["mySqlDatabaseConnection"] = this.mySqlDatabaseConnection ? this.mySqlDatabaseConnection.toJSON() : <any>undefined;
        data["mariaDbDatabaseConnection"] = this.mariaDbDatabaseConnection ? this.mariaDbDatabaseConnection.toJSON() : <any>undefined;
        return data;
    }

    clone(): Types {
        const json = this.toJSON();
        let result = new Types();
        result.init(json);
        return result;
    }
}

export interface ITypes {
    yesNoCancel: YesNoCancel;
    ipcMessageBatch?: IpcMessageBatch | undefined;
    errorResult?: ErrorResult | undefined;
    script?: Script | undefined;
    htmlResultsScriptOutput?: HtmlResultsScriptOutput | undefined;
    htmlErrorScriptOutput?: HtmlErrorScriptOutput | undefined;
    htmlRawScriptOutput?: HtmlRawScriptOutput | undefined;
    htmlSqlScriptOutput?: HtmlSqlScriptOutput | undefined;
    settingsUpdated?: SettingsUpdatedEvent | undefined;
    appStatusMessagePublished?: AppStatusMessagePublishedEvent | undefined;
    scriptPropertyChanged?: ScriptPropertyChangedEvent | undefined;
    scriptConfigPropertyChanged?: ScriptConfigPropertyChangedEvent | undefined;
    scriptOutputEmitted?: ScriptOutputEmittedEvent | undefined;
    environmentsAdded?: EnvironmentsAddedEvent | undefined;
    environmentsRemoved?: EnvironmentsRemovedEvent | undefined;
    environmentPropertyChanged?: EnvironmentPropertyChangedEvent | undefined;
    activeEnvironmentChanged?: ActiveEnvironmentChangedEvent | undefined;
    scriptDirectoryChanged?: ScriptDirectoryChangedEvent | undefined;
    dataConnectionSavedEvent?: DataConnectionSavedEvent | undefined;
    dataConnectionDeletedEvent?: DataConnectionDeletedEvent | undefined;
    dataConnectionResourcesUpdatingEvent?: DataConnectionResourcesUpdatingEvent | undefined;
    dataConnectionResourcesUpdatedEvent?: DataConnectionResourcesUpdatedEvent | undefined;
    dataConnectionResourcesUpdateFailedEvent?: DataConnectionResourcesUpdateFailedEvent | undefined;
    dataConnectionSchemaValidationStartedEvent?: DataConnectionSchemaValidationStartedEvent | undefined;
    dataConnectionSchemaValidationCompletedEvent?: DataConnectionSchemaValidationCompletedEvent | undefined;
    openWindowCommand?: OpenWindowCommand | undefined;
    confirmSaveCommand?: ConfirmSaveCommand | undefined;
    requestScriptSavePath?: RequestScriptSavePathCommand | undefined;
    alertUserCommand?: AlertUserCommand | undefined;
    confirmWithUserCommand?: ConfirmWithUserCommand | undefined;
    promptUserCommand?: PromptUserCommand | undefined;
    promptUserForInputCommand?: PromptUserForInputCommand | undefined;
    alertUserAboutMissingAppDependencies?: AlertUserAboutMissingAppDependencies | undefined;
    msSqlServerDatabaseConnection?: MsSqlServerDatabaseConnection | undefined;
    postgreSqlDatabaseConnection?: PostgreSqlDatabaseConnection | undefined;
    sqLiteDatabaseConnection?: SQLiteDatabaseConnection | undefined;
    mySqlDatabaseConnection?: MySqlDatabaseConnection | undefined;
    mariaDbDatabaseConnection?: MariaDbDatabaseConnection | undefined;
}

export type YesNoCancel = "Yes" | "No" | "Cancel";

export class IpcMessageBatch implements IIpcMessageBatch {
    messages!: IpcMessage[];

    constructor(data?: IIpcMessageBatch) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.messages = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["messages"])) {
                this.messages = [] as any;
                for (let item of _data["messages"])
                    this.messages!.push(IpcMessage.fromJS(item));
            }
        }
    }

    static fromJS(data: any): IpcMessageBatch {
        data = typeof data === 'object' ? data : {};
        let result = new IpcMessageBatch();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.messages)) {
            data["messages"] = [];
            for (let item of this.messages)
                data["messages"].push(item.toJSON());
        }
        return data;
    }

    clone(): IpcMessageBatch {
        const json = this.toJSON();
        let result = new IpcMessageBatch();
        result.init(json);
        return result;
    }
}

export interface IIpcMessageBatch {
    messages: IpcMessage[];
}

export class IpcMessage implements IIpcMessage {
    message!: any;
    messageType!: string;

    constructor(data?: IIpcMessage) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.message = _data["message"];
            this.messageType = _data["messageType"];
        }
    }

    static fromJS(data: any): IpcMessage {
        data = typeof data === 'object' ? data : {};
        let result = new IpcMessage();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["message"] = this.message;
        data["messageType"] = this.messageType;
        return data;
    }

    clone(): IpcMessage {
        const json = this.toJSON();
        let result = new IpcMessage();
        result.init(json);
        return result;
    }
}

export interface IIpcMessage {
    message: any;
    messageType: string;
}

export class ErrorResult implements IErrorResult {
    message!: string;
    details?: string | undefined;

    constructor(data?: IErrorResult) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.message = _data["message"];
            this.details = _data["details"];
        }
    }

    static fromJS(data: any): ErrorResult {
        data = typeof data === 'object' ? data : {};
        let result = new ErrorResult();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["message"] = this.message;
        data["details"] = this.details;
        return data;
    }

    clone(): ErrorResult {
        const json = this.toJSON();
        let result = new ErrorResult();
        result.init(json);
        return result;
    }
}

export interface IErrorResult {
    message: string;
    details?: string | undefined;
}

/** A base class for all script output */
export abstract class ScriptOutput implements IScriptOutput {
    /** The body of the output. */
    body?: any | undefined;
    /** The order this output was emitted. A value of 0 indicates no order. */
    order!: number;

    constructor(data?: IScriptOutput) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.body = _data["body"];
            this.order = _data["order"];
        }
    }

    static fromJS(data: any): ScriptOutput {
        data = typeof data === 'object' ? data : {};
        throw new Error("The abstract class 'ScriptOutput' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["body"] = this.body;
        data["order"] = this.order;
        return data;
    }

    clone(): ScriptOutput {
        throw new Error("The abstract class 'ScriptOutput' cannot be instantiated.");
    }
}

/** A base class for all script output */
export interface IScriptOutput {
    /** The body of the output. */
    body?: any | undefined;
    /** The order this output was emitted. A value of 0 indicates no order. */
    order: number;
}

/** A base class for script output with an HTML-formatted string as the body. */
export abstract class HtmlScriptOutput extends ScriptOutput implements IHtmlScriptOutput {
    body?: string | undefined;

    constructor(data?: IHtmlScriptOutput) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.body = _data["body"];
        }
    }

    static fromJS(data: any): HtmlScriptOutput {
        data = typeof data === 'object' ? data : {};
        throw new Error("The abstract class 'HtmlScriptOutput' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["body"] = this.body;
        super.toJSON(data);
        return data;
    }

    clone(): HtmlScriptOutput {
        throw new Error("The abstract class 'HtmlScriptOutput' cannot be instantiated.");
    }
}

/** A base class for script output with an HTML-formatted string as the body. */
export interface IHtmlScriptOutput extends IScriptOutput {
    body?: string | undefined;
}

/** Results script output represented as HTML. */
export class HtmlResultsScriptOutput extends HtmlScriptOutput implements IHtmlResultsScriptOutput {

    constructor(data?: IHtmlResultsScriptOutput) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): HtmlResultsScriptOutput {
        data = typeof data === 'object' ? data : {};
        let result = new HtmlResultsScriptOutput();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): HtmlResultsScriptOutput {
        const json = this.toJSON();
        let result = new HtmlResultsScriptOutput();
        result.init(json);
        return result;
    }
}

/** Results script output represented as HTML. */
export interface IHtmlResultsScriptOutput extends IHtmlScriptOutput {
}

/** Error script output represented as HTML. */
export class HtmlErrorScriptOutput extends HtmlScriptOutput implements IHtmlErrorScriptOutput {

    constructor(data?: IHtmlErrorScriptOutput) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): HtmlErrorScriptOutput {
        data = typeof data === 'object' ? data : {};
        let result = new HtmlErrorScriptOutput();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): HtmlErrorScriptOutput {
        const json = this.toJSON();
        let result = new HtmlErrorScriptOutput();
        result.init(json);
        return result;
    }
}

/** Error script output represented as HTML. */
export interface IHtmlErrorScriptOutput extends IHtmlScriptOutput {
}

/** Raw script output represented as HTML. */
export class HtmlRawScriptOutput extends HtmlScriptOutput implements IHtmlRawScriptOutput {

    constructor(data?: IHtmlRawScriptOutput) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): HtmlRawScriptOutput {
        data = typeof data === 'object' ? data : {};
        let result = new HtmlRawScriptOutput();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): HtmlRawScriptOutput {
        const json = this.toJSON();
        let result = new HtmlRawScriptOutput();
        result.init(json);
        return result;
    }
}

/** Raw script output represented as HTML. */
export interface IHtmlRawScriptOutput extends IHtmlScriptOutput {
}

/** SQL script output represented as HTML. */
export class HtmlSqlScriptOutput extends HtmlScriptOutput implements IHtmlSqlScriptOutput {

    constructor(data?: IHtmlSqlScriptOutput) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): HtmlSqlScriptOutput {
        data = typeof data === 'object' ? data : {};
        let result = new HtmlSqlScriptOutput();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): HtmlSqlScriptOutput {
        const json = this.toJSON();
        let result = new HtmlSqlScriptOutput();
        result.init(json);
        return result;
    }
}

/** SQL script output represented as HTML. */
export interface IHtmlSqlScriptOutput extends IHtmlScriptOutput {
}

export class SettingsUpdatedEvent implements ISettingsUpdatedEvent {
    settings!: Settings;

    constructor(data?: ISettingsUpdatedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.settings = new Settings();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.settings = _data["settings"] ? Settings.fromJS(_data["settings"]) : new Settings();
        }
    }

    static fromJS(data: any): SettingsUpdatedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new SettingsUpdatedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["settings"] = this.settings ? this.settings.toJSON() : <any>undefined;
        return data;
    }

    clone(): SettingsUpdatedEvent {
        const json = this.toJSON();
        let result = new SettingsUpdatedEvent();
        result.init(json);
        return result;
    }
}

export interface ISettingsUpdatedEvent {
    settings: Settings;
}

export class AppStatusMessagePublishedEvent implements IAppStatusMessagePublishedEvent {
    message!: AppStatusMessage;

    constructor(data?: IAppStatusMessagePublishedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.message = new AppStatusMessage();
        }
    }

    init(_data?: any) {
        if (_data) {
            this.message = _data["message"] ? AppStatusMessage.fromJS(_data["message"]) : new AppStatusMessage();
        }
    }

    static fromJS(data: any): AppStatusMessagePublishedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new AppStatusMessagePublishedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["message"] = this.message ? this.message.toJSON() : <any>undefined;
        return data;
    }

    clone(): AppStatusMessagePublishedEvent {
        const json = this.toJSON();
        let result = new AppStatusMessagePublishedEvent();
        result.init(json);
        return result;
    }
}

export interface IAppStatusMessagePublishedEvent {
    message: AppStatusMessage;
}

/** Represents a status change in the application. */
export class AppStatusMessage implements IAppStatusMessage {
    /** The ID of the script this message relates to. */
    scriptId?: string | undefined;
    /** The text of this message. */
    text!: string;
    /** The priority of this message. */
    priority!: AppStatusMessagePriority;
    /** Whether this status message should be persistant or it should clear out after a timeout. */
    persistant!: boolean;
    /** The DateTime of when this message was created. */
    createdDate!: Date;

    constructor(data?: IAppStatusMessage) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.scriptId = _data["scriptId"];
            this.text = _data["text"];
            this.priority = _data["priority"];
            this.persistant = _data["persistant"];
            this.createdDate = _data["createdDate"] ? new Date(_data["createdDate"].toString()) : <any>undefined;
        }
    }

    static fromJS(data: any): AppStatusMessage {
        data = typeof data === 'object' ? data : {};
        let result = new AppStatusMessage();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["scriptId"] = this.scriptId;
        data["text"] = this.text;
        data["priority"] = this.priority;
        data["persistant"] = this.persistant;
        data["createdDate"] = this.createdDate ? this.createdDate.toISOString() : <any>undefined;
        return data;
    }

    clone(): AppStatusMessage {
        const json = this.toJSON();
        let result = new AppStatusMessage();
        result.init(json);
        return result;
    }
}

/** Represents a status change in the application. */
export interface IAppStatusMessage {
    /** The ID of the script this message relates to. */
    scriptId?: string | undefined;
    /** The text of this message. */
    text: string;
    /** The priority of this message. */
    priority: AppStatusMessagePriority;
    /** Whether this status message should be persistant or it should clear out after a timeout. */
    persistant: boolean;
    /** The DateTime of when this message was created. */
    createdDate: Date;
}

export type AppStatusMessagePriority = "Normal" | "High";

export abstract class PropertyChangedEvent implements IPropertyChangedEvent {
    propertyName!: string;
    oldValue?: any | undefined;
    newValue?: any | undefined;

    constructor(data?: IPropertyChangedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.propertyName = _data["propertyName"];
            this.oldValue = _data["oldValue"];
            this.newValue = _data["newValue"];
        }
    }

    static fromJS(data: any): PropertyChangedEvent {
        data = typeof data === 'object' ? data : {};
        throw new Error("The abstract class 'PropertyChangedEvent' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["propertyName"] = this.propertyName;
        data["oldValue"] = this.oldValue;
        data["newValue"] = this.newValue;
        return data;
    }

    clone(): PropertyChangedEvent {
        throw new Error("The abstract class 'PropertyChangedEvent' cannot be instantiated.");
    }
}

export interface IPropertyChangedEvent {
    propertyName: string;
    oldValue?: any | undefined;
    newValue?: any | undefined;
}

export class ScriptPropertyChangedEvent extends PropertyChangedEvent implements IScriptPropertyChangedEvent {
    scriptId!: string;

    constructor(data?: IScriptPropertyChangedEvent) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.scriptId = _data["scriptId"];
        }
    }

    static fromJS(data: any): ScriptPropertyChangedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new ScriptPropertyChangedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["scriptId"] = this.scriptId;
        super.toJSON(data);
        return data;
    }

    clone(): ScriptPropertyChangedEvent {
        const json = this.toJSON();
        let result = new ScriptPropertyChangedEvent();
        result.init(json);
        return result;
    }
}

export interface IScriptPropertyChangedEvent extends IPropertyChangedEvent {
    scriptId: string;
}

export class ScriptConfigPropertyChangedEvent extends PropertyChangedEvent implements IScriptConfigPropertyChangedEvent {
    scriptId!: string;

    constructor(data?: IScriptConfigPropertyChangedEvent) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.scriptId = _data["scriptId"];
        }
    }

    static fromJS(data: any): ScriptConfigPropertyChangedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new ScriptConfigPropertyChangedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["scriptId"] = this.scriptId;
        super.toJSON(data);
        return data;
    }

    clone(): ScriptConfigPropertyChangedEvent {
        const json = this.toJSON();
        let result = new ScriptConfigPropertyChangedEvent();
        result.init(json);
        return result;
    }
}

export interface IScriptConfigPropertyChangedEvent extends IPropertyChangedEvent {
    scriptId: string;
}

export class ScriptOutputEmittedEvent implements IScriptOutputEmittedEvent {
    scriptId!: string;
    output!: ScriptOutput;
    outputType!: string;

    constructor(data?: IScriptOutputEmittedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.scriptId = _data["scriptId"];
            this.output = _data["output"] ? ScriptOutput.fromJS(_data["output"]) : <any>undefined;
            this.outputType = _data["outputType"];
        }
    }

    static fromJS(data: any): ScriptOutputEmittedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new ScriptOutputEmittedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["scriptId"] = this.scriptId;
        data["output"] = this.output ? this.output.toJSON() : <any>undefined;
        data["outputType"] = this.outputType;
        return data;
    }

    clone(): ScriptOutputEmittedEvent {
        const json = this.toJSON();
        let result = new ScriptOutputEmittedEvent();
        result.init(json);
        return result;
    }
}

export interface IScriptOutputEmittedEvent {
    scriptId: string;
    output: ScriptOutput;
    outputType: string;
}

export class EnvironmentsAddedEvent implements IEnvironmentsAddedEvent {
    environments!: ScriptEnvironment[];

    constructor(data?: IEnvironmentsAddedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.environments = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["environments"])) {
                this.environments = [] as any;
                for (let item of _data["environments"])
                    this.environments!.push(ScriptEnvironment.fromJS(item));
            }
        }
    }

    static fromJS(data: any): EnvironmentsAddedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new EnvironmentsAddedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.environments)) {
            data["environments"] = [];
            for (let item of this.environments)
                data["environments"].push(item.toJSON());
        }
        return data;
    }

    clone(): EnvironmentsAddedEvent {
        const json = this.toJSON();
        let result = new EnvironmentsAddedEvent();
        result.init(json);
        return result;
    }
}

export interface IEnvironmentsAddedEvent {
    environments: ScriptEnvironment[];
}

export class EnvironmentsRemovedEvent implements IEnvironmentsRemovedEvent {
    environments!: ScriptEnvironment[];

    constructor(data?: IEnvironmentsRemovedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.environments = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["environments"])) {
                this.environments = [] as any;
                for (let item of _data["environments"])
                    this.environments!.push(ScriptEnvironment.fromJS(item));
            }
        }
    }

    static fromJS(data: any): EnvironmentsRemovedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new EnvironmentsRemovedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.environments)) {
            data["environments"] = [];
            for (let item of this.environments)
                data["environments"].push(item.toJSON());
        }
        return data;
    }

    clone(): EnvironmentsRemovedEvent {
        const json = this.toJSON();
        let result = new EnvironmentsRemovedEvent();
        result.init(json);
        return result;
    }
}

export interface IEnvironmentsRemovedEvent {
    environments: ScriptEnvironment[];
}

export class EnvironmentPropertyChangedEvent extends PropertyChangedEvent implements IEnvironmentPropertyChangedEvent {
    scriptId!: string;

    constructor(data?: IEnvironmentPropertyChangedEvent) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.scriptId = _data["scriptId"];
        }
    }

    static fromJS(data: any): EnvironmentPropertyChangedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new EnvironmentPropertyChangedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["scriptId"] = this.scriptId;
        super.toJSON(data);
        return data;
    }

    clone(): EnvironmentPropertyChangedEvent {
        const json = this.toJSON();
        let result = new EnvironmentPropertyChangedEvent();
        result.init(json);
        return result;
    }
}

export interface IEnvironmentPropertyChangedEvent extends IPropertyChangedEvent {
    scriptId: string;
}

export class ActiveEnvironmentChangedEvent implements IActiveEnvironmentChangedEvent {
    scriptId?: string | undefined;

    constructor(data?: IActiveEnvironmentChangedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.scriptId = _data["scriptId"];
        }
    }

    static fromJS(data: any): ActiveEnvironmentChangedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new ActiveEnvironmentChangedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["scriptId"] = this.scriptId;
        return data;
    }

    clone(): ActiveEnvironmentChangedEvent {
        const json = this.toJSON();
        let result = new ActiveEnvironmentChangedEvent();
        result.init(json);
        return result;
    }
}

export interface IActiveEnvironmentChangedEvent {
    scriptId?: string | undefined;
}

export class ScriptDirectoryChangedEvent implements IScriptDirectoryChangedEvent {
    scripts!: ScriptSummary[];

    constructor(data?: IScriptDirectoryChangedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.scripts = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            if (Array.isArray(_data["scripts"])) {
                this.scripts = [] as any;
                for (let item of _data["scripts"])
                    this.scripts!.push(ScriptSummary.fromJS(item));
            }
        }
    }

    static fromJS(data: any): ScriptDirectoryChangedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new ScriptDirectoryChangedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        if (Array.isArray(this.scripts)) {
            data["scripts"] = [];
            for (let item of this.scripts)
                data["scripts"].push(item.toJSON());
        }
        return data;
    }

    clone(): ScriptDirectoryChangedEvent {
        const json = this.toJSON();
        let result = new ScriptDirectoryChangedEvent();
        result.init(json);
        return result;
    }
}

export interface IScriptDirectoryChangedEvent {
    scripts: ScriptSummary[];
}

export class DataConnectionSavedEvent implements IDataConnectionSavedEvent {
    dataConnection!: DataConnection;

    constructor(data?: IDataConnectionSavedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.dataConnection = _data["dataConnection"] ? DataConnection.fromJS(_data["dataConnection"]) : <any>undefined;
        }
    }

    static fromJS(data: any): DataConnectionSavedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new DataConnectionSavedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["dataConnection"] = this.dataConnection ? this.dataConnection.toJSON() : <any>undefined;
        return data;
    }

    clone(): DataConnectionSavedEvent {
        const json = this.toJSON();
        let result = new DataConnectionSavedEvent();
        result.init(json);
        return result;
    }
}

export interface IDataConnectionSavedEvent {
    dataConnection: DataConnection;
}

export class DataConnectionDeletedEvent implements IDataConnectionDeletedEvent {
    dataConnection!: DataConnection;

    constructor(data?: IDataConnectionDeletedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.dataConnection = _data["dataConnection"] ? DataConnection.fromJS(_data["dataConnection"]) : <any>undefined;
        }
    }

    static fromJS(data: any): DataConnectionDeletedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new DataConnectionDeletedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["dataConnection"] = this.dataConnection ? this.dataConnection.toJSON() : <any>undefined;
        return data;
    }

    clone(): DataConnectionDeletedEvent {
        const json = this.toJSON();
        let result = new DataConnectionDeletedEvent();
        result.init(json);
        return result;
    }
}

export interface IDataConnectionDeletedEvent {
    dataConnection: DataConnection;
}

export class DataConnectionResourcesUpdatingEvent implements IDataConnectionResourcesUpdatingEvent {
    dataConnection!: DataConnection;
    dotNetFrameworkVersion!: DotNetFrameworkVersion;

    constructor(data?: IDataConnectionResourcesUpdatingEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.dataConnection = _data["dataConnection"] ? DataConnection.fromJS(_data["dataConnection"]) : <any>undefined;
            this.dotNetFrameworkVersion = _data["dotNetFrameworkVersion"];
        }
    }

    static fromJS(data: any): DataConnectionResourcesUpdatingEvent {
        data = typeof data === 'object' ? data : {};
        let result = new DataConnectionResourcesUpdatingEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["dataConnection"] = this.dataConnection ? this.dataConnection.toJSON() : <any>undefined;
        data["dotNetFrameworkVersion"] = this.dotNetFrameworkVersion;
        return data;
    }

    clone(): DataConnectionResourcesUpdatingEvent {
        const json = this.toJSON();
        let result = new DataConnectionResourcesUpdatingEvent();
        result.init(json);
        return result;
    }
}

export interface IDataConnectionResourcesUpdatingEvent {
    dataConnection: DataConnection;
    dotNetFrameworkVersion: DotNetFrameworkVersion;
}

export class DataConnectionResourcesUpdatedEvent implements IDataConnectionResourcesUpdatedEvent {
    dataConnection!: DataConnection;
    targetFrameworkVersion!: DotNetFrameworkVersion;

    constructor(data?: IDataConnectionResourcesUpdatedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.dataConnection = _data["dataConnection"] ? DataConnection.fromJS(_data["dataConnection"]) : <any>undefined;
            this.targetFrameworkVersion = _data["targetFrameworkVersion"];
        }
    }

    static fromJS(data: any): DataConnectionResourcesUpdatedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new DataConnectionResourcesUpdatedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["dataConnection"] = this.dataConnection ? this.dataConnection.toJSON() : <any>undefined;
        data["targetFrameworkVersion"] = this.targetFrameworkVersion;
        return data;
    }

    clone(): DataConnectionResourcesUpdatedEvent {
        const json = this.toJSON();
        let result = new DataConnectionResourcesUpdatedEvent();
        result.init(json);
        return result;
    }
}

export interface IDataConnectionResourcesUpdatedEvent {
    dataConnection: DataConnection;
    targetFrameworkVersion: DotNetFrameworkVersion;
}

export class DataConnectionResourcesUpdateFailedEvent implements IDataConnectionResourcesUpdateFailedEvent {
    dataConnection!: DataConnection;
    dotNetFrameworkVersion!: DotNetFrameworkVersion;
    error?: string | undefined;

    constructor(data?: IDataConnectionResourcesUpdateFailedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.dataConnection = _data["dataConnection"] ? DataConnection.fromJS(_data["dataConnection"]) : <any>undefined;
            this.dotNetFrameworkVersion = _data["dotNetFrameworkVersion"];
            this.error = _data["error"];
        }
    }

    static fromJS(data: any): DataConnectionResourcesUpdateFailedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new DataConnectionResourcesUpdateFailedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["dataConnection"] = this.dataConnection ? this.dataConnection.toJSON() : <any>undefined;
        data["dotNetFrameworkVersion"] = this.dotNetFrameworkVersion;
        data["error"] = this.error;
        return data;
    }

    clone(): DataConnectionResourcesUpdateFailedEvent {
        const json = this.toJSON();
        let result = new DataConnectionResourcesUpdateFailedEvent();
        result.init(json);
        return result;
    }
}

export interface IDataConnectionResourcesUpdateFailedEvent {
    dataConnection: DataConnection;
    dotNetFrameworkVersion: DotNetFrameworkVersion;
    error?: string | undefined;
}

export class DataConnectionSchemaValidationStartedEvent implements IDataConnectionSchemaValidationStartedEvent {
    dataConnectionId!: string;

    constructor(data?: IDataConnectionSchemaValidationStartedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.dataConnectionId = _data["dataConnectionId"];
        }
    }

    static fromJS(data: any): DataConnectionSchemaValidationStartedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new DataConnectionSchemaValidationStartedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["dataConnectionId"] = this.dataConnectionId;
        return data;
    }

    clone(): DataConnectionSchemaValidationStartedEvent {
        const json = this.toJSON();
        let result = new DataConnectionSchemaValidationStartedEvent();
        result.init(json);
        return result;
    }
}

export interface IDataConnectionSchemaValidationStartedEvent {
    dataConnectionId: string;
}

export class DataConnectionSchemaValidationCompletedEvent implements IDataConnectionSchemaValidationCompletedEvent {
    dataConnectionId!: string;

    constructor(data?: IDataConnectionSchemaValidationCompletedEvent) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.dataConnectionId = _data["dataConnectionId"];
        }
    }

    static fromJS(data: any): DataConnectionSchemaValidationCompletedEvent {
        data = typeof data === 'object' ? data : {};
        let result = new DataConnectionSchemaValidationCompletedEvent();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["dataConnectionId"] = this.dataConnectionId;
        return data;
    }

    clone(): DataConnectionSchemaValidationCompletedEvent {
        const json = this.toJSON();
        let result = new DataConnectionSchemaValidationCompletedEvent();
        result.init(json);
        return result;
    }
}

export interface IDataConnectionSchemaValidationCompletedEvent {
    dataConnectionId: string;
}

export abstract class CommandBase implements ICommandBase {
    id!: string;

    constructor(data?: ICommandBase) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.id = _data["id"];
        }
    }

    static fromJS(data: any): CommandBase {
        data = typeof data === 'object' ? data : {};
        throw new Error("The abstract class 'CommandBase' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["id"] = this.id;
        return data;
    }

    clone(): CommandBase {
        throw new Error("The abstract class 'CommandBase' cannot be instantiated.");
    }
}

export interface ICommandBase {
    id: string;
}

export abstract class Command extends CommandBase implements ICommand {

    constructor(data?: ICommand) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): Command {
        data = typeof data === 'object' ? data : {};
        throw new Error("The abstract class 'Command' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): Command {
        throw new Error("The abstract class 'Command' cannot be instantiated.");
    }
}

export interface ICommand extends ICommandBase {
}

export class OpenWindowCommand extends Command implements IOpenWindowCommand {
    windowName!: string;
    options!: WindowOptions;
    metadata!: { [key: string]: any; };

    constructor(data?: IOpenWindowCommand) {
        super(data);
        if (!data) {
            this.options = new WindowOptions();
            this.metadata = {};
        }
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.windowName = _data["windowName"];
            this.options = _data["options"] ? WindowOptions.fromJS(_data["options"]) : new WindowOptions();
            if (_data["metadata"]) {
                this.metadata = {} as any;
                for (let key in _data["metadata"]) {
                    if (_data["metadata"].hasOwnProperty(key))
                        (<any>this.metadata)![key] = _data["metadata"][key];
                }
            }
        }
    }

    static fromJS(data: any): OpenWindowCommand {
        data = typeof data === 'object' ? data : {};
        let result = new OpenWindowCommand();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["windowName"] = this.windowName;
        data["options"] = this.options ? this.options.toJSON() : <any>undefined;
        if (this.metadata) {
            data["metadata"] = {};
            for (let key in this.metadata) {
                if (this.metadata.hasOwnProperty(key))
                    (<any>data["metadata"])[key] = this.metadata[key];
            }
        }
        super.toJSON(data);
        return data;
    }

    clone(): OpenWindowCommand {
        const json = this.toJSON();
        let result = new OpenWindowCommand();
        result.init(json);
        return result;
    }
}

export interface IOpenWindowCommand extends ICommand {
    windowName: string;
    options: WindowOptions;
    metadata: { [key: string]: any; };
}

export class WindowOptions implements IWindowOptions {
    height!: number;
    width!: number;

    constructor(data?: IWindowOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
    }

    init(_data?: any) {
        if (_data) {
            this.height = _data["height"];
            this.width = _data["width"];
        }
    }

    static fromJS(data: any): WindowOptions {
        data = typeof data === 'object' ? data : {};
        let result = new WindowOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["height"] = this.height;
        data["width"] = this.width;
        return data;
    }

    clone(): WindowOptions {
        const json = this.toJSON();
        let result = new WindowOptions();
        result.init(json);
        return result;
    }
}

export interface IWindowOptions {
    height: number;
    width: number;
}

export abstract class CommandOfYesNoCancel extends CommandBase implements ICommandOfYesNoCancel {

    constructor(data?: ICommandOfYesNoCancel) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): CommandOfYesNoCancel {
        data = typeof data === 'object' ? data : {};
        throw new Error("The abstract class 'CommandOfYesNoCancel' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): CommandOfYesNoCancel {
        throw new Error("The abstract class 'CommandOfYesNoCancel' cannot be instantiated.");
    }
}

export interface ICommandOfYesNoCancel extends ICommandBase {
}

export class ConfirmSaveCommand extends CommandOfYesNoCancel implements IConfirmSaveCommand {
    message!: string;

    constructor(data?: IConfirmSaveCommand) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.message = _data["message"];
        }
    }

    static fromJS(data: any): ConfirmSaveCommand {
        data = typeof data === 'object' ? data : {};
        let result = new ConfirmSaveCommand();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["message"] = this.message;
        super.toJSON(data);
        return data;
    }

    clone(): ConfirmSaveCommand {
        const json = this.toJSON();
        let result = new ConfirmSaveCommand();
        result.init(json);
        return result;
    }
}

export interface IConfirmSaveCommand extends ICommandOfYesNoCancel {
    message: string;
}

export abstract class CommandOfString extends CommandBase implements ICommandOfString {

    constructor(data?: ICommandOfString) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): CommandOfString {
        data = typeof data === 'object' ? data : {};
        throw new Error("The abstract class 'CommandOfString' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): CommandOfString {
        throw new Error("The abstract class 'CommandOfString' cannot be instantiated.");
    }
}

export interface ICommandOfString extends ICommandBase {
}

export class RequestScriptSavePathCommand extends CommandOfString implements IRequestScriptSavePathCommand {
    scriptName!: string;
    defaultPath?: string | undefined;

    constructor(data?: IRequestScriptSavePathCommand) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.scriptName = _data["scriptName"];
            this.defaultPath = _data["defaultPath"];
        }
    }

    static fromJS(data: any): RequestScriptSavePathCommand {
        data = typeof data === 'object' ? data : {};
        let result = new RequestScriptSavePathCommand();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["scriptName"] = this.scriptName;
        data["defaultPath"] = this.defaultPath;
        super.toJSON(data);
        return data;
    }

    clone(): RequestScriptSavePathCommand {
        const json = this.toJSON();
        let result = new RequestScriptSavePathCommand();
        result.init(json);
        return result;
    }
}

export interface IRequestScriptSavePathCommand extends ICommandOfString {
    scriptName: string;
    defaultPath?: string | undefined;
}

export class AlertUserCommand extends Command implements IAlertUserCommand {
    message!: string;

    constructor(data?: IAlertUserCommand) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.message = _data["message"];
        }
    }

    static fromJS(data: any): AlertUserCommand {
        data = typeof data === 'object' ? data : {};
        let result = new AlertUserCommand();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["message"] = this.message;
        super.toJSON(data);
        return data;
    }

    clone(): AlertUserCommand {
        const json = this.toJSON();
        let result = new AlertUserCommand();
        result.init(json);
        return result;
    }
}

export interface IAlertUserCommand extends ICommand {
    message: string;
}

export class ConfirmWithUserCommand extends CommandOfYesNoCancel implements IConfirmWithUserCommand {
    message!: string;

    constructor(data?: IConfirmWithUserCommand) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.message = _data["message"];
        }
    }

    static fromJS(data: any): ConfirmWithUserCommand {
        data = typeof data === 'object' ? data : {};
        let result = new ConfirmWithUserCommand();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["message"] = this.message;
        super.toJSON(data);
        return data;
    }

    clone(): ConfirmWithUserCommand {
        const json = this.toJSON();
        let result = new ConfirmWithUserCommand();
        result.init(json);
        return result;
    }
}

export interface IConfirmWithUserCommand extends ICommandOfYesNoCancel {
    message: string;
}

export class PromptUserCommand extends CommandOfString implements IPromptUserCommand {
    message!: string;
    prefillValue?: string | undefined;

    constructor(data?: IPromptUserCommand) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.message = _data["message"];
            this.prefillValue = _data["prefillValue"];
        }
    }

    static fromJS(data: any): PromptUserCommand {
        data = typeof data === 'object' ? data : {};
        let result = new PromptUserCommand();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["message"] = this.message;
        data["prefillValue"] = this.prefillValue;
        super.toJSON(data);
        return data;
    }

    clone(): PromptUserCommand {
        const json = this.toJSON();
        let result = new PromptUserCommand();
        result.init(json);
        return result;
    }
}

export interface IPromptUserCommand extends ICommandOfString {
    message: string;
    prefillValue?: string | undefined;
}

export class PromptUserForInputCommand extends CommandOfString implements IPromptUserForInputCommand {
    scriptId!: string;

    constructor(data?: IPromptUserForInputCommand) {
        super(data);
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.scriptId = _data["scriptId"];
        }
    }

    static fromJS(data: any): PromptUserForInputCommand {
        data = typeof data === 'object' ? data : {};
        let result = new PromptUserForInputCommand();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["scriptId"] = this.scriptId;
        super.toJSON(data);
        return data;
    }

    clone(): PromptUserForInputCommand {
        const json = this.toJSON();
        let result = new PromptUserForInputCommand();
        result.init(json);
        return result;
    }
}

export interface IPromptUserForInputCommand extends ICommandOfString {
    scriptId: string;
}

export class AlertUserAboutMissingAppDependencies extends Command implements IAlertUserAboutMissingAppDependencies {
    dependencyCheckResult!: AppDependencyCheckResult;

    constructor(data?: IAlertUserAboutMissingAppDependencies) {
        super(data);
        if (!data) {
            this.dependencyCheckResult = new AppDependencyCheckResult();
        }
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.dependencyCheckResult = _data["dependencyCheckResult"] ? AppDependencyCheckResult.fromJS(_data["dependencyCheckResult"]) : new AppDependencyCheckResult();
        }
    }

    static fromJS(data: any): AlertUserAboutMissingAppDependencies {
        data = typeof data === 'object' ? data : {};
        let result = new AlertUserAboutMissingAppDependencies();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["dependencyCheckResult"] = this.dependencyCheckResult ? this.dependencyCheckResult.toJSON() : <any>undefined;
        super.toJSON(data);
        return data;
    }

    clone(): AlertUserAboutMissingAppDependencies {
        const json = this.toJSON();
        let result = new AlertUserAboutMissingAppDependencies();
        result.init(json);
        return result;
    }
}

export interface IAlertUserAboutMissingAppDependencies extends ICommand {
    dependencyCheckResult: AppDependencyCheckResult;
}

export abstract class DatabaseConnection extends DataConnection implements IDatabaseConnection {
    host?: string | undefined;
    port?: string | undefined;
    databaseName?: string | undefined;
    userId?: string | undefined;
    password?: string | undefined;
    containsProductionData!: boolean;
    connectionStringAugment?: string | undefined;

    constructor(data?: IDatabaseConnection) {
        super(data);
        this._discriminator = "DatabaseConnection";
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.host = _data["host"];
            this.port = _data["port"];
            this.databaseName = _data["databaseName"];
            this.userId = _data["userId"];
            this.password = _data["password"];
            this.containsProductionData = _data["containsProductionData"];
            this.connectionStringAugment = _data["connectionStringAugment"];
        }
    }

    static fromJS(data: any): DatabaseConnection {
        data = typeof data === 'object' ? data : {};
        if (data["discriminator"] === "EntityFrameworkDatabaseConnection") {
            throw new Error("The abstract class 'EntityFrameworkDatabaseConnection' cannot be instantiated.");
        }
        if (data["discriminator"] === "EntityFrameworkRelationalDatabaseConnection") {
            throw new Error("The abstract class 'EntityFrameworkRelationalDatabaseConnection' cannot be instantiated.");
        }
        if (data["discriminator"] === "MsSqlServerDatabaseConnection") {
            let result = new MsSqlServerDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "PostgreSqlDatabaseConnection") {
            let result = new PostgreSqlDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "SQLiteDatabaseConnection") {
            let result = new SQLiteDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "MySqlDatabaseConnection") {
            let result = new MySqlDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "MariaDbDatabaseConnection") {
            let result = new MariaDbDatabaseConnection();
            result.init(data);
            return result;
        }
        throw new Error("The abstract class 'DatabaseConnection' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["host"] = this.host;
        data["port"] = this.port;
        data["databaseName"] = this.databaseName;
        data["userId"] = this.userId;
        data["password"] = this.password;
        data["containsProductionData"] = this.containsProductionData;
        data["connectionStringAugment"] = this.connectionStringAugment;
        super.toJSON(data);
        return data;
    }

    clone(): DatabaseConnection {
        throw new Error("The abstract class 'DatabaseConnection' cannot be instantiated.");
    }
}

export interface IDatabaseConnection extends IDataConnection {
    host?: string | undefined;
    port?: string | undefined;
    databaseName?: string | undefined;
    userId?: string | undefined;
    password?: string | undefined;
    containsProductionData: boolean;
    connectionStringAugment?: string | undefined;
}

export abstract class EntityFrameworkDatabaseConnection extends DatabaseConnection implements IEntityFrameworkDatabaseConnection {
    entityFrameworkProviderName!: string;
    scaffoldOptions?: ScaffoldOptions | undefined;

    constructor(data?: IEntityFrameworkDatabaseConnection) {
        super(data);
        this._discriminator = "EntityFrameworkDatabaseConnection";
    }

    init(_data?: any) {
        super.init(_data);
        if (_data) {
            this.entityFrameworkProviderName = _data["entityFrameworkProviderName"];
            this.scaffoldOptions = _data["scaffoldOptions"] ? ScaffoldOptions.fromJS(_data["scaffoldOptions"]) : <any>undefined;
        }
    }

    static fromJS(data: any): EntityFrameworkDatabaseConnection {
        data = typeof data === 'object' ? data : {};
        if (data["discriminator"] === "EntityFrameworkRelationalDatabaseConnection") {
            throw new Error("The abstract class 'EntityFrameworkRelationalDatabaseConnection' cannot be instantiated.");
        }
        if (data["discriminator"] === "MsSqlServerDatabaseConnection") {
            let result = new MsSqlServerDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "PostgreSqlDatabaseConnection") {
            let result = new PostgreSqlDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "SQLiteDatabaseConnection") {
            let result = new SQLiteDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "MySqlDatabaseConnection") {
            let result = new MySqlDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "MariaDbDatabaseConnection") {
            let result = new MariaDbDatabaseConnection();
            result.init(data);
            return result;
        }
        throw new Error("The abstract class 'EntityFrameworkDatabaseConnection' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["entityFrameworkProviderName"] = this.entityFrameworkProviderName;
        data["scaffoldOptions"] = this.scaffoldOptions ? this.scaffoldOptions.toJSON() : <any>undefined;
        super.toJSON(data);
        return data;
    }

    clone(): EntityFrameworkDatabaseConnection {
        throw new Error("The abstract class 'EntityFrameworkDatabaseConnection' cannot be instantiated.");
    }
}

export interface IEntityFrameworkDatabaseConnection extends IDatabaseConnection {
    entityFrameworkProviderName: string;
    scaffoldOptions?: ScaffoldOptions | undefined;
}

export abstract class EntityFrameworkRelationalDatabaseConnection extends EntityFrameworkDatabaseConnection implements IEntityFrameworkRelationalDatabaseConnection {

    constructor(data?: IEntityFrameworkRelationalDatabaseConnection) {
        super(data);
        this._discriminator = "EntityFrameworkRelationalDatabaseConnection";
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): EntityFrameworkRelationalDatabaseConnection {
        data = typeof data === 'object' ? data : {};
        if (data["discriminator"] === "MsSqlServerDatabaseConnection") {
            let result = new MsSqlServerDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "PostgreSqlDatabaseConnection") {
            let result = new PostgreSqlDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "SQLiteDatabaseConnection") {
            let result = new SQLiteDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "MySqlDatabaseConnection") {
            let result = new MySqlDatabaseConnection();
            result.init(data);
            return result;
        }
        if (data["discriminator"] === "MariaDbDatabaseConnection") {
            let result = new MariaDbDatabaseConnection();
            result.init(data);
            return result;
        }
        throw new Error("The abstract class 'EntityFrameworkRelationalDatabaseConnection' cannot be instantiated.");
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): EntityFrameworkRelationalDatabaseConnection {
        throw new Error("The abstract class 'EntityFrameworkRelationalDatabaseConnection' cannot be instantiated.");
    }
}

export interface IEntityFrameworkRelationalDatabaseConnection extends IEntityFrameworkDatabaseConnection {
}

export class MsSqlServerDatabaseConnection extends EntityFrameworkRelationalDatabaseConnection implements IMsSqlServerDatabaseConnection {

    constructor(data?: IMsSqlServerDatabaseConnection) {
        super(data);
        this._discriminator = "MsSqlServerDatabaseConnection";
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): MsSqlServerDatabaseConnection {
        data = typeof data === 'object' ? data : {};
        let result = new MsSqlServerDatabaseConnection();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): MsSqlServerDatabaseConnection {
        const json = this.toJSON();
        let result = new MsSqlServerDatabaseConnection();
        result.init(json);
        return result;
    }
}

export interface IMsSqlServerDatabaseConnection extends IEntityFrameworkRelationalDatabaseConnection {
}

export class ScaffoldOptions implements IScaffoldOptions {
    noPluralize!: boolean;
    useDatabaseNames!: boolean;
    schemas!: string[];
    tables!: string[];
    optimizeDbContext!: boolean;

    constructor(data?: IScaffoldOptions) {
        if (data) {
            for (var property in data) {
                if (data.hasOwnProperty(property))
                    (<any>this)[property] = (<any>data)[property];
            }
        }
        if (!data) {
            this.schemas = [];
            this.tables = [];
        }
    }

    init(_data?: any) {
        if (_data) {
            this.noPluralize = _data["noPluralize"];
            this.useDatabaseNames = _data["useDatabaseNames"];
            if (Array.isArray(_data["schemas"])) {
                this.schemas = [] as any;
                for (let item of _data["schemas"])
                    this.schemas!.push(item);
            }
            if (Array.isArray(_data["tables"])) {
                this.tables = [] as any;
                for (let item of _data["tables"])
                    this.tables!.push(item);
            }
            this.optimizeDbContext = _data["optimizeDbContext"];
        }
    }

    static fromJS(data: any): ScaffoldOptions {
        data = typeof data === 'object' ? data : {};
        let result = new ScaffoldOptions();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        data["noPluralize"] = this.noPluralize;
        data["useDatabaseNames"] = this.useDatabaseNames;
        if (Array.isArray(this.schemas)) {
            data["schemas"] = [];
            for (let item of this.schemas)
                data["schemas"].push(item);
        }
        if (Array.isArray(this.tables)) {
            data["tables"] = [];
            for (let item of this.tables)
                data["tables"].push(item);
        }
        data["optimizeDbContext"] = this.optimizeDbContext;
        return data;
    }

    clone(): ScaffoldOptions {
        const json = this.toJSON();
        let result = new ScaffoldOptions();
        result.init(json);
        return result;
    }
}

export interface IScaffoldOptions {
    noPluralize: boolean;
    useDatabaseNames: boolean;
    schemas: string[];
    tables: string[];
    optimizeDbContext: boolean;
}

export class PostgreSqlDatabaseConnection extends EntityFrameworkRelationalDatabaseConnection implements IPostgreSqlDatabaseConnection {

    constructor(data?: IPostgreSqlDatabaseConnection) {
        super(data);
        this._discriminator = "PostgreSqlDatabaseConnection";
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): PostgreSqlDatabaseConnection {
        data = typeof data === 'object' ? data : {};
        let result = new PostgreSqlDatabaseConnection();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): PostgreSqlDatabaseConnection {
        const json = this.toJSON();
        let result = new PostgreSqlDatabaseConnection();
        result.init(json);
        return result;
    }
}

export interface IPostgreSqlDatabaseConnection extends IEntityFrameworkRelationalDatabaseConnection {
}

export class SQLiteDatabaseConnection extends EntityFrameworkRelationalDatabaseConnection implements ISQLiteDatabaseConnection {

    constructor(data?: ISQLiteDatabaseConnection) {
        super(data);
        this._discriminator = "SQLiteDatabaseConnection";
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): SQLiteDatabaseConnection {
        data = typeof data === 'object' ? data : {};
        let result = new SQLiteDatabaseConnection();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): SQLiteDatabaseConnection {
        const json = this.toJSON();
        let result = new SQLiteDatabaseConnection();
        result.init(json);
        return result;
    }
}

export interface ISQLiteDatabaseConnection extends IEntityFrameworkRelationalDatabaseConnection {
}

export class MySqlDatabaseConnection extends EntityFrameworkRelationalDatabaseConnection implements IMySqlDatabaseConnection {

    constructor(data?: IMySqlDatabaseConnection) {
        super(data);
        this._discriminator = "MySqlDatabaseConnection";
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): MySqlDatabaseConnection {
        data = typeof data === 'object' ? data : {};
        let result = new MySqlDatabaseConnection();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): MySqlDatabaseConnection {
        const json = this.toJSON();
        let result = new MySqlDatabaseConnection();
        result.init(json);
        return result;
    }
}

export interface IMySqlDatabaseConnection extends IEntityFrameworkRelationalDatabaseConnection {
}

export class MariaDbDatabaseConnection extends EntityFrameworkRelationalDatabaseConnection implements IMariaDbDatabaseConnection {

    constructor(data?: IMariaDbDatabaseConnection) {
        super(data);
        this._discriminator = "MariaDbDatabaseConnection";
    }

    init(_data?: any) {
        super.init(_data);
    }

    static fromJS(data: any): MariaDbDatabaseConnection {
        data = typeof data === 'object' ? data : {};
        let result = new MariaDbDatabaseConnection();
        result.init(data);
        return result;
    }

    toJSON(data?: any) {
        data = typeof data === 'object' ? data : {};
        super.toJSON(data);
        return data;
    }

    clone(): MariaDbDatabaseConnection {
        const json = this.toJSON();
        let result = new MariaDbDatabaseConnection();
        result.init(json);
        return result;
    }
}

export interface IMariaDbDatabaseConnection extends IEntityFrameworkRelationalDatabaseConnection {
}

export interface FileResponse {
    data: Blob;
    status: number;
    fileName?: string;
    headers?: { [name: string]: any };
}

export class ApiException extends Error {
    message: string;
    status: number;
    response: string;
    headers: { [key: string]: any; };
    result: any;

    constructor(message: string, status: number, response: string, headers: { [key: string]: any; }, result: any) {
        super();

        this.message = message;
        this.status = status;
        this.response = response;
        this.headers = headers;
        this.result = result;
    }

    protected isApiException = true;

    private _errorResponse: ErrorResult | undefined | null;
    public get errorResponse(): ErrorResult | undefined {
        if (this._errorResponse !== undefined)
            return this._errorResponse || undefined;

        if (!this.response) {
            this._errorResponse = null;
            return undefined;
        }

        try {
            this._errorResponse = JSON.parse(this.response) as ErrorResult;
            return this._errorResponse;
        } catch {
            this._errorResponse = null;
            return undefined;
        }
    }

    static isApiException(obj: any): obj is ApiException {
        return obj.isApiException === true;
    }
}

function throwException(message: string, status: number, response: string, headers: { [key: string]: any; }, result?: any): any {
    if (result !== null && result !== undefined)
        throw result;
    else
        throw new ApiException(message, status, response, headers, null);
}