# lushan 设计理念

**Tao Hui** http://weibo.com/taohui3

这篇文章来自于我发给同事的邮件：


lushan通信部分和memcached相似，具有相同的协议。只是通信模型不一样，memcached早期版本是单线程模式，后来改成多线程（redis目前也是单线程模式）。Memcached的多线程主要是为了充分利用当前机器多核和多CPU的特点。它的多线程是一个线程负责侦听，如果有连接过来，连接建立完成后，则派发给其它线程处理。剩下的记录读取，处理，返回结果都是在其它线程，通过IO多路复用完成的。

这种模型符合memcached只是查询hash表，处理速度非常快的特点。如果是一个操作需要的时间比较长，则会堵死IO多路复用的特点。所以，我们使用比较常见的IO线程和worker线程相分离的模型。如果一个连接建立完成，并且读取到一条完整的记录，则派发给工作线程，工作线程处理，处理完之后再转给IO线程，进行IO输出。在这里IO线程通常为一个，因为再写多个会异常复杂，通常需要把一个连接在三类线程间传递。
 
通信模型的编写是一个很细节的工作（看起来简单），例如用非阻塞套接字去处理，才能保证真正的处理C10K的问题，只要读写不返回EAGGIN或EWOULDBLOCK的，都不要再交给epoll再去提醒，等等。每次写这样细节的程序，都会有些后怕。
 
对于词典服务，也有一些细节，需要考虑：

1. **锁**。 尽量保持没有锁，或尽量少的锁。在这里用的是引用计数，来确保库切换过程中，同时保持两个库都可用的状态，close列表中库的引用计数为0后，再由管理线程关闭。
2. **库的索引**。 索引保持尽量小，以便于加载到内存中，形成一个稳定的查询性能。在这里当前只是支持了key为一个长整型，这样保持了一个索引项只需要16个字节。如果为了通用，也可以支持字符串。但字符串索引的设计，需要是连续的文本加对这个文本的每条记录的定长索引。
3. **库的value**。 这部分重点是应用需要考虑的，尽可能的小，例如：错过的微博使用了压缩存储，让10G的一个库，变成了3G。那么对于线上存储来说，3G的库和10G的库，性能差异是可想而知的。
4. **尽量减少内存的拷贝**。 这点会降低代码所谓的清晰性。但是高效的服务都不容易看懂，例如HAProxy，包括现在的Memcached等。这些服务通常一两个文件搞定，因为代码之间都有关联，这种关联保持了最大的效率。