# Web Applications with FastAPI course

Demo code and other handouts for students of our FastAPI Web Apps course.

[![](./data/readme_resources/fastapi-apps.png)](https://training.talkpython.fm/courses/full-html-web-applications-with-fastapi)

## Course Summary

FastAPI has burst on to the Python web scene. In fact, the 2020 PSF developer survey shows FastAPI going from off the
radar to the 3rd most popular and fastest growing framework for Python developers. People discovering FastAPI are
thrilled with it's toolchain for building APIs. But they wonder if they will need to build a parallel app in Flask or
Django for the HTML side of their site.

This course is here to show you that you do not need a second browser-oriented framework: FastAPI is a fantastic
framework for HTML-oriented content and static content. That's what this course is all about. You'll learn to build full
web apps with FastAPI, equivalent to what you can do with Flask or Django. And it's an amazing framework with even more
features than those older, more established frameworks.

## What's this course about and how is it different?

There are not many courses out focusing on the FastAPI web framework. But even those that are around focus almost
entirely on the API side of FastAPI. While that is useful and interesting, you'll need to answer the question of whether
**you need another web framework such as Flask or Django for the web browsers.** The answer is no.

FastAPI is a truly modern framework that allows you to write web apps with dynamic HTML templates just as much as Flask.
Throughout this course, you'll see how to use the various features of FastAPI along with a couple external packages to
create wonderful Python web apps.

As part of the course, we well create a nearly complete clone of pypi.org in FastAPI. We'll learn how to use SQLAlchemy,
HTML templates, static files, and even deploy our app to a Linux VM in the cloud.

## What topics are covered

This course covers everything you need to know to develop, run, and deploy full web apps on top of FastAPI. Just some of
the topics include:

- Building a basic FastAPI application
- Using server-side dynamic HTML templates such as Jinja2 and Chameleon
- Centralizing look & feel as well as structural items with a layout HTML template
- Serving static files from FastAPI (such as images and CSS files)
- Using the view model design pattern to help with data exchange in FastAPI
- Create HTML forms accepting user input and doing validation
- Storing data in the SQLAlchemy ORM
- Leveraging SQLAlchemy's new async/await capable API for scaling out
- Deploy your FastAPI app to a Linux cloud VM

## Course revisions

See the [course revisions and change log](./revisions.md).

## Take the course

Take the course over
at [Talk Python Training today](https://training.talkpython.fm/courses/full-html-web-applications-with-fastapi).
