import Script from 'next/script'
export const GA_MEASUREMENT_ID = process.env.NEXT_PUBLIC_GA_ID || ''

export function GoogleAnalytics() {
  if (!GA_MEASUREMENT_ID) {
    return <></>
  }
  return (
    <>
      <Script
        src={`https://www.googletagmanager.com/gtag/js?id=${GA_MEASUREMENT_ID}`}
        strategy="afterInteractive"
      />
      <Script id="google-analytics" strategy="afterInteractive">
        {`
            window.dataLayer = window.dataLayer || [];
            function gtag(){dataLayer.push(arguments);}
            gtag('js', new Date());

            gtag('config', '${GA_MEASUREMENT_ID}');
          `}
      </Script>
    </>
  )
}
export default GoogleAnalytics
