import { createStore, combineReducers, applyMiddleware, compose } from "redux";
import thunk from "redux-thunk";
import sessionReducer from "./session";
import usersReducer from "./user";
import carsReducer from "./cars";
import tripsReducer from "./trips";
import reviewsReducer from "./reviews";
import favoritesReducer from "./favorites";

const rootReducer = combineReducers({
  session: sessionReducer,
  users: usersReducer,
  cars: carsReducer,
  trips: tripsReducer,
  reviews: reviewsReducer,
  favorites: favoritesReducer,
});

let enhancer;

if (process.env.NODE_ENV === "production") {
  enhancer = applyMiddleware(thunk);
} else {
  const logger = require("redux-logger").default;
  const composeEnhancers =
    window.__REDUX_DEVTOOLS_EXTENSION_COMPOSE__ || compose;
  enhancer = composeEnhancers(applyMiddleware(thunk, logger));
}

const configureStore = (preloadedState) =>
  createStore(rootReducer, preloadedState, enhancer);

export default configureStore;
