这是一个简易版的助手，主要是意图识别和槽位填充。直接看代码：

```python
# 定义意图及槽位
LANUCH = {
  "name": "lanuch",
  "description": "打开某个app或者电器",
  "slots":{
    "app_name": "app或者电器名",
  }
}

TRANSLATION = {
  "name": "translation",
  "description": "翻译",
  "slots": {
    "language": "语言",
  }
}

LOCAITON = {
  "name": "location",
  "description": "查询两个地点之间的路径",
  "slots": {
    "from_loation": "起始位置",
    "to_location": "终止位置",
  }
}

# from transformers import AutoTokenizer, AutoModel
# tokenizer = AutoTokenizer.from_pretrained("THUDM/chatglm-6b-int4", trust_remote_code=True)
# model = AutoModel.from_pretrained("THUDM/chatglm-6b-int4", trust_remote_code=True).half().cuda()

history = []
start_prompt = """你现在是一个识别意图的专家，给定一个文本，你需要识别文本里面的意图，请从
`{打开某app或者电器：lanuch,翻译文本:translation,查询路径:location]`进行选择。

```文本：{text}```

你需要返回意图对应的英文名，比如如果是翻译文本，则返回translation等。如果没有上述意图，则回答无。
"""

second_prompt = """
给定文本：{text}

你已经知道该文本意图为`{intent}`，请识别里面的{slots}。

结果返回为一个字典，例如{text: 原始文本, intent:意图名, slots:按照字典里面格式填充值}。
"""

import openai

openai_api_key = ""

# 导入ChatOpenAI，这是LangChain对ChatGPT API访问的抽象
from langchain.chat_models import ChatOpenAI
from langchain.llms import OpenAI
# 要控制 LLM 生成文本的随机性和创造性，请使用 temperature = 0.0
# 用一个比较高的temperature值以获得一些更有意思的结果
llm = OpenAI(model_name="gpt-3.5-turbo",
          openai_api_key=openai_api_key,
          temperature=0.0)


str2intent = {
  "lanuch": LANUCH,
  "translation": TRANSLATION,
  "location": LOCAITON
}

zh2eng = {
  "打开某app或者电器": "lanuch",
  "翻译文本": "translation",
  "查询路径": "location",
}

text = "打开淘宝"
history = []
while True:
  if len(history) == 0:
    text = str(input("user："))
    prompt = start_prompt.replace("{text}", text)
    # response, history = model.chat(tokenizer, prompt, history=history)
    response = llm(prompt)
    print("chatgpt", response)
  if response.strip() in zh2eng:
    response = zh2eng[response]
  if response in ["lanuch", "translation", "location"]:
    history = second_prompt.replace("{text}", text).replace("{intent}", response)
    history = history.replace("{slots}", str(str2intent[response]["slots"]))
    print(history)
    response = llm(history)
    print("chatgpt", response)
  history = []

```

结果：

```python
user：把我爱你翻译为英文
chatgpt 翻译文本

给定文本：把我爱你翻译为英文

你已经知道该文本意图为`translation`，请识别里面的{'language': '语言'}。

结果返回为一个字典，例如{text: 原始文本, intent:意图名, slots:按照字典里面格式填充值}。

chatgpt {
  "text": "把我爱你翻译为英文",
  "intent": "translation",
  "slots": {
    "language": "英文"
  }
}
user：武汉到深圳怎么去
chatgpt 查询路径

给定文本：武汉到深圳怎么去

你已经知道该文本意图为`location`，请识别里面的{'from_loation': '起始位置', 'to_location': '终止位置'}。

结果返回为一个字典，例如{text: 原始文本, intent:意图名, slots:按照字典里面格式填充值}。

chatgpt {
  "text": "武汉到深圳怎么去",
  "intent": "location",
  "slots": {
    "from_location": "武汉",
    "to_location": "深圳"
  }
}
user：打开天天象棋
chatgpt lanuch

给定文本：打开天天象棋

你已经知道该文本意图为`lanuch`，请识别里面的{'app_name': 'app或者电器名'}。

结果返回为一个字典，例如{text: 原始文本, intent:意图名, slots:按照字典里面格式填充值}。

chatgpt {
  "text": "打开天天象棋",
  "intent": "launch",
  "slots": {
    "app_name": "天天象棋"
  }
}
user：打开相机这

给定文本：打开相机这

你已经知道该文本意图为`lanuch`，请识别里面的{'app_name': 'app或者电器名'}。

结果返回为一个字典，例如{text: 原始文本, intent:意图名, slots:按照字典里面格式填充值}。

chatgpt {
  "text": "打开相机这",
  "intent": "launch",
  "slots": {
    "app_name": "相机"
  }
}
```

麻雀虽小，五脏俱全。

这只是一个简单的样例，有很多值得改进的地方：

- 如果不存在上述的意图怎么处理。
- 对于特定的意图，还需要继续问答下去。
- 将公用的部分进一步进行分装。
- 怎么将其整合到langchain里面。

- 除了上述的利用LLM充当中间角色外，还可以使用embedding来充当。