# Changelog

All notable changes to this project will be documented in this file.

The format is based on [Keep a Changelog](https://keepachangelog.com/),
and this project adheres to [Semantic Versioning](https://semver.org/spec/v2.0.0.html).

## [Unreleased]

- Nothing yet!

## [2.2.0] - 2024-11-18

### Added

- Add React 19 support ([#1247](https://github.com/tailwindlabs/heroicons/pull/1247))

### Fixed

- Removed unnecessary clipping path from `solid/arrow-left-circle` ([#1211](https://github.com/tailwindlabs/heroicons/pull/1211))

## [2.1.5] - 2024-07-10

### Added

- Add new icons (`arrow-turn-*`, `bold`, `calendar-date-range`, `divide`, `document-currency-*`, `equals`, `h1`, `h2`, `h3`, `italic`, `link-slash`, `numbered-list`, `percent-badge`, `slash`, `strikethrough`, `underline`)

## [2.1.4] - 2024-06-17

### Fixed

- Improve tree-shakability of React package ([#1192](https://github.com/tailwindlabs/heroicons/pull/1192))

## [2.1.3] - 2024-03-22

- Improve project READMEs ([#1152](https://github.com/tailwindlabs/heroicons/pull/1152))

## [2.1.2] - 2024-03-22

- Include license file with published packages ([#1151](https://github.com/tailwindlabs/heroicons/pull/1151))

## [2.1.1] - 2023-12-18

### Fixed

- Fixed chevrons in mini set ([#1106](https://github.com/tailwindlabs/heroicons/pull/1106))

## [2.1.0] - 2023-12-18

### Added

- Added micro icon set ([#1104](https://github.com/tailwindlabs/heroicons/pull/1104))
- Rebuilt some icons for better clarity ([#1104](https://github.com/tailwindlabs/heroicons/pull/1104))

## [2.0.18] - 2023-05-09

### Fixed

- Fix incorrect `esm` paths in package.json for both React and Vue ([#988](https://github.com/tailwindlabs/heroicons/pull/988))

## [2.0.17] - 2023-03-30

### Fixed

- Fix React icon types ([#966](https://github.com/tailwindlabs/heroicons/pull/966))

## [2.0.16] - 2023-02-17

### Fixed

- Add root-level import ([#936](https://github.com/tailwindlabs/heroicons/pull/936))

## [2.0.15] - 2023-02-08

### Fixed

- Fix icon tree-shaking ([#929](https://github.com/tailwindlabs/heroicons/pull/929))

## [2.0.14] - 2023-01-25

### Fixed

- Fix React ref types ([#903](https://github.com/tailwindlabs/heroicons/pull/903))

### Changed

- Specify explicit package exports ([#920](https://github.com/tailwindlabs/heroicons/pull/920))

## [2.0.13] - 2022-11-02

### Fixed

- Fix `minus` icon alignment ([0a88242](https://github.com/tailwindlabs/heroicons/commit/0a88242ffddbd79177b8cd4cf954d3a54be121a6))

## [2.0.12] - 2022-10-05

### Fixed

- Add `title` and `titleId` props to the React types ([#814](https://github.com/tailwindlabs/heroicons/pull/814))
- Fix `information-circle` icon alignment ([#846](https://github.com/tailwindlabs/heroicons/pull/846))

## [2.0.11] - 2022-09-12

### Added

- Add new icons (`bug-ant`, `eye-dropper`, `pause-circle`, `play-circle`, `power`, `rocket-launch`, `square-2-stack-3d`, `stop-circle`, `trophy`, `tv`, `viewfinder-circle`, `window`) ([#809](https://github.com/tailwindlabs/heroicons/pull/809))

## [2.0.10] - 2022-08-30

## Fixed

- Fix `arrow-path` direction and fix optical alignment of `exclamation-triangle` ([#786](https://github.com/tailwindlabs/heroicons/pull/786))

## [2.0.9] - 2022-08-30

## Added

- Add new icons (`arrow-small-down`, `arrow-small-left`, `arrow-small-right`, `arrow-small-up`, `battery-0`, `battery-100`, `battery-50`, `cube-transparent`, `currency-bangladeshi`, `minus-small`, `paint-brush`, `plus-small`, `variable`, `wallet`, `arrow-path-rounded-square`) and fix optical alignment and appearance of icons (`bookmark-slash`, `bookmark`, `exclamation-triangle`, `table-cells`, `view-columns`, `arrow-path`) ([#785](https://github.com/tailwindlabs/heroicons/pull/785))

## [2.0.8] - 2022-08-26

## Fixed

- Fix optical alignment and size of icons (`heart`, `minus`, `pencil-square`, `user-plus`, `x-mark`, `hand-thumb-up`, `hand-thumb-down`) ([#767](https://github.com/tailwindlabs/heroicons/pull/767))
- Fix size of icons (`arrow-down-left`, `arrow-down-right`, `arrow-down`, `arrow-left`, `arrow-right`, `arrow-up-left`, `arrow-up-right`, `arrow-up`) ([#768](https://github.com/tailwindlabs/heroicons/pull/768))
- Fix optical alignment and size of `tag` icon ([#769](https://github.com/tailwindlabs/heroicons/pull/769))
- Fix size of `check` icon ([#770](https://github.com/tailwindlabs/heroicons/pull/770))

## Added

- Add `user-minus` icon

## [2.0.7] - 2022-08-25

## Fixed

- Improve optical alignment and sizing of icons (`hand-thumb-up`, `hand-thumb-down`, `plus`, `minus`) ([#746](https://github.com/tailwindlabs/heroicons/pull/746))

## [2.0.6] - 2022-08-25

## Fixed

- Fix size of icons (`chevron-double-down`, `chevron-double-left`, `chevron-double-right`, `chevron-double-up`, `chevron-down`, `chevron-left`, `chevron-right`, `chevron-up`, `funnel`, `minus`, `plus`) ([#763](https://github.com/tailwindlabs/heroicons/pull/763))

## [2.0.5] - 2022-08-25

## Fixed

- Modify the curved design of the `check-*` icons to a straight check ([#762](https://github.com/tailwindlabs/heroicons/pull/762))

## [2.0.4] - 2022-08-24

## Fixed

- Remove additional stroke from outline icons (`bars-arrow-down`,`bars-arrow-up`,`chevron-up-down`, `rss`) ([#759](https://github.com/tailwindlabs/heroicons/pull/759))

## [2.0.3] - 2022-08-24

### Added

- Add missing icons from v1 (`bars-arrow-down`,`bars-arrow-up`,`chevron-up-down`, `rss`) ([#758](https://github.com/tailwindlabs/heroicons/pull/758))

### Fixed

- Fix inconsistent naming for 'code-bracket' icons (#756)

## [2.0.2] - 2022-08-24

### Fixed

- Fix typo in `exclamation-*` icons (#735)

## [2.0.1] - 2022-08-23

## Added

- Warn when trying to import from v1 paths ([f508658](https://github.com/tailwindlabs/heroicons/commit/f5086588a9b25fd425578fbe185deb38d6b8505f))

## [2.0.0] - 2022-08-23

### Added

- Completely new icon set, checkout the [release notes](https://github.com/tailwindlabs/heroicons/releases/tag/v2.0.0) for more info.

## [1.0.6] - 2022-03-02

### Added

- Add `forwardRef` support for React components ([#614](https://github.com/tailwindlabs/heroicons/pull/614))

### Fixed

- Add `sideEffects` to `package.json` files ([#572](https://github.com/tailwindlabs/heroicons/pull/572))
- Fix folder icons ([#598](https://github.com/tailwindlabs/heroicons/pull/598))
- Fix Vue TypeScript declarations ([#608](https://github.com/tailwindlabs/heroicons/pull/608))
- Move `stroke-width` from `path` to `svg` ([#631](https://github.com/tailwindlabs/heroicons/pull/631))

## [1.0.5] - 2021-10-22

### Fixed

- Add MIT license to `package.json` files ([#317](https://github.com/tailwindlabs/heroicons/pull/317))
- Add `aria-hidden="true"` attribute ([#261](https://github.com/tailwindlabs/heroicons/pull/261))
- Fix solid `arrows-expand` fill color ([#515](https://github.com/tailwindlabs/heroicons/pull/515))
- Add `{"type": "module"}` to `esm` `package.json` files

## [1.0.4] - 2021-08-17

### Fixed

- Fix Vue type declarations ([#322](https://github.com/tailwindlabs/heroicons/pull/322))

## [1.0.3] - 2021-07-26

### Added

- Add Vue type declarations ([#254](https://github.com/tailwindlabs/heroicons/pull/254))

## [1.0.2] - 2021-07-09

### Fixed

- Add correct `plus` icons

## [1.0.1] - 2021-04-14

### Added

- Add small arrow icons (`arrow-sm-up`, `arrow-sm-right`, `arrow-sm-down`, `arrow-sm-left`)

## [1.0.0] - 2021-03-29

## [0.4.2] - 2020-09-02

## [0.4.1] - 2020-08-26

## [0.4.0] - 2020-08-25

### Fixed

- Don't run build scripts on install

## [0.3.7] - 2020-07-23

## [0.3.6] - 2020-06-02

## [0.3.5] - 2020-06-01

## [0.3.4] - 2020-06-01

## [0.3.3] - 2020-06-01

## [0.3.2] - 2020-06-01

## [0.3.1] - 2020-06-01

## [0.3.0] - 2020-06-01

### Added

- Add 22 new icons (`fire`, `shopping-bag`, `thumb-up`, `thumb-down`, `hand`, `arrows-expand`, `view-grid`, `puzzle`, `folder-download`, `folder-add`, `folder-remove`) ([60e6750](https://github.com/tailwindlabs/heroicons/commit/60e6750e1cee2477e62f62f54f4023690de7336c))
- Add React and Vue components ([aa8fe98](https://github.com/tailwindlabs/heroicons/commit/aa8fe98dc1106fe0cfd68f0c91b2fa1c4f7a147a))

## [0.2.0] - 2020-05-18

### Added

- Everything!

[unreleased]: https://github.com/tailwindlabs/heroicons/compare/v2.2.0...HEAD
[2.2.0]: https://github.com/tailwindlabs/heroicons/compare/v2.1.5...v2.2.0
[2.1.5]: https://github.com/tailwindlabs/heroicons/compare/v2.1.4...v2.1.5
[2.1.4]: https://github.com/tailwindlabs/heroicons/compare/v2.1.3...v2.1.4
[2.1.3]: https://github.com/tailwindlabs/heroicons/compare/v2.1.2...v2.1.3
[2.1.2]: https://github.com/tailwindlabs/heroicons/compare/v2.1.1...v2.1.2
[2.1.1]: https://github.com/tailwindlabs/heroicons/compare/v2.1.0...v2.1.1
[2.1.0]: https://github.com/tailwindlabs/heroicons/compare/v2.0.18...v2.1.0
[2.0.18]: https://github.com/tailwindlabs/heroicons/compare/v2.0.17...v2.0.18
[2.0.17]: https://github.com/tailwindlabs/heroicons/compare/v2.0.16...v2.0.17
[2.0.16]: https://github.com/tailwindlabs/heroicons/compare/v2.0.15...v2.0.16
[2.0.15]: https://github.com/tailwindlabs/heroicons/compare/v2.0.14...v2.0.15
[2.0.14]: https://github.com/tailwindlabs/heroicons/compare/v2.0.13...v2.0.14
[2.0.13]: https://github.com/tailwindlabs/heroicons/compare/v2.0.12...v2.0.13
[2.0.12]: https://github.com/tailwindlabs/heroicons/compare/v2.0.11...v2.0.12
[2.0.11]: https://github.com/tailwindlabs/heroicons/compare/v2.0.10...v2.0.11
[2.0.10]: https://github.com/tailwindlabs/heroicons/compare/v2.0.9...v2.0.10
[2.0.9]: https://github.com/tailwindlabs/heroicons/compare/v2.0.8...v2.0.9
[2.0.8]: https://github.com/tailwindlabs/heroicons/compare/v2.0.7...v2.0.8
[2.0.7]: https://github.com/tailwindlabs/heroicons/compare/v2.0.6...v2.0.7
[2.0.6]: https://github.com/tailwindlabs/heroicons/compare/v2.0.5...v2.0.6
[2.0.5]: https://github.com/tailwindlabs/heroicons/compare/v2.0.4...v2.0.5
[2.0.4]: https://github.com/tailwindlabs/heroicons/compare/v2.0.3...v2.0.4
[2.0.3]: https://github.com/tailwindlabs/heroicons/compare/v2.0.2...v2.0.3
[2.0.2]: https://github.com/tailwindlabs/heroicons/compare/v2.0.1...v2.0.2
[2.0.1]: https://github.com/tailwindlabs/heroicons/compare/v2.0.0...v2.0.1
[2.0.0]: https://github.com/tailwindlabs/heroicons/compare/v1.0.6...v2.0.0
[1.0.6]: https://github.com/tailwindlabs/heroicons/compare/v1.0.5...v1.0.6
[1.0.5]: https://github.com/tailwindlabs/heroicons/compare/v1.0.4...v1.0.5
[1.0.4]: https://github.com/tailwindlabs/heroicons/compare/v1.0.3...v1.0.4
[1.0.3]: https://github.com/tailwindlabs/heroicons/compare/v1.0.2...v1.0.3
[1.0.2]: https://github.com/tailwindlabs/heroicons/compare/v1.0.1...v1.0.2
[1.0.1]: https://github.com/tailwindlabs/heroicons/compare/v1.0.0...v1.0.0
[1.0.0]: https://github.com/tailwindlabs/heroicons/compare/v0.4.2...v1.0.0
[0.4.2]: https://github.com/tailwindlabs/heroicons/compare/v0.4.1...v0.4.2
[0.4.1]: https://github.com/tailwindlabs/heroicons/compare/v0.4.0...v0.4.1
[0.4.0]: https://github.com/tailwindlabs/heroicons/compare/v0.3.7...v0.4.0
[0.3.7]: https://github.com/tailwindlabs/heroicons/compare/v0.3.6...v0.3.7
[0.3.6]: https://github.com/tailwindlabs/heroicons/compare/v0.3.5...v0.3.6
[0.3.5]: https://github.com/tailwindlabs/heroicons/compare/v0.3.4...v0.3.5
[0.3.4]: https://github.com/tailwindlabs/heroicons/compare/v0.3.3...v0.3.4
[0.3.3]: https://github.com/tailwindlabs/heroicons/compare/v0.3.2...v0.3.3
[0.3.2]: https://github.com/tailwindlabs/heroicons/compare/v0.3.1...v0.3.2
[0.3.1]: https://github.com/tailwindlabs/heroicons/compare/v0.3.0...v0.3.1
[0.3.0]: https://github.com/tailwindlabs/heroicons/compare/v0.2.0...v0.3.0
[0.2.0]: https://github.com/tailwindlabs/heroicons/releases/tag/v0.2.0
