# Tools

This is a list of tools that are installed from manifests managed in this action.

If a tool not included in the list below is specified, this action uses [cargo-binstall] as a fallback.

See the [Supported tools section in README.md](README.md#supported-tools) for how to ensure that fallback is not used.

> If `$CARGO_HOME/bin` is not available, Rust-related binaries will be installed to `$HOME/.cargo/bin`.<br>
> If `$HOME/.cargo/bin` is not available, Rust-related binaries will be installed to `$HOME/.install-action/bin`.<br>

| Name | Where binaries will be installed | Where will it be installed from | Supported platform | License |
| ---- | -------------------------------- | ------------------------------- | ------------------ | ------- |
| [**biome**](https://biomejs.dev) | `$HOME/.install-action/bin` | [GitHub Releases](https://github.com/biomejs/biome/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/biomejs/biome/blob/main/LICENSE-APACHE) OR [MIT](https://github.com/biomejs/biome/blob/main/LICENSE-MIT) |
| [**cargo-audit**](https://github.com/rustsec/rustsec/tree/HEAD/cargo-audit) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/rustsec/rustsec/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/rustsec/rustsec/blob/HEAD/cargo-audit/LICENSE-APACHE) OR [MIT](https://github.com/rustsec/rustsec/blob/HEAD/cargo-audit/LICENSE-MIT) |
| [**cargo-auditable**](https://github.com/rust-secure-code/cargo-auditable) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/rust-secure-code/cargo-auditable/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/rust-secure-code/cargo-auditable/blob/HEAD/LICENSE-APACHE) OR [MIT](https://github.com/rust-secure-code/cargo-auditable/blob/HEAD/LICENSE-MIT) |
| [**cargo-binstall**](https://github.com/cargo-bins/cargo-binstall) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/cargo-bins/cargo-binstall/releases) | Linux, macOS, Windows | [GPL-3.0](https://github.com/cargo-bins/cargo-binstall/blob/HEAD/crates/bin/LICENSE) |
| [**cargo-careful**](https://github.com/RalfJung/cargo-careful) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/RalfJung/cargo-careful/releases) | Linux, macOS, Windows | [MIT](https://github.com/RalfJung/cargo-careful/blob/master/LICENSE-MIT) OR [Apache-2.0](https://github.com/RalfJung/cargo-careful/blob/master/LICENSE-APACHE) |
| [**cargo-cyclonedx**](https://github.com/CycloneDX/cyclonedx-rust-cargo) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/CycloneDX/cyclonedx-rust-cargo/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/CycloneDX/cyclonedx-rust-cargo/blob/main/LICENSE) |
| [**cargo-deny**](https://github.com/EmbarkStudios/cargo-deny) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/EmbarkStudios/cargo-deny/releases) | Linux, macOS, Windows | [MIT](https://github.com/EmbarkStudios/cargo-deny/blob/main/LICENSE-MIT) OR [Apache-2.0](https://github.com/EmbarkStudios/cargo-deny/blob/main/LICENSE-APACHE) |
| [**cargo-dinghy**](https://github.com/sonos/dinghy) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/sonos/dinghy/releases) | Linux, macOS | [MIT](https://github.com/sonos/dinghy/blob/main/LICENSE-MIT) OR [Apache-2.0](https://github.com/sonos/dinghy/blob/main/LICENSE-APACHE) |
| [**cargo-export**](https://github.com/bazhenov/cargo-export) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/bazhenov/cargo-export/releases) | Linux, macOS, Windows | [MIT](https://github.com/bazhenov/cargo-export/blob/master/LICENSE) |
| [**cargo-hack**](https://github.com/taiki-e/cargo-hack) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/taiki-e/cargo-hack/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/taiki-e/cargo-hack/blob/main/LICENSE-APACHE) OR [MIT](https://github.com/taiki-e/cargo-hack/blob/main/LICENSE-MIT) |
| [**cargo-lambda**](https://github.com/cargo-lambda/cargo-lambda) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/cargo-lambda/cargo-lambda/releases) | Linux, macOS, Windows | [MIT](https://github.com/cargo-lambda/cargo-lambda/blob/main/LICENSE) |
| [**cargo-llvm-cov**](https://github.com/taiki-e/cargo-llvm-cov) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/taiki-e/cargo-llvm-cov/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/taiki-e/cargo-llvm-cov/blob/main/LICENSE-APACHE) OR [MIT](https://github.com/taiki-e/cargo-llvm-cov/blob/main/LICENSE-MIT) |
| [**cargo-machete**](https://github.com/bnjbvr/cargo-machete) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/bnjbvr/cargo-machete/releases) | Linux, macOS, Windows | [MIT](https://github.com/bnjbvr/cargo-machete/blob/main/LICENSE.md) |
| [**cargo-make**](https://github.com/sagiegurari/cargo-make) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/sagiegurari/cargo-make/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/sagiegurari/cargo-make/blob/master/LICENSE) |
| [**cargo-minimal-versions**](https://github.com/taiki-e/cargo-minimal-versions) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/taiki-e/cargo-minimal-versions/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/taiki-e/cargo-minimal-versions/blob/main/LICENSE-APACHE) OR [MIT](https://github.com/taiki-e/cargo-minimal-versions/blob/main/LICENSE-MIT) |
| [**cargo-nextest**](https://github.com/nextest-rs/nextest) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/nextest-rs/nextest/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/nextest-rs/nextest/blob/main/LICENSE-APACHE) OR [MIT](https://github.com/nextest-rs/nextest/blob/main/LICENSE-MIT) |
| [**cargo-no-dev-deps**](https://github.com/taiki-e/cargo-no-dev-deps) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/taiki-e/cargo-no-dev-deps/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/taiki-e/cargo-no-dev-deps/blob/main/LICENSE-APACHE) OR [MIT](https://github.com/taiki-e/cargo-no-dev-deps/blob/main/LICENSE-MIT) |
| [**cargo-rdme**](https://github.com/orium/cargo-rdme) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/orium/cargo-rdme/releases) | Linux, macOS, Windows | [MPL-2.0](https://github.com/orium/cargo-rdme/blob/main/LICENSE.md) |
| [**cargo-semver-checks**](https://github.com/obi1kenobi/cargo-semver-checks) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/obi1kenobi/cargo-semver-checks/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/obi1kenobi/cargo-semver-checks/blob/main/LICENSE-APACHE) OR [MIT](https://github.com/obi1kenobi/cargo-semver-checks/blob/main/LICENSE-MIT) |
| [**cargo-sort**](https://github.com/DevinR528/cargo-sort) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/DevinR528/cargo-sort/releases) | Linux, macOS, Windows | [Apache-2.0 OR MIT](https://github.com/DevinR528/cargo-sort/blob/v1.0.9/Cargo.toml#L5) |
| [**cargo-spellcheck**](https://github.com/drahnr/cargo-spellcheck) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/drahnr/cargo-spellcheck/releases) | Linux, Windows | [LGPLv2.1](https://github.com/drahnr/cargo-spellcheck/blob/master/LICENSE-LGPL) |
| [**cargo-tarpaulin**](https://github.com/xd009642/tarpaulin) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/xd009642/tarpaulin/releases) | Linux, macOS, Windows | [MIT](https://github.com/xd009642/tarpaulin/blob/develop/LICENSE-MIT) OR [Apache-2.0](https://github.com/xd009642/tarpaulin/blob/develop/LICENSE-APACHE) |
| [**cargo-udeps**](https://github.com/est31/cargo-udeps) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/est31/cargo-udeps/releases) | Linux, macOS, Windows | [Apache-2.0 OR MIT](https://github.com/est31/cargo-udeps/blob/HEAD/LICENSE) |
| [**cargo-valgrind**](https://github.com/jfrimmel/cargo-valgrind) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/jfrimmel/cargo-valgrind/releases) | Linux, macOS, Windows | [MIT](https://github.com/jfrimmel/cargo-valgrind/blob/master/LICENSE-MIT) OR [Apache-2.0](https://github.com/jfrimmel/cargo-valgrind/blob/master/LICENSE-APACHE) |
| [**cargo-zigbuild**](https://github.com/rust-cross/cargo-zigbuild) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/rust-cross/cargo-zigbuild/releases) | Linux, macOS, Windows | [MIT](https://github.com/rust-cross/cargo-zigbuild/blob/main/LICENSE) |
| [**cross**](https://github.com/cross-rs/cross) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/cross-rs/cross/releases) | Linux, macOS, Windows | [MIT](https://github.com/cross-rs/cross/blob/main/LICENSE-MIT) OR [Apache-2.0](https://github.com/cross-rs/cross/blob/main/LICENSE-APACHE) |
| [**deepsource**](https://github.com/DeepSourceCorp/cli) | `$HOME/.install-action/bin` | [GitHub Releases](https://github.com/DeepSourceCorp/cli/releases) | Linux, macOS, Windows | [BSD-2-Clause](https://github.com/DeepSourceCorp/cli/blob/master/LICENSE) |
| [**dprint**](https://github.com/dprint/dprint) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/dprint/dprint/releases) | Linux, macOS, Windows | [MIT](https://github.com/dprint/dprint/blob/main/LICENSE) |
| [**earthly**](https://github.com/earthly/earthly) | `$HOME/.install-action/bin` | [GitHub Releases](https://github.com/earthly/earthly/releases) | Linux, macOS, Windows | [MPL-2.0](https://github.com/earthly/earthly/blob/main/LICENSE) |
| [**editorconfig-checker**](https://github.com/editorconfig-checker/editorconfig-checker) | `$HOME/.install-action/bin` | [GitHub Releases](https://github.com/editorconfig-checker/editorconfig-checker/releases) | Linux, macOS, Windows | [MIT](https://github.com/editorconfig-checker/editorconfig-checker/blob/main/LICENSE) |
| [**espup**](https://github.com/esp-rs/espup) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/esp-rs/espup/releases) | Linux, macOS, Windows | [MIT](https://github.com/esp-rs/espup/blob/main/LICENSE-MIT) OR [Apache-2.0](https://github.com/esp-rs/espup/blob/main/LICENSE-APACHE) |
| [**git-cliff**](https://github.com/orhun/git-cliff) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/orhun/git-cliff/releases) | Linux, macOS, Windows | [MIT](https://github.com/orhun/git-cliff/blob/main/LICENSE-MIT) OR [Apache-2.0](https://github.com/orhun/git-cliff/blob/main/LICENSE-APACHE) |
| [**grcov**](https://github.com/mozilla/grcov) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/mozilla/grcov/releases) | Linux, macOS, Windows | [MPL-2.0](https://github.com/mozilla/grcov/blob/HEAD/LICENSE-MPL-2.0) |
| [**hyperfine**](https://github.com/sharkdp/hyperfine) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/sharkdp/hyperfine/releases) | Linux, macOS, Windows | [MIT](https://github.com/sharkdp/hyperfine/blob/master/LICENSE-MIT) OR [Apache-2.0](https://github.com/sharkdp/hyperfine/blob/master/LICENSE-APACHE) |
| [**jaq**](https://github.com/01mf02/jaq) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/01mf02/jaq/releases) | Linux, macOS, Windows | [MIT](https://github.com/01mf02/jaq/blob/main/LICENSE-MIT) |
| [**just**](https://github.com/casey/just) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/casey/just/releases) | Linux, macOS, Windows | [CC0-1.0](https://github.com/casey/just/blob/master/LICENSE) |
| [**knope**](https://github.com/knope-dev/knope) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/knope-dev/knope/releases) | Linux, macOS, Windows | [MIT](https://github.com/knope-dev/knope/blob/main/LICENSE) |
| [**mdbook**](https://github.com/rust-lang/mdBook) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/rust-lang/mdBook/releases) | Linux, macOS, Windows | [MPL-2.0](https://github.com/rust-lang/mdBook/blob/master/LICENSE) |
| [**mdbook-linkcheck**](https://github.com/Michael-F-Bryan/mdbook-linkcheck) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/Michael-F-Bryan/mdbook-linkcheck/releases) | Linux, macOS, Windows | [MIT](https://github.com/Michael-F-Bryan/mdbook-linkcheck/blob/master/LICENSE) |
| [**osv-scanner**](https://github.com/google/osv-scanner) | `$HOME/.install-action/bin` | [GitHub Releases](https://github.com/google/osv-scanner/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/google/osv-scanner/blob/main/LICENSE) |
| [**parse-changelog**](https://github.com/taiki-e/parse-changelog) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/taiki-e/parse-changelog/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/taiki-e/parse-changelog/blob/main/LICENSE-APACHE) OR [MIT](https://github.com/taiki-e/parse-changelog/blob/main/LICENSE-MIT) |
| [**protoc**](https://github.com/protocolbuffers/protobuf) | `$HOME/.install-action/bin` | [GitHub Releases](https://github.com/protocolbuffers/protobuf/releases) | Linux, macOS, Windows | [BSD-3-Clause](https://github.com/protocolbuffers/protobuf/blob/HEAD/LICENSE) |
| [**rclone**](https://github.com/rclone/rclone) | `$HOME/.install-action/bin` | [GitHub Releases](https://github.com/rclone/rclone/releases) | Linux, macOS, Windows | [MIT](https://github.com/rclone/rclone/blob/master/COPYING) |
| [**release-plz**](https://release-plz.dev/) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/release-plz/release-plz/releases) | Linux, macOS, Windows | [MIT](https://github.com/release-plz/release-plz/blob/main/LICENSE-MIT) OR [Apache-2.0](https://github.com/release-plz/release-plz/blob/main/LICENSE-APACHE) |
| [**sccache**](https://github.com/mozilla/sccache) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/mozilla/sccache/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/mozilla/sccache/blob/main/LICENSE) |
| [**shellcheck**](https://www.shellcheck.net) | `$HOME/.install-action/bin` | [GitHub Releases](https://github.com/koalaman/shellcheck/releases) | Linux, macOS, Windows | [GPL-3.0](https://github.com/koalaman/shellcheck/blob/master/LICENSE) |
| [**shfmt**](https://github.com/mvdan/sh) | `$HOME/.install-action/bin` | [GitHub Releases](https://github.com/mvdan/sh/releases) | Linux, macOS, Windows | [BSD-3-Clause](https://github.com/mvdan/sh/blob/master/LICENSE) |
| [**syft**](https://github.com/anchore/syft) | `$HOME/.install-action/bin` | [GitHub Releases](https://github.com/anchore/syft/releases) | Linux, macOS, Windows | [Apache-2.0](https://github.com/anchore/syft/blob/main/LICENSE) |
| [**typos**](https://github.com/crate-ci/typos) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/crate-ci/typos/releases) | Linux, macOS, Windows | [MIT](https://github.com/crate-ci/typos/blob/master/LICENSE-MIT) OR [Apache-2.0](https://github.com/crate-ci/typos/blob/master/LICENSE-APACHE) |
| [**valgrind**](https://valgrind.org/) | `/snap/bin` | [snap](https://snapcraft.io/install/valgrind/ubuntu) | Linux | [GPL-2.0](https://sourceware.org/git/?p=valgrind.git;a=blob;f=COPYING;hb=HEAD) |
| [**wait-for-them**](https://github.com/shenek/wait-for-them) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/shenek/wait-for-them/releases) | Linux, macOS, Windows | [GPL-3.0](https://github.com/shenek/wait-for-them/blob/v0.4.0/Cargo.toml#L7) |
| [**wasm-bindgen**](https://github.com/rustwasm/wasm-bindgen) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/rustwasm/wasm-bindgen/releases) | Linux, macOS, Windows | [MIT](https://github.com/rustwasm/wasm-bindgen/blob/main/LICENSE-MIT) OR [Apache-2.0](https://github.com/rustwasm/wasm-bindgen/blob/main/LICENSE-APACHE) |
| [**wasm-pack**](https://github.com/rustwasm/wasm-pack) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/rustwasm/wasm-pack/releases) | Linux, macOS, Windows | [MIT](https://github.com/rustwasm/wasm-pack/blob/master/LICENSE-MIT) OR [Apache-2.0](https://github.com/rustwasm/wasm-pack/blob/master/LICENSE-APACHE) |
| [**wasmtime**](https://github.com/bytecodealliance/wasmtime) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/bytecodealliance/wasmtime/releases) | Linux, macOS, Windows | [Apache-2.0 WITH LLVM-exception](https://github.com/bytecodealliance/wasmtime/blob/main/LICENSE) |
| [**xbuild**](https://github.com/rust-mobile/xbuild) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/rust-mobile/xbuild/releases) | Linux, macOS, Windows | [Apache-2.0 OR MIT](https://github.com/rust-mobile/xbuild/blob/v0.2.0/xbuild/Cargo.toml#L7) |
| [**xh**](https://github.com/ducaale/xh) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/ducaale/xh/releases) | Linux, macOS, Windows | [MIT](https://github.com/ducaale/xh/blob/master/LICENSE) |
| [**zola**](https://github.com/getzola/zola) | `$CARGO_HOME/bin` | [GitHub Releases](https://github.com/getzola/zola/releases) | Linux, macOS, Windows | [MIT](https://github.com/getzola/zola/blob/master/LICENSE) |

[cargo-binstall]: https://github.com/cargo-bins/cargo-binstall
