---
title: Чому CT3A?
description: Чому вам слід вибрати Create T3 App для наступного проекту?
layout: ../../layouts/docs.astro
lang: uk
---

Ми почали Create T3 App, тому що [Theo](https://twitter.com/t3dotgg) відмовився робити шаблон своїх улюблених технологій. Натхненний create-next-app, [Astro's CLI](https://astro.build) та загальною любов'ю до типобезпеки, команда Create T3 App працювала, щоб створити кращу можливу відправну точку для нових проектів T3 Stack.

Якщо ви зацікавлені у використанні Next.js у типобезпечному варіанті, це те, з чого потрібно почати. Якщо ви цікавитеся будь-якими з конкретних технологічних рішень, які ми зробили, читайте далі :)

## Чому TypeScript?

JavaScript складний. Навіщо додавати ще більше правил?

Ми цілком впевнені, що досвід TypeScript дозволяє вам бути кращим розробником. Він надає зворотний зв'язок під час написання коду, визначаючи очікувані типи даних, і, або допомгає корисним автозаповненням у вашому редакторі, або кричить на вас червоними хвилястими лініями, якщо ви намагаєтеся отримати доступ до властивості, якої не існує, або намагаєтеся передати значення неправильного типу, що в іншому випадку довелося б налагоджувати в подальшому. Незалежно від того, новачок ви у веб-розробці або досвідчений професіонал, "суворість" TypeScript забезпечує менш дратівливий, більш послідовний досвід, ніж ванільний JS.

Типобезпека робить вас швидше. Якщо ви ще не переконані, ви [можете використовувати TypeScript неправильно...](https://www.youtube.com/watch?v=RmGHnYUqQ4k)

## Чому Next.js?

Ми любимо React. Він зробив розробку UI доступною у тому вигляді, в якому ми ніколи не могли собі уявити. Він також може вести розробників тернистими шляхами.

Next.js пропонує злегка суб'єктивний, більш оптимізований підхід до створення додатків з використанням React. Від маршрутизації до визначення API до візуалізації зображень ми довіряємо Next.js, щоб вести розробників до правильних рішень.

## Чому tRPC/Prisma/Tailwind/и т.д.?

Хоча ми віримо, що все має бути якнайлегше, ми знаходимо, що ці частини використовуються в кожному проекті, складнішому ніж "лендінг" (напр. проєкти зі складнішими технологіями і логікою). `create-t3-app` виконує чудову роботу, дозволяючи вам вибрати ті частини, які вам потрібні.

### tRPC

tRPC надає всі переваги GraphQL, такі як гладка та безперервна розробка клієнта проти типобезпечного сервера без будь-якого бойлерплейту. Це розумний аб'юз TypeScript, яке забезпечує неймовірний досвід розробки.

### Prisma

Prisma для SQL це те й що TypeScript для JS. Вона створила досвід розробки, якого раніше не було. Створюючи типи з схеми користувача, сумісної з [кількома базами даних](https://www.prisma.io/docs/concepts/database-connectors), Prisma гарантує безпеку типів від початку до кінця від вашої бази даних до вашої програми.

Prisma надає цілий [набір інструментів](https://www.prisma.io/docs/concepts/overview/should-you-use-prisma#-you-want-a-tool-that-holistically-covers-your-database-workflows), що полегшують щоденну взаємодію з вашою базою даних. Зокрема, Prisma Client відповідає за запити та робить SQL настільки простим, що ви ледве помітите, що його використовуєте, а Prisma Studio – це зручний GUI для вашої бази даних, який дозволяє швидко читати та маніпулювати даними без необхідності писати код.

### Tailwind CSS

Tailwind відчувається як "CSS у режимі дзен".

Завдяки наданню будівельних блоків у вигляді гарних кольорів за замовчуванням, відступів та інших примітивних налаштувань Tailwind дозволяє легко створювати додаток із гарним зовнішнім виглядом. І на відміну від бібліотек компонентів, він не обмежує вас, коли ви хочете вивести свою програму на наступний рівень і створити щось красиве та унікальне.

До того ж, завдяки інлайновому підходу, Tailwind спонукає вас стилізувати без занепокоєння про назву класів, організацію файлів або будь-яку іншу проблему, не пов'язану з вирішенням завдання.

### NextAuth.js

Коли ви хочете додати систему аутентифікації у вашу програму NextJS, NextAuth.js - відмінне рішення, щоб не морочитися з реалізацією складної системи безпеки. Вона має великий список провайдерів для швидкого додавання аутентифікації через OAuth і надає адаптери для багатьох баз даних та ORM.
