---
title: Додаткові рекомендації
description: Бібліотеки та сервіси, які ми рекомендуємо для багатьох проектів
layout: ../../layouts/docs.astro
lang: uk
---

Ми розуміємо, що бібліотеки, включені до `create-t3-app`, не вирішують кожну проблему. Хоча ми рекомендуємо розпочати свій проект з того, що ми надаємо, настане час, коли вам потрібно буде встановити інші пакети. Тільки ви можете знати, чого потребує ваш проект, але ось деякі рішення, які ми часто рекомендуємо.

Це рекомендації окремих учасників Create T3 App і не повинні розглядатись як "офіційні" рекомендації команди Create T3 App або T3-OSS. _**Будь ласка, проведіть власне дослідження, особливо перед тим, як прив'язуватись до платних сервісів**_.

## Управління станом

_**Примітка редактора**_: Бібліотеки керування станом можуть бути відмінними, але часто не потрібні. tRPC's хуки React Query повинні впоратися із вашим серверним станом. Для клієнтського стану почніть з `useState` React, і зверніться до одного з цих варіантів, коли вам буде потрібно більше.

### Zustand

**Для того, щоб більше ніколи не використовувати Redux**

"Сучасний простий Redux", який ви не знали, що вам потрібен. [Poimandres](https://github.com/pmndrs) завжди можна довіряти. Ви можете створювати все, від відеодзвінків до ігор та серверів із цією маленькою бібліотекою.

- [Головна Zustand](https://zustand-demo.pmnd.rs/)
- [Zustand GitHub](https://github.com/pmndrs/zustand)

### Jotai

**Для того, щоб більше ніколи не використовувати Context**

Jotai важко перевершити в підході Atomic. Також від [Poimandres](https://github.com/pmndrs), Jotai дозволяє визначати сінгелтони, які здаються глобальними useState. Відмінний варіант для станів, які не вимагають стейт машини прямо зараз.

- [Головна Jotai](https://jotai.org/)
- [Jotai GitHub](https://github.com/pmndrs/jotai)

## Бібліотеки компонентів

Більшість додатків потребують однакову низку компонентів: перемикачі, меню, модальні вікна і т.д. Ці бібліотеки надають відмінні, доступні компоненти, які ви можете використовувати та налаштовувати на свій розсуд.

### Бібліотеки компонентів без стилів

Також відомі як headless бібліотеки, вони надають відмінні, нестилізовані та доступні компоненти, які ви можете налаштувати на свій розсуд. Ось кілька рекомендацій.

- [Radix UI](https://www.radix-ui.com/) надає потужний набір зручних і доступних примітивів, які ви можете стилізувати за допомогою звичайного CSS або Tailwind CSS.

- [Headless UI](https://headlessui.com/) від команди Tailwind CSS також надає нестилізовані, доступні компоненти, які бездоганно інтегруються з Tailwind CSS.

- [React Aria](https://react-spectrum.adobe.com/react-aria/) надає доступні примітивні налаштування UI для вашої системи дизайну. Їхній компонент вибору дати - це найвищий рівень.

### Бібліотеки компонентів зі стилями

**Коли вам просто потрібно, щоб ваш додаток виглядав непогано**

Іноді ви створюєте проект, де вам просто потрібно, щоб інтерфейс користувача виглядав від початку. Для адміністративних панелей управління та інших подібних проектів будь-яка з цих бібліотек компонентів упорається з цим завданням.

- [Chakra UI](https://chakra-ui.com)
- [Mantine](https://mantine.dev)
- [@shadcn/ui](https://ui.shadcn.com/)

### Class Variance Authority

**Для створення бібліотек інтерфейсу користувача**

Декларативно створюйте бібліотеку інтерфейсу користувача з різними кольоровими, розмірними і т.д. варіантами. Коли ваш проект досягає масштабу, де вам потрібен стандартизований набір компонентів інтерфейсу користувача з кількома варіантами з використанням Tailwind CSS, CVA - відмінний інструмент.

- [Class Variance Authority GitHub](https://github.com/joe-bell/cva)

## Анімації

Наші рекомендації для створення анімацій у вашому додатку.

### AutoAnimate

**Для анімацій з одним рядком коду**

Більшість бібліотек анімації намагаються задовольнити кожен можливий випадок використання і стають громіздкими. AutoAnimate – це інструмент без конфігурації, який дасть вам значне покращення UX без додаткових зусиль розробника.

- [Головна AutoAnimate](https://auto-animate.formkit.com/)
- [AutoAnimate GitHub](https://github.com/formkit/auto-animate)
- [Компонент для AutoAnimate](https://gist.github.com/hwkr/3fdea5d7f609b98c162e5325637cf3cb)

### Framer Motion

**Для складних анімацій із декларативним кодом**

Framer Motion надає простий, декларативний синтаксис і дозволяє писати менше коду для створення всього: від складних анімацій і навіть до жестів.

- [Головна Framer Motion](https://framer.com/motion)
- [Документація Framer Motion](https://www.framer.com/docs/)

## Деплоймент, інфраструктура, бази даних і CI

### Vercel

**Для хостинга вашого додатка**

Vercel позбавив нас болю при деплойменті веб-додатків, зробивши його простою інтеграцією з GitHub, яку можна встановити і забути. Ми без проблем масштабувалися до сотень тисяч користувачів. Він працює на AWS, але має набагато кращий інтерфейс :)

- [Головна Vercel](https://vercel.com/)
- [Гайд із деплою T3 додатка на Vercel](/uk/deployment/vercel)

### PlanetScale

**Для баз даних без занепокоєння**

PlanetScale - найкраща serverless платформа для баз даних, яку ми використовували. Неймовірна масштабованість, чудовий DX і фантастична ціна. Якщо ви використовуєте SQL (і, сподіваюся, Prisma), це важко перевершити.

- [Головна PlanetScale](https://planetscale.com/)

### Railway

**Для розміщення вашої інфраструктури**

"Сучасний Heroku". Найпростіший спосіб запустити реальний сервер. Якщо вам не вистачає функціоналу Vercel і PlanetScale, то Railway, ймовірно, вам підійде. Вкажіть його на репозиторій GitHub і готово.

- [Головна Railway](https://railway.app/)

### Upstash

**Для serverless Redis**

Ми любимо Prisma і PlanetScale, але деякі проєкти вимагають більш продуктивного рішення. Upstash дає вам змогу отримати in-memory продуктивність Redis у вашому безсерверному проєкті, не переймаючись самостійним управлінням інфраструктурою та масштабуванням.

- [Головна Upstash](https://upstash.com/)

### Pusher

**Для безсерверних WebSocket-ів**

Якщо WebSocket є основним фокусом вашого проекту, ви можете розглянути більш традиційний бекенд, такий як [Fastify](https://www.fastify.io/) (який [також працює з tRPC!](https://trpc.io/docs/v10/fastify)). Але для швидкого додавання WebSocket у T3 App, Pusher - чудовий вибір.

- [Головна Pusher](https://pusher.com/)

### Soketi

Soketi - це самодостатня, проста і швидка альтернатива Pusher. Він повністю сумісний з Pusher SDK, який ви можете використовувати для підключення до сервера. Soketi serverless також перебуває в бета-версії.

- [Головна Soketi](https://soketi.app)
- [Soketi GitHub](https://github.com/soketi/soketi)

## Аналітика

Користувацькі дані дуже цінні, коли ви створюєте додаток. Ось кілька рекомендованих провайдерів аналітики.

### Plausible

Потрібна аналітика? Plausible - один із найшвидших способів її отримати. Супер мінімалістичний. У нього навіть є [простий плагін для Next.js](https://plausible.io/docs/proxy/guides/nextjs).

- [Головна Plausible](https://plausible.io/)

### Umami

Umami - це самодостатня, проста, швидка і конфіденційна альтернатива Google Analytics. Ви можете легко задеплоїти його на Vercel, Railway і т.д. з PlanetScale як базою даних.

- [Головна Umami](https://umami.is/)
- [Umami GitHub](https://github.com/umami-software/umami)
- [Umami Cloud](https://cloud.umami.is/)

## Інше

### Next Bundle Analyzer

Буває складно визначити, що буде включено до збірки вихідних даних для вашого додатка. Next Bundle Analyzer - це простий спосіб візуалізувати й аналізувати JavaScript-бандли, які генеруються.

- [@next/bundle-analyzer на npm](https://www.npmjs.com/package/@next/bundle-analyzer)
