---
title: Вступ
description: Вступ в T3 стек
layout: ../../layouts/docs.astro
lang: uk
---

<div class="embed">
<iframe width="560" height="315" src="https://www.youtube.com/embed/YkOSUVzOAA4" title="The best stack for your next project" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
</div>

## T3 Stack

_"T3 Stack"_ - це стек веб-розробки, створений [Theo](https://twitter.com/t3dotgg), з упором на простоту, модульність і full-stack типобезпека.

Основні частини - [**Next.js**](https://nextjs.org/) і [**TypeScript**](https://typescriptlang.org/). [**Tailwind CSS**](https://tailwindcss.com/) майже завжди включені. Якщо ви робите щось, що нагадує бекенд, [**tRPC**](https://trpc.io/), [**Prisma**](https://prisma.io/), і [**NextAuth.js**](https://next-auth.js.org/) - чудові доповнення.

Ви могли помітити, що тут... багато частин. Це зроблено наміренно. Змінюйте частини залежно від ваших потреб - цей стек є модульним за своєю суттю :)

## І... що таке create-t3-app? Шаблон?

Щось типу? `create-t3-app` - це CLI, створений досвідченими розробниками T3 стека, щоб спростити налаштування модульного додатка T3 стека. Це означає, що кожна частина є необов'язковою, і "шаблон" генерується на основі ваших конкретних потреб.

Після безлічі проєктів і багатьох років із цією технологією у нас є безліч думок та інсайтів. Ми постаралися зафіксувати їх у цьому CLI.

Це **НЕ** всеосяжний шаблон. Ми **очікуємо**, що ви будете використовувати свої власні бібліотеки, які вирішують потреби **ВАШОГО** додатка. Хоча ми не хочемо призначати рішення для більш конкретних проблем, таких як управління станом і деплоймент, ми [маємо деякі рекомендації, перераховані тут](/uk/other-recs).

## Аксіоми T3

Будемо чесними - це _суб'єктивний проєкт_. Ми поділилися кількома основними переконаннями навколо створення і розглядаємо їх як основу для наших рішень.

### Вирішуйте проблеми

Легко потрапити в пастку "додавання всього" - ми явно не хочемо цього робити. Усе, що додається в `create-t3-app`, повинно вирішувати конкретну проблему, яка існує в основних технологіях, включених до нього. Це означає, що ми не додамо бібліотеки менеджменту стану (`zustand`, `redux`), але ми додамо NextAuth.js та інтегруємо Prisma і tRPC для вас.

### Оновлюйтесь з відповідальністю

Ми любимо технологічні новинки. Швидкість і, будемо чесними, приколів від нових фіговін, дійсно круті. Ми вважаємо важливим використовувати їх відповідально, використовуючи більш ризиковані технології в менш ризикованих частинах. Це означає, що ми не будемо ⛔️ робити ставку на ризиковану нову технологію бази даних (SQL - це здорово!). Але ми із задоволенням ✅ зробимо ставку на tRPC, оскільки це просто функції, які легко замінити.

### Типобезпека не є опціональною

Зазначена мета Create T3 App - це надати найшвидший спосіб розпочати новий повнофункціональний, **типобезпечний** веб-додаток. Ми серйозно ставимося до типобезпеки в цих частинах, оскільки вона підвищує нашу продуктивність і допомагає нам створювати менше багів. Будь-яке рішення, яке знижує типобезпеку Create T3 App, це рішення, яке повинно бути прийнято в іншому проекті.
