---
title: Почему CT3A?
description: Почему вам следует выбрать Create T3 App для вашего следующего проекта
layout: ../../layouts/docs.astro
lang: ru
---

Мы начали создавать create-t3-app, потому что [Theo](https://twitter.com/t3dotgg) отказался делать шаблон своих любимых технологий. Вдохновленный create-next-app, [CLI Astro](https://astro.build) и общей любовью к типобезопасности, команда create-t3-app трудилась, чтобы создать лучшую возможную отправную точку для новых проектов T3 Stack.

Если вы заинтересованы в использовании Next.js в типобезопасном режиме, это то с чего нужно начать. Если вы интересуетесь любыми из конкретных технологических решений, которые мы приняли, читайте дальше :)

## Почему TypeScript?

JavaScript сложен. Зачем добавлять еще больше правил?

Мы всецело уверены, что опыт TypeScript позволяет вам быть лучшим разработчиком. Он предоставляет обратную связь во время написания кода, определяя ожидаемые типы данных, и либо предоставляет полезное автозаполнение в вашем редакторе, либо кричит вам красными волнистыми линиями, если вы пытаетесь получить доступ к свойству, которого не существует, или пытаетесь передать значение неправильного типа, что в противном случае пришлось бы отлаживать дальше по линии. Независимо от того, новичок вы в веб-разработке или опытный профессионал, «строгость» TypeScript обеспечивает менее раздражающий, более последовательный опыт, чем ванильный JS.

Типобезопасность делает вас быстрее. Если вы еще не убеждены, вы [можете использовать TypeScript неправильно ...](https://www.youtube.com/watch?v=RmGHnYUqQ4k)

## Почему Next.js?

Мы любим React. Он сделал разработку UI доступной в том виде, в котором мы никогда не могли себе представить. Он также может привести разработчиков по некоторым тернистым путям.

Next.js предлагает мение субъективный, но более оптимизированный подход к созданию приложений с использованием React. От маршрутизации до определения API до рендеринга изображений мы доверяем Next.js, чтобы вести разработчиков к правильным решениям.

## Почему tRPC/Prisma/Tailwind/и т.д.?

Хотя мы верим, что все должно быть просто, мы находим, что эти части используются в каждом проекте, похожем на приложение. `create-t3-app` выполняет отличную работу, позволяя вам выбрать те части, которые вам нужны.

### tRPC

tRPC предоставляет все преимущества GraphQL, такие как бесшовная разработка клиента против типобезопасного сервера без всех шаблонов. Это умное злоупотребление TypeScript, которое обеспечивает невероятный опыт разработки.

### Prisma

Prisma для SQL то, что TypeScript для JS. Она создала опыт разработчика, которого раньше не было. Создавая типы из пользовательской схемы, совместимой с [несколькими базами данных](https://www.prisma.io/docs/concepts/database-connectors), Prisma гарантирует типобезопасность от начала до конца от вашей базы данных до вашего приложения.

Prisma предоставляет целый [набор инструментов](https://www.prisma.io/docs/concepts/overview/should-you-use-prisma#-you-want-a-tool-that-holistically-covers-your-database-workflows), облегчающих ежедневное взаимодействие с вашей базой данных. В частности, Prisma Client отвечает за запросы и делает SQL настолько простым, что вы едва заметите, что его используете, а Prisma Studio - это удобный GUI для вашей базы данных, который позволяет быстро читать и манипулировать данными без необходимости писать код.

### Tailwind CSS

Tailwind ощущается как "CSS в режиме дзен".

Благодаря предоставлению строительных блоков в виде хороших цветов по умолчанию, отступов и других примитивов Tailwind позволяет легко создавать приложение с хорошим внешним видом. И в отличие от библиотек компонентов, он не ограничивает вас, когда вы хотите вывести свое приложение на следующий уровень и создать что-то красивое и уникальное.

К тому же, благодаря инлайновому подходу, Tailwind побуждает вас стилизовать без беспокойства о названии классов, организации файлов или любой другой проблеме, не связаной с решением задачи.

### NextAuth.js

Когда вы хотите добавить систему аутентификации в ваше приложение NextJS, NextAuth.js - отличное решение, чтобы не заморачиваться с реализацией сложной системы безопасности. Она имеет обширный список провайдеров для быстрого добавления аутентификации через OAuth и предоставляет адаптеры для многих баз данных и ORM.
