---
title: Первые шаги
description: Начало работы с вашим новым T3 App
layout: ../../../layouts/docs.astro
lang: ru
---

Вы только что создали новое приложение T3 и готовы к работе. Вот минимальный набор для запуска вашего приложения.

## База данных

Если ваше приложение включает Prisma, убедитесь, что вы запустили `npx prisma db push` из корневого каталога вашего приложения. Эта команда синхронизирует схему Prisma с вашей базой данных и генерирует типы TypeScript для Prisma Client на основе вашей схемы. Обратите внимание, что вам нужно перезапустить сервер TypeScript после этого, чтобы он мог обнаружить сгенерированные типы.

## Аутентификация

Если ваше приложение включает NextAuth.js, мы начинаем с `DiscordProvider`. Это один из самых простых провайдеров, предлагаемый NextAuth.js, однако он все еще требует некоторой начальной настройки с вашей стороны.

Конечно, если вы предпочитаете использовать другой провайдер аутентификации, вы также можете использовать один из [многих провайдеров](https://next-auth.js.org/providers/), которые предлагает NextAuth.js.

1. Вам нужен аккаунт Discord, поэтому зарегистрируйтесь, если еще не зарегистрировались.
2. Перейдите на https://discord.com/developers/applications и нажмите «New Application» в правом верхнем углу. Дайте вашему приложению имя и согласитесь с Условиями использования.
3. Когда вы создадите приложение, перейдите к «Settings → OAuth2 → General».
4. Скопируйте «Client ID» и добавьте его в ваш `.env` как `AUTH_DISCORD_ID`.
5. Нажмите «Reset Secret», скопируйте новый секрет и добавьте его в ваш `.env` как `AUTH_DISCORD_SECRET`.
6. Нажмите «Add Redirect» и введите `http://localhost:3000/api/auth/callback/discord`.
   - Для развертывания в продакшене следуйте предыдущим шагам для создания другого приложения Discord, но на этот раз замените `http://localhost:3000` на URL, на который вы развертываете.
7. Сохраните изменения.

Теперь у вас должна быть возможность войти в систему.

## Следующие шаги

- Если ваше приложение включает tRPC, ознакомьтесь с `src/pages/index.tsx` и `src/server/trpc/router/post.ts`, чтобы узнать, как работают запросы tRPC.
- Посмотрите на документацию `create-t3-app`, а также на документацию пакетов, которые включает ваше приложение.
- Присоединяйтесь к нашему [Discord](https://t3.gg/discord) и поставьте звезду на [GitHub](https://github.com/t3-oss/create-t3-app)! :)
